/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.item;

import com.darkona.adventurebackpack.CreativeTabAB;
import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.fluids.FluidEffectRegistry;
import com.darkona.adventurebackpack.init.ModFluids;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.item.ItemAB;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemHose
extends ItemAB {
    IIcon drinkIcon;
    IIcon spillIcon;
    IIcon suckIcon;
    final byte HOSE_SUCK_MODE = 0;
    final byte HOSE_SPILL_MODE = 1;
    final byte HOSE_DRINK_MODE = (byte)2;

    public ItemHose() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.setNoRepair();
        this.func_77655_b("backpackHose");
        this.func_77637_a(CreativeTabAB.ADVENTURE_BACKPACK_CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        switch (ItemHose.getHoseMode(stack)) {
            case 0: {
                return this.suckIcon;
            }
            case 1: {
                return this.spillIcon;
            }
            case 2: {
                return this.drinkIcon;
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.field_77791_bV;
    }

    public static int getHoseMode(ItemStack hose) {
        return hose.field_77990_d != null ? hose.field_77990_d.func_74762_e("mode") : -1;
    }

    public static int getHoseTank(ItemStack hose) {
        return hose.func_77942_o() ? hose.func_77978_p().func_74762_e("tank") : -1;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("mode")) {
            return stack.field_77990_d.func_74762_e("mode") == 2 ? EnumAction.drink : EnumAction.none;
        }
        return EnumAction.none;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        String name = "hose_" + (ItemHose.getHoseTank(stack) == 0 ? "leftTank" : (ItemHose.getHoseTank(stack) == 1 ? "rightTank" : ""));
        switch (ItemHose.getHoseMode(stack)) {
            case 0: {
                return super.getUnlocalizedName(name + "_suck");
            }
            case 1: {
                return super.getUnlocalizedName(name + "_spill");
            }
            case 2: {
                return super.getUnlocalizedName(name + "_drink");
            }
        }
        return super.getUnlocalizedName("hoseUseless");
    }

    public int func_77626_a(ItemStack stack) {
        return 24;
    }

    public int func_77612_l() {
        return 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.drinkIcon = iconRegister.func_94245_a(Resources.getIconString("hoseDrink"));
        this.spillIcon = iconRegister.func_94245_a(Resources.getIconString("hoseSpill"));
        this.suckIcon = iconRegister.func_94245_a(Resources.getIconString("hoseSuck"));
        this.field_77791_bV = iconRegister.func_94245_a(Resources.getIconString("hoseLeft"));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int inv_slot, boolean isCurrent) {
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (world.field_72995_K && player.func_71011_bu() != null && player.func_71011_bu().func_77973_b().equals((Object)this)) {
            return;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        ItemStack backpack = Wearing.getWearingBackpack(player);
        if (backpack != null) {
            FluidTank tank;
            if (nbt.func_74762_e("tank") == -1) {
                nbt.func_74768_a("tank", 0);
            }
            if (nbt.func_74762_e("mode") == -1) {
                nbt.func_74768_a("mode", 0);
            }
            InventoryBackpack inv = new InventoryBackpack(backpack);
            FluidTank fluidTank = tank = nbt.func_74762_e("tank") == 0 ? inv.getLeftTank() : inv.getRightTank();
            if (tank != null && tank.getFluid() != null) {
                nbt.func_74778_a("fluid", Utils.capitalize(tank.getFluid().getFluid().getName()));
                nbt.func_74768_a("amount", tank.getFluidAmount());
            } else {
                nbt.func_74768_a("amount", 0);
                nbt.func_74778_a("fluid", "Empty");
            }
        } else {
            nbt.func_74768_a("amount", 0);
            nbt.func_74778_a("fluid", "None");
            nbt.func_74768_a("mode", -1);
            nbt.func_74768_a("tank", -1);
        }
        stack.func_77982_d(nbt);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!Wearing.isWearingBackpack(player)) {
            return true;
        }
        InventoryBackpack inv = (InventoryBackpack)BackpackProperty.get(player).getInventory();
        inv.func_70295_k_();
        FluidTank tank = ItemHose.getHoseTank(stack) == 0 ? inv.getLeftTank() : inv.getRightTank();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IFluidHandler) {
            IFluidHandler exTank = (IFluidHandler)te;
            int accepted = 0;
            switch (ItemHose.getHoseMode(stack)) {
                case 0: {
                    accepted = tank.fill(exTank.drain(ForgeDirection.UNKNOWN, 1000, false), false);
                    if (accepted <= 0) break;
                    tank.fill(exTank.drain(ForgeDirection.UNKNOWN, accepted, true), true);
                    te.func_70296_d();
                    inv.dirtyTanks();
                    return true;
                }
                case 1: {
                    accepted = exTank.fill(ForgeDirection.UNKNOWN, tank.drain(1000, false), false);
                    if (accepted <= 0) break;
                    exTank.fill(ForgeDirection.UNKNOWN, tank.drain(accepted, true), true);
                    te.func_70296_d();
                    inv.dirtyTanks();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        FluidTank tank;
        if (!Wearing.isWearingBackpack(player)) {
            return stack;
        }
        InventoryBackpack inventory = (InventoryBackpack)BackpackProperty.get(player).getInventory();
        inventory.func_70295_k_();
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        FluidTank fluidTank = tank = ItemHose.getHoseTank(stack) == 0 ? inventory.getLeftTank() : inventory.getRightTank();
        if (tank != null) {
            switch (ItemHose.getHoseMode(stack)) {
                case 0: {
                    if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) break;
                    Fluid fluidBlock = FluidRegistry.lookupFluidForBlock((Block)world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d));
                    if (fluidBlock != null) {
                        int accepted;
                        FluidStack fluid = new FluidStack(fluidBlock, 1000);
                        if ((tank.getFluid() == null || tank.getFluid().containsFluid(fluid)) && (accepted = tank.fill(fluid, false)) > 0) {
                            world.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            tank.fill(new FluidStack(fluidBlock, accepted), true);
                        }
                    }
                    inventory.dirtyTanks();
                    break;
                }
                case 1: {
                    FluidStack fluid;
                    if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) break;
                    int x = mop.field_72311_b;
                    int y = mop.field_72312_c;
                    int z = mop.field_72309_d;
                    if (world.func_147439_a(x, y, z).func_149747_d((IBlockAccess)world, x, y, z, mop.field_72310_e)) {
                        switch (mop.field_72310_e) {
                            case 0: {
                                --y;
                                break;
                            }
                            case 1: {
                                ++y;
                                break;
                            }
                            case 2: {
                                --z;
                                break;
                            }
                            case 3: {
                                ++z;
                                break;
                            }
                            case 4: {
                                --x;
                                break;
                            }
                            case 5: {
                                ++x;
                            }
                        }
                    }
                    if (tank.getFluidAmount() > 0 && (fluid = tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld()) {
                        boolean flag;
                        Material material = world.func_147439_a(x, y, z).func_149688_o();
                        boolean bl = flag = !material.func_76220_a();
                        if (!world.func_147437_c(x, y, z) && !flag) {
                            return stack;
                        }
                        if (world.field_73011_w.field_76575_d && fluid.getFluid() == FluidRegistry.WATER) {
                            tank.drain(1000, true);
                            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                            for (int l = 0; l < 12; ++l) {
                                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
                            }
                        } else {
                            FluidStack drainedFluid = tank.drain(1000, false);
                            if (drainedFluid != null && drainedFluid.amount >= 1000) {
                                if (!world.field_72995_K && flag && !material.func_76224_d()) {
                                    world.func_147480_a(x, y, z, true);
                                }
                                if (fluid.getFluid().getBlock() == Blocks.field_150355_j) {
                                    if (world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 3)) {
                                        tank.drain(1000, true);
                                    }
                                } else if (fluid.getFluid().getBlock() == Blocks.field_150353_l) {
                                    if (world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 0, 3)) {
                                        tank.drain(1000, true);
                                    }
                                } else if (world.func_147465_d(x, y, z, fluid.getFluid().getBlock(), 0, 3)) {
                                    tank.drain(1000, true);
                                }
                            }
                        }
                    }
                    inventory.dirtyTanks();
                    break;
                }
                case 2: {
                    if (tank.getFluid() == null || tank.getFluidAmount() < 1000 || !FluidEffectRegistry.hasFluidEffect(tank.getFluid().getFluid())) break;
                    player.func_71008_a(stack, this.func_77626_a(stack));
                    break;
                }
                default: {
                    return stack;
                }
            }
        }
        return stack;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    public ItemStack func_77654_b(ItemStack hose, World world, EntityPlayer player) {
        if (!Wearing.isWearingBackpack(player)) {
            return hose;
        }
        int mode = -1;
        int tank = -1;
        if (hose.field_77990_d != null) {
            tank = ItemHose.getHoseTank(hose);
            mode = ItemHose.getHoseMode(hose);
        }
        if (mode == 2 && tank > -1) {
            FluidTank backpackTank;
            InventoryBackpack inventory = (InventoryBackpack)BackpackProperty.get(player).getInventory();
            inventory.func_70295_k_();
            Object object = tank == 0 ? inventory.getLeftTank() : (backpackTank = tank == 1 ? inventory.getRightTank() : null);
            if (backpackTank != null && ServerActions.setFluidEffect(world, player, backpackTank)) {
                backpackTank.drain(1000, true);
                inventory.dirtyTanks();
            }
        }
        return hose;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (!Wearing.isWearingBackpack(player)) {
            return false;
        }
        InventoryBackpack inventory = (InventoryBackpack)BackpackProperty.get(player).getInventory();
        inventory.func_70295_k_();
        if (entity instanceof EntityCow && !(entity instanceof EntityMooshroom)) {
            FluidTank tank = ItemHose.getHoseTank(stack) == 0 ? inventory.getLeftTank() : inventory.getRightTank();
            tank.fill(new FluidStack((Fluid)ModFluids.milk, 1000), true);
            inventory.dirtyTanks();
            ((EntityCow)entity).func_70625_a((Entity)player, 0.1f, 0.1f);
            return true;
        }
        if (entity instanceof EntityMooshroom) {
            FluidTank tank = ItemHose.getHoseTank(stack) == 0 ? inventory.getLeftTank() : inventory.getRightTank();
            tank.fill(new FluidStack((Fluid)ModFluids.mushroomStew, 1000), true);
            inventory.dirtyTanks();
            ((EntityMooshroom)entity).func_70625_a((Entity)player, 0.1f, 0.1f);
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return FluidRegistry.lookupFluidForBlock((Block)block) != null;
    }
}

