/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.item;

import com.darkona.adventurebackpack.AdventureBackpack;
import com.darkona.adventurebackpack.block.BlockAdventureBackpack;
import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.client.models.ModelBackpackArmor;
import com.darkona.adventurebackpack.common.BackpackAbilities;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.events.WearableEvent;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.item.ItemAB;
import com.darkona.adventurebackpack.network.GUIPacket;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.ClientProxy;
import com.darkona.adventurebackpack.reference.BackpackNames;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemAdventureBackpack
extends ItemAB
implements IBackWearableItem {
    public ItemAdventureBackpack() {
        this.func_77655_b("adventureBackpack");
        this.func_77664_n();
        this.func_77625_d(1);
    }

    public static Item getItemFromBlock(Block block) {
        return block instanceof BlockAdventureBackpack ? ModItems.adventureBackpack : null;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0;
    }

    public String func_77653_i(ItemStack stack) {
        return "Adventure Backpack";
    }

    public void func_77622_d(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        super.func_77622_d(stack, par2World, par3EntityPlayer);
        BackpackNames.setBackpackColorNameFromDamage(stack, stack.func_77960_j());
    }

    public boolean placeBackpack(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, boolean from) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("colorName") || stack.field_77990_d.func_74779_i("colorName").isEmpty()) {
            stack.field_77990_d.func_74778_a("colorName", "Standard");
        }
        BlockAdventureBackpack backpack = ModBlocks.blockBackpack;
        if (y <= 0 || y >= 255) {
            return false;
        }
        if (backpack.func_149707_d(world, x, y, z, side)) {
            if (world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
                switch (side) {
                    case 0: {
                        --y;
                        break;
                    }
                    case 1: {
                        ++y;
                        break;
                    }
                    case 2: {
                        --z;
                        break;
                    }
                    case 3: {
                        ++z;
                        break;
                    }
                    case 4: {
                        --x;
                        break;
                    }
                    case 5: {
                        ++x;
                    }
                }
            }
            if (y <= 0 || y >= world.func_72800_K()) {
                return false;
            }
            if (backpack.func_149742_c(world, x, y, z) && world.func_147449_b(x, y, z, (Block)ModBlocks.blockBackpack)) {
                backpack.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                world.func_72956_a((Entity)player, BlockAdventureBackpack.field_149775_l.func_150498_e(), 0.5f, 1.0f);
                ((TileAdventureBackpack)world.func_147438_o(x, y, z)).loadFromNBT(stack.field_77990_d);
                if (from) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                } else {
                    BackpackProperty.get(player).setWearable(null);
                }
                WearableEvent event = new WearableEvent(player, stack);
                MinecraftForge.EVENT_BUS.post((Event)event);
                return true;
            }
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.placeBackpack(stack, player, world, x, y, z, side, true);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        if ((mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) && world.field_72995_K) {
            ModNetwork.net.sendToServer((IMessage)new GUIPacket.GUImessage(1, 1));
        }
        return stack;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        return new ModelBackpackArmor();
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String modelTexture = BackpackNames.getBackpackColorName(stack).equals("Standard") ? Resources.backpackTextureFromString(AdventureBackpack.instance.Holiday).toString() : Resources.backpackTexturesStringFromColor(stack);
        return modelTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound backpackData = BackpackUtils.getBackpackData(stack);
        if (backpackData != null && backpackData.func_74764_b("colorName")) {
            list.add(backpackData.func_74779_i("colorName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List subItems) {
        for (int i = 0; i < BackpackNames.backpackNames.length; ++i) {
            ItemStack bp = new ItemStack((Item)this, 1, 0);
            bp.func_77964_b(i);
            NBTTagCompound c = new NBTTagCompound();
            c.func_74778_a("colorName", BackpackNames.backpackNames[i]);
            BackpackUtils.setBackpackData(bp, c);
            subItems.add(bp);
        }
    }

    @Override
    public void onEquippedUpdate(World world, EntityPlayer player, ItemStack stack) {
        if (!ConfigHandler.BACKPACK_ABILITIES) {
            return;
        }
        if (world == null || player == null || stack == null) {
            return;
        }
        if (BackpackAbilities.hasAbility(BackpackNames.getBackpackColorName(stack))) {
            BackpackAbilities.backpackAbilities.executeAbility(player, world, stack);
        }
    }

    @Override
    public void onPlayerDeath(World world, EntityPlayer player, ItemStack stack) {
        if (Wearing.isWearingTheRightBackpack(player, "Creeper")) {
            player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 4.0f, false);
        }
        if (ConfigHandler.BACKPACK_DEATH_PLACE) {
            if (!this.tryPlace(world, player, stack)) {
                player.func_71019_a(stack, false);
                BackpackProperty.get(player).setWearable(null);
            }
        } else {
            player.func_71019_a(stack, false);
            BackpackProperty.get(player).setWearable(null);
        }
    }

    private boolean tryPlace(World world, EntityPlayer player, ItemStack backpack) {
        int X = (int)player.field_70165_t;
        int Z = (int)player.field_70161_v;
        for (int Y = (int)player.field_70163_u - 7; Y <= (int)player.field_70163_u + 7; ++Y) {
            ChunkCoordinates spawn = Utils.getNearestEmptyChunkCoordinatesSpiral((IBlockAccess)world, X, Z, X, Y, Z, 12, true, 1, (byte)0, false);
            if (spawn == null) continue;
            return this.placeBackpack(backpack, player, world, spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c, ForgeDirection.UP.ordinal(), false);
        }
        return false;
    }

    @Override
    public void onEquipped(World world, EntityPlayer player, ItemStack stack) {
    }

    @Override
    public void onUnequipped(World world, EntityPlayer player, ItemStack stack) {
        if (BackpackAbilities.hasRemoval(BackpackNames.getBackpackColorName(stack))) {
            BackpackAbilities.backpackAbilities.executeRemoval(player, world, stack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getWearableModel(ItemStack wearable) {
        return ClientProxy.modelAdventureBackpack.setWearable(wearable);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getWearableTexture(ItemStack wearable) {
        ResourceLocation modelTexture = BackpackNames.getBackpackColorName(wearable).equals("Standard") ? Resources.backpackTextureFromString(AdventureBackpack.instance.Holiday) : Resources.backpackTextureFromString(BackpackNames.getBackpackColorName(wearable));
        return modelTexture;
    }
}

