/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import com.darkona.adventurebackpack.util.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;

public class InventorySteamJetpack
implements IInventoryTanks {
    public static final boolean OFF = false;
    public static final boolean ON = true;
    private FluidTank waterTank = new FluidTank(6000);
    private FluidTank steamTank = new FluidTank(12000);
    private ItemStack[] inventory = new ItemStack[3];
    private int temperature = 25;
    private boolean status = false;
    private int burnTicks = 0;
    private ItemStack containerStack;
    private long systemTime = 0L;
    private boolean boiling = false;
    private boolean leaking = false;
    private boolean inUse = false;
    public int currentItemBurnTime = 0;
    public static final int MAX_TEMPERATURE = 200;
    public static final int BUCKET_IN_SLOT = 0;
    public static final int BUCKET_OUT_SLOT = 1;
    public static final int FUEL_SLOT = 2;
    private int coolTicks = 5000;

    public InventorySteamJetpack(ItemStack jetpack) {
        this.containerStack = jetpack;
        if (!this.containerStack.func_77942_o()) {
            this.containerStack.field_77990_d = new NBTTagCompound();
            this.func_70305_f();
        }
        this.func_70295_k_();
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTicks * scale / this.currentItemBurnTime;
    }

    @Override
    public boolean updateTankSlots() {
        return false;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("jetpackData")) {
            NBTTagCompound jetpackData = compound.func_74775_l("jetpackData");
            this.waterTank.readFromNBT(jetpackData.func_74775_l("waterTank"));
            this.steamTank.readFromNBT(jetpackData.func_74775_l("steamTank"));
            this.temperature = jetpackData.func_74762_e("temperature");
            this.status = jetpackData.func_74767_n("status");
            this.burnTicks = jetpackData.func_74762_e("burnTicks");
            this.coolTicks = jetpackData.func_74762_e("coolTicks");
            this.systemTime = jetpackData.func_74763_f("systemTime");
            this.inUse = jetpackData.func_74767_n("inUse");
            this.boiling = jetpackData.func_74767_n("boiling");
            this.leaking = jetpackData.func_74767_n("leaking");
            this.currentItemBurnTime = jetpackData.func_74762_e("currentBurn");
            NBTTagList items = jetpackData.func_150295_c("inventory", 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                byte slot = item.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
            }
        }
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound jetpackData = compound.func_74764_b("jetpackData") ? compound.func_74775_l("jetpackData") : new NBTTagCompound();
        jetpackData.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        jetpackData.func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        jetpackData.func_74768_a("temperature", this.temperature);
        jetpackData.func_74757_a("status", this.status);
        jetpackData.func_74768_a("burnTicks", this.burnTicks);
        jetpackData.func_74768_a("coolTicks", this.coolTicks);
        jetpackData.func_74772_a("systemTime", this.systemTime);
        jetpackData.func_74757_a("inUse", this.inUse);
        jetpackData.func_74757_a("boiling", this.boiling);
        jetpackData.func_74757_a("leaking", this.leaking);
        jetpackData.func_74768_a("currentBurn", this.currentItemBurnTime);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        jetpackData.func_74782_a("inventory", (NBTBase)items);
        compound.func_74782_a("jetpackData", (NBTBase)jetpackData);
    }

    @Override
    public FluidTank[] getTanksArray() {
        FluidTank[] tanks = new FluidTank[]{this.waterTank, this.steamTank};
        return tanks;
    }

    @Override
    public void dirtyInventory() {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        this.containerStack.field_77990_d.func_74775_l("jetpackData").func_74782_a("inventory", (NBTBase)items);
    }

    @Override
    public void dirtyTanks() {
        this.containerStack.field_77990_d.func_74775_l("jetPackData").func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        this.containerStack.field_77990_d.func_74775_l("jetPackData").func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
    }

    public void dirtyBoiler() {
        NBTTagCompound jetpackData = this.containerStack.field_77990_d.func_74775_l("jetPackData");
        jetpackData.func_74757_a("boiling", this.boiling);
        jetpackData.func_74757_a("leaking", this.leaking);
        jetpackData.func_74768_a("temperature", this.temperature);
        jetpackData.func_74768_a("burnTicks", this.burnTicks);
        jetpackData.func_74768_a("coolTicks", this.coolTicks);
        jetpackData.func_74768_a("currentBurn", this.currentItemBurnTime);
    }

    public int consumeFuel() {
        int result = 0;
        if (this.isFuel(this.inventory[2])) {
            result = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[2]);
            --this.inventory[2].field_77994_a;
            if (this.inventory[2].field_77994_a == 0) {
                this.inventory[2] = this.inventory[2].func_77973_b().getContainerItem(this.inventory[2]);
            }
            this.dirtyInventory();
        }
        return result;
    }

    public boolean isFuel(ItemStack stack) {
        return TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    public void setInventorySlotContentsNoSave(int slot, ItemStack stack) {
        if (slot > this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public ItemStack decrStackSizeNoSave(int slot, int amount) {
        if (slot < this.inventory.length && this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a > amount) {
                ItemStack result = this.inventory[slot].func_77979_a(amount);
                return result;
            }
            ItemStack stack = this.inventory[slot];
            this.setInventorySlotContentsNoSave(slot, null);
            return stack;
        }
        return null;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= quantity) {
                if (slot == 2) {
                    this.func_70299_a(slot, itemstack.func_77973_b().getContainerItem(itemstack));
                } else {
                    this.func_70299_a(slot, null);
                }
            } else {
                itemstack = itemstack.func_77979_a(quantity);
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        return i == 0 || i == 1 ? this.inventory[i] : null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (slot < 2) {
            this.onInventoryChanged();
        }
        this.dirtyInventory();
    }

    public void onInventoryChanged() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (i != 0) continue;
            ItemStack container = this.func_70301_a(i);
            if (FluidContainerRegistry.isFilledContainer((ItemStack)container) && FluidUtils.isContainerForFluid(container, FluidRegistry.WATER)) {
                InventoryActions.transferContainerTank(this, this.waterTank, i);
                continue;
            }
            if (!FluidContainerRegistry.isEmptyContainer((ItemStack)container) || this.waterTank.getFluid() == null || !FluidUtils.isContainerForFluid(container, FluidRegistry.WATER)) continue;
            InventoryActions.transferContainerTank(this, this.waterTank, i);
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Steam Jetpack";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.saveToNBT(this.containerStack.field_77990_d);
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
        this.loadFromNBT(this.containerStack.field_77990_d);
    }

    public void func_70305_f() {
        this.saveToNBT(this.containerStack.field_77990_d);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return SlotFluid.valid(stack) && FluidUtils.isContainerForFluid(stack, FluidRegistry.WATER);
        }
        if (slot == 2) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        return false;
    }

    public ItemStack getParentItemStack() {
        return this.containerStack;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public FluidTank getSteamTank() {
        return this.steamTank;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean isBoiling() {
        return this.boiling;
    }

    public void setBoiling(boolean boiling) {
        this.boiling = boiling;
    }

    public boolean isLeaking() {
        return this.leaking;
    }

    public void setLeaking(boolean leaking) {
        this.leaking = leaking;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    public int getBurnTicks() {
        return this.burnTicks;
    }

    public void setBurnTicks(int burnTicks) {
        this.burnTicks = burnTicks;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void setInventory(ItemStack[] inventory) {
        this.inventory = inventory;
    }

    public int getIncreasingFactor() {
        if (this.temperature < 50) {
            return 20;
        }
        if (this.temperature < 100) {
            return 15;
        }
        if (this.temperature < 150) {
            return 10;
        }
        return 5;
    }

    public int getDecreasingFactor() {
        if (this.temperature > 150) {
            return 40;
        }
        if (this.temperature > 100) {
            return 80;
        }
        if (this.temperature > 50) {
            return 120;
        }
        return 5;
    }

    public int getCoolTicks() {
        return this.coolTicks;
    }

    public void setCoolTicks(int coolTicks) {
        this.coolTicks = coolTicks;
    }

    public void setContainerStack(ItemStack containerStack) {
        this.containerStack = containerStack;
    }

    public ItemStack getContainerStack() {
        return this.containerStack;
    }

    public void calculateLostTime() {
        long elapsedTimesince = System.currentTimeMillis() - this.systemTime;
    }
}

