/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.entity.EntityInflatableBoat;
import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.item.ItemCopterPack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryInflatableBoat
implements IInventoryTanks {
    private ItemStack containerStack;
    private EntityInflatableBoat containerEntity;
    public FluidTank fuelTank;
    public int tickCounter;
    public byte status;
    private ItemStack[] inventory;

    public FluidTank getFuelTank() {
        return this.fuelTank;
    }

    public InventoryInflatableBoat(ItemStack copterPack) {
        this.containerStack = copterPack;
        this.fuelTank = new FluidTank(6000);
        this.status = ItemCopterPack.OFF_MODE;
        this.inventory = new ItemStack[2];
        this.func_70295_k_();
    }

    public InventoryInflatableBoat(EntityInflatableBoat boat) {
        this.fuelTank = new FluidTank(4000);
    }

    public void consumeFuel(int quantity) {
        this.fuelTank.drain(quantity, true);
    }

    public boolean canConsumeFuel(int quantity) {
        return this.fuelTank.drain(quantity, false) != null && this.fuelTank.drain((int)quantity, (boolean)false).amount > 0;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= quantity) {
                this.func_70299_a(slot, null);
            } else {
                itemstack = itemstack.func_77979_a(quantity);
                this.onInventoryChanged();
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory[i];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.onInventoryChanged();
    }

    public String func_145825_b() {
        return "Copter Pack";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
        NBTTagCompound compound;
        NBTTagCompound nBTTagCompound = compound = this.containerStack.func_77978_p() != null ? this.containerStack.field_77990_d : new NBTTagCompound();
        if (compound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(compound.func_74775_l("fuelTank"));
        }
        this.status = compound.func_74764_b("status") ? compound.func_74771_c("status") : ItemCopterPack.OFF_MODE;
        this.tickCounter = compound.func_74764_b("tickCounter") ? compound.func_74762_e("tickCounter") : 0;
    }

    public void func_70305_f() {
        NBTTagCompound compound = this.containerStack.func_77942_o() ? this.containerStack.field_77990_d : new NBTTagCompound();
        compound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        compound.func_74774_a("status", this.status);
        compound.func_74768_a("tickCounter", this.tickCounter);
        this.containerStack.field_77990_d = compound;
    }

    public void closeInventoryNoStatus() {
        NBTTagCompound compound = this.containerStack.field_77990_d;
        compound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("tickCounter", this.tickCounter);
        this.containerStack.field_77990_d = compound;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public void onInventoryChanged() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (i != 0) continue;
            ItemStack container = this.func_70301_a(i);
            FluidStack oil = new FluidStack(FluidRegistry.getFluid((String)"oil"), 1);
            FluidStack fuel = new FluidStack(FluidRegistry.getFluid((String)"fuel"), 1);
            if (fuel == null || oil == null || !FluidContainerRegistry.containsFluid((ItemStack)container, (FluidStack)oil) && !FluidContainerRegistry.containsFluid((ItemStack)container, (FluidStack)fuel) && !FluidContainerRegistry.isEmptyContainer((ItemStack)container)) continue;
            InventoryActions.transferContainerTank(this, this.fuelTank, i);
        }
        this.func_70305_f();
    }

    @Override
    public void setInventorySlotContentsNoSave(int slot, ItemStack stack) {
        if (slot > this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public ItemStack decrStackSizeNoSave(int slot, int amount) {
        if (slot < this.inventory.length && this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a > amount) {
                ItemStack result = this.inventory[slot].func_77979_a(amount);
                return result;
            }
            ItemStack stack = this.inventory[slot];
            this.setInventorySlotContentsNoSave(slot, null);
            return stack;
        }
        return null;
    }

    public ItemStack getParentItemStack() {
        return this.containerStack;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setTickCounter(int ticks) {
        this.tickCounter = ticks;
    }

    public byte getStatus() {
        return this.status;
    }

    @Override
    public boolean updateTankSlots() {
        return false;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
    }

    @Override
    public FluidTank[] getTanksArray() {
        return new FluidTank[0];
    }

    @Override
    public void dirtyInventory() {
    }

    @Override
    public void dirtyTanks() {
    }
}

