/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.item.ItemCopterPack;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTank;

public class InventoryCopterPack
implements IInventoryTanks {
    private ItemStack containerStack;
    public FluidTank fuelTank = new FluidTank(6000);
    public int tickCounter = 0;
    public byte status = ItemCopterPack.OFF_MODE;
    private ItemStack[] inventory = new ItemStack[2];

    public InventoryCopterPack(ItemStack copterPack) {
        this.status = ItemCopterPack.OFF_MODE;
        this.containerStack = copterPack;
        if (!copterPack.func_77942_o()) {
            copterPack.field_77990_d = new NBTTagCompound();
            this.saveToNBT(copterPack.field_77990_d);
        }
        this.func_70295_k_();
    }

    public FluidTank getFuelTank() {
        return this.fuelTank;
    }

    public void consumeFuel(int quantity) {
        this.fuelTank.drain(quantity, true);
        this.dirtyTanks();
    }

    public boolean canConsumeFuel(int quantity) {
        return this.fuelTank.drain(quantity, false) != null && this.fuelTank.drain((int)quantity, (boolean)false).amount > 0;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= quantity) {
                this.func_70299_a(slot, null);
            } else {
                itemstack = itemstack.func_77979_a(quantity);
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory[i];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack) && GeneralReference.isValidFuel(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack).getFluid())) {
            InventoryActions.transferContainerTank(this, this.fuelTank, 0);
        } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)stack) && this.fuelTank.getFluid() != null && FluidUtils.isContainerForFluid(stack, this.fuelTank.getFluid().getFluid())) {
            InventoryActions.transferContainerTank(this, this.fuelTank, 0);
        }
        this.dirtyTanks();
        this.dirtyInventory();
    }

    public String func_145825_b() {
        return "Copter Pack";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.containerStack.field_77990_d.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        this.containerStack.field_77990_d.func_74774_a("status", this.status);
        this.containerStack.field_77990_d.func_74768_a("tickCounter", this.tickCounter);
    }

    @Override
    public void dirtyTanks() {
        this.containerStack.field_77990_d.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void dirtyInventory() {
    }

    public void dirtyCounter() {
        this.containerStack.field_77990_d.func_74768_a("tickCounter", this.tickCounter);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
        this.loadFromNBT(this.containerStack.field_77990_d);
    }

    public void func_70305_f() {
        this.saveToNBT(this.containerStack.field_77990_d);
    }

    public void closeInventoryNoStatus() {
        this.containerStack.field_77990_d.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        this.containerStack.field_77990_d.func_74768_a("tickCounter", this.tickCounter);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public void onInventoryChanged() {
        ItemStack container = this.func_70301_a(0);
        this.func_70305_f();
    }

    @Override
    public void setInventorySlotContentsNoSave(int slot, ItemStack stack) {
        if (slot > this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public ItemStack decrStackSizeNoSave(int slot, int amount) {
        if (slot < this.inventory.length && this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a > amount) {
                ItemStack result = this.inventory[slot].func_77979_a(amount);
                return result;
            }
            ItemStack stack = this.inventory[slot];
            this.setInventorySlotContentsNoSave(slot, null);
            return stack;
        }
        return null;
    }

    public ItemStack getParentItemStack() {
        return this.containerStack;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setTickCounter(int ticks) {
        this.tickCounter = ticks;
    }

    public byte getStatus() {
        return this.status;
    }

    @Override
    public boolean updateTankSlots() {
        return false;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        this.fuelTank.readFromNBT(compound.func_74775_l("fuelTank"));
        this.status = compound.func_74771_c("status");
        this.tickCounter = compound.func_74762_e("tickCounter");
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        compound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        compound.func_74774_a("status", this.status);
        compound.func_74768_a("tickCounter", this.tickCounter);
    }

    @Override
    public FluidTank[] getTanksArray() {
        FluidTank[] tanks = new FluidTank[]{this.fuelTank};
        return tanks;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void dirtyStatus() {
        this.containerStack.field_77990_d.func_74774_a("status", this.status);
    }

    public void setContainerStack(ItemStack containerStack) {
        this.containerStack = containerStack;
    }
}

