/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.block.BlockAdventureBackpack;
import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.common.BackpackAbilities;
import com.darkona.adventurebackpack.common.IInventoryAdventureBackpack;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTank;

public class InventoryBackpack
implements IInventoryAdventureBackpack {
    public ItemStack[] inventory = new ItemStack[45];
    private FluidTank leftTank = new FluidTank(4000);
    private FluidTank rightTank = new FluidTank(4000);
    private ItemStack containerStack;
    private String colorName = "Standard";
    private int lastTime = 0;
    private boolean special = false;
    public NBTTagCompound extendedProperties = new NBTTagCompound();

    public ItemStack getContainerStack() {
        return this.containerStack;
    }

    public void setContainerStack(ItemStack containerStack) {
        this.containerStack = containerStack;
    }

    public InventoryBackpack(ItemStack backpack) {
        this.containerStack = backpack;
        if (!backpack.func_77942_o()) {
            backpack.field_77990_d = new NBTTagCompound();
            this.saveToNBT(backpack.field_77990_d);
        }
        this.loadFromNBT(backpack.field_77990_d);
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public TileAdventureBackpack getTile() {
        return null;
    }

    @Override
    public ItemStack getParentItemStack() {
        return this.containerStack;
    }

    @Override
    public String getColorName() {
        return this.colorName;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public NBTTagCompound getExtendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public void setExtendedProperties(NBTTagCompound properties) {
        this.extendedProperties = properties;
    }

    @Override
    public boolean isSpecial() {
        return this.special;
    }

    @Override
    public void saveTanks(NBTTagCompound compound) {
        compound.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void loadTanks(NBTTagCompound compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("leftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("rightTank"));
    }

    @Override
    public boolean hasItem(Item item) {
        return InventoryActions.hasItem(this, item);
    }

    @Override
    public void consumeInventoryItem(Item item) {
        InventoryActions.consumeItemInInventory(this, item);
    }

    @Override
    public boolean isSBDeployed() {
        return false;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot > this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.dirtyInventory();
    }

    @Override
    public void setInventorySlotContentsNoSave(int slot, ItemStack stack) {
        if (slot > this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= quantity) {
                this.func_70299_a(slot, null);
            } else {
                itemstack = itemstack.func_77979_a(quantity);
            }
        }
        return itemstack;
    }

    @Override
    public ItemStack decrStackSizeNoSave(int slot, int quantity) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= quantity) {
                this.setInventorySlotContentsNoSave(slot, null);
            } else {
                stack = stack.func_77979_a(quantity);
            }
        }
        return stack;
    }

    @Override
    public boolean updateTankSlots() {
        boolean answer = InventoryActions.transferContainerTank(this, this.getLeftTank(), 41) || InventoryActions.transferContainerTank(this, this.getRightTank(), 43);
        this.dirtyInventory();
        this.dirtyTanks();
        return answer;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("backpackData")) {
            NBTTagCompound backpackData = compound.func_74775_l("backpackData");
            NBTTagList items = backpackData.func_150295_c("ABPItems", 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                byte slot = item.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
            }
            this.leftTank.readFromNBT(backpackData.func_74775_l("leftTank"));
            this.rightTank.readFromNBT(backpackData.func_74775_l("rightTank"));
            this.colorName = backpackData.func_74779_i("colorName");
            this.lastTime = backpackData.func_74762_e("lastTime");
            this.special = backpackData.func_74767_n("special");
            this.extendedProperties = backpackData.func_74775_l("extendedProperties");
        }
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound backpackData = new NBTTagCompound();
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        backpackData.func_82580_o("ABPItems");
        backpackData.func_74782_a("ABPItems", (NBTBase)items);
        backpackData.func_74778_a("colorName", this.colorName);
        backpackData.func_74768_a("lastTime", this.lastTime);
        backpackData.func_74757_a("special", BackpackAbilities.hasAbility(this.colorName));
        backpackData.func_74782_a("extendedProperties", (NBTBase)this.extendedProperties);
        backpackData.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        backpackData.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("backpackData", (NBTBase)backpackData);
    }

    @Override
    public FluidTank[] getTanksArray() {
        FluidTank[] array = new FluidTank[]{this.leftTank, this.rightTank};
        return array;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot == 41 || slot == 43 || slot == 42 || slot == 44) {
            return this.inventory[slot];
        }
        return null;
    }

    public String func_145825_b() {
        return "Adventure Backpack";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.saveToNBT(this.containerStack.field_77990_d);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
        this.loadFromNBT(this.containerStack.field_77990_d);
    }

    public void func_70305_f() {
        this.saveToNBT(this.containerStack.field_77990_d);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAdventureBackpack || Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockAdventureBackpack) {
            return false;
        }
        if (slot == 43 || slot == 41) {
            return FluidContainerRegistry.isContainer((ItemStack)stack);
        }
        return slot != 39 && slot != 40 || SlotTool.isValidTool(stack);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    @Override
    public void dirtyTanks() {
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void dirtyTime() {
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_74768_a("lastTime", this.lastTime);
    }

    @Override
    public void dirtyExtended() {
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_82580_o("extendedProperties");
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_74782_a("extendedProperties", (NBTBase)this.extendedProperties);
    }

    @Override
    public void dirtyInventory() {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_82580_o("ABPItems");
        this.containerStack.field_77990_d.func_74775_l("backpackData").func_74782_a("ABPItems", (NBTBase)items);
    }

    public boolean hasBlock(Block block) {
        return InventoryActions.hasBlockItem(this, block);
    }
}

