/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.handlers;

import com.darkona.adventurebackpack.AdventureBackpack;
import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.entity.EntityFriendlySpider;
import com.darkona.adventurebackpack.entity.ai.EntityAIHorseFollowOwner;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.inventory.IWearableContainer;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.ServerProxy;
import com.darkona.adventurebackpack.reference.BackpackNames;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;

public class PlayerEventHandler {
    private static int tickCounter = 0;

    @SubscribeEvent
    public void registerBackpackProperty(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && BackpackProperty.get((EntityPlayer)event.entity) == null) {
            BackpackProperty.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void joinPlayer(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            AdventureBackpack.proxy.joinPlayer((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            BackpackProperty.sync(event.player);
        }
    }

    @SubscribeEvent
    public void playerTravelsAcrossDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            BackpackProperty.sync(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.entity != null && event.entityLiving instanceof EntityPlayer && Wearing.isWearingBoots(player = (EntityPlayer)event.entity) && player.field_70122_E) {
            ServerActions.pistonBootsJump(player);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.entity != null) {
            EntityCreature creature;
            if (event.entityLiving instanceof EntityCreature && ConfigHandler.FIX_LEAD && (creature = (EntityCreature)event.entityLiving).func_110167_bD() && creature.func_110166_bE() != null && creature.func_110166_bE() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)creature.func_110166_bE();
                if (creature.field_70181_x > -2.0 && player.field_70181_x > -2.0) {
                    event.setCanceled(true);
                }
            }
            if (event.entityLiving instanceof EntityFriendlySpider && ((EntityFriendlySpider)event.entityLiving).field_70153_n != null && ((EntityFriendlySpider)event.entityLiving).field_70153_n instanceof EntityPlayer && event.distance < 5.0f) {
                event.setCanceled(true);
            }
            if (event.entityLiving instanceof EntityPlayer) {
                if (Wearing.isWearingBoots((EntityPlayer)event.entityLiving) && event.distance < 8.0f) {
                    event.setCanceled(true);
                }
                if (Wearing.isWearingTheRightBackpack((EntityPlayer)event.entityLiving, "IronGolem") && ConfigHandler.BACKPACK_ABILITIES) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerDies(LivingDeathEvent event) {
        if (Utils.notNullAndInstanceOf(event.entity, EntityPlayer.class)) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K) {
                ChunkCoordinates lastCampFire;
                BackpackProperty props = BackpackProperty.get(player);
                if (props.hasWearable()) {
                    ItemStack wearable = props.getWearable();
                    ((IBackWearableItem)wearable.func_77973_b()).onPlayerDeath(player.field_70170_p, player, wearable);
                }
                if (props.isForceCampFire() && (lastCampFire = BackpackProperty.get(player).getCampFire()) != null) {
                    player.setSpawnChunk(lastCampFire, false, player.field_71093_bK);
                }
                ServerProxy.storePlayerProps(player.func_110124_au(), props.getData());
            }
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void playerCraftsBackpack(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() == ModItems.adventureBackpack) {
            LogHelper.info("Player crafted a backpack, and that backpack's appearance is: " + event.crafting.func_77978_p().func_74779_i("colorName"));
            if (BackpackNames.getBackpackColorName(event.crafting).equals("Dragon")) {
                event.player.func_71019_a(new ItemStack(Blocks.field_150380_bt, 1), false);
                event.player.func_85030_a("mob.enderdragon.growl", 1.0f, 5.0f);
            }
        }
    }

    @SubscribeEvent
    public void interactWithCreatures(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            if (Utils.notNullAndInstanceOf(event.target, EntitySpider.class) && Wearing.isWearingTheRightBackpack(player, "Spider")) {
                EntityFriendlySpider pet = new EntityFriendlySpider(event.target.field_70170_p);
                pet.func_70012_b(event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, event.target.field_70177_z, event.target.field_70125_A);
                event.target.func_70106_y();
                event.entityPlayer.field_70170_p.func_72838_d((Entity)pet);
                event.entityPlayer.func_70078_a((Entity)pet);
            }
            if (Utils.notNullAndInstanceOf(event.target, EntityHorse.class)) {
                ItemStack stack = player.func_71045_bC();
                EntityHorse horse = (EntityHorse)event.target;
                if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemNameTag && stack.func_82837_s() && (horse.func_94057_bL() == null || horse.func_94057_bL().equals("") && horse.func_110248_bS())) {
                    horse.func_110263_g(player);
                    horse.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIHorseFollowOwner(horse, 1.5, 2.0f, 20.0f));
                    if (horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b) != null) {
                        horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
                        LogHelper.info("the horse follow range is now: " + horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b());
                    }
                }
            }
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void playerWokeUp(PlayerWakeUpEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        ChunkCoordinates bedLocation = event.entityPlayer.getBedLocation(event.entityPlayer.field_71093_bK);
        if (bedLocation != null && event.entityPlayer.field_70170_p.func_147439_a(bedLocation.field_71574_a, bedLocation.field_71572_b, bedLocation.field_71573_c) == ModBlocks.blockSleepingBag) {
            BackpackProperty.get(event.entityPlayer).setForceCampFire(true);
            LogHelper.info("Player just woke up in a sleeping bag, forcing respawn in the last lighted campfire, if there's any");
        } else {
            BackpackProperty.get(event.entityPlayer).setForceCampFire(false);
        }
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.player != null && !event.player.field_70128_L && Wearing.isWearingWearable(event.player)) {
            if (event.phase == TickEvent.Phase.START) {
                BackpackProperty.get(event.player).executeWearableUpdateProtocol();
            }
            if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
                EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
                if (Utils.notNullAndInstanceOf(event.player.field_71070_bA, IWearableContainer.class)) {
                    playerMP.func_71110_a(playerMP.field_71070_bA, playerMP.field_71070_bA.func_75138_a());
                    BackpackProperty.syncToNear(event.player);
                } else {
                    BackpackProperty.syncToNear(event.player);
                }
            }
        }
    }
}

