/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.handlers;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.client.gui.GuiAdvBackpack;
import com.darkona.adventurebackpack.client.gui.GuiCopterPack;
import com.darkona.adventurebackpack.client.gui.GuiSteamJetpack;
import com.darkona.adventurebackpack.inventory.ContainerBackpack;
import com.darkona.adventurebackpack.inventory.ContainerCopter;
import com.darkona.adventurebackpack.inventory.ContainerJetpack;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.inventory.InventoryCopterPack;
import com.darkona.adventurebackpack.inventory.InventorySteamJetpack;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    public static final byte JETPACK_WEARING = 6;
    public static final byte JETPACK_HOLDING = 5;
    public static final byte COPTER_WEARING = 4;
    public static final byte COPTER_HOLDING = 3;
    public static final byte BACKPACK_HOLDING = 2;
    public static final byte BACKPACK_WEARING = 1;
    public static final byte BACKPACK_TILE = 0;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                TileEntity te = world.func_147438_o(x, y, z);
                if (te == null || !(te instanceof TileAdventureBackpack)) break;
                return new ContainerBackpack(player, (TileAdventureBackpack)te, ContainerBackpack.SOURCE_TILE);
            }
            case 1: {
                InventoryBackpack inv = Wearing.getBackpackInv(player, true);
                if (inv.getParentItemStack() == null) break;
                return BackpackProperty.get(player).getContainer();
            }
            case 2: {
                InventoryBackpack inv = Wearing.getBackpackInv(player, false);
                if (inv.getParentItemStack() == null) break;
                return new ContainerBackpack(player, inv, ContainerBackpack.SOURCE_HOLDING);
            }
            case 3: {
                InventoryCopterPack inv2 = new InventoryCopterPack(Wearing.getHoldingCopter(player));
                if (inv2.getParentItemStack() == null) break;
                return new ContainerCopter(player, inv2, false);
            }
            case 4: {
                InventoryCopterPack inv2 = new InventoryCopterPack(Wearing.getWearingCopter(player));
                if (inv2.getParentItemStack() == null) break;
                return BackpackProperty.get(player).getContainer();
            }
            case 5: {
                InventorySteamJetpack inv3 = new InventorySteamJetpack(Wearing.getHoldingSteam(player));
                if (inv3.getParentItemStack() == null) break;
                return new ContainerJetpack(player, inv3, false);
            }
            case 6: {
                InventorySteamJetpack inv3 = new InventorySteamJetpack(Wearing.getWearingSteam(player));
                if (inv3.getParentItemStack() == null) break;
                return BackpackProperty.get(player).getContainer();
            }
            default: {
                player.func_71053_j();
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                TileEntity te = world.func_147438_o(x, y, z);
                if (te == null || !(te instanceof TileAdventureBackpack)) break;
                return new GuiAdvBackpack(player, (TileAdventureBackpack)te);
            }
            case 1: {
                InventoryBackpack inv = Wearing.getBackpackInv(player, true);
                if (inv.getParentItemStack() == null) break;
                return new GuiAdvBackpack(player, inv, true);
            }
            case 2: {
                InventoryBackpack inv = Wearing.getBackpackInv(player, false);
                if (inv.getParentItemStack() == null) break;
                return new GuiAdvBackpack(player, inv, false);
            }
            case 3: {
                InventoryCopterPack inv2 = new InventoryCopterPack(Wearing.getHoldingCopter(player));
                if (inv2.getParentItemStack() == null) break;
                return new GuiCopterPack(player, inv2, false);
            }
            case 4: {
                InventoryCopterPack inv2 = new InventoryCopterPack(Wearing.getWearingCopter(player));
                if (inv2.getParentItemStack() == null) break;
                return new GuiCopterPack(player, inv2, true);
            }
            case 5: {
                InventorySteamJetpack inv3 = new InventorySteamJetpack(Wearing.getHoldingSteam(player));
                if (inv3.getParentItemStack() == null) break;
                return new GuiSteamJetpack(player, inv3, false);
            }
            case 6: {
                InventorySteamJetpack inv3 = new InventorySteamJetpack(Wearing.getWearingSteam(player));
                if (inv3.getParentItemStack() == null) break;
                return new GuiSteamJetpack(player, inv3, true);
            }
            default: {
                player.func_71053_j();
            }
        }
        return null;
    }
}

