/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.client.gui;

import com.darkona.adventurebackpack.client.gui.GuiImageButtonNormal;
import com.darkona.adventurebackpack.client.gui.GuiTank;
import com.darkona.adventurebackpack.client.gui.GuiWithTanks;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.config.Keybindings;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.ContainerJetpack;
import com.darkona.adventurebackpack.inventory.InventorySteamJetpack;
import com.darkona.adventurebackpack.network.EquipUnequipBackWearablePacket;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiSteamJetpack
extends GuiWithTanks {
    private static final ResourceLocation texture = Resources.guiTextures("guiSteamJetpack");
    private static GuiTank waterTank = new GuiTank(8, 8, 72, 16, ConfigHandler.GUI_TANK_RENDER);
    private static GuiTank steamTank = new GuiTank(116, 8, 72, 16, ConfigHandler.GUI_TANK_RENDER);
    private static GuiImageButtonNormal equipButton = new GuiImageButtonNormal(150, 64, 18, 18);
    private static GuiImageButtonNormal unequipButton = new GuiImageButtonNormal(150, 64, 18, 18);
    private boolean wearing;
    EntityPlayer player;
    InventorySteamJetpack inventory;
    int boiling = 0;

    public GuiSteamJetpack(EntityPlayer player, InventorySteamJetpack inventory, boolean wearing) {
        super(new ContainerJetpack(player, inventory, wearing));
        this.wearing = wearing;
        this.player = player;
        this.inventory = inventory;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146976_a(float p_146976_1_, int mouseX, int mouseY) {
        this.inventory.func_70295_k_();
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.wearing) {
            if (unequipButton.inButton(this, mouseX, mouseY)) {
                unequipButton.draw(this, 20, 186);
            } else {
                unequipButton.draw(this, 1, 186);
            }
        } else if (equipButton.inButton(this, mouseX, mouseY)) {
            equipButton.draw(this, 20, 167);
        } else {
            equipButton.draw(this, 1, 167);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        if (this.wearing) {
            this.inventory = new InventorySteamJetpack(Wearing.getWearingSteam(this.player));
        }
        FluidTank water = this.inventory.getWaterTank();
        FluidTank steam = this.inventory.getSteamTank();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.inventory.isBoiling() && steam.getFluidAmount() < steam.getCapacity() && water.getFluidAmount() > 0) {
            if (this.boiling < 83) {
                this.func_73729_b(28, 40, 50, 172, this.boiling++, 37);
            } else {
                this.boiling = 0;
            }
        }
        if (this.inventory.getBurnTicks() > 0) {
            int i1 = this.inventory.getBurnTimeRemainingScaled(13);
            this.func_73729_b(78, 60 - i1, 176, 12 - i1, 14, i1 + 1);
        }
        int H = Math.round(0.36f * (float)this.inventory.getTemperature());
        this.func_73729_b(139, 8 + (72 - H), 40, 167 + (72 - H), 5, H);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        waterTank.draw(this, water);
        steamTank.draw(this, steam);
        float factor = 0.7f;
        String show = (water.getFluidAmount() > 0 ? Utils.capitalize(FluidRegistry.getFluidName((FluidStack)water.getFluid())) : "None") + "-" + water.getFluidAmount();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)70.0f, (float)10.0f, (float)0.0f);
        GL11.glScalef((float)factor, (float)factor, (float)factor);
        this.field_146289_q.func_85187_a(show, 0, 0, 0x373737, false);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        show = (steam.getFluidAmount() > 0 ? Utils.capitalize(FluidRegistry.getFluidName((FluidStack)steam.getFluid())) : "None") + "-" + steam.getFluidAmount();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)70.0f, (float)20.0f, (float)0.0f);
        GL11.glScalef((float)factor, (float)factor, (float)factor);
        this.field_146289_q.func_85187_a(show, 0, 0, 0x373737, false);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)145.0f, (float)8.0f, (float)0.0f);
        GL11.glScalef((float)0.9f, (float)0.9f, (float)0.9f);
        this.field_146289_q.func_85187_a(this.inventory.getTemperature() + " C", 0, 0, 0x373737, false);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int sneakKey = Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i();
        if (this.wearing) {
            if (unequipButton.inButton(this, mouseX, mouseY)) {
                ModNetwork.net.sendToServer((IMessage)new EquipUnequipBackWearablePacket.Message(1, false));
                this.player.func_71053_j();
            }
        } else if (equipButton.inButton(this, mouseX, mouseY)) {
            ModNetwork.net.sendToServer((IMessage)new EquipUnequipBackWearablePacket.Message(0, Keyboard.isKeyDown((int)sneakKey)));
            this.player.func_71053_j();
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public int getLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getTop() {
        return this.field_147009_r;
    }

    @Override
    public float getZLevel() {
        return this.field_73735_i;
    }

    protected void func_73869_a(char key, int keycode) {
        if (keycode == Keybindings.openBackpack.func_151463_i()) {
            this.player.func_71053_j();
        }
        super.func_73869_a(key, keycode);
    }
}

