/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.block;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class BlockSleepingBag
extends BlockDirectional {
    public static final int[][] footBlockToHeadBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] endIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] sideIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] topIcons;

    public BlockSleepingBag() {
        super(Material.field_151580_n);
        this.func_149978_e();
    }

    public String func_149739_a() {
        return "blockSleepingBag";
    }

    private void func_149978_e() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
    }

    public static boolean isBlockHeadOfBed(int meta) {
        return (meta & 8) != 0;
    }

    public static ChunkCoordinates verifyRespawnCoordinatesOnBlock(World world, ChunkCoordinates chunkCoordinates, boolean forced) {
        IChunkProvider ichunkprovider = world.func_72863_F();
        ichunkprovider.func_73158_c(chunkCoordinates.field_71574_a - 3 >> 4, chunkCoordinates.field_71573_c - 3 >> 4);
        ichunkprovider.func_73158_c(chunkCoordinates.field_71574_a + 3 >> 4, chunkCoordinates.field_71573_c - 3 >> 4);
        ichunkprovider.func_73158_c(chunkCoordinates.field_71574_a - 3 >> 4, chunkCoordinates.field_71573_c + 3 >> 4);
        ichunkprovider.func_73158_c(chunkCoordinates.field_71574_a + 3 >> 4, chunkCoordinates.field_71573_c + 3 >> 4);
        if (world.func_147439_a(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c).isBed((IBlockAccess)world, chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c, null)) {
            ChunkCoordinates newChunkCoords = world.func_147439_a(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c).getBedSpawnPosition((IBlockAccess)world, chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c, null);
            return newChunkCoords;
        }
        Material material = world.func_147439_a(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c).func_149688_o();
        Material material1 = world.func_147439_a(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b + 1, chunkCoordinates.field_71573_c).func_149688_o();
        boolean flag1 = !material.func_76220_a() && !material.func_76224_d();
        boolean flag2 = !material1.func_76220_a() && !material1.func_76224_d();
        return forced && flag1 && flag2 ? chunkCoordinates : null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int id, float f1, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        if (!BlockSleepingBag.isBlockHeadOfBed(meta)) {
            int dir = BlockSleepingBag.func_149895_l((int)meta);
            if (world.func_147439_a(x += footBlockToHeadBlockMap[dir][0], y, z += footBlockToHeadBlockMap[dir][1]) != this) {
                return true;
            }
            meta = world.func_72805_g(x, y, z);
        }
        if (world.field_73011_w.func_76567_e() && world.func_72807_a(x, z) != BiomeGenBase.field_76778_j) {
            EntityPlayer.EnumStatus enumstatus;
            if (BlockSleepingBag.isBedOccupied(meta)) {
                EntityPlayer entityplayer1 = null;
                for (EntityPlayer entityplayer2 : world.field_73010_i) {
                    if (!entityplayer2.func_70608_bn()) continue;
                    ChunkCoordinates chunkcoordinates = entityplayer2.field_71081_bT;
                    if (chunkcoordinates.field_71574_a != x || chunkcoordinates.field_71572_b != y || chunkcoordinates.field_71573_c != z) continue;
                    entityplayer1 = entityplayer2;
                }
                if (entityplayer1 != null) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.occupied", new Object[0]));
                    return true;
                }
                BlockSleepingBag.setBedOccupied(world, x, y, z, false);
            }
            if ((enumstatus = player.func_71018_a(x, y, z)) == EntityPlayer.EnumStatus.OK) {
                BlockSleepingBag.setBedOccupied(world, x, y, z, true);
                player.setSpawnChunk(new ChunkCoordinates(x, y, z), true, player.field_71093_bK);
                LogHelper.info("Looking for a campfire nearby...");
                ChunkCoordinates campfire = Utils.findBlock3D(world, x, y, z, (Block)ModBlocks.blockCampFire, 8, 2);
                if (campfire != null) {
                    LogHelper.info("Campfire Found, saving coordinates. " + LogHelper.print3DCoords(campfire));
                    BackpackProperty.get(player).setCampFire(campfire);
                }
                return true;
            }
            if (enumstatus == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
            } else if (enumstatus == EntityPlayer.EnumStatus.NOT_SAFE) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
            }
            return true;
        }
        double d2 = (double)x + 0.5;
        double d0 = (double)y + 0.5;
        double d1 = (double)z + 0.5;
        world.func_147468_f(x, y, z);
        int k1 = BlockSleepingBag.func_149895_l((int)meta);
        if (world.func_147439_a(x += footBlockToHeadBlockMap[k1][0], y, z += footBlockToHeadBlockMap[k1][1]) == this) {
            world.func_147468_f(x, y, z);
            d2 = (d2 + (double)x + 0.5) / 2.0;
            d0 = (d0 + (double)y + 0.5) / 2.0;
            d1 = (d1 + (double)z + 0.5) / 2.0;
        }
        world.func_72885_a((Entity)null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 5.0f, true, true);
        return true;
    }

    public static void setBedOccupied(World world, int x, int y, int z, boolean flag) {
        int l = world.func_72805_g(x, y, z);
        l = flag ? (l |= 4) : (l &= 0xFFFFFFFB);
        world.func_72921_c(x, y, z, l, 4);
    }

    public static boolean isBedOccupied(int meta) {
        return (meta & 4) != 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        int dir = BlockSleepingBag.func_149895_l((int)meta);
        if (BlockSleepingBag.isBlockHeadOfBed(meta)) {
            if (world.func_147439_a(x - footBlockToHeadBlockMap[dir][0], y, z - footBlockToHeadBlockMap[dir][1]) != this) {
                world.func_147468_f(x, y, z);
            }
        } else if (world.func_147439_a(x + footBlockToHeadBlockMap[dir][0], y, z + footBlockToHeadBlockMap[dir][1]) != this) {
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, meta, 0);
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.blockBoundsForRender();
    }

    private void blockBoundsForRender() {
        this.func_149978_e();
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public static ChunkCoordinates func_149977_a(World world, int x, int y, int z, int whatever) {
        int meta = world.func_72805_g(x, y, z);
        int dir = BlockDirectional.func_149895_l((int)meta);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = x - footBlockToHeadBlockMap[dir][0] * k1 - 1;
            int i2 = z - footBlockToHeadBlockMap[dir][1] * k1 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!World.func_147466_a((IBlockAccess)world, (int)l2, (int)(y - 1), (int)i3) || world.func_147439_a(l2, y, i3).func_149688_o().func_76218_k() || world.func_147439_a(l2, y + 1, i3).func_149688_o().func_76218_k()) continue;
                    if (whatever <= 0) {
                        return new ChunkCoordinates(l2, y, i3);
                    }
                    --whatever;
                }
            }
        }
        return null;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        int direction = BlockSleepingBag.func_149895_l((int)meta);
        if (player.field_71075_bZ.field_75098_d && BlockSleepingBag.isBlockHeadOfBed(meta) && world.func_147439_a(x -= footBlockToHeadBlockMap[direction][0], y, z -= footBlockToHeadBlockMap[direction][1]) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion boom) {
        this.func_149664_b(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        int direction = BlockSleepingBag.func_149895_l((int)meta);
        int tileZ = z;
        int tileX = x;
        switch (meta) {
            case 0: {
                --tileZ;
                break;
            }
            case 1: {
                ++tileX;
                break;
            }
            case 2: {
                ++tileZ;
                break;
            }
            case 3: {
                --tileX;
            }
        }
        if (world.func_147438_o(tileX, y, tileZ) != null && world.func_147438_o(tileX, y, tileZ) instanceof TileAdventureBackpack) {
            ((TileAdventureBackpack)world.func_147438_o(tileX, y, tileZ)).setSleepingBagDeployed(false);
        }
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int isHead;
        if (side == 0) {
            return Blocks.field_150344_f.func_149733_h(side);
        }
        int k = BlockSleepingBag.func_149895_l((int)meta);
        int l = Direction.field_71584_h[k][side];
        int n = isHead = BlockSleepingBag.isBlockHeadOfBed(meta) ? 1 : 0;
        return !(isHead == 1 && l == 2 || isHead == 0 && l == 3) ? (l != 5 && l != 4 ? this.topIcons[isHead] : this.sideIcons[isHead]) : this.endIcons[isHead];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcons = new IIcon[]{iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_feet_top").toString()), iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_head_top").toString())};
        this.endIcons = new IIcon[]{iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_feet_end").toString()), iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_head_end").toString())};
        this.sideIcons = new IIcon[]{iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_feet_side").toString()), iconRegister.func_94245_a(Resources.blockTextures("sleepingBag_head_side").toString())};
    }

    public int func_149645_b() {
        return 14;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149703_v() {
        return super.func_149703_v();
    }
}

