/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.thread.SchedulerTimerTask;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactivityMonitor
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(InactivityMonitor.class);
    private static ThreadPoolExecutor ASYNC_TASKS;
    private static int CHECKER_COUNTER;
    private static long DEFAULT_CHECK_TIME_MILLS;
    private static Timer READ_CHECK_TIMER;
    private static Timer WRITE_CHECK_TIMER;
    private WireFormatInfo localWireFormatInfo;
    private WireFormatInfo remoteWireFormatInfo;
    private final AtomicBoolean monitorStarted = new AtomicBoolean(false);
    private final AtomicBoolean commandSent = new AtomicBoolean(false);
    private final AtomicBoolean inSend = new AtomicBoolean(false);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean commandReceived = new AtomicBoolean(true);
    private final AtomicBoolean inReceive = new AtomicBoolean(false);
    private final AtomicInteger lastReceiveCounter = new AtomicInteger(0);
    private SchedulerTimerTask writeCheckerTask;
    private SchedulerTimerTask readCheckerTask;
    private boolean ignoreRemoteWireFormat = false;
    private boolean ignoreAllWireFormatInfo = false;
    private long readCheckTime = DEFAULT_CHECK_TIME_MILLS;
    private long writeCheckTime = DEFAULT_CHECK_TIME_MILLS;
    private long initialDelayTime = DEFAULT_CHECK_TIME_MILLS;
    private boolean useKeepAlive = true;
    private boolean keepAliveResponseRequired;
    private WireFormat wireFormat;
    private final Runnable readChecker = new Runnable(){
        long lastRunTime;

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastRunTime;
            if (this.lastRunTime != 0L && LOG.isDebugEnabled()) {
                LOG.debug("" + elapsed + " ms elapsed since last read check.");
            }
            if (!InactivityMonitor.this.allowReadCheck(elapsed)) {
                LOG.debug("Aborting read check.. Not enough time elapsed since last read check.");
                return;
            }
            this.lastRunTime = now;
            InactivityMonitor.this.readCheck();
        }
    };
    private final Runnable writeChecker = new Runnable(){
        long lastRunTime;

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            if (this.lastRunTime != 0L && LOG.isDebugEnabled()) {
                LOG.debug(this + " " + (now - this.lastRunTime) + " ms elapsed since last write check.");
            }
            this.lastRunTime = now;
            InactivityMonitor.this.writeCheck();
        }
    };
    private ThreadFactory factory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "InactivityMonitor Async Task: " + runnable);
            thread.setDaemon(true);
            return thread;
        }
    };

    private boolean allowReadCheck(long elapsed) {
        return elapsed > this.readCheckTime * 9L / 10L;
    }

    public InactivityMonitor(Transport next, WireFormat wireFormat) {
        super(next);
        this.wireFormat = wireFormat;
        if (this.wireFormat == null) {
            this.ignoreAllWireFormatInfo = true;
        }
    }

    @Override
    public void start() throws Exception {
        this.next.start();
        this.startMonitorThreads();
    }

    @Override
    public void stop() throws Exception {
        this.stopMonitorThreads();
        this.next.stop();
    }

    final void writeCheck() {
        if (this.inSend.get()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("A send is in progress");
            }
            return;
        }
        if (!this.commandSent.get() && this.useKeepAlive) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + " no message sent since last write check, sending a KeepAliveInfo");
            }
            ASYNC_TASKS.execute(new Runnable(){

                @Override
                public void run() {
                    if (InactivityMonitor.this.monitorStarted.get()) {
                        try {
                            KeepAliveInfo info = new KeepAliveInfo();
                            info.setResponseRequired(InactivityMonitor.this.keepAliveResponseRequired);
                            InactivityMonitor.this.oneway(info);
                        }
                        catch (IOException e) {
                            InactivityMonitor.this.onException(e);
                        }
                    }
                }
            });
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(this + " message sent since last write check, resetting flag");
        }
        this.commandSent.set(false);
    }

    final void readCheck() {
        int currentCounter = this.next.getReceiveCounter();
        int previousCounter = this.lastReceiveCounter.getAndSet(currentCounter);
        if (this.inReceive.get() || currentCounter != previousCounter) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("A receive is in progress");
            }
            return;
        }
        if (!this.commandReceived.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No message received since last read check for " + this.toString() + "! Throwing InactivityIOException.");
            }
            ASYNC_TASKS.execute(new Runnable(){

                @Override
                public void run() {
                    InactivityMonitor.this.onException(new InactivityIOException("Channel was inactive for too (>" + InactivityMonitor.this.readCheckTime + ") long: " + InactivityMonitor.this.next.getRemoteAddress()));
                }
            });
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Message received since last read check, resetting flag: ");
        }
        this.commandReceived.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommand(Object command) {
        block17: {
            this.commandReceived.set(true);
            this.inReceive.set(true);
            try {
                Object object;
                if (command.getClass() == KeepAliveInfo.class) {
                    KeepAliveInfo info = (KeepAliveInfo)command;
                    if (info.isResponseRequired()) {
                        try {
                            info.setResponseRequired(false);
                            this.oneway(info);
                        }
                        catch (IOException e) {
                            this.onException(e);
                        }
                    }
                    break block17;
                }
                if (command.getClass() == WireFormatInfo.class) {
                    object = this;
                    synchronized (object) {
                        IOException error = null;
                        this.remoteWireFormatInfo = (WireFormatInfo)command;
                        try {
                            this.startMonitorThreads();
                        }
                        catch (IOException e) {
                            error = e;
                        }
                        if (error != null) {
                            this.onException(error);
                        }
                    }
                }
                object = this.readChecker;
                synchronized (object) {
                    this.transportListener.onCommand(command);
                }
            }
            finally {
                this.inReceive.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        AtomicBoolean atomicBoolean = this.inSend;
        synchronized (atomicBoolean) {
            this.inSend.set(true);
            try {
                if (this.failed.get()) {
                    throw new InactivityIOException("Cannot send, channel has already failed: " + this.next.getRemoteAddress());
                }
                if (o.getClass() == WireFormatInfo.class) {
                    InactivityMonitor inactivityMonitor = this;
                    synchronized (inactivityMonitor) {
                        this.localWireFormatInfo = (WireFormatInfo)o;
                        this.startMonitorThreads();
                    }
                }
                this.next.oneway(o);
            }
            finally {
                this.commandSent.set(true);
                this.inSend.set(false);
            }
        }
    }

    @Override
    public void onException(IOException error) {
        if (this.failed.compareAndSet(false, true)) {
            this.stopMonitorThreads();
            this.transportListener.onException(error);
        }
    }

    public void setKeepAliveResponseRequired(boolean val) {
        this.keepAliveResponseRequired = val;
    }

    public void setUseKeepAlive(boolean val) {
        this.useKeepAlive = val;
    }

    public void setIgnoreRemoteWireFormat(boolean val) {
        this.ignoreRemoteWireFormat = val;
    }

    public long getReadCheckTime() {
        return this.readCheckTime;
    }

    public void setReadCheckTime(long readCheckTime) {
        this.readCheckTime = readCheckTime;
    }

    public long getInitialDelayTime() {
        return this.initialDelayTime;
    }

    public void setInitialDelayTime(long initialDelayTime) {
        this.initialDelayTime = initialDelayTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void startMonitorThreads() throws IOException {
        if (this.monitorStarted.get()) {
            return;
        }
        if (!this.configuredOk()) {
            return;
        }
        if (this.readCheckTime <= 0L) return;
        this.monitorStarted.set(true);
        this.writeCheckerTask = new SchedulerTimerTask(this.writeChecker);
        this.readCheckerTask = new SchedulerTimerTask(this.readChecker);
        this.writeCheckTime = this.readCheckTime > 3L ? this.readCheckTime / 3L : this.readCheckTime;
        Class<InactivityMonitor> clazz = InactivityMonitor.class;
        synchronized (InactivityMonitor.class) {
            if (CHECKER_COUNTER == 0) {
                ASYNC_TASKS = this.createExecutor();
                READ_CHECK_TIMER = new Timer("InactivityMonitor ReadCheck", true);
                WRITE_CHECK_TIMER = new Timer("InactivityMonitor WriteCheck", true);
            }
            ++CHECKER_COUNTER;
            WRITE_CHECK_TIMER.scheduleAtFixedRate((TimerTask)this.writeCheckerTask, this.initialDelayTime, this.writeCheckTime);
            READ_CHECK_TIMER.scheduleAtFixedRate((TimerTask)this.readCheckerTask, this.initialDelayTime, this.readCheckTime);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean configuredOk() throws IOException {
        boolean configured = false;
        if (this.ignoreAllWireFormatInfo) {
            configured = true;
        } else if (this.localWireFormatInfo != null && this.remoteWireFormatInfo != null) {
            if (!this.ignoreRemoteWireFormat) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using min of local: " + this.localWireFormatInfo + " and remote: " + this.remoteWireFormatInfo);
                }
                this.readCheckTime = Math.min(this.localWireFormatInfo.getMaxInactivityDuration(), this.remoteWireFormatInfo.getMaxInactivityDuration());
                this.initialDelayTime = Math.min(this.localWireFormatInfo.getMaxInactivityDurationInitalDelay(), this.remoteWireFormatInfo.getMaxInactivityDurationInitalDelay());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using local: " + this.localWireFormatInfo);
                }
                this.readCheckTime = this.localWireFormatInfo.getMaxInactivityDuration();
                this.initialDelayTime = this.localWireFormatInfo.getMaxInactivityDurationInitalDelay();
            }
            configured = true;
        }
        return configured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void stopMonitorThreads() {
        if (!this.monitorStarted.compareAndSet(true, false)) return;
        this.readCheckerTask.cancel();
        this.writeCheckerTask.cancel();
        Class<InactivityMonitor> clazz = InactivityMonitor.class;
        synchronized (InactivityMonitor.class) {
            WRITE_CHECK_TIMER.purge();
            READ_CHECK_TIMER.purge();
            if (--CHECKER_COUNTER != 0) return;
            WRITE_CHECK_TIMER.cancel();
            READ_CHECK_TIMER.cancel();
            WRITE_CHECK_TIMER = null;
            READ_CHECK_TIMER = null;
            ASYNC_TASKS.shutdownNow();
            ASYNC_TASKS = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadPoolExecutor createExecutor() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.factory);
    }

    static {
        DEFAULT_CHECK_TIME_MILLS = 30000L;
    }
}

