/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.transport.Transport;

public class ActiveMQXAConnectionFactory
extends ActiveMQConnectionFactory
implements XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory {
    public ActiveMQXAConnectionFactory() {
    }

    public ActiveMQXAConnectionFactory(String userName, String password, String brokerURL) {
        super(userName, password, brokerURL);
    }

    public ActiveMQXAConnectionFactory(String userName, String password, URI brokerURL) {
        super(userName, password, brokerURL);
    }

    public ActiveMQXAConnectionFactory(String brokerURL) {
        super(brokerURL);
    }

    public ActiveMQXAConnectionFactory(URI brokerURL) {
        super(brokerURL);
    }

    public XAConnection createXAConnection() throws JMSException {
        return (XAConnection)this.createActiveMQConnection();
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return (XAConnection)this.createActiveMQConnection(userName, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createActiveMQConnection();
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        return (XAQueueConnection)this.createActiveMQConnection(userName, password);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createActiveMQConnection();
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        return (XATopicConnection)this.createActiveMQConnection(userName, password);
    }

    @Override
    protected ActiveMQConnection createActiveMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
        ActiveMQXAConnection connection = new ActiveMQXAConnection(transport, this.getClientIdGenerator(), stats);
        return connection;
    }
}

