/*
 * 项目: 新浪曲库
 * 说明: 公用js函数库
 * 
 *
 * 创建日期: 2008/11/25
 * 作者: 胡国亮 (guoliang1@staff.sina.com.cn)
 */
 
 //状态说明
 gStatus = new Array();
 gStatus[1] = '新入库';
 gStatus[2] = '被修改';
 gStatus[20] = '已审核';
 gStatus[21] = '待上线';
 gStatus[22] = 'rsync完成';
 gStatus[23] = '进入上线队列等待';
 gStatus[50] = '已上线';
 gStatus[51] = '待下线';
 gStatus[52] = '开始处理（虚拟占位）';
 gStatus[53] = '进入下线队列等待';
 gStatus[80] = '已下线';
 gStatus[81] = '待删除';
 gStatus[82] = '开始处理（虚拟占位）';
 gStatus[83] = '进入删除队列等待';
 gStatus[110] = '虚拟物理删除';
 gStatus[111] = '没有歌曲的音频文件';
 gStatus[112] = 'rsync失败';
 gStatus[113] = '转码失败';
 gStatus[114] = 'post129失败';
 gStatus[115] = '锁定';
 gStatus[116] = '字符编码错误';
 gStatus[201] = '等待物理删除，手动操作';
 
//获取 id 为 eId 的HTML 元素
function $id(eId) {
	return document.getElementById(eId);
}

//获取 name 为 eName的HTML元素
function $name(eName) {
	return document.getElementsByName(eName);
}

 /*
  * 对多选框做 全选或取消全选 的操作,依赖jquery
  * 
  * @param eName checkbox的元素名称
  * @param isCheck true:选择 false:取消选择 
  * 
  * @example:
  *   <input name="albumID[]" type="checkbox" value="1" />
  * 
  *   <input name="albumIDCheckBtn" onclick="checkAll('albumID[]', this.checked)" type="checkbox"  /> 
  */
function checkAll(eName, isCheck) {
	var chk = typeof(isCheck) == 'boolean' ? isCheck : isCheck.checked;
	jQuery($name(eName)).attr('checked', chk);
}

//检查EMAIL
function isEmail(str) {
  var reg = /^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+((\.[a-zA-Z0-9_-]{2,3}){1,2})$/;
  var flag = reg.test(str);
  return flag;
}

//检查是否字母
function isAlpha(str) {
  var reg = /^[A-z]+$/;
  var flag = reg.test(str);
  return flag;
}

//检查是否字母或数字
function isAlphaNumeric(str) {
  var reg = /^[0123456789A-z]+$/;
  var flag = reg.test(str);
  return flag;
}

//检查是否字母或数字或中划线下划线
function isAlphaDash(str) {
  var reg = /^[-_0123456789A-z]+$/;
  var flag = reg.test(str);
  return flag;
}

//检查是否数值
function isNumeric(str) {
  var reg = /^-?[0-9]+\.?[0-9]*$/;
  var flag = reg.test(str);
  return flag;
}

//检查是否整值
function isInt(str) {
  var reg = /^-?[0-9]+$/;
  var flag = reg.test(str);
  return flag;
}

//检查有没有选择单选项的其中一个
function isRadioChecked(rName) {
	var rdos = $name(rName);
	for (var r = 0; r < rdos.length; r++) {
		if (rdos[r].checked) {
			return true;
		}
	}
	
	return false;
}

//检查下拉框有没有被选
function isSelected(sName) {
	var ss = $name(sName);

	if (ss[0] && ss[0].selectedIndex > 0) {

		return true;
	}
	
	return false;
}

/**
 * 检查是否为ID格式
 * 1349 或 1,2,3 或 1-10
 */ 
function isID(str) {
	var reg1 = /^[0-9]+$/;
	var reg2 = /^([0-9]+,?)+[0-9]+$/;
	var reg3 = /^[0-9]+-[0-9]+$/;

	return ((isInt(str) && str > 0) || reg1.test(str) || reg2.test(str) || reg3.test(str));
}


/**
 * 检查元素是否在数组中
 * 返回true or false
 */
function in_array(ele, arr) {
	for (var arr_i = 0; arr_i < arr.length; arr_i++) {
		if (ele == arr[arr_i]) {
			return true;
		}
	}
	
	return false;
}

//检查日期格式
function isDate(str) {
  var reg = /^([0-9]{4}|[0-9]{2})-[0-9]{1,2}-[0-9]{1,2}$/;
  var reg1 = /^([0-9]{4}|[0-9]{2})(-|\/)[0-9]{1,2}(-|\/)[0-9]{1,2}$/;
  var reg2 = /^[0-9]{1,2}(-|\/)[0-9]{1,2}$/;
  var reg3 = /^[0-9]{4}(-|\/)[0-9]{1,2}$/;
  
  return (reg.test(str) || reg1.test(str) || reg2.test(str) || reg3.test(str));   
}


function isFdate(str, fm) {
	arrformat = fm.split(',');
	var reg;
	var regz;
	for (i = 0; i < arrformat.length; i++) {
		if (arrformat[i] == 'yyyy') {
			reg = /^[0-9]{4}$/;
			regz = /^[0-9]{4}年$/;
		} else if (arrformat[i] == 'yyyy-mm') {
			reg = /^[0-9]{4}-([0]?[1-9]{1}|10|11|12)$/;
			regz = /^[0-9]{4}年([0]?[1-9]{1}|10|11|12)月$/;
		} else if (arrformat[i] == 'yyyy-mm-dd') {
			reg = /^[0-9]{4}-([0]?[1-9]{1}|10|11|12)-([0]?[1-9]{1}|(1[0-9]{1})|(2[0-9]{1})|30|31)$/;
			regz = /^[0-9]{4}年([0]?[1-9]{1}|10|11|12)月([0]?[1-9]{1}|(1[0-9]{1})|(2[0-9]{1})|30|31)日$/;
		} else if (arrformat[i] == 'mm-dd') {
			reg = /^([0]?[1-9]{1}|10|11|12)-([0]?[1-9]{1}|(1[0-9]{1})|(2[0-9]{1})|30|31)$/;
			regz = /^([0]?[1-9]{1}|10|11|12)月([0]?[1-9]{1}|(1[0-9]{1})|(2[0-9]{1})|30|31)日$/;
		}
		
		if (reg.test(str)) {
			return true;
		}
		if (regz.test(str)) {
			return true;
		}
	}
	
	return false;
}
/**
 * 测试年份必须大于1970年
 */
function chkYear(str) {
	var reg = /^\d{4}/;
	if ((result = str.match(reg)) && result[1] < 1970) {
		return false;
	}
	return true;
}

/**
 * 是否少于当前日期
 */
function isLessNow(str) {
	var reg = /^(\d{2,4})([\-\/]([01]?\d))?([\-\/]([0-3]?\d))?$/;
	if (!(result = str.match(reg))) {
		return false;
	}
	d = new Date();
	d = new Date(d.getFullYear(), d.getMonth(), d.getDate());
	if (result[1].length < 4) {
		if (new Number(result[1]) > (d.getFullYear() % 100) && new Number(result[1]) >= 70) {
			result[1] = "19" + result[1];
		} else {
			year = new String(d.getFullYear ());
			result[1] = year.substr(0,2) + new String(result[1]);
		}
	}
	if (result[1] && result[3] && result[5]) {
		date = new Date(result[1] , result[3] - 1 , result[5]);
		if (date > d) {
			return false;
		}
	} else if (result[1] && result[3]) {
		if (result[1] > d.getFullYear()) {
			return false;
		} else if (result[1] == d.getFullYear() && result[3] > d.getMonth() + 1) {
			return false;
		}
	} else if (result[1] > d.getFullYear()) {
		return false;
	}
	return true;
}

/**
 * 检查是否大于当前日期
 */
function isMoreThanNow(str) {
	var reg = /^(\d{2,4})([\-\/]([01]?\d))?([\-\/]([0-3]?\d))?$/;
	if (!(result = str.match(reg))) {
		return false;
	}
	d = new Date();
	d = new Date(d.getFullYear(), d.getMonth(), d.getDate());
	// 补全年份
	if (result[1].length < 4) {
		if (new Number(result[1]) > (d.getFullYear() % 100) && new Number(result[1]) >= 70) {
			result[1] = "19" + result[1];
		} else {
			year = new String(d.getFullYear ());
			result[1] = year.substr(0,2) + new String(result[1]);
		}
	}
	if (result[1] && result[3] && result[5]) {
		date = new Date(result[1] , result[3] - 1 , result[5]);
		if (date < d) {
			return false;
		}
	} else if (result[1] && result[3]) {
		if (result[1] < d.getFullYear()) {
			return false;
		} else if (result[1] == d.getFullYear() && result[3] > d.getMonth() + 1) {
			return false;
		}
	} else if (result[1] < d.getFullYear()) {
		return false;
	}
	return true;
}

/**
 * 功能: 验证表单中,用户输入内容是否适合
 * form 表单对象
 * showmode 显示方式：'alert'、'div'(默认)
 * 		alert: 使用alert函数提示
 * 		div:   显示在"元素名_msg"的DIV或TD
 */
function checkForm(form, showmode, act) {
	//第一个有提示信息的元素
	this.firstMsgElement = null;
	
	//提示信息的左边距
	this.msgBoxLeft = null;
	
	if (!showmode) {
		showmode = 'div';
	}
	
	if (act) {
		form.action = act;
	}
	if (form.tagName.toLowerCase() == 'form') {
		var eles = form.elements;
	} else {
		var eles = [form];
	}
	//frm的检查标记,默认true
	var succeed = true;
	
	var alert_msg = '';
	
	this.showError = function (ele, msg) {
		if (!msg || msg == '') {
			return ;
		}
		//设置第一个有提示信息的元素
		if (this.firstMsgElement == null && ele.type != 'hidden') {
			this.firstMsgElement = ele;
		}
		
		var idDiv = ele.name + '_msg';
		var msgp = $id(idDiv);
		
		// 尝试使用控件ID构建信息显示框ID
		if (!msgp) {
			msgp = $id(ele.id + '_msg');
			}
		
		if (!msgp) {
			msgp = document.createElement('div');
			msgp.className = 'reg_info';
			msgp.id = idDiv;
			msgp.style.zIndex = 9999;
			
			var posele = $name(ele.name);
			posele = posele[posele.length-1];
			
			document.body.appendChild(msgp);
			
			if (posele.type == 'hidden') {
				posele = $(posele).parent()[0];
			}
			
						
			var offset = getScreenOffset(posele);

			if (this.msgBoxLeft == null) {
				this.msgBoxLeft = offset.x + posele.clientWidth + 5;
			}
			msgp.style.position = 'absolute';
			msgp.style.left = this.msgBoxLeft + 'px';
			msgp.style.top = offset.y + 'px';
			
		}
		
		msgp.className = 'reg_info1';
		
		msgp.innerHTML = msg;
		msgp.style.display = '';
		
		if (msgp.style.position == 'absolute') {
			msgp.style.width = (msg.length + 2) + 'em';
		}
		
	}
	
	//隐藏信息
	this.hideError = function(ele) {
		var msgp = $id(ele.name + '_msg');
		if (!msgp) {
			msgp = $id(ele.id + '_msg');
			}
		
		if (msgp) {
			if (msgp.className == 'reg_info1') {
				msgp.className = '';
				msgp.innerHTML = '';
			} else if (msgp.className == 'reg_info'){
				msgp.style.display = 'none';
			}
		}
	}
try{
	CHECKELE:
	for (var i = 0; i < eles.length; i++) {
		var unitresult = true;
		var ele = eles[i];
		
		var break_for = false;
		
		//错误提示
		var errInfo = '';
		  
		//获取检查串
		if ($.browser.msie) {
			var valid_str = ele.valid;
		}else{
			var valid_str = ele.getAttribute('valid');
		}
		

		//没有设置则返回
		if(!valid_str) {
			continue;
		}
		
		var eleValue = ele.value;
		
		//分解属性
		var valids = valid_str.split('|');
		
		//处理单选和多选
		if ((ele.type == 'radio' || ele.type == 'checkbox') && in_array('required', valids)) {
			var result = isRadioChecked(ele.name);
			if (!result) {
				errInfo += '必须选择其中一个选项！';
				unitresult = false;
			}
		}
		
		//上传框
		if (ele.type == 'file') {
			for (vs = 0; vs < valids.length; vs++) {
				if (valids[vs].indexOf(':') > 0) {
					param = valids[vs].split(':');
					
					if (param[0] == 'type' && ele.value != ''){
						types = param[1].split(',');

						ftype = ele.value.split('.');
						result = in_array(ftype[ftype.length-1].toLowerCase(), types);
						if (!result) {
							errInfo += '只能上传指定的文件类型：' + types.join(',');
							unitresult = false;
						}
					}
					
				} else {
					if ('required' == valids[vs]) {
						var result = ele.value != '';
						if (!result) {
							errInfo += '请选择要上传的文件！';
							unitresult = false;
						}
					}
				}
			}
		}
		
		//下拉
		if (ele.type == 'select-one' || ele.type == 'select') {
			var result = isSelected(ele.name);
			if (!result) {
				errInfo += '必须选择其中一个选项！';
				unitresult = false;
			}
		}

		//检查text类型输入框
		if (ele.type == 'text' || ele.type == 'textarea' || ele.type == 'password' || ele.type == 'hidden') {
			for (var j = 0; j < valids.length; j++) {
				//元素值测试
				var result = true;
				switch (valids[j]) {
					case 'trim':
						ele.value = eleValue = jQuery.trim(eleValue);
						break;
					
					case 'required':
						result = (eleValue != '');
						if (!result) {
							errInfo += '请输入此项信息';
							unitresult = false;
						}
						break;
					
					case 'norequired':
						if (eleValue == '') {
							//result = true;
							//unitresult = true;
							break_for = true;
						}
						
						break;
						
					case 'alpha':
						var result = isAlpha(eleValue);
						
						if (!result) {
							errInfo += '只能输入英文！';
							unitresult = false;
						}
						
						break;
						
					case 'alpha_numeric':
						var result = isAlphaNumeric(eleValue);
						if (!result) {
							errInfo += '只能输入英文和数字！';
							unitresult = false;
						}
						break;
					
					case 'alpha_dash':
						var result = isAlphaDash(eleValue);
						if (!result) {
							errInfo += '只有输入英文、数字、_、- ！';
							unitresult = false;

						}
						break;
						
					case 'numeric':
						var result = isNumeric(eleValue);
						if (!result) {
							errInfo += '只能输入有效的数值！';
							unitresult = false;
						}
						break;
						
					case 'int':
						var result = isInt(eleValue);
						if (!result) {
							errInfo += '只允许输入整数！';
							unitresult = false;
						}
						break;
						
					case 'email':
						var result = isEmail(eleValue);
						if (!result){
							errInfo += 'email格式不正确！';
							unitresult = false;
						}
						break;
						
					case 'date':
						var result = isDate(eleValue);
						if (!result) {
							errInfo += '日期格式不正确;';
							unitresult = false;
						}
						if (!chkYear(eleValue)) {
							errInfo += "年份不能少于1970";
							unitresult = false;
							}
						
						// 只有完整的日期格式(年、月、日写全)才执行测试
						if (in_array("less_now", valids) && eleValue.match(/\d{2,4}[\/\-]\d{1,2}[\/\-]\d{1,2}/) && !isLessNow(eleValue)) {
							errInfo += "不能大于当前日期";
							unitresult = false;
						}
						// 只有完整的日期格式(年、月、日写全)才执行测试
						if (in_array("more_than_now", valids) && eleValue.match(/\d{2,4}[\/\-]\d{1,2}[\/\-]\d{1,2}/) && !isMoreThanNow(eleValue)) {
							errInfo += "不能少于当前日期";
							unitresult = false;
						}
						break;
					case 'time':
						if (eleValue != '') {
							if (!(rs = eleValue.match(/^(\d{2}):(\d{2})(:(\d{2}))?$/))) {
								errInfo += "时间格式不正确"
								unitresult = false;
							} else {
								if (parseInt(rs[1]) > 23) {
									errInfo += "时间格式不正确,＂小时＂不能超23";
									unitresult = false;
								}
								if (parseInt(rs[2]) > 59) {
									errInfo += "时间格式不正确,＂分钟＂不能超59";
									unitresult = false;
								}
								if (rs[4] && parseInt(rs[4]) > 59) {
									errInfo += "时间格式不正确,＂秒＂不能超59";
									unitresult = false;
								}
							}
						}
						break;
					case 'ID':
						if (eleValue) {
							result = isID(eleValue);
							if (!result) {
								errInfo += '不符合ID格式！';
								unitresult = false;
							}
						}
						break;
						
					case 'nospace':
						result = eleValue.indexOf(' ') == -1;
						if (!result) {
							errInfo += '不能含有空格！';
							unitresult = false;
						}
						break;
					
					default:
						if (valids[j].indexOf(':') > 0) {
							var part = valids[j].split(':'); 
							switch (part[0]) {
								case 'min_length':
									var result = (eleValue.length >= part[1]);
									if (!result) { 
										errInfo += ('最少要输入' + part[1] + '个字符！');
										unitresult = false;
									}
									break;
									
								case 'max_length':
									var result = (eleValue.length <= part[1]);
									if (!result) {
										errInfo += ('最多只能输入' + part[1] + '个字符！');
										unitresult = false;
									}
									break;
									
								case 'length':
									var result = (eleValue.length == part[1]);
									if (!result) {
										errInfo += ('必须输入' + part[1] + '个字符！');
										unitresult = false;
									}
									break;
									
								case 'fdate':
									if (eleValue == '') {
										break_for = true;
									} else {
										var result = isFdate(eleValue, part[1]);
										if (!result) {
											errInfo += '日期格式不正确。';
											unitresult = false;
										}
										if (!chkYear(eleValue)) {
											errInfo += "年份不能少于1970";
											unitresult = false;
										}
										// 只有完整的日期格式(年、月、日写全)才执行测试
										if (in_array("less_now", valids) && eleValue.match(/\d{2,4}[\/\-]\d{1,2}[\/\-]\d{1,2}/) && !isLessNow(eleValue)) {
											errInfo += "不能大于当前日期";
											unitresult = false;
										}
										// 只有完整的日期格式(年、月、日写全)才执行测试
										if (in_array("more_than_now", valids) && eleValue.match(/\d{2,4}[\/\-]\d{1,2}[\/\-]\d{1,2}/) && !isMoreThanNow(eleValue)) {
											errInfo += "不能少于当前日期";
											unitresult = false;
										}
									}
									break;
									
								case 'type':
									if (ele.value != ''){
										types = part[1].split(',');
				
										ftype = ele.value.split('.');
										result = in_array(ftype[ftype.length-1].toLowerCase(), types);
										if (!result) {
											errInfo += '只能选定文件的类型：' + types.join(',');
											unitresult = false;
										}
									}
									
									break;
							}
						}
						
				}
						//alert(unitresult);
				//unitresult = unitresult && result;
				
				if (break_for) {
					break;
				}
			}

			//succeed = succeed && unitresult;

			if (showmode == 'alert' && !unitresult) {
				if ($.browser.msie) {
					var msg_title = ele.msg_title;
				}else{
					var msg_title = ele.getAttribute('msg_title');
				}
				if (msg_title) {
					errInfo = msg_title + errInfo;
				}
			}

			
		}
		
		if (unitresult == false){
			succeed = false;
		}
		//显示提示信息到DIV 或 放到alert_msg
		SHOWMSG:
		if (showmode == 'div') {
			if (!unitresult) {
				this.showError(ele, errInfo);
			} else {
				this.hideError(ele);
			}
		} else if(!unitresult) {
			alert_msg += errInfo + "\n";
		}
	}
	
	
	if (showmode == 'alert' && alert_msg != '') {
		alert(alert_msg);
	}

	//将焦点放到第一个有提示信息的元素
	if (this.firstMsgElement != null && form.tagName.toLowerCase() == 'form') {
		this.firstMsgElement.focus();
	}
} catch(e) {
	alert(e);
	return false;
}
	return succeed;;
}

/**
 * 返回元素在页面中的offset
 * 返回: {x,y}
 */
function getScreenOffset(htmlObj){ 
   var  rd  =  {x:0,y:0} 
   do{ 
       rd.x  +=  htmlObj.offsetLeft          
       rd.y  +=  htmlObj.offsetTop 
       htmlObj  =  htmlObj.offsetParent
   }  while(htmlObj) 
   return  rd 
}

/**
 * 转向一个删除链接
 * url: 链接地址
 * msg: 提示信息(可选)
 */
function delConfirm(url, msg) {
	if (!msg) {
		msg = '确定要删除这条记录吗？';
	}
	
	if (confirm(msg)) {
		window.location.href = url;
	}
}

/**
 * 返回指定ID的checkbox元素被选择的数据条数,
 */
function getCheckedNum(id) {
	var obj = $name(id);
	
	if (!obj) {
		return null;
	}
	
	var num = 0;
	
	for (var i = 0; i < obj.length; i++) {
		if (obj[i].checked) {
			num++;
		}
	}
	
	return num;
} 

function getCheckedItems(n) {
	var obj = $name(n);
	
	if (!obj) {
		return null;
	}
	
	var items = new Array();
	
	for (var i = 0; i < obj.length; i++) {
		if (obj[i].checked) {
			items.push(obj[i]);
		}
	}
	
	return items;
}


/**
 * 曲库常用操作(删除、合并、上线、下线等)
 * 判断用户是否有选中ID为"idname"的checkbox元素,如果没选中,那么提示用户,并终止操作.
 * 
 * @param operate 操作名称 
 * 			合并：merge	删除：del
 * 			上线: upline	下线: offline
 * @param idname 提交的ID的元素名称
 * @param formid form表单ID
 * @param action form提交的地址
 * 
 */

function doAction(operate, idname, formid, action, ret) {	
	//设置action
	this.setTarget = function(formid, action) {
		if (formid && $id(formid) && action ) {
			$id(formid).action = action;
		}
	}
	
	ret = ret || false; 

	//要选择的元素数量,默认1
	var needCheckedNum = 1;
	
	//最多最允许选中这个数, -1为不限制
	var maxOperateNum = -1;
	
	switch (operate) {	
		case 'del':
			operate_title = '删除';
			break;
		case 'resume':
			operate_title = '恢复';
			break;
		default:
			operate_title = '';
	}
	
	//选中数量
	var checkedNum = getCheckedNum(idname);

	if (checkedNum < needCheckedNum || (checkedNum > maxOperateNum && maxOperateNum > 0)) {
		var msg = '请选中要' + (operate_title? operate_title: '操作') + '的项目,最少选择：' + needCheckedNum + '个';
		
		if (maxOperateNum > 0) {
			msg = msg + '，最多选择' + maxOperateNum + '个';
		}
		
		alert(msg);
		
		return false;
	}
	
	
	var msg = '你选中了' + checkedNum + '个项目，确定要' + (operate_title?operate_title: '执行') + '吗?';
	if (confirm(msg)) {
		this.setTarget(formid,action);
		if (!ret) {
			try{$id(formid).submit();}catch(e){alert(e)};
		}
		return true;
	} else {
		return false;
	}

}

function isIE6() {
	return navigator.appVersion.match(/MSIE [0-6]\./);
}

function ajaxInput() {
	this.action  = '';
	this.idname = '';
	this.inputObj = null;
	
	this.inited = false;
	
	//只允许选一个
	this.single = false;
	
	this.defaultText = '';
	this.defaultValue = '';
	
	//允许选择数据量
	this.allowMax = 1;
	
	//已经选择的元素
	this.elements = new Array();
	
	this.show_divid = '';
	
	//结果列表显示状态
	this.showing = false;
	
	//选中的元素的索引
	this.selectedIndex = -1;
	
	//模式设置,1:ID保存到隐藏表单
	//		  2: 纯辅助输入
	this.mode = 2;
	
	//隐藏的表单对象
	this.hidden = null;
	
	//查询缓存
	this.cache = new Array();
	
	//查询关键字
	this.keyword = '';
	
	//ajax查询接口
	this.action = '';
	
	//是否只能选择列表内的项
	this.mustChoose = false;

	//执行完调用的函数
	this.callfunc = '';
	
	this.choice = false;
	
	//添加结果到缓存
	this.addResult = function (key, result) {
		this.cache.push({'key':key, 'result': result});
	}
	
	//搜索缓存
	this.findResultCache = function(key){
		for(i = 0; i < this.cache.length; i++) {
			if (this.cache[i]['key'] == key) {
				return this.cache[i]['result'];
			}
		}
		
		return false;
	}
		
	this.changed = false;
		
	this.init = function(input, idname, action, mode, mustChoose,allowMax,callfunc) {
		this.idname  = idname;
		this.action  = action;
		this.inputObj  = input;
		this.mode      = mode ? mode : 2;
		this.mustChoose = mustChoose || false;
		this.callfunc = callfunc;

		//ajaxInput.listJson = [{"id":"1","title":"刘德华"},{"id":2,"title":"张学友"},{id:3,title:'刘欢'},{id:4,title:'张敬轩'},{id:5,title:'动力火车'},{id:6,title:'光良'},{id:7,title:'迪克牛仔'}];
		//ajaxInput.listJson = [];
		
		if (allowMax) {
			if (allowMax > 1) {
				this.allowMax = allowMax;
				this.single   = false;
			} else if (allowMax == 1) {
				this.allowMax = 1;
				this.single   = true;
			} else {
				this.allowMax = 9999;
				this.single   = false;
			}
		}
		this.show_divid = idname + '_list';

		if ($.browser.msie) {
			input.inputHelperIndex = idname;
		}else{
			input.setAttribute('inputHelperIndex', idname);
		}
		
		//初始化隐藏表单
		if ($id(idname)) {
			this.hidden = $id(idname);
		} else if ($name(idname).length > 0) {
			this.hidden = $name(idname)[0];
		}
		
		//$(input).attr('autocomplete', 'off');
		
		//初始值、等阿亮修改
		if ($.browser.msie) {
			var defaultValue = input.defaultvalue;
		}else{
			var defaultValue = input.getAttribute('defaultvalue');
		}
		

		if (defaultValue && defaultValue.length > 0) {
			try{
				eval('var json='+defaultValue);
				for (var i in json) {
					this.addShowItem(idname, json[i]['id'], json[i]['title']);
				}
				this.setHiddenValue();
			} catch(e) {
				alert(e.message);
				this.elements = new Array();
			}
		}
		
		if (input.value) {
			this.choice = true;
			if (this.hidden){
				this.defaultValue = this.hidden.value;
			}
			this.defaultText = input.value;
		}
		
		if ($.browser.msie) {
			input.defaultvalue = '';
		}else{
			input.setAttribute('defaultvalue', '');
		}
		
	}
	
	/**
	 * 显示待选列表
	 */
	this.showList = function() {
		 //<div id='artistID_list' class="show_msg1" style="top:62px;left:332px;width:148px;">
		 listJson = this.findResultCache(this.keyword);
		 if (listJson.length > 0) {
		 	var show_div = $id(this.show_divid);
		 	
			if (show_div == null) { 
				 show_div = document.createElement('DIV');
				 show_div.id = this.show_divid;
				 show_div.className = 'show_msg1';
				 show_div.style.width = this.inputObj.clientWidth + 'px';
				 show_div.style.zIndex = 9999;
				 
				 document.body.appendChild(show_div);
			} else {
				show_div.innerHTML = '';
			}
			 
			 var dUl = document.createElement('UL');
			 dUl.style.width = show_div.style.width; 
			 show_div.appendChild(dUl);
			 
			 for (var i = 0; i < listJson.length; i++) {
				var tLi = document.createElement('LI');
				tLi.style.cursor = 'pointer';
				$(tLi).text(listJson[i].title);
				tLi.onmouseover = function () {this.style.backgroundColor='#3366cc';};
				tLi.onmouseout = function () {this.style.backgroundColor='#fff';};
				
				if ($.browser.msie) {
					tLi.valueid = listJson[i].id;
					tLi.helperIndex = this.idname;
				}else{
					tLi.setAttribute('valueid', listJson[i].id);
					tLi.setAttribute('helperIndex', this.idname);
				}
				tLi.onclick = function () {
					if ($.browser.msie) {
						var idname = this.helperIndex;
						var valueid = this.valueid;
					}else{
						var idname = this.getAttribute('helperIndex');
						var valueid = this.getAttribute('valueid');
					}
					var helper = window.inputHelper[idname];
					if (helper.mode == 1) { 
						helper.add(idname,valueid);
					} else if (helper.mode == 2) {
						helper.setValue(idname, valueid);
					} else if (helper.mode == 3) {
						helper.setOption(valueid);
					}
					helper.choice = true;
				}
				
				dUl.appendChild(tLi);
			 }
			 
			 /*
			 if (ajaxInput.listJson.length > 20) {
			 	show_div.style.height = (14 * 20) + 'px';
			 	show_div.style.overflowY = 'auto';
			 } else {
			 	alert(ajaxInput.listJson.length);
			 	show_div.style.height = (tLi.clientHeight * ajaxInput.listJson.length) + 'px';
			 }
			 */
			 
			 
			 
			 //隐藏其他的
			 for (var i in window.inputHelper) {
			 	if (window.inputHelper[i].idname != this.idname) {
			 		window.inputHelper[i].hideList();
			 	}
			 }
			 
			 itemHeight = 19 * listJson.length;
			 
			 var offs = getScreenOffset(this.inputObj);
			 
			 show_div.style.left = offs.x + 'px';
			 show_div.style.top  = offs.y + this.inputObj.clientHeight +  'px';
			 
			 //用IFRAME解决select控件挡住问题
			 if (isIE6()) {
				 var layerid = 'block_layer';
				 var layer = $id(layerid);
				 if (!layer) {
				 	var layer = document.createElement('IFRAME');
				 	layer.id = layerid;
					if ($.browser.msie) {
						layer.frameborder = 0;
					}else{
						layer.setAttribute('frameborder', 0);
					}
				 	
				 	//layer.setAttribute('style', 'z-index:9998;border:0;position:absolute;');
				 	layer.style.zIndex = 9998;
				 	layer.style.border = 0;
				 	layer.style.position = 'absolute';
				 	layer.style.display = 'block';
				 	document.body.appendChild(layer);
				 } else {
				 	layer.style.visibility = 'visible';
				 }
				 
				 layer.style.width = show_div.clientWidth + 2 + 'px';
				 //layer.style.height = show_div.clientHeight + 2 + 'px';
				 layer.style.height = itemHeight + 2 + 'px';
				 layer.style.left = show_div.style.left;
				 layer.style.top = show_div.style.top;
				 layer.style.backgroundColor = '#000';
			 }
			 
			 show_div.style.display = '';
			 
			 this.showing = true;
		 } else {
		 	this.hideList();
		 }
	}
	
	/**
	 * 取得select中option的数据,并转为json,保存到listJson
	 */
	this.getOptions = function(kw) {
		if (typeof(kw) == 'undefined' || $.trim(kw) == ''){
			return false;
		}
		
		kw = $.trim(kw).toUpperCase();
		key = kw;
		this.keyword = kw;
		
		ajaxInput.activeID = this.idname;

		if (!this.findResultCache(key)){
			jsonPart = [];
			if ($name(this.idname).length > 0) {
				var sel = $name(this.idname)[0];
				if (sel.options.length > 0) {
					for (var i = 0; i < sel.options.length; i++) {
						if (sel.options[i].text.indexOf(kw) != -1) {
							var element = {"id":sel.options[i].value,"title":sel.options[i].text};
							jsonPart.push(element);
							if (jsonPart.length >= 20) {
								break;
							}
						}
					}
				}
			}
			
			this.addResult(key, jsonPart);
		}
		
		ajaxInput.showList();
	}
	
	this.updateData = function(kw) {
		if (typeof(kw) == 'undefined' || kw == ''){
			return false;
		}
		
		kw = $.trim(kw);
		
		if (kw == this.keyword) {
			if (!this.showing) {
				ajaxInput.showList();
			}
			return true;
		}
		
		//保存上次查询过的keyword
		this.keyword = kw;
		
		ajaxInput.activeID = this.idname;
		
		this.selectedIndex = -1;
		
		//ajaxInput.showList();return true;
		
		$.getJSON(this.action,
			{"keyword":kw},
			function(json){
				//处理状态码
				if (typeof(json.status) != 'undefined') {
					if (json.status == 0) {
						window.location.reload();
						return;
					}
				}
				
				window.inputHelper[ajaxInput.activeID].addResult(kw, json);
				ajaxInput.showList();
			}
		);
	}
	
	//移动 +1 or -1
	this.move = function(offset) {
		listJson = this.findResultCache(this.keyword);
		var size = listJson.length;
		if (size > 0) {
			var newPos = this.selectedIndex + offset;
			if (newPos < 0) {
				newPos = 0;
			} else if (newPos > (size-1)){
				newPos = (size-1);
			}
		
			this.select(newPos);
		}
	}
	
	this.select = function(offset) {
		listJson = this.findResultCache(this.keyword);
		var size = listJson.length;
		if (size > 0) {
			var Lis = $($id(this.show_divid).firstChild).children();
			for (var i = 0; i < Lis.length; i++) {
				if (i == offset) {
					Lis[i].style.backgroundColor='#3366cc';
				} else {
					Lis[i].style.backgroundColor='#fff';
				}
			} 
		}
		this.selectedIndex = offset;
	}
	
	this.keyup = function() {		
		if (this.mode == 3) {
			this.getOptions(this.inputObj.value);
		} else {
			this.updateData(this.inputObj.value);
		}
	}
	
	this.hideList = function() {
		var div = $id(this.show_divid);
		if (div) {
			div.style.display = 'none';
			this.showing = false;
			
			if (isIE6()) {
				var obj = $id('block_layer');
				if (obj) {
					obj.style.visibility = 'hidden';
				} 
			}
			
		}
	}
	
	this.addByOffset = function(idname, offset) {
		var valueid = '';
		listJson = this.findResultCache(this.keyword);
		if (listJson[offset]) {
			valueid = listJson[offset]['id'];
		}

		if (valueid) {
			this.add(idname, valueid);
		}
	}
	
	this.resetHiddenValue = function() {
		if (this.hidden) {
			this.hidden.value = '';
		}
	}
	
	this.setOffsetOption = function() {
		listJson = this.findResultCache(this.keyword);
		var valueid = listJson[this.selectedIndex]['id'];
		this.setOption(valueid); 
	}
	
	//设置select值
	this.setOption = function(valueid) {
		var opts = $name(this.idname)[0];
		if (opts.length > 0) {
			for (var i = 0; i < opts.length; i++) {
				if (opts[i].value == valueid) {
					opts[i].selected = true;
				} else {
					opts[i].selected = false;
				}
			}

			//wujun modified
			if (this.callfunc != '') {
				eval(this.callfunc);
			}
		}
	}
	
	this.setValue = function(idname, valueid) {
		var title = '';
		var listJson = this.findResultCache(this.keyword);
		if (typeof(valueid) != 'undefined') {
			for (var i = 0; i < listJson.length; i++) {
				if (listJson[i]['id'] == valueid) {
					title = listJson[i]['title'];
					break;
				}
			}
		} else {
			var helper = window.inputHelper[idname];
			if (listJson[helper.selectedIndex]) {
				title = listJson[helper.selectedIndex]['title'];
				valueid = listJson[helper.selectedIndex]['id'];
			}
		}

		var helper = window.inputHelper[idname];
		if (title) {
			helper.inputObj.value = title;
			helper.elements = new Array({"valueid":valueid,'title':title});
			helper.setHiddenValue();
		}
	}
	
	this.add = function(idname,valueid) {
		var title = '';		
		listJson = this.findResultCache(this.keyword);
		for (var i = 0; i < listJson.length; i++) {
			if (listJson[i]['id'] == valueid) {
				title = listJson[i]['title'];
				break;
			}
		}
		
		var helper = window.inputHelper[idname];
		
		this.addShowItem(idname, valueid, title);
		//helper.showElements();
		helper.hideList();
		
		//设置隐藏表单
		helper.setHiddenValue();
		
		//去除input框内容
		helper.inputObj.value = '';
		
		//重置selectedIndex
		helper.selectedIndex = -1;
	}
	
	/**
	 * 添加选择后要显示的组件
	 */
	this.addShowItem = function(idname, valueid, title) {
		var layerShow = $id(idname + '_content');
		
		if (!layerShow) {
			return;
		}
		
		var helper = window.inputHelper[idname];
		
		if (helper.searchElements(valueid) == null) {
			helper.elements.push({"valueid":valueid,'title':title});
			
			//显示选择的对象
			var tA = document.createElement('A');
			tA.innerHTML = title + ',';
			tA.title = '点击删除';
			tA.href = '#';
			
			if ($.browser.msie) {
				tA.valueid = valueid;
				tA.helperIndex = idname;
			}else{
				tA.setAttribute('valueid', valueid);
				tA.setAttribute('helperIndex', idname);
			}

			
			tA.onclick = function() {
				if ($.browser.msie) {
					var vid = this.valueid;
					var idname = this.helperIndex;
				}else{
					var vid = this.getAttribute('valueid');
					var idname = this.getAttribute('helperIndex');
				}				
				
				window.inputHelper[idname].del(vid);
				$(this).remove();
				
				return false;
			}
			
			layerShow.appendChild(tA);
			
		}
	}
	
	//删除元素
	this.del = function(valueid) {
		var idx = this.searchElements(valueid);
		if (idx != null) {
			delete this.elements[idx];
		}
		this.setHiddenValue();
	}
	
	//设置隐藏表单的值
	this.setHiddenValue = function() {
		if (this.hidden) {
			var idArr = new Array();
			for(var i = 0; i < this.elements.length; i++) {
				if (this.elements[i]) {
					idArr.push(this.elements[i]['valueid']);
				}
			}

			this.hidden.value = idArr.join(',');
		}
	}
	
	this.showElements = function() {
		if (this.elements.length > 0){
			var jDiv = $('#' + this.idname + '_content');
			jDiv.html('');
			for (var i = 0; i < this.elements.length; i++) {
				if (this.elements[i]) {
					jDiv.html(jDiv.html() + '<a href="">' + this.elements[i]['title'] + "</a> ");
				}
			}
		}
	}
	
	/**
	 * 查询元素在不在已选容器内,如果在则返回下标(index)
	 */
	this.searchElements = function(valueid) {
		if (this.elements.length > 0) {
			for (var i = 0; i < this.elements.length; i++) {
				if (this.elements[i] && this.elements[i].valueid == valueid) {
					return i;
				}
			}
		}
		
		return null;
	}
	
	/**
	 * 检查mustchoose属性
	 */
	this.checkMustChoose = function() {
		if (this.mode == 2 && this.mustChoose) {
			if (!this.choice||(this.hidden&&(this.hidden.value == ""||this.hidden.value == this.defaultValue))) {
				if (this.defaultText && this.inputObj.value != '') {
					this.inputObj.value = this.defaultText;
					if (this.hidden) {
						this.hidden.value = this.defaultValue;
					}
				} else {
					this.resetHiddenValue();
					this.inputObj.value = '';
				}
			}
		}
	}
	
}

//当前活动的控件
ajaxInput.activeID = '';

//最近一次查询时间
ajaxInput.lastTime = 0;

//显示结果列表
ajaxInput.showList = function() {
	if (ajaxInput.activeID) {
		window.inputHelper[ajaxInput.activeID].showList();
	}
}

//隐藏所有列表
ajaxInput.hideList = function() {
	for (var i in window.inputHelper) {
		if (window.inputHelper[i]) {
			window.inputHelper[i].hideList();
		}
	}
}


/**
 * 智能辅助用户输入内容
 */
function ajaxInputInit(input, idname, action, mode, mustChoose, allowMax, callfunc) {
	var timeout = null;
	
	//初始化
	if (typeof(window.inputHelper) == 'undefined') {
		window.inputHelper = {};
	}

	var obj = null;
	if (!window.inputHelper[idname]) {
		obj = new ajaxInput();
		window.inputHelper[idname] = obj;
	}else {
		obj = window.inputHelper[idname];
	}
	
	if ($.browser.msie) {
		var idx = input.inputHelperIndex;
	}else{
		var idx = input.getAttribute('inputHelperIndex');
	}

	if(typeof(idx) == 'undefined' || !idx || !window.inputHelper[idname].inited){
		obj.init(input, idname, action, mode, mustChoose, allowMax, callfunc);
		
		$(input).keyup(function(e) {
			if ($.browser.msie) {
				var idx = this.inputHelperIndex;
			}else{
				var idx = this.getAttribute('inputHelperIndex');
			}
			
			switch (e.keyCode) {
				case 8:
					if (this.value == ''){
						
						if (window.inputHelper[idx].mode == 2) {
							window.inputHelper[idx].resetHiddenValue();
						}
						
						window.inputHelper[idx].hideList();
						return;
					}
					break;
				
				case 16:
				case 17:
				case 18:
				case 20:
					return;
					break;
					
				case 13:
					helper = window.inputHelper[idx];
					if(helper.keyword == helper.inputObj.value){
						return;
					}
					break;
					
				case 37:
				case 38:
				case 39:
				case 40:
					return;
					break;
			}
			if (idx) {
				if (timeout) clearTimeout(timeout);
				timeout = setTimeout(
				function(){
					helper = window.inputHelper[idx];
					if (helper.findResultCache(helper.inputObj.value)) {
						helper.keyword = helper.inputObj.value;
						helper.showList();
					} else {
						helper.keyup(idx);
					}
				}
				,100);
			}
		});
		
		//处理上下方向键
		$(input).keydown(function(e) {
			if ($.browser.msie) {
				var idx = this.inputHelperIndex;
			}else{
				var idx = this.getAttribute('inputHelperIndex');
			}
			var helper = window.inputHelper[idx];
			if (!helper.showing) {
				return;
			}
 
			switch (e.keyCode) {
				case 38: //up
					helper.move(-1);
					break;
					
				case 40: //down
					helper.move(1);
					break;
					
				case 13:
					if (helper.mode == 1) {
						helper.addByOffset(idx, helper.selectedIndex);
					} else if (helper.mode == 2) {
						helper.hideList();
					} else if (helper.mode == 3) {
						helper.setOffsetOption();
						helper.hideList();
					}
					return false;
					break;
			}
			if (helper.mode == 2) {
				helper.setValue(idx);
				helper.choice = true;
			}
		});
		
		$(input).focus(function() {
			if ($.browser.msie) {
				ajaxInput.activeID = this.inputHelperIndex;
			}else{
				ajaxInput.activeID = this.getAttribute('inputHelperIndex');
			}
		});
		
		//失去焦点后,关闭列表
		input.onblur = function(){
			window.setTimeout(function() {
				ajaxInput.hideList();
				helper.checkMustChoose();
				ajaxInput.activeID='';
			}, 200);
			if ($.browser.msie) {
				var helper = window.inputHelper[this.inputHelperIndex];
			}else{
				var helper = window.inputHelper[this.getAttribute('inputHelperIndex')];
			}
			
			helper.selectedIndex = -1;
		}
		
		var setChoice = function(){
			if ($.browser.msie) {
				var helper = window.inputHelper[this.inputHelperIndex];
			}else{
				var helper = window.inputHelper[this.getAttribute('inputHelperIndex')];
			}
			//alert(helper);
			helper.choice = false;
		}
		if (mode == 2){
			if ($.browser.msie) {
				input.onpropertychange = setChoice;
			} else {
				input.addEventListener('input', setChoice, false);
			}
		}
		
		obj.inited = true;
	}
	
}


function groupSelectCheck(selected_checkbox)
{
	var i,j = 0;
	var module_id = document.getElementsByName('module_id[]');
	var file_id = document.getElementsByName('file_id[]');
	var action_id = document.getElementsByName('action_id[]');
	var length = selected_checkbox.value.length;
	// 如果选择是模块
	if (length == 1){
		// 选中模块下的所有文件列表
		eval("var pattern = /^"+selected_checkbox.value+"/;");
		for (i=0;i<file_id.length;i++ ){
			if (pattern.test(file_id[i].value)){
				file_id[i].checked = selected_checkbox.checked;
			}
		}
		// 选中模块下的操作列表
		for (i=0;i<action_id.length;i++ ){
			if (pattern.test(action_id[i].value)){
				action_id[i].checked = selected_checkbox.checked;
			}
		}
	}else if (length == 3){
		// 判断是否还有其它选中文件
		eval("var pattern = /^"+selected_checkbox.value.substr(0,1)+"/");
		for (i=0;i<file_id.length;i++ ){
			if (file_id[i].value.length == 3 && pattern.test(file_id[i].value) && file_id[i].checked){
				j++;
			}
		}
		eval("var pattern = /^"+selected_checkbox.value.substr(0,1)+"$/");
		for (i=0;i<module_id.length;i++ ){
			if (pattern.test(module_id[i].value) && selected_checkbox.checked){
				module_id[i].checked = true;
			}else if(pattern.test(module_id[i].value) && !selected_checkbox.checked && j == 0){
				module_id[i].checked = false;
			}
		}

		// 选中模块下的操作列表
		eval("var pattern = /^"+selected_checkbox.value+"/");
		for (i=0;i<action_id.length;i++ ){
			if (pattern.test(action_id[i].value)){
				action_id[i].checked = selected_checkbox.checked;
			}
		}
	}else{
		// 判断是否还有其它选中操作
		eval("var pattern = /^"+selected_checkbox.value.substr(0,3)+"/");
		for (i=0;i<action_id.length;i++ ){
			if (action_id[i].value.length == 5 && pattern.test(action_id[i].value) && action_id[i].checked){
				j++;
			}
		}
		eval("var pattern = /^"+selected_checkbox.value.substr(0,3)+"$/");
		for (i=0;i<file_id.length;i++ ){
			if (pattern.test(file_id[i].value) && selected_checkbox.checked){
				file_id[i].checked = true;
			}else if(pattern.test(file_id[i].value) && !selected_checkbox.checked && j == 0){
				file_id[i].checked = false;
			}
		}

		// 判断是否还有其它选中文件
		j = 0;
		eval("var pattern = /^"+selected_checkbox.value.substr(0,1)+"/");
		for (i=0;i<file_id.length;i++ ){
			if (file_id[i].value.length == 3 && pattern.test(file_id[i].value) && file_id[i].checked){
				j++;
			}
		}
		eval("var pattern = /^"+selected_checkbox.value.substr(0,1)+"$/");
		for (i=0;i<module_id.length;i++ ){
			if (pattern.test(module_id[i].value) && selected_checkbox.checked){
				module_id[i].checked = true;
			}else if(pattern.test(module_id[i].value) && !selected_checkbox.checked && j == 0){
				module_id[i].checked = false;
			}
		}
	}
}

/**
 * 检查专辑或歌曲的状态是否为锁定状态
 *
 * 批量操作，需要设置5个参数
 * 单个操作，需要设置要操作的id，操作的url，检查的ajax url 例如：checkState('25511', '/album/edit?aid=2551', '/album/check', 'name')
*/
function checkState(action, idName, formName, doUrl, ajaxUrl)
{
	var id;
	var url;
	var ajaxUrls;
	var batch = false;
	if (arguments.length == 5) {
		if(false == doAction(action, idName, formName, doUrl, true)) {
			return false;
		}	
		var temp = '';
		var msg;
		var ids = '';
		var param;
		var sign = true;
		id = $name(idName);
		for(var j = 0; j < id.length; j++) {
			if(id[j].checked == true) {
				ids += temp + id[j].value;
				temp = ','
			}
		}
		ajaxUrls = ajaxUrl.split('?');
		if (ajaxUrls.length > 1) {
			param = '&ids='+ids;
		} else {
			param = '?ids='+ids;
		}
		url = ajaxUrl+param;
	} else {
		ajaxUrls = arguments[2].split('?');
		if (ajaxUrls.length > 1) {
			url = arguments[2] + '&ids='+arguments[0];
		} else {
			url = arguments[2] + '?ids='+arguments[0];
		}
		batch = true;
	}
	
	//设置为同步
	$.ajaxSetup({async:false});
	$.getJSON(url, function(json){
		//检测是否登录
		if (json.status == 0 && json.mem == 'nologin') {
			window.location.reload();
			return;
		}
		if (json.length > 0) {
			var name = '';
			temp = '';
			for (var i = 0;i < json.length; i++) {
				name += temp + '['+json[i].name+']';
				temp = ','
			}
			msg = name+' 已经被锁定,不能被执行任何操作，请先解锁！';
			tigMsgConfirm(msg);
			sign = false;
		} else {
			sign = true;
		}
	})
	
	if (true == sign) {
		if (false == batch) {
				$id(formName).action = doUrl;
				$id(formName).submit();
		} else {
			window.location.href = arguments[1];
		}
	}
	
	return false;
}

function tigMsgConfirm(msg)
{
	var width, height, bodywidth, bodyheight, top, left;
	var offset = 0;
	var selects = $('select');
	bodywidth = document.documentElement.clientWidth;
	bodyheight = document.documentElement.clientHeight;
	$("#trans").css('display', 'block');
	$("#trans").css('width', document.body.scrollWidth + "px");
	$("#trans").css('height', document.body.scrollHeight + "px");
	$("#trans").css('backgroundColor', "");
	if (msg != '') {
		msg = msg.replace(/\n/g, '<br/>');
		$('#contentDiv').html(msg);
	}
	$('#tigMsg').css('display', 'block');
	height = $id('tigMsg').clientHeight;
	width = $id('tigMsg').clientWidth;
	top = Math.floor(bodyheight / 2) - Math.floor(height / 2) + document.documentElement.scrollTop;
	if (top < 0)
	{
		top = 60;
	}
	left = Math.floor(bodywidth / 2) - Math.floor(width / 2);
	$('#tigMsg').css('left', left+'px');
	$('#tigMsg').css('top', top+'px');
	if (isIE6()) {
		if (selects.length > 0) {
			for (var n = 0; n < selects.length; n++) {
				selects[n].disabled= 'disabled';
			}
		}
		var layer = document.createElement('IFRAME');
		if ($.browser.msie) {
			layer.id = 'ifdiv';
			layer.frameborder = 0;
		}else{
			layer.setAttribute('id', 'ifdiv');
			layer.setAttribute('frameborder', 0);
		}
		layer.style.zIndex = 100001;
		layer.style.border = 0;
		layer.style.position = 'absolute';
		layer.style.display = 'block';
		layer.style.width = width + 10 + 'px';
		layer.style.height = height + 'px';
		layer.style.visibility = '';
		layer.style.left =  left + 'px';
		layer.style.top = top + 'px';
		layer.style.backgroundColor = '#000';
		document.body.appendChild(layer);
	}
}

function closeTigMsg()
{
	$("#trans").css('display', 'none');
	$("#trans").css('width', 0);
	$("#trans").css('height', 0);
	$('#tigMsg').css('display', 'none');
	if (isIE6()) {
		$('#ifdiv').remove();
		var selects = $('select');
		if (selects.length > 0) {
			for (var n = 0; n < selects.length; n++) {
				selects[n].disabled= '';
			}
		}
	}
}

function defaultChecked(check_name)
{
	var url = window.location.href;
	var para_str = url.substring(url.indexOf("?")+1);
	var para_arr = para_str.split("&");
	var para_name;
	var para_value = "";
	var i,j;
	for(i=0;i<para_arr.length;i++){
		var para_name = para_arr[i].substring(0,para_arr[i].indexOf("="));
		if (para_name == "selected"){
			para_value = para_arr[i].substring(para_arr[i].indexOf("=")+1);
			break;
		}
	}

	if (para_value != ""){
		var id_arr = para_value.split(",");
		var name = $name(check_name);
		for(j=0;j<name.length;j++){
			if (in_array(name[j].value, id_arr)){
				name[j].checked = true;
			}
		}
	}
}

function toggleDiv(source,id)
{
	if (source.checked){
		$(id).hide();
	}else{
		$(id).show();
	}
}
function buildModulePath(module, action, querystring) {
		var base = typeof BASE_PATH == 'undefined' ? '': BASE_PATH;
		var file = typeof W_BASE_FILENAME == 'undefined' ? '': W_BASE_FILENAME;
		var get_var_mame = typeof R_VAR_NAME == 'undefined' ? 'm': R_VAR_NAME;
		var mode = ROUTE_MODE || 0;
		
		if (mode == 2 || mode == 3) {
			var uri = base + module;
			
			if (action) {
				if (action.indexOf('.') > -1) {
					uri += '/';
				}
				else {
					uri += '.';
				}
				uri += action;
			}
			
			if (querystring) {
				if (uri.indexOf('?') == -1) {
					uri += '?';
				}
				uri += querystring;
			}
			
			return uri;
		} else {
			var params = '?' + get_var_mame + '=' + module;
			if (action) {
				params += '.' + action;
			}
			
			if (querystring) {
				params += '&' + querystring;
			}
			
			return base + file + params; 
		}
	}

function isElement(o) {
	return !!(o && o.nodeType == 1);
}
function isNumber(o) {
	return Object.prototype.toString.call(o) == '[object Number]';
}
function isString(o) {
	return Object.prototype.toString.call(o) == '[object String]';
}
var admin = {
	index: {
		$selectedSubMenu : null,
		$selectedMainMenu : null,
		$selectedSubMenuContainer: null,
		$mainmenu_container: null,
		$submenu_container: null,
		$mainmenu: null,
		$submenu: null,

		/**
		 * select main menu
		 * @param n HTMLElement|int|'default'
		 *
		 */
		selectMainMenu: function(n) {
			with (admin.index) {
				if (!$mainmenu) {
					return;
				}
				if ($selectedMainMenu) {
					$selectedMainMenu.removeClass('current');
				}
				n = isNumber(n) || isElement(n) ? n : 'default';
				if (n == 'default') {
					$selectedMainMenu = $mainmenu.filter('.default');
				} else {
					$selectedMainMenu = isElement(n) ? $(n) : $mainmenu.eq(n);
				}

				if (!$selectedMainMenu.length && !($selectedMainMenu = $mainmenu.eq(0)).length) {
					$selectedMainMenu  = null;
					return;
				}

				$selectedMainMenu.addClass('current').trigger('blur');
				// show selected sub-menu container
				$selectedSubMenuContainer = $submenu_container.eq($mainmenu.index($selectedMainMenu));
				selectSubMenu();
				$submenu_container.hide();
				$selectedSubMenuContainer.show();
			}
		},

		/**
		 * select sub menu
		 * @param n HTMLElement|int|'.default'
		 *
		 */
		selectSubMenu: function(n, jump) {
			jump = jump == undefined? true : false;
			with (admin.index) {
				if (!$submenu_container) {
					return;
				}
				if ($selectedSubMenu && $selectedSubMenu.length) {
					$selectedSubMenu.removeClass('current');
				}
				if (!$selectedSubMenuContainer.length && !($selectedSubMenuContainer = $submenu_container.eq(0)).length) {
					$selectedSubMenuContainer = null;
					return;
				}

				$submenu = $selectedSubMenuContainer.find('div > a');
				n = isNumber(n) || isElement(n) || isString(n) ? n : '.default';
				if (n == '.default') {
					$selectedSubMenu = $submenu.filter('.default');
				}else if(isString(n) && n.indexOf('#') === 0) {
					$selectedSubMenu = $(n);
				} else {
					$selectedSubMenu = isElement(n) ? $(n) : $submenu.eq(n);
				}
				if (!$selectedSubMenu.length && !($selectedSubMenu = $submenu.eq(0)).length) {
					$selectedSubMenu = null;
					return false;
				}
				$selectedSubMenu.addClass('current').trigger('blur');
				if (jump) {
					$('#mainframe').attr('src', $selectedSubMenu.attr('href'));
				}
			}
		},

		init: function() {
			with (admin.index) {
				// init main menu
				$mainmenu_container = $('#header > .menu');
				$submenu_container = $('#container > .sidebar > .sub-menu');
				$mainmenu = $mainmenu_container.children('a');
				selectMainMenu();
				// attach event to container
				$mainmenu_container.click(function(e) {
					if (e.target.tagName.toLowerCase() == 'a') {
						selectMainMenu(e.target);
					}
				});
				$submenu_container.click(function(e) {
					if (e.target.tagName.toLowerCase() == 'a') {
						selectSubMenu(e.target);
					}
				})
			}
		}
	}
}
