﻿/**
 * @fileoverview 该文件是 xweibo 开通服务。
 */
 
 (function() {

 var 
    UNDEFINED,
    NULL = null,	
	TRUE = true,	
	FALSE = false
 
 var cache = {
    hasSubmit: FALSE,
    curTab: 'reg'
 };
 
var 
    $ui = window.xform.$ui,
    msg = window.xform.msg,
    cityChange = window.xform.cityChange,
    checkForm = window.xform.checkForm,
    showError = window.xform.showError;

  $(document).ready(function() {
    //查找并缓存相关DOM
    var _$tem = $('#container div.form-title strong');
    $ui.regTab = $(_$tem[0]);
    $ui.bindTab = $(_$tem[1]);
    $ui.regForm = $('#register');
    $ui.bindForm = $('#binding');
    
    var _$tem = $('#register div.form-row');
    $.extend($ui, {
        nick: $(_$tem[0]),
        email: $(_$tem[1]),
        location: $(_$tem[2]),
        gender: $(_$tem[3]),
        description: $(_$tem[4]),
        password: $(_$tem[5]),
        password2: $(_$tem[6]),
        authcode: $(_$tem[7]),
        agreement: $(_$tem[8])
    });
    
    //绑定相关事件
    $ui.regTab.bind('click', {'type': 'reg'}, tabChange);
    $ui.bindTab.bind('click', {'type': 'bind'}, tabChange);
    
    $('#registBtn').bind('click', {'type': 'reg'}, formSubmit);
    $('#bindBtn').bind('click', {'type': 'bind'}, formSubmit);
    
    $('#nick')
        .bind('focus', {'type': 'nick'}, showTips)
        .bind('blur', {'type': 'nick'}, checkForm);
    $('#email')
        .bind('blur', {'type': 'email'}, checkForm);
    $('#description')
        .bind('blur', {'type': 'description'}, checkForm);
    $('#password')
        .bind('focus', {'type': 'pwd'}, showTips)
        .bind('blur', {'type': 'pwd'}, checkForm);
    $('#password2')
        .bind('focus', {'type': 'pwd2'}, showTips)
        .bind('blur', {'type': 'pwd2'}, checkForm);
    $('#authcode')
        .bind('blur', {'type': 'code'}, checkForm);
    $('#isconfirm')
        .bind('click', {'type': 'agreement'}, checkForm);
    
    $('#province')
        .bind('change', function(e) {
            cityChange.curProvince = this.value;
            cityChange.createOpt('city');
            
            checkForm('province');
        });
    
    $('#changeCode')
        .bind('click', function() {
            var img = $ui.authcode.find('img')[0];
            setTimeout(function() {
                img.src = XWB.url('authImage','paint' , 'w=70&h=25&r=' + Math.random());
            }, 1);
        })
        .click(); 

    $(document)
        .bind('keyup', function(e) {
            if(e.keyCode == 13) {
                formSubmit(cache.curTab);
            }
        });
    
    cityChange.init();
 });
 

 function submitCallback(type, error, info) {
    var $el, msgNum;
 
    if(type == 'bind') {
        $el = $('#binding div.form-row').first();
        
        switch(+error) {
            case 30003:
            case 30011:
                msgNum = 23;
                showError($el, type, msgNum);
                break;
            case 30013:
                msgNum = 24;
                showError($el, type, msgNum);
                break;
            case 30014:
                showError($ui.nick, 'nick', 28);
                break;
            case 30015:
                showError($ui.description, 'description', 29);
                break;
            case 0:
                var url = window.XWB && window.XWB.url('account', 'activeResult');
                location.href=url;
                break;
            default:
                window.XWB && window.XWB.alert({
                    'title': '绑定失败',
                    'msg': info
                });
        }
    }else if(type == 'reg'){
        
        switch(+error) {
            case 30001:
                if(info.indexOf('需要提供注册者电子邮箱') != -1) {
                   showError($ui.email, 'email', 8);
                }
                else if(info.indexOf('需要提供注册者密码') != -1) {
                    showError($ui.password, 'pwd', 16);
                }
                else if(info.indexOf('需要提供注册者昵称') != -1) {
                    showError($ui.nick, 'nick', 2);
                }
                else if(info.indexOf('该邮箱地址已被注册') != -1) {
                    showError($ui.email, 'email', 27);
                }
                else if(info.indexOf('需要提供注册者省份') != -1) {
                    showError($ui.location, 'location', 10);
                }
                else if(info.indexOf('昵称重复或者非法') != -1) {
                    showError($ui.nick, 'nick', 3);
                }                
                else{
                    window.XWB && window.XWB.alert({
                        'title': '开通失败',
                        'msg': info
                    });
                }
                break;
            case 30002:
            case 30003:
            case 30004:
            case 30005:
            case 30006:
                showError($ui.nick, 'nick', 25);
                break;
            case 30007:
                showError($ui.password2, 'pwd2', 22);
                break;
            case 30008:
                showError($ui.agreement, 'agreement', 20);
                break;
            case 30009:
                showError($ui.authcode, 'code', 19);
                $('#changeCode').click();
                break;
            case 30010:
                showError($ui.description, 'description', 26);
                break;
            case 30011:
                showError($ui.nick, 'nick', 23);
                break;
            case 30014:
                showError($ui.nick, 'nick', 28, info);
                break;
            case 30015:
                showError($ui.description, 'description', 29, info);
                break;
            case 0:
                var url = window.XWB && window.XWB.url('account', 'activeResult');
                location.href=url;
                break;
            default:
                window.XWB && window.XWB.alert({
                    'title': '开通失败',
                    'msg': info
                });
                break;
        }
    }
 }
 
/**
* 提交表单数据
*/
 function formSubmit(e) {
    if(cache.hasSubmit) {
        return;
    }
    
    if(!xform.canSubmit) {
        window.XWB && window.XWB.alert({
            'title': '提示',
            'msg': '请确认填写的信息正确再提交。'
        });
        return;
    }
    
    var type = '';
    if(typeof e == 'object') {
        type = e.data.type;
    }else {
        type = e;
    }
    
    switch(type) {
        case 'reg':
            var args = getFormVal('reg');
            
            cache.hasSubmit = TRUE;
            
            $.ajax({
                type: 'POST',
                url: window.XWB && window.XWB.url('account', 'register'),
                dataType: 'json',
                data: args,
                success: function(data){

                    var num = data.errno;
                    submitCallback('reg', num, data.err);
                    
                    cache.hasSubmit = FALSE;
                }
            });
            break;
            
        case 'bind':
            var args = getFormVal('bind');
            
            cache.hasSubmit = TRUE;
            
            $.ajax({
                type: 'POST',
                url: window.XWB && window.XWB.url('account', 'bind'),
                dataType: 'json',
                data: args,
                success: function(data){

                    var num = data.errno;
                    
                    submitCallback('bind', num, data.err);
                    
                    cache.hasSubmit = FALSE;
                }
            });
            break;
        
    }
 }
 
/**
* 获取表单数据
*/
 function getFormVal(type) {
    var args = {};
 
    switch(type) {
        case 'reg':
            $.extend(args, {
                'nick': $('#nick').val(),
                'email': $('#email').val(),
                'province': $('#province').val(),
                'city': $('#city').val(),
                'gender': $('#male').attr('checked')? 'm' : 'f',
                'description': $('#description').val(),
                'password': $('#password').val(),
                'password2': $('#password2').val(),
                'authcode': $('#authcode').val(),                
                'isconfirm': $('#isconfirm').attr('checked')?1:0
            });            
            break;
        case 'bind':
            $.extend(args, {
                'sina_user': $('#sina_user').val(),
                'sina_pwd': $('#sina_pwd').val()
            });            
            break;
    }
    
    return args;
 }
 
 /**
* tab切换
*/
 function tabChange(e) {
    var type = '';
    if(typeof e == 'object') {
        type = e.data.type;
    }else {
        type = e;
    }
    
    cache.curTab = type;
    
    switch(type) {
        case 'reg':
            $ui.regTab.addClass('active');
            $ui.bindTab.removeClass('active');
            $ui.regForm.show();
            $ui.bindForm.hide();
            break;
        case 'bind':
            $ui.bindTab.addClass('active');
            $ui.regTab.removeClass('active');
            $ui.bindForm.show();
            $ui.regForm.hide();
            break;
    }
 }
 
 /**
* 表单提示
*/
 function showTips(e) {
    var $el, msgNum;
    var type = '';
    if(typeof e == 'object') {
        type = e.data.type;
    }else {
        type = e;
    }
    
    switch(type) {
        case 'nick':
            $el = $ui.nick;
            msgNum = 1;
            break;
        case 'pwd':
            $el = $ui.password;
            msgNum = 13;
            break;
        case 'pwd2':
            $el = $ui.password2;
            msgNum = 17;
            break;
    }

    $el.find('em.warn').hide();
    var $tips = $el.find('em.tips');
    
    if($tips[0]) {
        $tips.show();
    }else {
        $('<em></em>')
            .addClass('tips')
            .text(msg[msgNum])
            .appendTo($el);
    }
 }
 

    
 })();
 
