<?php


if (!defined('XWEIBO_ACCESS')) {
	die('NOT ACCESS');
}

if(function_exists('date_default_timezone_set')) {
	@date_default_timezone_set('Etc/GMT-8');
}

if (!function_exists('array_combine')) {
	function array_combine( $keys, $values ) {
	   if( !is_array($keys) || !is_array($values) || empty($keys) || empty($values) || count($keys) != count($values)) {
		 trigger_error( "array_combine() expects parameters 1 and 2 to be non-empty arrays with an equal number of elements", E_USER_WARNING );
		 return false;
	   }
	   $keys = array_values($keys);
	   $values = array_values($values);
	   $result = array();
	   foreach( $keys as $index => $key ) {
		 $result[$key] = $values[$index];
	   }
	   return $result;
	}
}

/**
 * 环境检查
 *
 * @param unknown_type
 * @return unknown
 */
function check_env(&$result)
{
	global $_LANG;

	$env_vars = array();

	//检查操作系统
	$env_vars['php_os'] = array('required' => $_LANG['no_limit'], 'best' => $_LANG['unix'], 'curr' => PHP_OS, 'state' => true);

	//检查php版本
	$env_vars['php_vers'] = array('required' => '4.0', 'best' => '5.0', 'curr' => PHP_VERSION);
	if ((int)$env_vars['php_vers']['required'] > (int)$env_vars['php_vers']['curr']) {
		$env_vars['php_vers']['state'] = false;
		$result = false;
	} else {
		$env_vars['php_vers']['state'] = true;
	}

	//检查上传附件大小
	$env_vars['upload'] = array('required' => '1M', 'best' => '2M', 'curr' => ini_get('upload_max_filesize'));
	$u = substr($env_vars['upload']['curr'], -1, 1);
	$max_upload = $u == 'M' ? (int)$env_vars['upload']['curr'] : ($u == 'K' ? (int)$env_vars['upload']['curr'] / 1024 : (int)$env_vars['upload']['curr'] / (1024 * 1024));
	if ((int)$env_vars['upload']['required'] > $max_upload) {
		$env_vars['upload']['state'] = false;
		$result = false;
	} else {
		$env_vars['upload']['state'] = true;
	}

	//检查gd库版本
	if (function_exists('gd_info')) {
		$gd_info = gd_info();
	} else {
		$gd_info['GD Version'] = $_LANG['advice_gd'];
		$result = false;
	}
	$env_vars['gd_vers'] = array('required' => '1.0', 'best' => '2.0', 'curr' => $gd_info['GD Version']);
	$match = array();
	preg_match('/\d/', $env_vars['gd_vers']['curr'], $match);
	$gd_vers = $match[0];
	if ((int)$env_vars['gd_vers']['required'] > $gd_vers) {
		$env_vars['gd_vers']['state'] = false;
	} else {
		$env_vars['gd_vers']['state'] = true;
	}

	//检查可用磁盘空间
	$env_vars['disk'] = array('required' => '10M', 'best' => $_LANG['no_limit'], 'curr' => floor(diskfreespace(ROOT_PATH) / (1024 * 1024)).'M');
	if ((int)$env_vars['disk']['required'] > (int)$env_vars['disk']['curr']) {
		$env_vars['disk']['state'] = false;
		$result = false;
	} else {
		$env_vars['disk']['state'] = true;
	}

	return $env_vars;
}

/**
 * 检查目录文件
 *
 * @param unknown_type
 * @return unknown
 */
function check_dir(&$result)
{
	//需要检查的目录和文件
	$dir_files = array(
					'./',
					'./css/base.css',
					'./var',
					'./var/cache',
					'./var/data',
					'./var/data/fonts',
					'./var/data/logo',
					'./var/upload');

	$check_dir_files = array();
	foreach ($dir_files as $var) {
		if (is_dir($var)) {
			if ($fp = @fopen(ROOT_PATH.$var.'/text.txt', 'w')) {
				@fclose($fp);
				@unlink(ROOT_PATH.$var.'/text.txt');
				$check_dir_files[$var] = array('w' => 'writeable', 'state' => true);
			} else {
				$check_dir_files[$var] = array('w' => 'unwriteable', 'state' => false);
				$result = false;
			}
		} else {
			if (file_exists(ROOT_PATH.$var)) {
				if (is_writable(ROOT_PATH.$var)) {
					$check_dir_files[$var] = array('w' => 'writeable', 'state' => true);
				} else {
					$check_dir_files[$var] = array('w' => 'unwriteable', 'state' => false);
					$result = false;
				}
			} else {
				$check_dir_files[$var] = array('w' => 'unwriteable', 'state' => false);
				$result = false;
			}
		}
	}
	return $check_dir_files;
}

/**
 * 检查函数依赖
 *
 * @param unknown_type
 * @return unknown
 */
function check_func(&$result)
{
	$func_items = array('mysql' => 'mysql_connect',
						'sock' => 'fsockopen',
						'file' => 'file_get_contents',
						'image' => 'imagettftext',
						'mhash' => array('mhash', 'hash_hmac')
						);
	$check_func_items = array();
	foreach ($func_items as $key => $var) {
		if ('mhash' == $key) {
			if (!function_exists($var[0]) && !function_exists($var[1])) {
				$check_func_items[implode(',', $var).'( )'] = array('s' => 'unsupportted_both', 'state' => false);
				$result = false;
			} else {
				$check_func_items[$var[0].'( ),'.$var[1].'( )'] = array('s' => 'supportted', 'state' => true);
			}
		} else {
			if (function_exists($var)) {
				$check_func_items[$var.'( )'] = array('s' => 'supportted', 'state' => true);
			} else {
				$check_func_items[$var.'( )'] = array('s' => 'unsupportted', 'state' => false);
				$result = false;
			}
		}
	}
	return $check_func_items;
}

/**
 * 检查app的真确性
 *
 * @param unknown_type
 * @return unknown
 */
function check_app($app_key, $app_secret)
{
	global $_LANG;
	include_once "oauth.class.php";
	include_once "fsockopen.php";

	if (!ini_get('allow_url_fopen')) {
		show_msg('fsockopen'.$_LANG['advice_fsockopen']);
	}

	$http = new Http_Client();
	$url = 'http://api.t.sina.com.cn/oauth/request_token';
	$sha1_method = new OAuthSignatureMethod_HMAC_SHA1();
	$consumer = new OAuthConsumer($app_key, $app_secret);
	$request = OAuthRequest::from_consumer_and_token($consumer, $token, 'GET', $url, $parameters);
	$request->sign_request($sha1_method, $consumer, $token);
	$http->setUrl($request->to_url());
	$result = $http->request();
	$code = $http->getState();
	if ($code != '200') {
		show_msg($_LANG['app_key_error']);
	}
	return true;
}

/**
 * 检查mc是否可用
 *
 * @param unknown_type
 * @return unknown
 */
function check_mc_connect($mc_host, $mc_port)
{
	//没有加载mc模块
	if (!function_exists('memcache_connect')) {
		show_msg($_LANG['advice_memcache_connect']);
	}
	global $_LANG;
	$memcache = new Memcache;
	@$memcache->connect($mc_host, $mc_port) || show_msg($_LANG['mc_connect_error']);
}

/**
 * 创建数据库
 *
 * @param unknown_type
 * @return unknown
 */
function create_db($db_host, $db_user, $db_passwd, $db_name)
{
	global $_LANG;
	$link = @mysql_connect($db_host, $db_user, $db_passwd);
	if (!$link) {
		show_msg($_LANG['database_connect_error']);
	}

    if (mysql_select_db($db_name, $link) === false)
    {
        $sql = "CREATE DATABASE $db_name DEFAULT CHARACTER SET " . XWEIBO_DB_CHARSET;
        if (mysql_query($sql, $link) === false)
        {
			show_msg($_LANG['database_create_error']);
        }
    }
    mysql_close($link);
}

/**
 * 创建数据库资源
 *
 * @param unknown_type
 * @return unknown
 */
function db_resource($db_host = null, $db_user = null, $db_passwd = null, $db_name = null, $ajax = false)
{
	global $_LANG;
	$link = @mysql_connect($db_host, $db_user, $db_passwd);
	if (!$link) {
		if ($ajax) {
			die($_LANG['database_connect_error']);
		}
		show_msg($_LANG['database_connect_error'], 'index.php?step=3');
	}
	if (!mysql_select_db($db_name, $link)) {
		if ($ajax) {
			die($_LANG['database_exists_error']);
		}
		show_msg($_LANG['database_exists_error']);
	}
	mysql_query('SET NAMES '.XWEIBO_DB_CHARSET, $link);
	return $link;
}

/**
 * 创建表并且返回表的列表
 *
 * @param unknown_type
 * @return unknown
 */
function create_tables($db_host, $db_user, $db_passwd, $db_name, $db_prefix)
{
	$sql_items = file_get_contents(ROOT_PATH.'/install/data/structure.sql');
	//删除SQL行注释
	$sql_items = preg_replace('/^\s*(?:--|#).*/m', '', $sql_items);
	//删除SQL块注释
	$sql_items = preg_replace('/^\s*\/\*.*?\*\//ms', '', $sql_items);
	//代替表前缀
	$keywords = 'CREATE\s+TABLE(?:\s+IF\s+NOT\s+EXISTS)?|'
			  . 'DROP\s+TABLE(?:\s+IF\s+EXISTS)?|'
			  . 'ALTER\s+TABLE|'
			  . 'UPDATE|'
			  . 'REPLACE\s+INTO|'
			  . 'DELETE\s+FROM|'
			  . 'INSERT\s+INTO';
	$pattern = '/(' . $keywords . ')(\s*)`?' . XWEIBO_DB_PREFIX . '(\w+)`?(\s*)/i';
	$replacement = '\1\2`' . $db_prefix . '\3`\4';
	$sql_items = preg_replace($pattern, $replacement, $sql_items);

	$pattern = '/(UPDATE.*?WHERE)(\s*)`?' . XWEIBO_DB_PREFIX . '(\w+)`?(\s*\.)/i';
	$replacement = '\1\2`' . $db_prefix . '\3`\4';
	$sql_items = preg_replace($pattern, $replacement, $sql_items);

	$sql_items = str_replace("\r", '', $sql_items);
	$query_items = explode(";\n", $sql_items);

	$link = db_resource($db_host, $db_user, $db_passwd, $db_name);
	$sign = true;
	foreach ($query_items as $var) {
		if (empty($var)) {
			continue;
		}
		$sign = mysql_query($var, $link);
	}

	mysql_close($link);
	if (!$sign) {
		show_msg($_LANG['tables_create_error']);
	}
}

/**
 * 罗列表列表
 *
 * @param unknown_type
 * @return unknown
 */
function get_tables_list()
{
	global $_LANG;
	$config_info = get_ini_config();
	@extract($config_info);

	$link = db_resource($db_host, $db_user, $db_passwd, $db_name);
	//罗列表
	$sql = 'SHOW tables';
	$result = mysql_query($sql, $link);
	$list = array();
	while ($row = mysql_fetch_array($result, MYSQL_NUM)) {
		if (!preg_match("/$db_prefix.+/i", $row[0])) {
			continue;
		}
		$list[] = $row;
	}
	mysql_free_result($result);
	mysql_close($link);

	return $list;

}

/**
 * 卸载xeibo，删除表和配置文件
 *
 * @param unknown_type
 * @return unknown
 */
function uninstall($backup)
{
	if (!file_exists(ROOT_PATH.'/user_config.php')) {
		@unlink(ROOT_PATH.'/var/data/install.lock');
		die('1');
	}

	@include_once ROOT_PATH.'/user_config.php';
	//是否保留数据
	if ($backup != 1) { 
		$link = db_resource(DB_HOST, DB_USER, DB_PASSWD, DB_NAME, true);
		$sql = 'SHOW tables';
		$result = mysql_query($sql, $link);
		$list = array();
		$db_prefix = DB_PREFIX;
		$tables = array();
		$sql_dump = '';
		while ($row = mysql_fetch_array($result, MYSQL_NUM)) {
			if (!preg_match("/$db_prefix.+/i", $row[0])) {
				continue;
			}
			$sql_dump .= backup_data_sql($link, $row[0]);
			$tables[] = $row[0];
		}

		//生成备份数据表的sql文件
		$name = date('Ymd', time()).'_'.DB_NAME.'_backup.sql';
		$fp = fopen(ROOT_PATH.'/var/data/'.$name, 'wb+');
		if ($fp == false) {
			die($_LANG['datadir_access']);
		}
		if (fwrite($fp, $sql_dump) === false) {
			die($_LANG['xweibo_uninstall_backup_error']);
		}
		fclose($fp);

		//删除表
		foreach ($tables as $var) {
			$sql = 'DROP TABLE '.$var;
			mysql_query($sql, $link);
		}

		mysql_free_result($result);
		mysql_close($link);
	}

	//统计上报 
	include_once "fsockopen.php";
	$http = new Http_Client();
	$url_report = 'http://beacon.x.weibo.com/a.gif?xt=un&akey='.WB_AKEY.'&ip='.get_real_ip().'&random='.mt_rand();
	$http->setUrl($url_report);
	$http->request();

	@unlink(ROOT_PATH.'/var/data/temp.ini');
	@unlink(ROOT_PATH.'/var/data/install.lock');
	@unlink(ROOT_PATH.'/user_config.php');
	die('1');
}

/**
 * 备份数据表sql语句
 *
 * @param unknown_type
 * @return unknown
 */
function backup_data_sql($link, $table)
{
	$sql_dump = "DROP TABLE IF EXISTS `$table`;\r\n\r\n";
	$sql = 'SHOW CREATE TABLE '.$table;
	$result = mysql_query($sql, $link);
	$rows = mysql_fetch_row($result);
	$sql_dump .= $rows[1]."\r\n\r\n";

	$sql = 'SELECT * FROM '.$table;
	$result = mysql_query($sql, $link);
	$field_key = array();
	$field_value = array();
	$field_value_string = array();
	while($row = mysql_fetch_assoc($result)) {
		if (empty($row)) {
			continue;
		}
		foreach ($row as $key => $var) {
			$field_key[$key] = "`".$key."`";
			$field_value[$key] = "'".mysql_real_escape_string($var)."'";
		}
		$field_value_string[] = '('.implode(', ', $field_value).')';
	}

	if (!empty($field_value_string)) {
		$sql_dump .= "/*Data for the table `$table` */\r\n\r\n";
		$sql_dump .= "INSERT INTO $table (".implode(', ', $field_key).")VALUES".implode(',', $field_value_string)."\r\n\r\n";
	}
	return $sql_dump;
}

/**
 * 添加管理员
 *
 * @param unknown_type
 * @return unknown
 */
function add_admin($db_host, $db_user, $db_passwd, $db_name, $db_prefix = 'xwb_', $admin_name, $admin_passwd)
{
	global $_LANG;
	$link = db_resource($db_host, $db_user, $db_passwd, $db_name);
	$table = $db_prefix.'admin_user';
	$sql = "INSERT INTO $table (`name`, `real_name`, `pwd`, `state`, `add_time`)VALUES('".mysql_real_escape_string($admin_name)."', '".mysql_real_escape_string($admin_name)."', '".md5(mysql_real_escape_string($admin_passwd))."', '0', ".time().")";
	if (mysql_query($sql, $link) == false) {
		show_msg($_LANG['add_admin_errno']);
	}
	mysql_close($link);
}

/**
 * 获取临时ini文件变量
 *
 * @param unknown_type
 * @return unknown
 */
function get_ini_config()
{
	if (!file_exists(ROOT_PATH.'/var/data/temp.ini')) {
		return false;
	}
	$fp = fopen(ROOT_PATH.'/var/data/temp.ini', 'rb+');
	$content = fread($fp, filesize(ROOT_PATH.'/var/data/temp.ini'));

	$site_base_info = array();
	parse_str($content, $site_base_info);
	return $site_base_info;
}

/**
 * 创建临时ini文件
 *
 * @param unknown_type
 * @return unknown
 */
function set_ini_file($config)
{
	global $_LANG;
	extract($config);

	$app_config = get_ini_config();

	$site_name = empty($site_name) ? $app_config['site_name'] : $site_name;
	$site_info = empty($site_info) ? $app_config['site_info'] : $site_info;
	$app_key = empty($app_key) ? $app_config['app_key'] : $app_key;
	$app_secret = empty($app_secret) ? $app_config['app_secret'] : $app_secret;
	$oauth_token = empty($oauth_token) ? $app_config['oauth_token'] : $oauth_token;
	$oauth_token_secret = empty($oauth_token_secret) ? $app_config['oauth_token_secret'] : $oauth_token_secret;

	$config_file = 'site_name='.$site_name.'&site_info='.$site_info.'&app_key='.$app_key.'&app_secret='.$app_secret.'&db_host='.$db_host.'&db_name='.$db_name.'&db_user='.$db_user.'&db_passwd='.$db_passwd.'&db_prefix='.$db_prefix.'&cache='.$cache.'&mc_host='.$mc_host.'&user_name='.$user_name.'&email='.$email.'&qq='.$qq.'&msn='.$msn.'&tel='.$tel.'&oauth_token='.$oauth_token.'&oauth_token_secret='.$oauth_token_secret;
	//写临时ini配置文件
	$fp = fopen(ROOT_PATH.'/var/data/temp.ini', 'wb+');
	if ($fp == false) {
		show_msg($_LANG['datadir_access']);
	} else {
		if (fwrite($fp, $config_file) === false) {
			show_msg($_LANG['tmp_config_error']);
		}
		fclose($fp);
	}
}

/**
 * 修改css文件
 *
 * @param unknown_type
 * @return unknown
 */
function modifly_css_file($path)
{
	$fp = fopen(ROOT_PATH.'/css/base.css', 'rb+');
	if ($fp == false) {
		show_msg($_LANG['create_config_error']);
	} else {
		$css = fread($fp, filesize(ROOT_PATH.'/css/base.css'));
		$css = preg_replace('/(\.zoom-move){.+}/', "\$1{ cursor:url($path/css/bgimg/big.cur), auto;}", $css);
		$css = preg_replace('/(\.narrow-move){.+}/', "\$1{ cursor:url($path/css/bgimg/small.cur), auto;}", $css);
		fclose($fp);

		$fp = fopen(ROOT_PATH.'/css/base.css', 'wb+');
		if (fwrite($fp, $css) === false) {
			show_msg($_LANG['write_css_error']);
		}
		fclose($fp);
	}
}

/**
 * 获取ip
 *
 * @return unknown
 */
function get_real_ip() {
	// Gets the default ip sent by the user
	if (!empty($_SERVER['REMOTE_ADDR'])) {
		$direct_ip = $_SERVER['REMOTE_ADDR'];
	}
	// Gets the proxy ip sent by the user
	$proxy_ip     = '';
	if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$proxy_ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else if (!empty($_SERVER['HTTP_X_FORWARDED'])) {
		$proxy_ip = $_SERVER['HTTP_X_FORWARDED'];
	} else if (!empty($_SERVER['HTTP_FORWARDED_FOR'])) {
		$proxy_ip = $_SERVER['HTTP_FORWARDED_FOR'];
	} else if (!empty($_SERVER['HTTP_FORWARDED'])) {
		$proxy_ip = $_SERVER['HTTP_FORWARDED'];
	} else if (!empty($_SERVER['HTTP_VIA'])) {
		$proxy_ip = $_SERVER['HTTP_VIA'];
	} else if (!empty($_SERVER['HTTP_X_COMING_FROM'])) {
		$proxy_ip = $_SERVER['HTTP_X_COMING_FROM'];
	} else if (!empty($_SERVER['HTTP_COMING_FROM'])) {
		$proxy_ip = $_SERVER['HTTP_COMING_FROM'];
	}
	// Returns the true IP if it has been found, else FALSE
	if (empty($proxy_ip)) {
		// True IP without proxy
		return $direct_ip;
	} else {
		$is_ip = preg_match('|^([0-9]{1,3}\.){3,3}[0-9]{1,3}|', $proxy_ip, $regs);
		if ($is_ip && (count($regs) > 0)) {
			// True IP behind a proxy
			return $regs[0];
		} else {
			// Can't define IP: there is a proxy but we don't have
			// information about the true IP
			return $direct_ip;
		}
	}
}

/**
 * 获取token
 *
 * @param unknown_type
 * @return unknown
 */
function getOauthToken()
{
//	$url = '';
//	$params['app_key'] = $app_key;
//	$params['app_secret'] = $app_secret;
//	$params_string = http_build_query($params);
//	$url = strpos($url, '?') === false ? $url.$params_string : $url.'&'.$params_string;
//	$http = new Http_Client();
//	$http->setUrl($url);
//	$result = $http->request();
//	$code = $http->getState();
////	if ($code != '200') {
////		show_msg($_LANG['app_key_error']);
////	}
//	$result = json_decode($result, true);
	$result['oauth_token'] = '6724f3fd9a92b82df087a09673cdbcde';
	$result['oauth_token_secret'] = 'df82a6fb06562ac3f91de09f15b1262c';
	set_ini_file($result);
}

/**
 * 创建配置文件
 *
 * @param unknown_type
 * @return unknown
 */
function set_config_file()
{
    if (file_exists(ROOT_PATH.'/var/data/install.lock')) {
		return false;
    }
	
	global $_LANG;
	$site_configs = get_ini_config();
	$app_key = $site_configs['app_key'];
	$app_secret = $site_configs['app_secret'];
	$site_name = $site_configs['site_name'];
	$site_info = $site_configs['site_info'];
	$db_host = $site_configs['db_host'];
	$db_user = $site_configs['db_user'];
	$db_name = $site_configs['db_name'];
	$db_passwd = $site_configs['db_passwd'];
	$db_prefix = $site_configs['db_prefix'];
	$db_charset = XWEIBO_DB_CHARSET;
	$user_name = $site_configs['user_name'];
	$email = $site_configs['email'];
	$qq = $site_configs['qq'];
	$msn = $site_configs['msn'];
	$tel = $site_configs['tel'];
	$oauth_token = $site_configs['oauth_token'];
	$oauth_token_secret = $site_configs['oauth_token_secret'];

	//统计上报 
	include_once "fsockopen.php";
	$http = new Http_Client();
	$url_report = 'http://beacon.x.weibo.com/a.gif?xt=in&akey='.$app_key.'&name='.urlencode($site_name).'&content='.urlencode($site_info).'&uname='.urlencode($user_name).'&em='.urlencode($email).'&qq='.$qq.'&msn='.$msn.'&tel='.$tel.'&ip='.get_real_ip().'&random='.mt_rand();
	$http->setUrl($url_report);
	$http->request();

	//是否加载curl模块
	if (function_exists('curl_init')) {
		$http_adapter = 'curl';
	} else {
		$http_adapter = 'fsockopen';
	}

	$config_file = <<<XWB
<?php
//----------------------------------------------------------------------
//数据库服务器地址
define("DB_HOST",						"$db_host");
//数据库端口,默认为3306
define("DB_PORT",						"3306");
//数据库名
define("DB_NAME",						"$db_name");
//数据库用户名
define("DB_USER",						"$db_user");
//数据库密码
define("DB_PASSWD",						"$db_passwd");
//数据库字符集
define("DB_CHARSET",					"$db_charset");
//数据库表前缀
define("DB_PREFIX",						"$db_prefix");
//----------------------------------------------------------------------
//微博 APP_KEY
define("WB_AKEY",						"$app_key");
//微博 SECRET_KEY
define("WB_SKEY",						"$app_secret");
//----------------------------------------------------------------------
//http适配器配置
define('HTTP_ADAPTER',					"$http_adapter");
//----------------------------------------------------------------------
//用户个人信息
define("WB_USER_SITENAME",				"$site_name");
define("WB_USER_SITEINFO",				"$site_info");
define("WB_USER_NAME",					"$user_name");
define("WB_USER_EMAIL",					"$email");
define("WB_USER_QQ",					"$qq");
define("WB_USER_MSN",					"$msn");
define("WB_USER_TEL",					"$tel");
//----------------------------------------------------------------------
//用户后台TONKEN
define("WB_USER_OAUTH_TOKEN",			"$oauth_token");
define("WB_USER_OAUTH_TOKEN_SECRET",	"$oauth_token_secret");
//----------------------------------------------------------------------
define("R_MODE",						0);
//----------------------------------------------------------------------
XWB;

//缓存设置
	$config_file .= "\r\n";
	if ($site_configs['cache'] == 1) {
		$mc_host = $site_configs['mc_host'];
//		$mc_port = $site_configs['mc_port'];
		$cache_adapter = 'memcache';
		$config_file .= <<<XWB
//缓存适配器配置
define('CACHE_ADAPTER',					"$cache_adapter");
define("MC_HOST",						"$mc_host");
//----------------------------------------------------------------------
?>
XWB;
	} else {
		$cache_adapter = 'file';
		$config_file .= <<<XWB
//缓存适配器配置
define('CACHE_ADAPTER',					"$cache_adapter");
//----------------------------------------------------------------------
?>
XWB;
	}

	//写配置文件
	$fp = fopen(ROOT_PATH.'/user_config.php', 'wb+');
	if ($fp == false) {
		show_msg($_LANG['create_config_error']);
	} else {
		if (fwrite($fp, $config_file) === false) {
			show_msg($_LANG['write_config_error']);
		}
		fclose($fp);
	}

	//创建安装成功文件标示
	$fp = fopen(ROOT_PATH.'/var/data/install.lock', 'w+');
	if ($fp != false) {
		if (fwrite($fp, time()) === false) {
			show_msg($_LANG['create_install_lock_error']);
		}
		fclose($fp);
	} else {
		show_msg($_LANG['create_install_lock_error']);
	}

	//删除临时ini配置文件
	@unlink(ROOT_PATH.'/var/data/temp.ini');
}

/**
 * 错误提示信息
 *
 * @param unknown_type
 * @return unknown
 */
function show_msg($msg, $url = null, $auto = null)
{
	global $_LANG;
	include 'templates/error.php';
	exit;
}
