<?php
/**************************************************
*  Created:  2010-07-08
*
*  Xweibo安装程序
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author heli1 <heli1@staff.sina.com.cn>
*
***************************************************/

@ini_set('display_errors', 1);
error_reporting(E_ALL ^ E_NOTICE);
@ini_set('magic_quotes_runtime', 'Off');
define('XWEIBO_ACCESS', true);

define('ROOT_PATH', dirname(__FILE__).'/../');
define('XWEIBO_DB_PREFIX', 'xwb_');
define('XWEIBO_CHARSET','utf-8');
define('XWEIBO_DB_CHARSET','utf8');

include_once ROOT_PATH.'/install/libs/func.php';


$install_lang = 'zh_cn';
include_once ROOT_PATH.'/install/lang/'.$install_lang.'.php';

if (file_exists(ROOT_PATH.'/var/data/install.lock')) {
	show_msg($_LANG['xwb_installed'], './');
}

$step = empty($_REQUEST['step']) ? 0 : $_REQUEST['step'];
$allow_action = array('license', 'check', 'setApp', 'setConfig', 'create', 'done');

$method = empty($_GET['method']) ? $allow_action[$step] : $_GET['method'];

switch ($method) {
	case 'license':
		@unlink(ROOT_PATH.'/var/data/temp.ini');
		include_once ('templates/index.php');
		break;
	case 'check':
		$disabled = true;

		$env_vars = check_env($disabled);

		$dir_file_vars = check_dir($disabled);

		$func_vars = check_func($disabled);

		include_once ('templates/step-1.php');
		break;
	case 'setApp':
		$app_info = get_ini_config();
		@extract($app_info);
		include_once ('templates/step-2.php');
		break;
	case 'check_app':
		$site_name = trim($_POST['site_name']);
		$site_info = trim($_POST['site_info']);
		$app_key = trim($_POST['app_key']);
		$app_secret = trim($_POST['app_secret']);

		$config = array('site_name' => $site_name,
						'site_info' => $site_info,
						'app_key' => $app_key,
						'app_secret' => $app_secret
						);
		set_ini_file($config);

		if (empty($app_key) || empty($app_secret)) {
			show_msg($_LANG['app_key_empty']);
		}

		$disabled = check_app($app_key, $app_secret);
		if ($disabled) {
//			getOauthToken();
			header('Location: ./index.php?step=3');
			exit;
		} else {
			include_once ('templates/step-2.php');
		}
		break;
	case 'setConfig':
		$site_config = get_ini_config();
		@extract($site_config);
		include_once ('templates/step-3.php');
		break;
	case 'create':
		if (!function_exists('mysql_connect')) {
			show_msg($_LANG['mysql_connect']);
		}
		$db_host = trim($_POST['db_host']);
		$db_user = trim($_POST['db_user']);
		$db_passwd = trim($_POST['db_passwd']);
		$db_name = trim($_POST['db_name']);
		$db_prefix = trim($_POST['db_prefix']);
		$db_prefix = empty($db_prefix) ? XWEIBO_DB_PREFIX : (strpos($db_prefix, '_') === false ? $db_prefix.'_' : $db_prefix);

		$cache = $_POST['cache'];
		$mc_host = trim($_POST['mc_host']);
		$mc_port = trim($_POST['mc_port']);

		$admin_name = trim($_POST['admin_name']);
		$admin_passwd = trim($_POST['admin_passwd']);
		$admin_confirm_passwd = trim($_POST['admin_confirm_passwd']);

		$user_name = trim($_POST['user_name']);
		$email = trim($_POST['email']);
		$qq = trim($_POST['qq']);
		$msn = trim($_POST['msn']);
		$tel = trim($_POST['tel']);

		$config = array('db_host' => $db_host,
						'db_user' => $db_user,
						'db_passwd' => $db_passwd,
						'db_name' => $db_name,
						'db_prefix' => $db_prefix,
						'cache' => $cache,
						'mc_host' => $mc_host . ':' . $mc_port,
						'user_name' => $user_name,
						'email' => $email,
						'qq' => $qq,
						'msn' => $msn,
						'tel' => $tel);
		set_ini_file($config);

		$error_msg = array();
		if (empty($db_host) || empty($db_name) || empty($db_user) || empty($db_passwd)) {
			$error_msg[] = $_LANG['database_info_empty'];
		}

		if ($cache == 1) {
			if (empty($mc_host) || empty($mc_port)) {
				$error_msg[] = $_LANG['memcache_info_empty'];
			}
			check_mc_connect($mc_host, $mc_port);
		}

		if (empty($admin_name) || empty($admin_passwd) || empty($admin_confirm_passwd)) {
			$error_msg[] = $_LANG['admin_info_empty'];
		} elseif ($admin_passwd != $admin_confirm_passwd) {
			$error_msg[] = $_LANG['admin_confirm_passwd_incorrect'];
		}

		if (empty($user_name) || empty($email)) {
			$error_msg[] = $_LANG['contact_info_empty'];
		}
		if (!empty($error_msg)) {
			show_msg(implode(', ', $error_msg));
		}

		create_db($db_host, $db_user, $db_passwd, $db_name);

		create_tables($db_host, $db_user, $db_passwd, $db_name, $db_prefix);

		add_admin($db_host, $db_user, $db_passwd, $db_name, $db_prefix, $admin_name, $admin_passwd);

		header('Location: ./index.php?step=4&method=view');
		exit;
		break;
	case 'view':
		$table_list = get_tables_list();
		include_once ('templates/step-4.php');
		break;
	case 'done':
		set_config_file();

		$paths = explode('/', $_SERVER['SCRIPT_NAME']);
		foreach ($paths as $var) {
			if ($var == 'install' || $var == 'uninstall' || strpos($var, '.')) {
				continue;
			}
			$urls[] = $var;
		}
		$string_path = implode('/', $urls);
		$index_url = 'http://'.$_SERVER['HTTP_HOST'].$string_path;
		//修改css文件
		modifly_css_file($string_path);

		$admin_url = 'http://'.$_SERVER['HTTP_HOST'].$string_path.'/admin.php';
		include_once ('templates/finish.php');
		break;
		default:
			include_once ('templates/index.php');
}
?>
