

/*Table structure for table `xwb_admin_user` */

DROP TABLE IF EXISTS `xwb_admin_user`;

CREATE TABLE `xwb_admin_user` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(50) NOT NULL COMMENT '帐号',
  `real_name` VARCHAR(100) DEFAULT NULL COMMENT '真实姓名',
  `pwd` VARCHAR(50) NOT NULL COMMENT '密码',
  `state` TINYINT(2) DEFAULT NULL COMMENT '状态：0为开通，1为被禁用',
  `add_time` INT(11) DEFAULT NULL COMMENT '注册时间',
  PRIMARY KEY (`id`,`name`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `xwb_api_log` */

DROP TABLE IF EXISTS `xwb_api_log`;

CREATE TABLE `xwb_api_log` (
  `id` INT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `url` VARCHAR(500) DEFAULT NULL COMMENT '请求url',
  `base_string` VARCHAR(500) NOT NULL DEFAULT '' COMMENT '加密的base_string',
  `key_string` VARCHAR(500) NOT NULL DEFAULT '' COMMENT '加密的key_string',
  `http_code` INT(4) DEFAULT NULL COMMENT 'http code',
  `ret` VARCHAR(200) NOT NULL DEFAULT '' COMMENT '返回结果',
  `post_data` TEXT COMMENT 'post数据',
  `request_time` FLOAT DEFAULT NULL COMMENT '请求时间',
  `total_time` FLOAT DEFAULT NULL COMMENT '总执行时间',
  `s_ip` CHAR(15) DEFAULT NULL COMMENT '服务器ip',
  `log_time` CHAR(20) DEFAULT NULL COMMENT '记录时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC COMMENT='请求接口日志';

/*Table structure for table `xwb_celebrity` */

DROP TABLE IF EXISTS `xwb_celebrity`;

CREATE TABLE `xwb_celebrity` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nick` VARCHAR(45) NOT NULL COMMENT '昵称',
  `url` VARCHAR(400) NOT NULL COMMENT '微博地址',
  `description` TINYTEXT NOT NULL COMMENT '描述',
  `orders` INT(10) UNSIGNED NOT NULL COMMENT '顺序',
  `operator` INT(10) UNSIGNED NOT NULL COMMENT '操作人',
  `add_time` INT(10) UNSIGNED NOT NULL COMMENT '添加时间',
  `image` VARCHAR(400) NOT NULL COMMENT '头像URL',
  `del` TINYINT(3) UNSIGNED NOT NULL,
  `sina_uid` INT(10) UNSIGNED NOT NULL,
  `province` TINYINT(3) UNSIGNED NOT NULL,
  `city` TINYINT(3) UNSIGNED NOT NULL,
  `type` VARCHAR(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `index_orders` (`orders`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='名人推荐';

/*Table structure for table `xwb_disabled_comment` */

DROP TABLE IF EXISTS `xwb_disabled_comment`;

CREATE TABLE `xwb_disabled_comment` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cid` INT(10) UNSIGNED NOT NULL,
  `operator` INT(10) UNSIGNED NOT NULL,
  `add_time` INT(10) UNSIGNED NOT NULL,
  `text` VARCHAR(200) NOT NULL,
  `user` VARCHAR(45) NOT NULL,
  `uid` INT(10) UNSIGNED NOT NULL,
  `created_at` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='被屏蔽的回复';

/*Table structure for table `xwb_disabled_followers` */

DROP TABLE IF EXISTS `xwb_disabled_followers`;

CREATE TABLE `xwb_disabled_followers` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `screen_name` VARCHAR(45) NOT NULL,
  `uid` INT(10) UNSIGNED NOT NULL,
  `add_time` INT(10) UNSIGNED NOT NULL,
  `operator` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='被屏蔽的人气关注列表项';

/*Table structure for table `xwb_disabled_hot_publish` */

DROP TABLE IF EXISTS `xwb_disabled_hot_publish`;

CREATE TABLE `xwb_disabled_hot_publish` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `wid` BIGINT(20) UNSIGNED NOT NULL COMMENT '微博ID',
  `operator` VARCHAR(45) NOT NULL COMMENT '操作人',
  `add_time` INT(10) UNSIGNED NOT NULL COMMENT '加入时间',
  `type` TINYINT(3) UNSIGNED NOT NULL COMMENT '1为热门转发,2为热门评论',
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='被屏蔽的热门转发和评论';

/*Table structure for table `xwb_disabled_user` */

DROP TABLE IF EXISTS `xwb_disabled_user`;

CREATE TABLE `xwb_disabled_user` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` INT(10) UNSIGNED NOT NULL COMMENT '被屏蔽的 用户ID',
  `operator` INT(10) UNSIGNED NOT NULL COMMENT '操作者ID',
  `add_time` INT(10) UNSIGNED NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='被屏蔽的"人气关注"用户';

/*Table structure for table `xwb_disabled_weibo` */

DROP TABLE IF EXISTS `xwb_disabled_weibo`;

CREATE TABLE `xwb_disabled_weibo` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `wid` INT(10) UNSIGNED NOT NULL COMMENT '主题ID',
  `uid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `add_time` INT(10) UNSIGNED NOT NULL COMMENT '屏蔽时间',
  `operator` INT(10) UNSIGNED NOT NULL COMMENT '操作人',
  `text` VARCHAR(300) NOT NULL COMMENT '微博内容',
  `user` VARCHAR(45) NOT NULL COMMENT '姓名',
  `created_at` INT(10) UNSIGNED NOT NULL COMMENT '微博创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_wid` (`wid`),
  KEY `index_add_time` (`add_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='被屏蔽的主题';

/*Table structure for table `xwb_followers_count` */

DROP TABLE IF EXISTS `xwb_followers_count`;

CREATE TABLE `xwb_followers_count` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `screen_name` VARCHAR(45) NOT NULL,
  `followers_count` INT(10) UNSIGNED NOT NULL,
  `uid` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_uid` (`uid`),
  KEY `index_followers_count` (`followers_count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='人气关注榜基数';

/*Table structure for table `xwb_keyword` */

DROP TABLE IF EXISTS `xwb_keyword`;

CREATE TABLE `xwb_keyword` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` TINYINT(3) UNSIGNED NOT NULL DEFAULT '1' COMMENT '1为昵称过滤2为内容过滤',
  `keyword` VARCHAR(45) NOT NULL COMMENT '要过滤的关键字',
  `add_time` INT(10) UNSIGNED NOT NULL,
  `operator` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_keyword` (`keyword`),
  KEY `index_add_time` (`add_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='过滤关键词';

/*Table structure for table `xwb_sys_config` */

DROP TABLE IF EXISTS `xwb_sys_config`;

CREATE TABLE `xwb_sys_config` (
  `key` VARCHAR(40) NOT NULL,
  `value` TEXT NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='系统配置信息';

/*Table data for table `xwb_sys_config`*/
insert into `xwb_sys_config` (`key`, `value`) values('check_version','1');
insert into `xwb_sys_config` (`key`, `value`) values('version','1.0');
insert into `xwb_sys_config` (`key`, `value`) values('logo','');
insert into `xwb_sys_config` (`key`, `value`) values('bind_enable','0');
insert into `xwb_sys_config` (`key`, `value`) values('each_page_wb','10');
insert into `xwb_sys_config` (`key`, `value`) values('each_page_comment','10');
insert into `xwb_sys_config` (`key`, `value`) values('display_head','0');
insert into `xwb_sys_config` (`key`, `value`) values('header_html','');
insert into `xwb_sys_config` (`key`, `value`) values('footer_html','	<div id=\"footer\">\r\n\r\n<a href=\"http://x.weibo.com/\" target=\"_blank\">关于X微博</a>|<a href=\"http://x.weibo.com/index.php\" target=\"_blank\"> 联系我们</a>|<a href=\"http://bbs.x.weibo.com/\" target=\"_blank\">意见反馈</a>|<a href=\"http://x.weibo.com/help.php\" target=\"_blank\">帮助中心</a>\r\n\r\n<br />Copyright © 1996-2010 SINA\r\n\r\n</div>');


/*Table structure for table `xwb_temp` */

DROP TABLE IF EXISTS `xwb_temp`;

CREATE TABLE `xwb_temp` (
  `id` INT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `url` VARCHAR(400) DEFAULT NULL,
  `data` TEXT,
  `code` INT(4) DEFAULT NULL,
  `add_time` CHAR(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `xwb_today_topic` */

DROP TABLE IF EXISTS `xwb_today_topic`;

CREATE TABLE `xwb_today_topic` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `topic` VARCHAR(100) NOT NULL COMMENT '话题',
  `start_time` INT(10) UNSIGNED NOT NULL COMMENT '开始使用时间',
  `operator` INT(10) UNSIGNED NOT NULL COMMENT '操作人',
  `add_time` INT(10) UNSIGNED NOT NULL COMMENT '加入时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_topic` (`topic`),
  KEY `index_start_time` (`start_time`),
  KEY `index_operator` (`operator`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='今日话题';

/*Table structure for table `xwb_user_config` */

DROP TABLE IF EXISTS `xwb_user_config`;

CREATE TABLE `xwb_user_config` (
  `id` INT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sina_uid` INT(4) NOT NULL,
  `values` VARCHAR(100) NOT NULL DEFAULT '0' COMMENT '用户自定义的配置',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sina_uid` (`sina_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户自定义配置的信息';

/*Table structure for table `xwb_user_token` */

DROP TABLE IF EXISTS `xwb_user_token`;

CREATE TABLE `xwb_user_token` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `screen_name` VARCHAR(200) COLLATE utf8_bin DEFAULT NULL COMMENT '微博昵称',
  `sina_uid` VARCHAR(50) COLLATE utf8_bin DEFAULT NULL COMMENT '绑定账号的SINA_UID',
  `uid` INT(11) DEFAULT NULL COMMENT '用户ID',
  `oauth_token` VARCHAR(50) COLLATE utf8_bin DEFAULT NULL COMMENT 'oauth_token',
  `oauth_token_secret` VARCHAR(50) COLLATE utf8_bin DEFAULT NULL COMMENT 'oauth_token_secret',
  `sina_account` VARCHAR(50) COLLATE utf8_bin DEFAULT NULL COMMENT '绑定的账号',
  `add_time` INT(11) NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`uid`),
  UNIQUE KEY `sina_uid` (`sina_uid`),
  UNIQUE KEY `sina_account` (`sina_account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC COMMENT='用户ID与AUTH_TOKEN信息关联表';

/*Table structure for table `xwb_user_verify` */

DROP TABLE IF EXISTS `xwb_user_verify`;

CREATE TABLE `xwb_user_verify` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nick` VARCHAR(45) NOT NULL COMMENT '要加V的用户',
  `add_time` INT(10) UNSIGNED NOT NULL,
  `operator` INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_nick` (`nick`),
  KEY `index_add_time` (`add_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='要加V的用户';

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
