<?php
/**************************************************
*  Created:  2010-06-08
*
*  系统配置文件
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/
define('WB_VERSION', '1.0.0');
/// 系统默认的模块路由 当入口文件中未定义时使用如下值
if ( !defined('R_DEF_MOD') ) {define('R_DEF_MOD', "index");}
/// 系统默认的模块方法
define('R_DEF_MOD_FUNC',	"default_action");
//----------------------------------------------------------------------
/// 本地安全 solt string
define('AUTH_KEY',			'XMBLOG');
/// 站点语言名称（目录）
define('SITE_LANG',			'zh_cn');
/// 站点皮肤名称（目录）
define('SITE_SKIN_TYPE',	'default');
/// 字体目录
define('WB_FONT_PATH',		P_VAR_DATA . '/fonts');

/// 微博列表默认显示条数
define('WB_API_LIMIT', 20);
//----------------------------------------------------------------------
/// 微博 api url
define('WEIBO_API_URL', 	'http://api.t.sina.com.cn/');
/// sinaurl.cn 地址信息查询API地址
define('SINAURL_INFO', 		'http://t.sina.com.cn/mblog/sinaurl_info.php');
/// 微博表情 url
define('WB_EMOTICONS_URL',	'http://timg.sjs.sinajs.cn/miniblog2style/images/common/face/basic/');
/// X微博升级检查URL
define('WB_UPGRADE_CHK_URL','http://x.weibo.com/service/stdVersion.php');
//----------------------------------------------------------------------

/// 存储OAUTH 未授权信息的 SESSION 变量名
define('WB_OAUTH_KEYS1',	'XWB_OAUTH_NO_CONFIRM');
/// 存储OAUTH 已授权信息的 SESSION 变量名
define('WB_OAUTH_KEYS2',	'XWB_OAUTH_CONFIRM');
/// 存储用户会话数据的 SESSION 变量名
define('WB_CLIENT_SESSION',	'XWB_CLIENT_SESSION');
/// 存储管理员会话数据的 SESSION 变量名
define('WB_ADMIN_SESSION',	'XWB_ADMIN_SESSION');
/// 与FLASH同步会话时 FLASH 传递 PHPSESSID 使用的变量路由
define('WB_FLASH_PHPSESSID','p:_PHPSESSID');
/// 与FLASH同步会话时 FLASH 传递 uid 使用的变量路由
define('WB_FLASH_PHPSESSUID','p:_PHPSESSUID');
//----------------------------------------------------------------------
//// 站点LOGO文件名
define('WB_LOGO_FILE_NAME',	'/data/logo/logo.png');
define('WB_LOGO_PREVIEW_FILE_NAME',	'/data/logo/logo_preview.png');

/// 数据库名表名 admin_user
define('T_ADMIN_USER',		'admin_user');
/// 数据库名表名 user_token
define('T_USER_TOKEN',		'user_token');
/// 数据表,今日话题
define('T_TODAY_TOPIC',		'today_topic');
/// 数据表,明人推荐
define('T_CELEBRITY', 		'celebrity');
/// 数据表,被屏蔽的热门转发和评论
define('T_DISABLED_HOT_PUBLISH', 'disabled_hot_publish');
/// 数据表,被屏蔽的"人气关注"用户
define('T_DISABLED_USER',	'disabled_user');
/// 数据表,被屏蔽的微博
define('T_DISABLED_WEIBO',	'disabled_weibo');
/// 数据表，被屏蔽的回复
define('T_DISABLED_COMMENT','disabled_comment');
/// 数据表,过滤关键词
define('T_KEYWORD',			'keyword');
/// 数据表,要加V的用户
define('T_USER_VERIFY',		'user_verify');
/// 关注人气榜基数
define('T_FOLLOWERS_COUNT',	'followers_count');
/// 数据表,被屏蔽的人气关注列表项
define('T_DISABLED_FOLLOWERS',	'disabled_followers');
/// 数据表,保存用户后台设置项
define('T_SYS_CONFIG',		'sys_config');
/// 数据表,保存用户自定义配置项
define('T_USER_CONFIG',		'user_config');
//---------------------------------------------------------------------
/// cache下标定义 屏蔽回复
define('CACHE_DISABLED_COMMENT',			'disabled_comment');
/// cache下标定义  屏蔽微博
define('CACHE_DISABLED_WEIBO',				'disabled_weibo');
/// cache下标定义 昵称关键字
define('CACHE_DISABLED_NICK_KEYWORD',		'disabled_nick_keyword');
/// cache下标定义 内容关键字
define('CACHE_DISABLED_CONTENT_KEYWORD',	'disabled_content_keyword');
/// cache下标定义 通过认证的用户
define('CACHE_USER_VERIFY', 				'user_verify');
/// cache下标前缀定义 @me,评论,粉丝未读数
define('CACHE_UNREAD_COUNTER',				'unread_counter_');
/// cache下标,用户后台配置缓存
define('CACHE_SYS_CONFIG',					'sys_config');
/// cache下标,用户自定义配置缓存
define('CACHE_USER_CONFIG',					'user_config');
//----------------------------------------------------------------------

//// 定时程序锁文件前缀
define('CRON_LOCK_FILE_PREFIX', 'cron_lock_');

/// 全局配置变量
$cfg = array();
//----------------------------------------------------------------------
/// 适配器选择配置
if (!defined('HTTP_ADAPTER')) {
	define('HTTP_ADAPTER', 'curl');
}
if (!defined('CACHE_ADAPTER')) {
	define('CACHE_ADAPTER', 'file');
}
$cfg['adapter'] = array(
	'io'	=>'file',
	'db'	=>'mysql',
	'http'	=> HTTP_ADAPTER,
	'cache'	=> CACHE_ADAPTER,
	'mailer'=>'smtp'
);
//----------------------------------------------------------------------
/// 适配器初始化数据配置变量
$_adapter = &$cfg['adapter_cfg'];
//----------------------------------------------------------------------
$_adapter['db'] = array();
$_adapter['db']['mysql'] = array(
	'host'	 => DB_HOST,
	'port'	 => DB_PORT,
	'user'	 => DB_USER,
	'pwd'	 => DB_PASSWD,
	'charset'=> DB_CHARSET,
	'tbpre'	 => DB_PREFIX,
	'db'	 => DB_NAME
);
//----------------------------------------------------------------------
$_adapter['io'] = array();
$_adapter['io']['file'] = array();
$_adapter['io']['ftp']	= array();
//----------------------------------------------------------------------
$_adapter['http'] = array();
$_adapter['http']['curl'] 		= array();
$_adapter['http']['fsockopen'] 	= array();
$_adapter['http']['snoopy'] 	= array();
//----------------------------------------------------------------------
$_adapter['cache'] = array();
$_adapter['cache']['file'] 				= array(
	'baseDir'=>		P_VAR_CACHE,
	'pathLevel'=>	3,
	'nameLen'=>		2,
	'varName'=>		'__cache_data'
);
$_adapter['cache']['xcache'] 			= array();

$_adapter['cache']['memcache'] 			= array(
	'pconnect'=>false,
	'servers'=>	MC_HOST,
	'keyPre'=>	'XWB_MC_'
);
$_adapter['cache']['eaccelerator'] 		= array();
//----------------------------------------------------------------------
$_adapter['mail'] = array();
$_adapter['mail']['mail'] 	= array();
$_adapter['mail']['smtp']	= array();

//----------------------------------------------------------------------
/// WB api接口错误状态吗
$cfg['apierrno'] = array('400', '403', '404', '500');
//----------------------------------------------------------------------
/// sina微博表情对应表
$cfg['sinaWeiboEmotions'] = array(
	array('足球','football.gif'),
	array('哨子','shao.gif'),
	array('红牌','redcard.gif'),
	array('黄牌','yellowcard.gif'),
	array('哈哈','laugh.gif'),
	array('呵呵', 'smile.gif'),
	array('衰','cry.gif'),
	array('汗','sweat.gif'),
	array('爱你','love.gif'),
	array('嘻嘻','tooth.gif'),
	array('哼','hate.gif'),
	array('心','heart.gif'),
	array('晕','dizzy.gif'),
	array('怒','angry.gif'),
	array('蛋糕','cake.gif'),
	array('花','flower.gif'),
	array('抓狂','crazy.gif'),
	array('困','sleepy.gif'),
	array('干杯','cheer.gif'),
	array('太阳','sun.gif'),
	array('下雨','rain.gif'),
	array('泪','sad.gif'),
	array('月亮','moon.gif'),
	array('猪头','pig.gif'),
	array('蜡烛','candle.gif'),
	array('冰棍','ice.gif'),
    /*
	array('帽子','hat_thumb.gif'),
	array('微风','wind_thumb.gif'),
	array('礼花','bingo_thumb.gif'),
	array('雨伞','umb_thumb.gif'),
	array('电视机','tv_thumb.gif'),
	array('阳光','sunny_thumb.gif'),
	array('星','star_thumb.gif'),
	array('话筒','m_thumb.gif'),
	array('音乐','music_thumb.gif'),
	array('电影','movie_thumb.gif'),
    */
	array('风扇','fan.gif'),
	array('西瓜','watermelon.gif'));
//----------------------------------------------------------------------
/// 访问控制列表
$aclTable = &$cfg['aclTable'];
/// 入口控制配置 : 入口名 路由匹配正则 控制选项 （选项为 true 时 表示匹配的路由被允许访问 ）
$aclTable['E']		= array();
$aclTable['E'][]	= array('admin',	"#^admin/.*#sim",true);
$aclTable['E'][]	= array('index',	"#^admin/.*#sim",false);

/// IP控制配置 ： 入口名称 IP匹配正则 控制选项
$aclTable['IP']		= array();
//$aclTable['IP'][]	= array('index',"",true);
//----------------------------------------------------------------------

// 模板使用的变量，使用方法：  V('-:tpl/title');
$tpl = &$cfg['tpl'];
$tpl = array(
			'title' => ' - Powered By X微博'	// 站点标题中的站点名
			);

?>
