<?php
/**************************************************
*  Created:  2010-06-08
*
*  他人的微博
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/

class ta
{

	function ta()
	{
	}

	/**
	 * ta的首页
	 *
	 *
	 */
	function default_action()
	{
		$id = V('g:id');
		$name = V('g:name');

		if (empty($id) && empty($name)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'location' => 'index', 'timeout' => 5, 'msg'=> '抱歉，您访问的页面不存在或已经删除了'));
		}

		//实例化存储
		$storage = APP::N('clientUser');

		$sina_id = $storage->getInfo('sina_uid');

		//如果是自己，跳转到首页
		if ($name == $storage->getInfo('screen_name') ||
			$id == $sina_id) {
			APP::redirect('index');
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化分页pager
		$pager = APP::N('pager');

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($id, '', $name);

		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//是否关注了ta
		$isFriends = $wbApi->existsFriendship($sina_id, $userinfo['id']);
		if ($isFriends['error_code']) {
			//调用接口失败
		}

		//获取ta的粉丝列表前9条数据
		$followers = $wbApi->getFollowers($userinfo['id'], null, null, 1, 9);

		//页码数
		$page = max(V('g:page'), 1);

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit * 2;

		//调用获取当前用户所关注用户的最新微博信息api
		if ($page == 1) {
			$list = $wbApi->getUserTimeline($userinfo['id'], null, null, null, null, $count, $page);
		} else {
			$list = $wbApi->getUserTimeline($userinfo['id'], null, null, $start_pos, $end_pos, $count);
		}

		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);

		//获取总条数
		$total_count = count($list);
		if ($total_count > $limit) {
			//取LIMIT条数据
			$list = array_slice($list, 0, $limit+1);
			$end_pos_array = array_pop($list);
			$end_pos = $end_pos_array['id'];
		} else {
			$end_pos_array = end($list);
			$end_pos = $end_pos_array['id'];
		}

		$start_pos = $list[0]['id'];
		$makePage = $pager->pagehtml(array('endmid' => $endmid, 'start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		/*
		if (!empty($list)) {
			$ids = array();
			foreach ($list as $key => $var) {
				$ids[] = $var['id'];
				//如果存在转发微博
				if ($var['retweeted_status']) {
					$ids[] = $var['retweeted_status']['id'];
				}
			}
			//批量获取指定微博的转发数和评论数
			$batch_counts = APP::F('weibo_counts', $ids);
		}
		*/

		//获取ta的粉丝列表前9条数据
		$followers = $wbApi->getFollowers($userinfo['id'], null, null, -1, 9);

		//获取当前用户的粉丝列表id
		$fids = $wbApi->getFollowerIds($sina_id, null, null, -1, 5000);

		TPL::assign('uid', $sina_id);
		TPL::assign('list', $list);
		TPL::assign('userinfo', $userinfo);
//		TPL::assign('batch_counts', $batch_counts);
		TPL::assign('isFriends', $isFriends['friends']);
		TPL::assign('followers', $followers['users']);
		TPL::assign('isFriends', $isFriends);
		TPL::assign('makePage', $makePage);
		TPL::assign('fids', $fids['ids']);
		TPL::assign('tab', 'profile');
		TPL::display('profile');
	}

	/**
	 * ta的关注列表
	 *
	 *
	 */
	function follow()
	{
		$id = V('g:id');
		$name = V('g:name');
		if (empty($id) && empty($name)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error'));
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//如果是自己，跳转到首页
		if ($name == $storage->getInfo('screen_name') ||
			$id == $storage->getInfo('sina_uid')) {
			APP::redirect('index.follow');
		}

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($id, '', $name);

		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//实例化分页pager
		$pager = APP::N('pager');

		//光标开始位置
		$start_pos = V('g:start_pos');
		//下一个光标开始位置
		$end_pos = V('g:end_pos');

		//页码数
		$page = max(V('g:page'), 1);

		//标示是否有下一页
		$p = V('g:p');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit;

		if (empty($end_pos) && empty($start_pos)) {
			$cursor = -1;
		} elseif (!empty($start_pos)) {
			$cursor = $start_pos;
		} elseif (!empty($end_pos)) {
			$cursor = $end_pos;
		}

		//调用获取当前用户关注对象列表及最新一条微博信息api
		$list = $wbApi->getFriends($userinfo['id'], null, null, $cursor, $count);
		//过滤过敏微博
		$list['users'] = APP::F('user_filter', $list['users']);
		if (empty($list['users']) && $page > 1) {
			$page = $page - 1;
			$end_pos = $list['previous_cursor'] - $limit;
			APP::redirect(URL('ta.follow', 'id='.$userinfo['id'].'&page='.$page.'&p=end&end_pos='.$end_pos), 3);
			exit;
		}

		//获取总条数
		$total_count = count($list['users']);
		if ($total_count > $limit) {
			//只取20条数据
			$list['users'] = array_slice($list['users'], 0, $limit);
		}

		//如果next_cursor为零，则没有下一页
		if ($list['next_cursor'] == 0 || $p == 'end') {
			$total_count = 0;
		} elseif ($list['next_cursor'] > 0 && $userinfo['friends_count'] >= $limit) {
			$total_count = $limit + 1;
		}

		$start_pos = $list['previous_cursor'];
		$end_pos = $list['next_cursor'];
		if ($start_pos > 0) {
			$start_pos = $start_pos - $count;
		}
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		//获取ta的粉丝列表前9条数据
		$followers = $wbApi->getFollowers($userinfo['id'], null, null, -1, 9);

		//获取当前用户的关注列表id
		$fids = $wbApi->getFriendIds($storage->getInfo('sina_uid'), null, null, -1, 5000);

		TPL::assign('list', $list);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::assign('followers', $followers['users']);
		TPL::assign('fids', $fids['ids']);
		TPL::display('follow');
	}


	/**
	 * ta的粉丝列表
	 *
	 *
	 */
	function fans()
	{
		$id = V('g:id');
		$name = V('g:name');
		if (empty($id) && empty($name)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error'));
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($id, '', $name);

		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//如果是自己，跳转到首页
		if ($name == $storage->getInfo('screen_name') ||
			$id == $storage->getInfo('sina_uid')) {
			APP::redirect('index.fans');
		}

		//实例化分页pager
		$pager = APP::N('pager');

		//光标开始位置
		$start_pos = V('g:start_pos');
		//下一个光标开始位置
		$end_pos = V('g:end_pos');

		//页码数
		$page = max(V('g:page'), 1);

		//标示是否有下一页
		$p = V('g:p');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit;

		if (empty($end_pos) && empty($start_pos)) {
			$cursor = -1;
		} elseif (!empty($start_pos)) {
			$cursor = $start_pos;
		} elseif (!empty($end_pos)) {
			$cursor = $end_pos;
		}

		//调用获取ta的粉丝列表及最新一条微博信息api
		$list = $wbApi->getFollowers($userinfo['id'], null, null, $cursor, $count);

		//获取ta的粉丝列表前9条数据
		$followers = $wbApi->getFollowers($userinfo['id'], null, null, -1, 9);

		//过滤过敏微博
		$list['users'] = APP::F('user_filter', $list['users']);
		if (empty($list['users']) && $page > 1) {
			$page = $page - 1;
			$end_pos = $list['previous_cursor'] - $limit;
			APP::redirect(URL('ta.fans', 'id='.$userinfo['id'].'&page='.$page.'&p=end&end_pos='.$end_pos), 3);
			exit;
		}

		//获取总条数
		$total_count = count($list['users']);
		if ($total_count > $limit) {
			//只取20条数据
			$list['users'] = array_slice($list['users'], 0, $limit);
		}

		//如果next_cursor为零，则没有下一页
		if ($list['next_cursor'] == 0 || $p == 'end') {
			$total_count = 0;
		} elseif ($list['next_cursor'] > 0 && $userinfo['followers_count'] >= $limit) {
			$total_count = $limit + 1;
		}

		$start_pos = $list['previous_cursor'];
		$end_pos = $list['next_cursor'];
		if ($start_pos > 0) {
			$start_pos = $start_pos - $count;
		}
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		//获取当前用户的关注列表id
		$fids = $wbApi->getFriendIds($storage->getInfo('sina_uid'), null, null, -1, 5000);

		TPL::assign('list', $list);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::assign('followers', $followers['users']);
		TPL::assign('fids', $fids['ids']);
		TPL::display('fans');
	}

	function profile()
	{
		$this->default_action();
	}

}
