<?php
/**************************************************
*  Created:  2010-06-08
*
*  单条微博的评论列表
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/

class show {

	function show()
	{
	}

	/**
	 * 某人的单条微博的评论列表
	 *
	 *
	 */
	function default_action()
	{
		$id = V('g:id');

		if (empty($id)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'location' => 'index', 'timeout' => 5, 'msg'=> '抱歉，您访问的页面不存在或已经删除了'));
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//调用单条微博的详细信息接口
		$mblog_info = $wbApi->getStatuseShow($id);

		//过滤过敏微博
		$mblog_info = APP::F('weibo_filter', $mblog_info, true);

		if (empty($mblog_info)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//获取个人资料
		$userinfo = $wbApi->getUserShow($mblog_info['user']['id']);;
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		$ids = array();
		$ids[] = $mblog_info['id'];
		if ($mblog_info['retweeted_status']['id']) {
			$ids[] = $mblog_info['retweeted_status']['id'];
		}

		//批量获取指定微博的转发数和评论数
		$batch_counts = APP::F('weibo_counts', $ids);

		//获取ta的粉丝列表前9条数据
		$followers = $wbApi->getFollowers($userinfo['id'], null, null, -1, 9);

		TPL::assign('id', $id);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('mblog_info', $mblog_info);
		TPL::assign('uid', $storage->getInfo('sina_uid'));
		TPL::assign('followers', $followers['users']);
		TPL::assign('batch_counts', $batch_counts);
		TPL::display('mblog_detail');
	}
}
?>
