<?php

class setting {

	var $uInfo	= false;
	var $cfg	= array();
	var $avatarTemp = '';
	var $avatarPath = '';

	function setting(){
		$user = APP::N('clientUser');
		$this->uInfo	= $user->getInfo();

		$this->avatarPath	= 'avatarTemp/'.date("Y_m/d/H");
		$this->avatarTemp	= W_BASE_URL.P_URL_UPLOAD.'/'.$this->avatarPath;

		$this->cfg		= array(
			'upload_path'	=> $this->avatarPath,
			'allowed_types' => 'jpg|gif|jpeg|png',
			'max_size'	=> 5*1024*1024);
	}

	/// 默认 ACTION
	function default_action(){
		$this->profile();
	}

	/// 个人资料编辑
	function profile(){
		$wbApi = APP::N('weibo');
		$uInfo = $wbApi->getUserShow($this->uInfo['sina_uid'], null, null, false);
		if ( !is_array($uInfo) || !empty($uInfo['error_code']) ) {
			// $uInfo['error']
			echo '无法获取用户信息';exit;
		}

		//print_r(V('s'));exit;
		$uData = array();
		$uData['edit_tab']	= V('g:edit', 'info');
		$uData['avatar']	= APP::F('profile_image_url', $uInfo['profile_image_url'], 'profile');
		$uData['sina_uid']	= $uInfo['id'];
		$uData['nick']		= $uInfo['screen_name'];
		$uData['gender']	= $uInfo['gender'];
		$uData['province']	= $uInfo['province'];
		$uData['city']		= $uInfo['city'];
		$uData['description']	= $uInfo['description'];
		$uData['_uploadPicApi']	= urlencode(URL('setting.upload'));
		$uData['_savePicApi']	= urlencode(URL('setting.saveAvatar'));
		//print_r($uData);exit;
		TPL::assign('U', $uData);
		TPL::display('userinfo');
	}
	/// 保存个人资料
	function saveProfile(){
		$p['name']		= trim(V('p:nick'));
		$p['gender']	= trim(V('p:gender'));
		$p['province']	= trim(V('p:province'));
		$p['city']		= trim(V('p:city'));
		$p['description'] = trim(V('p:description'));

		if (V('p:_debug')) {print_r($p);}

		if (empty($p['name'])) 		{ APP::ajaxRst(false, 40004);exit;}
		if (empty($p['gender'])) 	{ APP::ajaxRst(false, 40005);exit;}
		if (!is_numeric($p['province'])) 	{ APP::ajaxRst(false, 40006);exit;}
		if (!empty($p['city']) && !is_numeric($p['city'])) 		{ APP::ajaxRst(false, 40007);exit;}


		// 敏感词检测
		$kwChk = APP::F('filter', $p['name'], 'nick');
		if (  $kwChk !== true ) {
			APP::ajaxRst(false, 40008, $kwChk);exit;
		}
		// 敏感词检测
		if (!empty($p['description'])){
			$kwChk = APP::F('filter', $p['description'], 'nick');
			if (  $kwChk !== true ) {
				APP::ajaxRst(false, 40009, $kwChk);exit;
			}
		}

		$wbApi = APP::N('weibo');
		$rst = $wbApi->updateProfile($p, false);
		$this->_chkApiRst($rst, 40001);

		$sess	= APP::N('clientUser');
		$sess->setInfo('screen_name', $p['name']);
		$sess->setInfo('description', $p['description']);

		APP::ajaxRst(true);exit;
	}

	/// 图像更改步骤1
	function upload() {

		//if (1) {print_r(V('p'));print_r(V('f'));}
		$this->_chkUid();

		$r = array('w'=>180,'h'=>180, 'url'=>'');
		$uploadObj = APP::N('upload',$this->cfg);
		$rst = $uploadObj->do_upload('avatarFile');
		$rst_arr = explode("\r\n", $rst);
		if ($rst_arr[0] == '-1') {
			APP::ajaxRst(false, 40002, $rst_arr[1]); exit;
		}else{
			$pImg = $uploadObj->get_path().$rst_arr[0];
			if ( !$this->_chkImgType($pImg) ){
				APP::ajaxRst(false, 40010, 'Bad img type!'); exit;
			}

			$imgObj = APP::N('images');
			$imgObj->loadFile($pImg);
			$imgInfo = $imgObj->getImgInfo();
			if ($imgInfo['width'] > 1024 || $imgInfo['height'] > 1024 ) {
				$imgObj->resize(1024,1024,true);
				$imgObj->save($pImg);
			}
			/**/
			$r['url'] = $this->avatarTemp.'/'.$rst_arr[0];
			APP::ajaxRst($r); exit;
		}
	}
	function _chkImgType($p){
		$ext	= strtolower(end(explode('.', $p)));
		$imtT	= getimagesize($p);
		$rExt	= trim(strtolower(end(explode('/',$imtT['mime'] ))));

		if ($rExt=='jpeg') $rExt='jpg';
		if ($ext=='jpeg')  $ext='jpg';
		return $rExt === $ext;
	}
	/// 图像保存 更新到微博
	function saveAvatar(){
		$this->_chkUid();
		$imgData = V('p:uploadField');
		$avatarFile = P_VAR_UPLOAD.'/'.$this->avatarPath.'/avatar_tmp_'.$this->uInfo['sina_uid'].'.jpg';
		IO::write($avatarFile, base64_decode($imgData));

		$wbApi = APP::N('weibo');
		$rst = $wbApi->updateProfileImage($avatarFile, false);
		$this->_chkApiRst($rst, 40050);
		APP::ajaxRst(true);exit;
	}

	/// 用户ID检验
	function _chkUid(){
		if ( !V(WB_FLASH_PHPSESSUID) || V(WB_FLASH_PHPSESSUID) != $this->uInfo['sina_uid'] ){
			APP::ajaxRst(false, 40003, 'UID confirm error ');exit;
		}
	}
	/// 检查API结果 如果有错误直接退出 , 并输出错误代码
	function _chkApiRst($v, $err_code=0){
		if (!is_array($v) || !empty($v['error_code']) || !empty($v['error'])) {
			APP::ajaxRst(false, $err_code, $v['error_code'].":".$v['error']);
			exit;
		}
	}

	//个人显示设置
	function saveShowSetting()
	{
		$newfeed = (int)V('p:newfeed');
		$newmsg = (int)V('p:newmsg');
		$feedtotal = (int)V('p:feedtotal');
		$commenttotal = (int)V('p:commenttotal');

		$json = array();
		$json['user_newfeed'] = $newfeed;
		$json['user_newmsg'] = $newmsg;
		$json['user_page_wb'] = $feedtotal;
		$json['user_page_comment'] = $commenttotal;
		$values = json_encode($json);

		$userConfig = APP::N('userConfig');
		$ret = $userConfig->set($values);
		if ($ret === false) {
			APP::ajaxRst(false, 60003, 'failed to save config');
			exit;
		}
		APP::ajaxRst('0', 0);
		exit;
	}
}
?>