<?php
/**************************************************
*  Created:  2010-06-08
*
*  我的首页
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/

class index
{

	function index()
	{
	}

	/**
	 * 首页
	 *
	 *
	 */
	function default_action()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//最新的一条微博id
		$endmid = V('g:endmid');

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//页码数
		$page = max(V('g:page'), 1);

		//echo '<pre>';
		//var_dump($_SESSION);
		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit * 2;
		//调用获取当前用户所关注用户的最新微博信息api
		if ($page == 1) {
			$list = $wbApi->getFriendsTimeline($count, $page);
			if (!empty($list)) {
				$endmid = $list[0]['id'];
			}
		} else {
			$list = $wbApi->getFriendsTimeline($count, null, $start_pos, $end_pos);
		}
		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);

		//获取总条数
		$total_count = count($list);
		if ($total_count > $limit) {
			//取LIMIT+1条数据
			$list = array_slice($list, 0, $limit+1);
			//弹出最后一条微博，只显示LIMIT条微博
			$end_pos_array = array_pop($list);
			$end_pos = $end_pos_array['id'];
		} else {
			$end_pos_array = end($list);
			$end_pos = $end_pos_array['id'];
		}

		$start_pos = $list[0]['id'];
		$makePage = $pager->pagehtml(array('endmid' => $endmid, 'start_pos' => $start_pos, 'end_pos' => $end_pos, 'return_index' => true), $total_count, $limit);

		if (!empty($list)) {
			/*
			$ids = array();
			foreach ($list as $key => $var) {
				$ids[] = $var['id'];
				//如果存在转发微博
				if ($var['retweeted_status']) {
					$ids[] = $var['retweeted_status']['id'];
				}
			}

			//批量获取指定微博的转发数和评论数
			$batch_counts = APP::F('weibo_counts', $ids);
			*/
		} else {
			//如果微博为空，显示初始页，获取人气排行榜Top8
			$db = APP :: ADP('db');
			$toplist = $db->query('SELECT *FROM ' . $db->getTable(T_FOLLOWERS_COUNT) . ' WHERE uid NOT IN(SELECT uid FROM ' .$db->getTable(T_DISABLED_FOLLOWERS). ') ORDER BY `followers_count` DESC LIMIT 8');
		}


		$sinaid = $storage->getInfo('sina_uid');

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($sinaid);

		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		// 定时加载最新"关注"
		$file = P_VAR_LOCK . '/' . CRON_LOCK_FILE_PREFIX . 'follow_count';
		$flag = 1;
		if (file_exists($file)) {
			$rs = file_get_contents($file);
			if (!empty($rs)) {
				$rs = explode('|', $rs);
				if ($rs[0] + 1800 > time()) {
					$flag = 0;
				}
			}
		}
		TPL::assign('cron_follow_count', $flag);

		TPL::assign('uid', $sinaid);
		TPL::assign('list', $list);
		TPL::assign('toplist', $toplist);
		TPL::assign('userinfo', $userinfo);
//		TPL::assign('batch_counts', $batch_counts);
		TPL::assign('endmid', $endmid);
		TPL::assign('makePage', $makePage);
		TPL::assign('page', $page);
		TPL::display('index');
	}

	function demo()
	{
		$wb = APP::N('weibo');

		$list = $wb->getFriendsTimeline();

		$storage = APP::N('clientUser');

		$sinaid = $storage->getInfo('sina_uid');

		TPL::assign('uid', $sinaid);
		TPL::assign('list', $list);
		TPL::display('index_demo');
	}


	/**
	 * @提到我的
	 *
	 *
	 */
	function atme()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//页码数
		$page = max(V('g:page'), 1);

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit * 2;

		//调用获取@当前用户的微博列表api
		if ($page == 1) {
			$list = $wbApi->getMentions($count, $page);
			//清零
			$wbApi->reset_count(2, false);

			//实例化计数器
		//	$counter = APP::N('counter');

		//	$last_id = $list[0]['id'];
		//	//清零
		//	if (empty($last_id)) {
		//		$last_id = -1;
		//	}
		//	$counter->zero($storage->getInfo('sina_uid'), 'mentions', $last_id);
		} else {
			$list = $wbApi->getMentions($count, null, $start_pos, $end_pos);
		}


		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);
		/*
		if ($list) {
			$ids = array();
			foreach ($list as $key => $var) {
				$ids[] = $var['id'];
				//如果存在转发微博
				if ($var['retweeted_status']) {
					$ids[] = $var['retweeted_status']['id'];
				}
			}
			//批量获取指定微博的转发数和评论数
			$batch_counts = APP::F('weibo_counts', $ids);
		}
		*/
		//获取总条数
		$total_count = count($list);
		if ($total_count > $limit) {
			//取LIMIT+1条数据
			$list = array_slice($list, 0, $limit+1);
			$end_pos_array = array_pop($list);
			$end_pos = $end_pos_array['id'];
		} else {
			$end_pos_array = end($list);
			$end_pos = $end_pos_array['id'];
		}

		$start_pos = $list[0]['id'];
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		$sinaid = $storage->getInfo('sina_uid');
		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($sinaid);
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);

		if (empty($userinfo)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		TPL::assign('list', $list);
		TPL::assign('uid', $sinaid);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
//		TPL::assign('batch_counts', $batch_counts);
		TPL::assign('tab', 'atme');
		TPL::display('atme');
	}


	/**
	 *  收到的评论
	 *
	 *
	 */
	function comments()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//页码数
		$page = max(V('g:page'), 1);

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_comment') ? V('-:userConfig/user_page_comment') : (V('-:sysConfig/each_page_comment') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_comment'));
		$count = $limit * 3;

		//获取当前用户发送及收到的评论列表
		if ($page == 1) {
			$list = $wbApi->getCommentsToMe(null, $count, $page);
			//清零
			$wbApi->reset_count(1, false);

			//实例化计数器
			//$counter = APP::N('counter');
			//$last_id = $list[0]['id'];
			//清零
			//if (empty($last_id)) {
			//	$last_id = -1;
			//}
			//$counter->zero($storage->getInfo('sina_uid'), 'comments', $last_id);
		} else {
			$list = $wbApi->getCommentsToMe(null, $count, null, $start_pos, $end_pos);
		}

		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);
		//获取总条数
		$total_count = count($list);
		if ($total_count > $limit) {
			//取LIMIT+1条数据
			$list = array_slice($list, 0, $limit+1);
			$end_pos_array = array_pop($list);
			$end_pos = $end_pos_array['id'];
		} else {
			$end_pos_array = end($list);
			$end_pos = $end_pos_array['id'];
		}

		$start_pos = $list[0]['id'];
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		$uid = $storage->getInfo('sina_uid');
		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($uid);
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		TPL::assign('list', $list);
		TPL::assign('total', $total_count);
		TPL::assign('uid', $uid);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::display('comments');
	}


	/**
	 *  发出的评论
	 *
	 *
	 */
	function commentsend()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//页码数
		$page = max(V('g:page'), 1);

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_comment') ? V('-:userConfig/user_page_comment') : (V('-:sysConfig/each_page_comment') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_comment'));
		$count = $limit * 2;

		//获取当前用户收到的评论列表
		if ($page == 1) {
			$list = $wbApi->getCommentsByMe($count, $page);
		} else {
			$list = $wbApi->getCommentsByMe($count, null, $start_pos, $end_pos);
		}

//		echo '<pre>';
//		print_r($list);
//		echo '</pre>';
		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);

		//获取总条数
		$total_count = count($list);
		if ($total_count > $limit) {
			//取LIMIT条数据
			$list = array_slice($list, 0, $limit+1);
			$end_pos_array = array_pop($list);
			$end_pos = $end_pos_array['id'];
		} else {
			$end_pos_array = end($list);
			$end_pos = $end_pos_array['id'];
		}
		$start_pos = $list[0]['id'];
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		$sinaid = $storage->getInfo('sina_uid');
		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($sinaid);
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		TPL::assign('list', $list);
		TPL::assign('uid', $sinaid);
		TPL::assign('total', $total_count);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::display('commentsend');
	}


	/**
	 * 我的私信
	 *
	 *
	 */
	function messages()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//页码数
		$page = max(V('g:page'), 1);

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//设置每页显示微博数
		$limit = WB_API_LIMIT;

		if ($page == 1) {
			//调用获取当前用户收到的最新私信列表 api
			$re_list = $wbApi->getDirectMessages($limit, $page);
			//清零
			$wbApi->reset_count(3, false);

			//实例化计数器
		//	$counter = APP::N('counter');

		//	$last_id = $re_list[0]['id'];
		//	//清零
		//	if (empty($last_id)) {
		//		$last_id = -1;
		//	}
		//	$counter->zero($storage->getInfo('sina_uid'), 'dm', $last_id);

			//调用获取当前用户发送的最新私信列表 api
			$send_list = $wbApi->getSentDirectMessages($limit, $page);
		} else {
			//调用获取当前用户收到的最新私信列表 api
			$re_list = $wbApi->getDirectMessages($limit, null, $start_pos, $end_pos);
			//调用获取当前用户发送的最新私信列表 api
			$send_list = $wbApi->getSentDirectMessages($limit, null, $start_pos, $end_pos);
		}
		$re_list = empty($re_list) ? $re_list = array() : $re_list;
		$send_list = empty($send_list) ? $send_list = array() : $send_list;
		$list = array_merge($re_list, $send_list);
		if ($list) {
			$compare = create_function('$a, $b', 'return strcasecmp(strtotime($b["created_at"]), strtotime($a["created_at"]));');
			//根据时间排序
			usort($list, $compare);

			//获取总条数
			$total_count = count($list);
			if ($total_count > $limit) {
				//取LIMIT条数据
				$list = array_slice($list, 0, $limit+1);
				$end_pos_array = array_pop($list);
				$end_pos = $end_pos_array['id'];
			} else {
				$end_pos_array = end($list);
				$end_pos = $end_pos_array['id'];
			}
			$start_pos = $list[0]['id'];
			$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);
		}

		$sinaid = $storage->getInfo('sina_uid');
		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($sinaid);
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		TPL::assign('list', $list);
		TPL::assign('uid', $sinaid);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::display('messages');
	}


	/**
	 * 我的收藏
	 *
	 *
	 */
	function favorites()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//页码数
		$page = max(V('g:page'), 1);

		$p = V('g:p');

		//调用获取当前用户的收藏列表api
		$list = $wbApi->getFavorites($page);
		if (empty($list) && $page > 1) {
			APP::redirect(URL('index.favorites', 'p=end'), 3);
			exit;
		}

		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);
		$total = count($list);
		/*
		if ($list) {
			$ids = array();
			foreach ($list as $key => $var) {
				$ids[] = $var['id'];
				//如果存在转发微博
				if ($var['retweeted_status']) {
					$ids[] = $var['retweeted_status']['id'];
				}
			}
			//批量获取指定微博的转发数和评论数
			$batch_counts = APP::F('weibo_counts', $ids);
		}
		*/

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($storage->getInfo('sina_uid'));
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		if ($userinfo['favourites_count'] == 0 && count($list) != 0) {
			$userinfo['favourites_count'] = count($list);
		}

		//收藏接口固定显示20条记录
		$limit = 20;
		//总页码数
		$pagetotal = ceil($userinfo['favourites_count'] / $limit);
		if ($pagetotal > $page) {
			$total = $limit + 1;
		} elseif ($total == $limit && $p != 'end') {
			$total = $limit + 1;
		} elseif ($p == 'end') {
			$total = $limit - 1;
		}

		$makePage = $pager->pagehtml('', $total, $limit);

		$sinaid = $storage->getInfo('sina_uid');

		TPL::assign('uid', $sinaid);
		TPL::assign('list', $list);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::assign('total', $userinfo['favourites_count']);
		TPL::assign('tab', 'favs');
//		TPL::assign('batch_counts', $batch_counts);
		TPL::display('favs');
	}


	/**
	 * 我的关注列表
	 *
	 *
	 */
	function follow()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//光标开始位置
		$start_pos = V('g:start_pos');
		//下一个光标开始位置
		$end_pos = V('g:end_pos');

		//页码数
		$page = max(V('g:page'), 1);

		//标示是否有下一页
		$p = V('g:p');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit;

		if (empty($end_pos) && empty($start_pos)) {
			$cursor = -1;
		} elseif (!empty($start_pos)) {
			$cursor = $start_pos;
		} elseif (!empty($end_pos)) {
			$cursor = $end_pos;
		}

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($storage->getInfo('sina_uid'));
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//调用获取当前用户关注对象列表及最新一条微博信息api
		$list = $wbApi->getFriends(null, null, null, $cursor, $count);

		//过滤过敏微博
		$list['users'] = APP::F('user_filter', $list['users']);
		if (empty($list['users']) && $page > 1) {
			$page = $page - 1;
			$end_pos = $list['previous_cursor'] - $limit;
			APP::redirect(URL('index.follow', 'page='.$page.'&p=end&end_pos='.$end_pos), 3);
			exit;
		}

		//获取总条数
		$total_count = count($list['users']);
		if ($total_count > $limit) {
			//只取LIMIT条数据
			$list['users'] = array_slice($list['users'], 0, $limit);
		}

		//如果next_cursor为零，则没有下一页
		if ($list['next_cursor'] == 0 || $p == 'end') {
			$total_count = 0;
		} elseif ($list['next_cursor'] > 0 && $userinfo['friends_count'] >= $limit) {
			$total_count = $limit + 1;
		}

		$start_pos = $list['previous_cursor'];
		$end_pos = $list['next_cursor'];
		if ($start_pos > 0) {
			$start_pos = $start_pos - $count;
		}
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		//获取当前用户的粉丝列表id
		$fids = $wbApi->getFollowerIds($storage->getInfo('sina_uid'), null, null, -1, 5000);

		//获取人气排行榜Top10
		$db = APP :: ADP('db');
		$toplist = $db->query('SELECT *FROM ' . $db->getTable(T_FOLLOWERS_COUNT) . ' WHERE uid NOT IN(SELECT uid FROM ' .$db->getTable(T_DISABLED_FOLLOWERS). ') ORDER BY `followers_count` DESC LIMIT 10');

		TPL::assign('list', $list);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::assign('fids', $fids['ids']);
		TPL::assign('top', 'true');
		TPL::assign('toplist', $toplist);
		TPL::assign('uid', $storage->getInfo('sina_uid'));
		TPL::assign('relationship', '1');
		TPL::display('follow');
	}


	/**
	 * 我的粉丝列表
	 *
	 *
	 */
	function fans()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化分页pager
		$pager = APP::N('pager');

		//光标开始位置
		$start_pos = V('g:start_pos');
		//下一个光标开始位置
		$end_pos = V('g:end_pos');

		//页码数
		$page = max(V('g:page'), 1);

		//标示是否有下一页
		$p = V('g:p');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit;

		if (empty($end_pos) && empty($start_pos)) {
			$cursor = -1;
		} elseif (!empty($start_pos)) {
			$cursor = $start_pos;
		} elseif (!empty($end_pos)) {
			$cursor = $end_pos;
		}

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($storage->getInfo('sina_uid'));
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//调用获取当前用户粉丝列表及最新一条微博信息api
		$list = $wbApi->getFollowers(null, null, null, $cursor, $count);
		if ($page == 1) {
			//清零
			$wbApi->reset_count(4, false);

			//实例化计数器
		//	$counter = APP::N('counter');

		//	$last_id = $list['users'][0]['id'];
		//	//清零
		//	if (empty($last_id)) {
		//		$last_id = -1;
		//	}
		//	$counter->zero($storage->getInfo('sina_uid'), 'followers', $last_id);
		}

		//过滤过敏微博
		$list['users'] = APP::F('user_filter', $list['users']);
		if (empty($list['users']) && $page > 1) {
			$page = $page - 1;
			$end_pos = $list['previous_cursor'] - $limit;
			APP::redirect(URL('index.fans', 'page='.$page.'&p=end&end_pos='.$end_pos), 3);
			exit;
		}

		//获取总条数
		$total_count = count($list['users']);
		if ($total_count > $limit) {
			//只取20条数据
			$list['users'] = array_slice($list['users'], 0, $limit);
		}

		//如果next_cursor为零，则没有下一页
		if ($list['next_cursor'] == 0 || $p == 'end') {
			$total_count = 0;
		} elseif ($list['next_cursor'] > 0 && $userinfo['followers_count'] >= $limit) {
			$total_count = $limit + 1;
		}

		$start_pos = $list['previous_cursor'];
		$end_pos = $list['next_cursor'];
		if ($start_pos > 0) {
			$start_pos = $start_pos - $count;
		}
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		//获取当前用户的关注列表id
		$fids = $wbApi->getFriendIds($storage->getInfo('sina_uid'), null, null, -1, 5000);

		//获取人气排行榜Top10
		$db = APP :: ADP('db');
		$toplist = $db->query('SELECT *FROM ' . $db->getTable(T_FOLLOWERS_COUNT) . ' WHERE uid NOT IN(SELECT uid FROM ' .$db->getTable(T_DISABLED_FOLLOWERS). ') ORDER BY `followers_count` DESC LIMIT 10');

		TPL::assign('list', $list);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('makePage', $makePage);
		TPL::assign('fids', $fids['ids']);
		TPL::assign('top', 'true');
		TPL::assign('toplist', $toplist);
		TPL::assign('uid', $storage->getInfo('sina_uid'));
		TPL::assign('relationship', '1');
		TPL::display('fans');
	}


	/**
	 * 我的微博列表
	 *
	 *
	 */
	function profile()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//页码数
		$page = max(V('g:page'), 1);

		//最新微博id
		$start_pos = V('g:start_pos');
		//最后微博id
		$end_pos = V('g:end_pos');

		//设置每页显示微博数
		$limit = V('-:userConfig/user_page_wb') ? V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
		$count = $limit * 2;

		//实例化分页pager
		$pager = APP::N('pager');

		//调用获取用户发布的微博信息列表api
		if ($page == 1) {
			$list = $wbApi->getUserTimeline(null, null, null, null, null, $count, $page);
		} else {
			$list = $wbApi->getUserTimeline(null, null, null, $start_pos, $end_pos, $count);
		}

		//过滤过敏微博
		$list = APP::F('weibo_filter', $list);
		//获取总条数
		$total_count = count($list);
		if ($total_count > $limit) {
			//取LIMIT条数据
			$list = array_slice($list, 0, $limit+1);
			$end_pos_array = array_pop($list);
			$end_pos = $end_pos_array['id'];
		} else {
			$end_pos_array = end($list);
			$end_pos = $end_pos_array['id'];
		}
		/*
		foreach ($list as $key => $var) {
			$ids[] = $var['id'];
			//如果存在转发微博
			if ($var['retweeted_status']) {
				$ids[] = $var['retweeted_status']['id'];
			}
		}
		//批量获取指定微博的转发数和评论数
		$batch_counts = APP::F('weibo_counts', $ids);
		*/
		$start_pos = $list[0]['id'];
		$makePage = $pager->pagehtml(array('start_pos' => $start_pos, 'end_pos' => $end_pos), $total_count, $limit);

		//调用微博个人资料接口
		$userinfo = $wbApi->getUserShow($storage->getInfo('sina_uid'));
		//过滤过敏用户
		$userinfo = APP::F('user_filter', $userinfo, true);
		if (empty($userinfo)) {
			//提示访问的页面不存在，跳转到首页
			APP::tips(array('tpl' => 'error', 'msg'=> '抱歉，您访问的页面已被禁止浏览。'));
		}

		//获取人气排行榜Top10
		$db = APP :: ADP('db');
		$toplist = $db->query('SELECT *FROM ' . $db->getTable(T_FOLLOWERS_COUNT) . ' WHERE uid NOT IN(SELECT uid FROM ' .$db->getTable(T_DISABLED_FOLLOWERS). ') ORDER BY `followers_count` DESC LIMIT 10');

		$sinaid = $storage->getInfo('sina_uid');

		TPL::assign('title', '我的微博');
		TPL::assign('list', $list);
		TPL::assign('uid', $sinaid);
		TPL::assign('userinfo', $userinfo);
		TPL::assign('toplist', $toplist);
		TPL::assign('top', 'true');
		TPL::assign('makePage', $makePage);
//		TPL::assign('batch_counts', $batch_counts);
		TPL::assign('tab', 'profile');
		TPL::display('profile');
	}
}
