<?php
include('action.abs.php');
class today_topic extends action {

	var $db = null;

	function today_topic() {
		parent :: action();
		$this->db = APP :: ADP('db');
		$this->db->setTable(T_TODAY_TOPIC);
	}

	function add() {
		if ($this->_isPost()) {
			$topic = V('p:topic');
			$date = V('p:start_date');
			$time = V('p:start_time');
			if (!$topic) {
				$this->_error('请填写话题内容', array('add'));
			}
			if ($date && $time) {
					$date = explode('-', $date);
					$time = explode(':', $time);
					$start_time = @mktime($time[0], $time[1], 0, $date[1], $date[2], $date[0]);
					if (!$start_time) {
						$start_time = time();
					}
			} else {
				$start_time = time();
			}
			$data = array(
						'topic' => $topic,
						'start_time' => $start_time,
						'operator' => $this->_getUid(),
						'add_time' => time()
					);
			$this->db->save($data);
			$this->_succ('已成功保存', array('topicList'));
		}
		$this->_display('today_topic/today_topic_add');
	}

	function topicList() {
		$page = V('g:page', 1);
		$each = V('g:each', 20);
		$keyword = V('g:keyword', '');
		$offset = ($page -1) * $each;

		$select_count = 'SELECT COUNT(*) FROM ' . $this->db->getTable(T_TODAY_TOPIC) ;
		$count = $this->db->getOne($select_count);
		$pager = APP :: N('pager');
		$page_param = array('currentPage'=> $page, 'pageSize' => $each, 'recordCount' => $count, 'linkNumber' => 10);
		$pager->setParam($page_param);
		TPL :: assign('pager', $pager->makePage());

		$sql = 'SELECT a.*,b.name FROM ' . $this->db->getTable(T_TODAY_TOPIC) . ' AS a LEFT JOIN ' . $this->db->getTable(T_ADMIN_USER) . ' AS b ON a.operator=b.id ORDER BY a.id DESC LIMIT ' . $offset . ',' . $each;
		$rs = $this->db->query($sql);
		TPL :: assign('list', $rs);
		$this->_display('today_topic/today_topic_list');
	}

	function edit() {
		if ($this->_isPost()) {
			$id = V('p:id');
			$topic = V('p:topic');
			$date = V('p:start_date');
			$time = V('p:start_time');

			if (!$topic) {
				$this->_error('请填写话题内容', URL('admin/today_topic.edit', 'id=' . $id));
			}
			if ($date && $time) {
					$date = explode('-', $date);
					$time = explode(':', $time);
					$start_time = @mktime($time[0], $time[1], 0, $date[1], $date[2], $date[0]);
					if (!$start_time) {
						$start_time = time();
					}
			} else {
				$start_time = time();
			}
			$data = array(
						'topic' => $topic,
						'start_time' => $start_time,
						'operator' => $this->_getUid(),
						'add_time' => time()
					);

			$this->db->save($data, $id);
			$this->_succ('已成功保存', array('topicList'));
		}
		$id = V('g:id');
		$rs = $this->db->get($id);
		TPL :: assign('info', $rs);
		$this->_display('today_topic/today_topic_add');
	}

	function delete() {
		$id = V('r:id');
		if (is_string($id)) {
			$id = trim($id, ', ');
			if (strpos(',', $id)) {
				$id = explode(',', $id);
			}
		}
		$select_count = 'SELECT COUNT(*) FROM ' . $this->db->getTable() ;
		$count = $this->db->getOne($select_count);
		if (count($id) >= $count) {
			$this->_error('最少保留一个话题', array('topicList'));
		}
		$this->db->delete($id);
		//$this->_succ('已经成功删除', array('topicList'));
		$this->_redirect('topicList');
	}

}
