<?php
include('action.abs.php');
class disabled_weibo extends action {
		function disabled_weibo() {
			parent :: action();
			$this->db = APP :: ADP('db');
			$this->db->setTable(T_DISABLED_WEIBO);
		}

		function weiboList() {
				$page = (int)V('g:page', 1);
				$each = (int)V('g:each', 15);
				$offset = ($page -1) * $each;
				$keyword = $this->db->escape(V('g:keyword', ''));

				$select_count = 'SELECT COUNT(*) FROM ' . $this->db->getTable(T_DISABLED_WEIBO) ;
				$count = $this->db->getOne($select_count);

				$cache = CACHE :: get(CACHE_DISABLED_WEIBO);
				if (!is_array($cache) || sizeof($cache) != $count) {
					$this->_synchronousMemcache();
				}

				$pager = APP :: N('pager');
				$page_param = array('currentPage'=> $page, 'pageSize' => $each, 'recordCount' => $count, 'linkNumber' => 10);
				$pager->setParam($page_param);
				TPL :: assign('pager', $pager->makePage());
				$where = '';
				if ($keyword) {
					$where = ' WHERE `text` LIKE "%' . $keyword . '%" OR `user` LIKE "%' . $keyword . '%"';
				}
				
				$sql = 'SELECT a.*,b.name FROM ' . $this->db->getTable(T_DISABLED_WEIBO) . ' AS a LEFT JOIN ' . $this->db->getTable(T_ADMIN_USER) . ' AS b ON a.operator=b.id' . $where . ' ORDER BY `id` DESC LIMIT ' . $offset . ',' . $each;
				$rs = $this->db->query($sql);
				TPL :: assign('list', $rs);

				TPL :: assign('states', array('0'=>'正常','1'=>'暂停使用'));
				TPL :: display('admin/weibo/disabled_list', '', 0, false);
		}

		function cancel() {
			$id = V('r:id');
			if (is_array($id)) {
				$ids = implode(',', $id);
			} else {
				$ids = $this->db->escape($id);
			}
			$sql = 'SELECT wid FROM ' . $this->db->getTable() . ' WHERE id IN(' .$ids. ')';
			$data = $this->db->query($sql);
			$this->db->getError();
			$rs = $this->db->delete($id);
			if ($rs !== false && $rs > 0) {
				$cache = CACHE::get(CACHE_DISABLED_WEIBO);
				if (!is_array($cache) || empty($cache)) {
					$this->_synchronousMemcache();
				} else {
					$size = sizeof($cache);
					if (!is_array($id)) {
						$id = trim($id, ', ');
						$id = explode(',', $id);
					}
					foreach ($data as $row) {
						unset($cache[$row['wid']]) ;
					}
					if (sizeof($cache) != $size) {
						CACHE :: set(CACHE_DISABLED_WEIBO, $cache);
					}
				}
			}
			$this->_redirect('weiboList');
		}

		function disable() {
			$values = array(
					$this->db->escape(V('p:wid')),
					$this->db->escape(V('p:text')),
					$this->db->escape(V('p:user')),
					$this->db->escape(V('p:uid')),
					$this->db->escape(V('p:created_at')),
					time(),
					$this->_getUid()
					);
			$values = '"' . implode('","', $values) . '"';
			$sql = 'INSERT IGNORE INTO ' . $this->db->getTable(T_DISABLED_WEIBO) . ' (`wid`,`text`,`user`,`uid`,`created_at`,`add_time`,`operator`) VALUES(' . $values . ')';
						
			$this->db->execute($sql);
			if ($err = $this->db->getError()) {
					exit( '{"state":"fail","info":"' . $err . '"}');
			}
			if ($this->db->getAffectedRows() > 0) {
				$cache = CACHE::get(CACHE_DISABLED_WEIBO);
				if (!is_array($cache) || empty($cache)) {
						$this->_synchronousMemcache();
				} else {
					$size = sizeof($cache);
					$cache[V('p:wid')] = '1';
					if (sizeof($cache) != $size) {
						CACHE :: set(CACHE_DISABLED_WEIBO, $cache);
					}
				}
			}
			echo '{"state":"succ"}';
		}

		function search() {
			$url = V('r:url');
			if ($url) {
				if (preg_match('!id(-|=)(\d+)!', $url, $match)) {
					$key = $match[2];
					//$key = '639989215';
					$wb = APP::N('weibo');
					$AdminUser = APP::N('adminUser', 'admin_id');
					$info = $AdminUser->getInfo();
					$wb->setToken($info['oauth_token'],$info['oauth_token_secret']);
					//$wb->setToken(WB_USER_OAUTH_TOKEN, WB_USER_OAUTH_TOKEN_SECRET);
					$data = $wb->getStatuseShow($key);
					if (!$data['error_code']) {
						TPL :: assign('info', $data);
					}
				}
			}
			TPL :: display('admin/weibo/search', '', 0, false);
		}
		
		function _synchronousMemcache() {
			$sql = 'SELECT `wid` FROM ' . $this->db->getTable();
				$data = $this->db->query($sql);
				$cache = array();
				while($r = array_pop($data)) {
					$cache[$r['wid']] = 1;
				}
				CACHE :: set(CACHE_DISABLED_WEIBO, $cache);
		}
}
