<?php
include('action.abs.php');
class disabled_comment extends action {
		function disabled_comment() {
			parent :: action();
			$this->db = APP :: ADP('db');
			$this->db->setTable(T_DISABLED_COMMENT);
		}

		function commentList() {
				$page = (int)V('g:page', 1);
				$each = (int)V('g:each', 15);
				$offset = ($page -1) * $each;
				$keyword = $this->db->escape(V('g:keyword', ''));

				$select_count = 'SELECT COUNT(*) FROM ' . $this->db->getTable() ;
				$count = $this->db->getOne($select_count);

				$cache = CACHE :: get(CACHE_DISABLED_COMMENT);
				if (!is_array($cache) || sizeof($cache) != $count) {
					$this->_synchronousMemcache();
				}

				$pager = APP :: N('pager');
				$page_param = array('currentPage'=> $page, 'pageSize' => $each, 'recordCount' => $count, 'linkNumber' => 10);
				$pager->setParam($page_param);
				TPL :: assign('pager', $pager->makePage());
				$where = '';
				if ($keyword) {
					$where = ' WHERE `text` LIKE "%' . $keyword . '%" OR `user` LIKE "%' . $keyword . '%"';
				}
				
				$sql = 'SELECT a.*,b.name FROM ' . $this->db->getTable() . ' AS a LEFT JOIN ' . $this->db->getTable(T_ADMIN_USER) . ' AS b ON a.operator=b.id' . $where . ' ORDER BY `id` DESC LIMIT ' . $offset . ',' . $each;
				$rs = $this->db->query($sql);
				TPL :: assign('list', $rs);

				TPL :: assign('states', array('0'=>'正常','1'=>'暂停使用'));
				TPL :: display('admin/comment/disabled_list', '', 0, false);
		}

		function cancel() {
			$id = V('r:id');
			if (is_array($id)) {
				$sid = implode($id);
			} else {
				$sid = $this->db->escape($id);
			}
			$sql = 'SELECT cid FROM ' . $this->db->getTable() . ' WHERE id IN(' . $sid . ')';
			$data = $this->db->query($sql);
			$rs = $this->db->delete($id);
			if ($rs !== false && $rs > 0) {
				$cache = CACHE::get(CACHE_DISABLED_COMMENT);
				if (!is_array($cache) || empty($cache)) {
						$this->_synchronousMemcache();
				} else {
					$size = sizeof($cache);
					if (!is_array($id)) {
						$id = trim($id, ', ');
						$id = explode(',', $id);
					}
					foreach ($data as $row) {
						unset($cache[$row['cid']]) ;
					}
					if (sizeof($cache) != $size) {
						CACHE :: set(CACHE_DISABLED_COMMENT, $cache);
					}
				}
			}
			//$this->_succ('已经成功恢复', array('commentList'));
			$this->_redirect('commentList');
		}

		function disable() {
			$values = array(
					$this->db->escape(V('p:cid')),
					$this->db->escape(V('p:text')),
					$this->db->escape(V('p:user')),
					$this->db->escape(V('p:uid')),
					$this->db->escape(V('p:created_at')),
					time(),
					$this->_getUid()
					);
			$values = '"' . implode('","', $values) . '"';
			$sql = 'INSERT IGNORE INTO ' . $this->db->getTable() . ' (`cid`,`text`,`user`,`uid`,`created_at`,`add_time`,`operator`) VALUES(' . $values . ')';
						
			$this->db->execute($sql);
			if ($err = $this->db->getError()) {
					exit( '{"state":"fail","info":"' . $err . '"}');
			}
			if ($this->db->getAffectedRows() > 0) {
				$cache = CACHE :: get(CACHE_DISABLED_COMMENT);
				if (!is_array($cache) || empty($cache)) {
						$this->_synchronousMemcache();
				} else {
					$size = sizeof($cache);
					$cache[V('p:cid')] = '1';
					if (sizeof($cache) > $size) {
						CACHE :: set(CACHE_DISABLED_COMMENT, $cache);
					}
				}
			}
			echo '{"state":"succ"}';
		}

		function search() {
			$url = V('r:url');
			if ($url) {
					preg_match('|[\d]+$|', $url, $match);
					$key = $match[0];
					//$key = '641596170';
					$wb = APP::N('weibo');
					$AdminUser = APP::N('adminUser', 'admin_id');
					$info = $AdminUser->getInfo();
					$wb->setToken($info['oauth_token'],$info['oauth_token_secret']);
					//$wb->setToken(WB_USER_OAUTH_TOKEN, WB_USER_OAUTH_TOKEN_SECRET);
					$data = $wb->getComments($key, 100);
					$disabled = CACHE :: get(CACHE_DISABLED_COMMENT);
					$new = array();
					foreach ($data as $row) {
						if (!isset($disabled[(string)$row['id']])) {
							$new[] = $row;
						}
					}
					if (!$data['error_code']) {
						TPL :: assign('info', $new);
					}
			}
			TPL :: display('admin/comment/search', '', 0, false);
		}

		/**
		 * 同步Memcache
		 */
		function _synchronousMemcache() {
				$sql = 'SELECT `cid` FROM ' . $this->db->getTable();
				$data = $this->db->query($sql);
				$cache = array();
				while($r = array_pop($data)) {
					$cache[$r['cid']] = 1;
				}
				CACHE :: set(CACHE_DISABLED_COMMENT, $cache);
		}
}
