<?php
/**************************************************
*  Created:  2010-06-08
*
*  后台Action基类
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author zhenquan <zhenquan@staff.sina.com.cn>
*
***************************************************/

class action {
		var $userInfo = array();
		function action() {
				$allow_no_login = array('login', 'authcode', 'tokenCallback');
				if (!$this->_isLogin() && !($this->_getModule() == 'admin' && in_array($this->_getAction() ,$allow_no_login ) )) {
					//APP :: redirect('admin/admin.login',2);
					exit('<script>window.top.location.href = "' . URL('admin/admin.login'). '"</script>');
				}
				if (!in_array($this->_getAction() , $allow_no_login)) {
					$this->userInfo = $this->_getUserInfo();
					
					// 如果session中没有token信息，则尝试去数据库读取，如果还没有，则跳到sina的用户授权
					if (!isset($this->userInfo['oauth_token'])) {
						$config = APP::N('sysConfig');
						$oauth_token = $config->get('oauth_token');
						$oauth_token_secret = $config->get('oauth_token_secret');
						
						//var_dump($oauth_token, $oauth_token_secret);
						//exit;
						if ($oauth_token && $oauth_token_secret) {
							$AdminUser = APP::N('adminUser', 'admin_id');
							$AdminUser->setInfo(array('oauth_token'=>$oauth_token, 'oauth_token_secret'=>$oauth_token_secret));
							$this->userInfo['oauth_token'] = $oauth_token;
							$this->userInfo['oauth_token_secret'] = $oauth_token_secret;
						} else {
							// 前端是否有登录
							$c = APP::N('clientUser');
							if ($c->isLogin()) {
								$keys = $c->getOAuthKey(true);
								$AdminUser = APP::N('adminUser', 'admin_id');
								$data = array('oauth_token'=>$keys['oauth_token'], 'oauth_token_secret'=>$keys['oauth_token_secret']);
								$AdminUser->setInfo($data);
								$this->userInfo['oauth_token'] = $keys['oauth_token'];
								$this->userInfo['oauth_token_secret'] = $keys['oauth_token_secret'];
								// 记录入数据库
								$config->set($data);
								$config->save();
							} else {
								$wb	= APP::N('weibo');
								$wb->setToken(null, null);
								$token = $wb->getRequestToken();
								$_SESSION['admin_oauth_keys1'] = $token;
								$url = W_BASE_HTTP . URL('admin/admin.tokenCallback', '', 'admin.php');
								$url = $wb->getAuthorizeURL($token, null, $url);
								header('Location:' . $url);exit;
							}
						}
					}
				}
				TPL :: assign($this->userInfo);
		}

		/**
		 * 用户是否已登录
		 */
		function _isLogin() {
			$AdminUser = APP::N('adminUser', 'admin_id');
			return $AdminUser->isLogin();
		}

		/**
		 * 得到当前登录用户ID
		 * @return int
		 */
		function _getUid() {
			return $this->userInfo['admin_id'];
		}

		/**
		 * 得到登录用户信息
		 */
		function _getUserInfo($key = '') {
			$AdminUser = APP::N('adminUser', 'admin_id');
			return $AdminUser->getInfo($key);
		}

		/**
		 * 得到控制器名称
		 * @return string
		 */
		function _getController() {
				$router_str = APP::getRuningRoute(true);
				return trim($router_str['path'], '/\\');
		}

		/**
		 * 得到模块名称
		 * @return string
		 */
		function _getModule() {
				$router_str = APP::getRuningRoute(true);
				return $router_str['class'];
		}

		/**
		 * 复到action名称
		 * @return string
		 */
		function _getAction() {
				$router_str = APP::getRuningRoute(true);
				return $router_str['function'];
		}

		/**
		 * 跳转
		 */
		function _redirect($action, $module = false, $controller = false) {
			if (!$action) {
				return;
			}
			$module = $module ? $module : $this->_getModule();
			$controller = $controller ? $controller : $this->_getController();
			$path = $controller . '/' . $module . '.' . $action;
			APP :: redirect($path, 2);
		}

		/**
		 * 当前请求方法
		 */
		function _requestMethod() {
			return $_SERVER['REQUEST_METHOD'];
		}

		/**
		 * 操作成功后跳转
		 * @param $msg String 要显示的消息
		 * @param $url String|Array 显示消息3秒后跳转的地址,如果该参数为数据则为路由方式,其中下标为0表示action,1表示module,2表示controller,
		 */
		function _succ($msg, $url = null) {
			if (is_array($url)) {
				if (empty($url[0])) {
					APP :: tips(array('msg'=> $msg, 'tpl' => 'error', 'baseskin'=>false));
				}
				$module = isset($url[1]) ? $url[1]: $this->_getModule();
				$controller = isset($url[2]) ? $url[2] : $this->_getController();
				$url = URL( $controller . '/' . $module . '.' . $url[0]);
			}
			if (!$url) {
				APP :: tips(array('msg'=> $msg, 'tpl' => 'error','baseskin'=>false));
			}
			APP :: tips(array('msg'=> $msg, 'tpl' => 'admin/success', 'timeout'=>3, 'location' => $url, 'baseskin'=>false));
		}

		/**
		 * 操作成功后跳转
		 * @param $msg String 要显示的消息
		 * @param $url String|Array 显示消息3秒后跳转的地址,如果该参数为数据则为路由方式,其中下标为0表示action,1表示module,2表示controller,
		 */
		function _error($msg, $url = null) {
			if (is_array($url)) {
				if (empty($url[0])) {
					APP :: tips(array('msg'=> $msg, 'tpl' => 'error', 'baseskin'=>false));
				}
				$module = isset($url[1]) ? $url[1]: $this->_getModule();
				$controller = isset($url[2]) ? $url[2] : $this->_getController();
				$url = URL( $controller . '/' . $module . '.' . $url[0]);
			}

			$param = array(
						'msg'=> $msg,
						'tpl' => 'admin/error',
						'baseskin'=>false
					);

			if ($url) {
				$param += array(
					'timeout'=>3,
					'location' => $url
				);
			}
			APP :: tips($param);
		}

		/**
		 * 当前请求是否为POST方法
		 */
		function _isPost() {
			if (strtolower($this->_requestMethod()) == 'post') {
				return true;
			}
			return false;
		}

		/**
		 * 当前请求是否为GET方法
		 *
		 */
		function _isGet() {
			if (strtolower($this->_requestMethod()) == 'get') {
				return true;
			}
			return false;
		}

		function _display($tpl) {
			TPL :: display('admin/' . $tpl, '', 0, false);
		}
}
