<?php
/**************************************************
*  Created:  2010-06-08
*
*  微博相关操作
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/

class action
{

	function action()
	{
	}

	/**
	 * 发微博以及发图片微博
	 *
	 *
	 */
	function update()
	{
		//发布的内容
		$text = trim(V('p:text'));
		//图片
		$pic = V('p:pic');

		if (empty($text)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		} elseif (strlen(iconv("utf-8", "gbk", $text)) > 280) {
			APP::ajaxRst(false, 20011, 'max_length');
			exit;
		} elseif (APP::F('filter', $text, 'content') !== true) {
			APP::ajaxRst(false, 20015, 'allowed');
			exit;
		}


		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		if (empty($pic)) {
			//调用发布微博api
			$result = $wbApi->update($text, false);
		} else {
			//调用发布图片微博api
			$pic = P_VAR_UPLOAD.'/pic/'.$pic;
			$result = $wbApi->upload($text, $pic, null, null, false);
		}

		//调用发布接口失败
		if ($result['error_code']) {
			//发布的微博内容重复
			if (strpos($result['error'], 'repeated')) {
				APP::ajaxRst(false, 20014, 'repeated');
				exit;
			}
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		//删除本地的图片
		if (file_exists($pic)) {
			@unlink($pic);
		}

		if ($result['retweeted_status']['id']) {
			$mblog_counts = $wbApi->getCounts($result['retweeted_status']['id'], false);
		}

		$json['data'] = array();
		$json['data']['id'] = (string)$result['id'];
		$json['data']['cr'] = $result['created_at'];
		$json['data']['f'] = $result['favorited'] == false ? 0 : 1;
		$json['data']['s'] = $result['source'];
		$json['data']['tx'] = $result['text'];
		$json['data']['tp'] = $result['thumbnail_pic'];
		$json['data']['mp'] = $result['bmiddle_pic'];
		$json['data']['op'] = $result['original_pic'];
		$json['data']['u'] = array();
		$json['data']['u']['id'] = (string)$result['user']['id'];
		$json['data']['u']['sn'] = $result['user']['screen_name'];
		$json['data']['u']['p'] = $result['user']['profile_image_url'];
		$json['data']['u']['v'] = $result['user']['verified'] == false ? 0 : 1;
		$json['data']['u']['sina_v'] = APP::F('filter', $result['user']['screen_name'], 'verify') == false ? 0 : 1;
		//转发微博内容
		if ( $result['retweeted_status']) {
			$json['data']['rt'] = array();
			$json['data']['rt']['id'] = (string)$result['retweeted_status']['id'];
			$json['data']['rt']['cr'] = $result['retweeted_status']['created_at'];
			$json['data']['rt']['f'] = $result['retweeted_status']['favorited'] == false ? 0 : 1;
			$json['data']['rt']['s'] = $result['retweeted_status']['source'];
			$json['data']['rt']['tx'] = $result['retweeted_status']['text'];
			$json['data']['rt']['tp'] = $result['retweeted_status']['thumbnail_pic'];
			$json['data']['rt']['mp'] = $result['retweeted_status']['bmiddle_pic'];
			$json['data']['rt']['op'] = $result['retweeted_status']['original_pic'];
			$json['data']['rt']['u'] = array();
			$json['data']['rt']['u']['id'] = (string)$result['retweeted_status']['user']['id'];
			$json['data']['rt']['u']['sn'] = $result['retweeted_status']['user']['screen_name'];
			$json['data']['rt']['u']['p'] = $result['retweeted_status']['user']['profile_image_url'];
			$json['data']['rt']['u']['v'] = $result['retweeted_status']['user']['verified'] == false ? 0 : 1;
			$json['data']['rt']['u']['sina_v'] = APP::F('filter', $result['retweeted_status']['user']['screen_name'], 'verify') == false ? 0 : 1;
		}
		$json['html'] = APP::F('mblog_html', $result);;
		APP::ajaxRst($json, 0);
		exit;
	}


	/**
	 * 上传图片并发布一条微博信息
	 *
	 *
	 */
//	function upload()
//	{
//		$text = V('p:text');
//		$pic = V('p:pic');
//
//		if (empty($text)) {
//			APP::ajaxRst(false, 20000, 'empty');
//			exit;
//		} elseif (strlen(iconv("utf-8", "gbk", $text)) > 280) {
//			APP::ajaxRst(false, 20000, 'max_length');
//			exit;
//		}
//
//		if (empty($pic)) {
//			die('{"retcode":"-3"}');
//		}
//
//		//实例化微博api
//		$wb = APP::N('weibo');
//		//调用发布微博api
//		$pic = P_VAR_UPLOAD.'/pic/'.$pic;
//		$result = $wb->upload($text, $pic);
//		die($result);
//		$json['retcode'] = '0';
//		$json['text'] = $result['text'];
//		die(json_encode($json));
//	}


	/**
	 * 上传图片
	 *
	 *
	 */
	function upload_pic()
	{
		$image_inst = APP::N('upload');
		$result = $image_inst->do_upload('pic');
		$callback = V('g:callback','');

		$errno = 0;
		$err = '';

		$result_array = explode("\r\n", $result);

		//header('Location: js/blank.html?rand='.rand(1,PHP_INT_MAX));

		$redirect = 'window.location="'.W_BASE_URL.'js/blank.html?rand='.rand(1,PHP_INT_MAX) . '"';

		if ($result_array[0] == '-1') {
			if ($result_array[1] == 'empty') {
				die("<script language=\"javascript\">$callback(".APP::ajaxRst(false, 20020, 'empty', true).");$redirect</script>");
			} elseif ($result_array[1] == 'max_size') {
				die("<script language=\"javascript\">$callback(".APP::ajaxRst(false, 20021, 'max_size', true).");$redirect</script>");
			} elseif ($result_array[1] == 'allowed_types') {
				die("<script language=\"javascript\">$callback(".APP::ajaxRst(false, 20022, 'allowed_types', true).");$redirect</script>");
			} elseif ($result_array[1] == 'upload') {
				die("<script language=\"javascript\">$callback(".APP::ajaxRst(false, 20023, 'upload', true).");$redirect</script>");
			} elseif ($result_array[1] == 'is_uploaded_file') {
				die("<script language=\"javascript\">$callback(".APP::ajaxRst(false, 20024, 'is_uploaded_file', true).");$redirect</script>");
			} else {
				die("<script language=\"javascript\">$callback(".APP::ajaxRst(false, 20023, 'upload', true).");$redirect</script>");
			}
		}

		$json = array();
		$json['msg'] = $result_array[0];
		die("<script language=\"javascript\">$callback(".APP::ajaxRst($json, 0, '', true).");$redirect</script>");
	}


	/**
	 * 删除微博
	 *
	 *
	 */
	function destroy()
	{
		//要删除微博的id
		$id = V('p:id');

		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		//调用删除微博api
		$result = $wbApi->destroy($id, false);

		//删除失败
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(array(1), 0);
		exit;
	}


	/**
	 * 转发微博
	 *
	 *
	 */
	function repost()
	{
		$id = V('p:id');
		$text = trim(V('p:text'));
		$rtids = V('p:rtids');

		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		if (!empty($text) && strlen(iconv("utf-8", "gbk", $text)) > 280) {
			APP::ajaxRst(false, 20011, 'max_length');
			exit;
		} elseif (APP::F('filter', $text, 'content') !== true) {
			APP::ajaxRst(false, 20015, 'allowed');
			exit;
		}


		//转发微博，默认微博内容为‘转发微博’
		$text = empty($text) ? '转发微博' : $text;

		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//调用转发微博api
		$result = $wbApi->repost($id, $text, false);
		//转发微博失败
		if ($result['error_code']) {
			if (strpos($result['error'], 'repeated')) {
				APP::ajaxRst(false, 20014, 'repeated');
				exit;
			}
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		//如果勾选了作为某人的评论，调用评论接口
		if (!empty($rtids)) {
			$add = true;
			$rtid_array = explode(',', $rtids);
			foreach ($rtid_array as $var) {
				$wbApi->comment($var, $text, null, false);
			}
		}

		//获取该微博的转发数和评论数
		$mblog_counts = $wbApi->getCounts($result['retweeted_status']['id'], false);

		$json['data'] = array();
		$json['data']['id'] = (string)$result['id'];
		$json['data']['cr'] = $result['created_at'];
		$json['data']['f'] = $result['favorited'] == false ? 0 : 1;
		$json['data']['s'] = $result['source'];
		$json['data']['tx'] = $result['text'];
		$json['data']['tp'] = $result['thumbnail_pic'];
		$json['data']['mp'] = $result['bmiddle_pic'];
		$json['data']['op'] = $result['original_pic'];
		$json['data']['u'] = array();
		$json['data']['u']['id'] = (string)$result['user']['id'];
		$json['data']['u']['sn'] = $result['user']['screen_name'];
		$json['data']['u']['p'] = $result['user']['profile_image_url'];
		$json['data']['u']['v'] = $result['user']['verified'] == false ? 0 : 1;
		$json['data']['u']['sina_v'] = APP::F('filter', $result['user']['screen_name'], 'verify') == false ? 0 : 1;
		//转发微博内容
		if ( $result['retweeted_status']) {
			$json['data']['rt'] = array();
			$json['data']['rt']['id'] = (string)$result['retweeted_status']['id'];
			$json['data']['rt']['cr'] = $result['retweeted_status']['created_at'];
			$json['data']['rt']['f'] = $result['retweeted_status']['favorited'] == false ? 0 : 1;
			$json['data']['rt']['s'] = $result['retweeted_status']['source'];
			$json['data']['rt']['tx'] = $result['retweeted_status']['text'];
			$json['data']['rt']['tp'] = $result['retweeted_status']['thumbnail_pic'];
			$json['data']['rt']['mp'] = $result['retweeted_status']['bmiddle_pic'];
			$json['data']['rt']['op'] = $result['retweeted_status']['original_pic'];
			$json['data']['rt']['u'] = array();
			$json['data']['rt']['u']['id'] = (string)$result['retweeted_status']['user']['id'];
			$json['data']['rt']['u']['sn'] = $result['retweeted_status']['user']['screen_name'];
			$json['data']['rt']['u']['p'] = $result['retweeted_status']['user']['profile_image_url'];
			$json['data']['rt']['u']['v'] = $result['retweeted_status']['user']['verified'] == false ? 0 : 1;
			$json['data']['rt']['u']['sina_v'] = APP::F('filter', $result['retweeted_status']['user']['screen_name'], 'verify') == false ? 0 : 1;
		}
		$json['html'] = APP::F('mblog_html', $result, $mblog_counts, 'repost', $add);
		APP::ajaxRst($json, 0);
		exit;
	}


	/**
	 * 评论微博
	 *
	 *
	 */
	function comment()
	{
		$id = V('p:id');
		$text = trim(V('p:text'));
		$forward = V('p:forward');
		//是否需要输出html
		$needHTML = V('p:needHTML');
		$type = max(V('p:type'), 1);

		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		if (empty($text)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		} elseif (strlen(iconv("utf-8", "gbk", $text)) > 280) {
			APP::ajaxRst(false, 20011, 'max_length');
			exit;
		} elseif (APP::F('filter', $text, 'content') !== true) {
			APP::ajaxRst(false, 20015, 'allowed');
			exit;
		}


		//实例化微博api
		$wbApi = APP::N('weibo');
		//调用评论微博api
		$result = $wbApi->comment($id, $text, null, false);
		//发表评论失败
		if ($result['error_code']) {
			//评论内容重复
			if (strpos($result['error'], 'repeated')) {
				APP::ajaxRst(false, 20014, 'repeated');
				exit;
			}
			APP::ajaxRst(false, 20015, $result);
			exit;
		}

		if ($forward == 1) {
			$add = true;
			//作为一条新微博发布
			$result = $wbApi->repost($id, $text, false);
			$json = array();
			$json['comment']['id'] = (string)$result['id'];
			$json['comment']['create_at'] = APP::F('format_time', $result['created_at']);
			$json['comment']['text'] = APP::F('format_text', $result['text']);
			$json['comment']['nick'] = htmlspecialchars($result['user']['screen_name']);
			$json['comment']['uid'] = (string)$result['user']['id'];
			$json['comment']['profileImg'] = $type == 1 ? APP::F('profile_image_url', $result['user']['profile_image_url'], 'comment') : APP::F('profile_image_url', $result['user']['profile_image_url']);
			$json['comment']['sina_v'] = APP::F('filter', $result['user']['screen_name'], 'verify') == false ? 0 : 1;
			//转发微博内容
			if ( $result['retweeted_status']) {
				$json['rel']['data'] = array();
				$json['rel']['data']['id'] = (string)$result['retweeted_status']['id'];
				$json['rel']['data']['cr'] = APP::F('format_time', $result['retweeted_status']['created_at']);
				$json['rel']['data']['f'] = $result['retweeted_status']['favorited'] == false ? 0 : 1;
				$json['rel']['data']['s'] = $result['retweeted_status']['source'];
				$json['rel']['data']['tx'] = APP::F('format_text', $result['retweeted_status']['text']);
				$json['rel']['data']['tp'] = $result['retweeted_status']['thumbnail_pic'];
				$json['rel']['data']['mp'] = $result['retweeted_status']['bmiddle_pic'];
				$json['rel']['data']['op'] = $result['retweeted_status']['original_pic'];
				$json['rel']['data']['u'] = array();
				$json['rel']['data']['u']['id'] = (string)$result['retweeted_status']['user']['id'];
				$json['rel']['data']['u']['sn'] = htmlspecialchars($result['retweeted_status']['user']['screen_name']);
				$json['rel']['data']['u']['p'] = APP::F('profile_image_url', $result['retweeted_status']['user']['profile_image_url'], 'comment');
				$json['rel']['data']['u']['v'] = $result['retweeted_status']['user']['verified'] == false ? 0 : 1;
				$json['rel']['data']['u']['sina_v'] = APP::F('filter', $result['retweeted_status']['user']['screen_name'], 'verify') == false ? 0 : 1;
			}
			$json['html'] = APP::F('mblog_html', $result, $mblog_counts, 'comment', $add);
			APP::ajaxRst($json, '0');
			exit;
		} else {
			//获取评论数
//			$comments = $wbApi->getCounts($id);
			//由于接口同步问题，获取的评论数需要加1
//			$json['total'] = $comments[0]['comments'] + 1;
			$json = array();
			$json['comment']['id'] = (string)$result['id'];
			$json['comment']['create_at'] = APP::F('format_time', $result['created_at']);
			$json['comment']['text'] = APP::F('format_text', $result['text']);
			$json['comment']['nick'] = htmlspecialchars($result['user']['screen_name']);
			$json['comment']['uid'] = (string)$result['user']['id'];
			$json['comment']['profileImg'] = $type == 1 ? APP::F('profile_image_url', $result['user']['profile_image_url'], 'comment') : APP::F('profile_image_url', $result['user']['profile_image_url']);
			$json['comment']['sina_v'] = APP::F('filter', $result['user']['screen_name'], 'verify') == false ? 0 : 1;
			APP::ajaxRst($json, 0);
			exit;
		}
	}


	/**
	 * 删除当前用户的微博评论信息
	 *
	 *
	 */
	function comment_destroy()
	{
		$id = V('p:id');
		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		$ids = explode(',', $id);
		if (is_array($ids)) {
			$log = array();
			//删除多条评论
			foreach ($ids as $key => $var) {
				if (empty($var)) {
					continue;
				}
				$result = $wbApi->comment_destroy($var, false);
				//删除评论失败
				if ($result['error_code']) {
					$log[] = $var;
				}
			}
		}

		//错误日志
		if (!empty($log)) {
			APP::ajaxRst($log, 20013, $result);
			exit;
		}

//		$comments = $wbApi->getCounts($id);
		$json['total'] = $comments[0]['comment'];
		APP::ajaxRst($json, 0);
		exit;
	}


	/**
	 * 回复微博评论信息
	 *
	 *
	 */
	function reply()
	{
		$id = V('p:id');
		$cid = V('p:cid');
		$text = trim(V('p:text'));
		$forward = V('p:forward');
		$type = max(V('p:type'), 1);

		if (empty($id) || empty($cid) || empty($text)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		if (strlen(iconv("utf-8", "gbk", $text)) > 280) {
			APP::ajaxRst(false, 20011, 'max_length');
			exit;
		} elseif (APP::F('filter', $text, 'content') !== true) {
			APP::ajaxRst(false, 20015, 'allowed');
			exit;
		}


		//实例化微博api
		$wbApi = APP::N('weibo');
		$result = $wbApi->reply($id, $cid, $text, false);
		//回复微博评论失败
		if ($result['error_code']) {
			//评论内容重复
			if (strpos($result['error'], 'repeated')) {
				APP::ajaxRst(false, 20014, 'repeated');
				exit;
			}
			APP::ajaxRst(false, 20013, $result);
			exit;
		}


		if ($forward == 1) {
			$add = true;
			//作为一条新微博发布
			$result = $wbApi->repost($id, $text, false);
			$json = array();
			$json['comment']['id'] = (string)$result['id'];
			$json['comment']['create_at'] = APP::F('format_time', $result['created_at']);
			$json['comment']['text'] = APP::F('format_text', $result['text']);
			$json['comment']['nick'] = htmlspecialchars($result['user']['screen_name']);
			$json['comment']['uid'] = (string)$result['user']['id'];
			$json['comment']['profileImg'] = $type == 1 ? APP::F('profile_image_url', $result['user']['profile_image_url'], 'comment') : APP::F('profile_image_url', $result['user']['profile_image_url']);
			$json['comment']['sina_v'] = APP::F('filter', $result['user']['screen_name'], 'verify') == false ? 0 : 1;
			//转发微博内容
			if ( $result['retweeted_status']) {
				$json['rel']['data'] = array();
				$json['rel']['data']['id'] = (string)$result['retweeted_status']['id'];
				$json['rel']['data']['cr'] = APP::F('format_time', $result['retweeted_status']['created_at']);
				$json['rel']['data']['f'] = $result['retweeted_status']['favorited'] == false ? 0 : 1;
				$json['rel']['data']['s'] = $result['retweeted_status']['source'];
				$json['rel']['data']['tx'] = APP::F('format_text', $result['retweeted_status']['text']);
				$json['rel']['data']['tp'] = $result['retweeted_status']['thumbnail_pic'];
				$json['rel']['data']['mp'] = $result['retweeted_status']['bmiddle_pic'];
				$json['rel']['data']['op'] = $result['retweeted_status']['original_pic'];
				$json['rel']['data']['u'] = array();
				$json['rel']['data']['u']['id'] = (string)$result['retweeted_status']['user']['id'];
				$json['rel']['data']['u']['sn'] = htmlspecialchars($result['retweeted_status']['user']['screen_name']);
				$json['rel']['data']['u']['p'] = APP::F('profile_image_url', $result['retweeted_status']['user']['profile_image_url'], 'comment');
				$json['rel']['data']['u']['v'] = $result['retweeted_status']['user']['verified'] == false ? 0 : 1;
				$json['rel']['data']['u']['sina_v'] = APP::F('filter', $result['retweeted_status']['user']['screen_name'], 'verify') == false ? 0 : 1;
			}
			$json['html'] = APP::F('mblog_html', $result, $mblog_counts, 'comment', $add);
			APP::ajaxRst($json, '0');
			exit;
		} else {
			$json = array();
			$json['comment']['id'] = (string)$result['id'];
			$json['comment']['create_at'] = APP::F('format_time', $result['created_at']);
			$json['comment']['text'] = APP::F('format_text', $result['text']);
			$json['comment']['nick'] = htmlspecialchars($result['user']['screen_name']);
			$json['comment']['uid'] = (string)$result['user']['id'];
			$json['comment']['profileImg'] = $type == 1 ? APP::F('profile_image_url', $result['user']['profile_image_url'], 'comment') : APP::F('profile_image_url', $result['user']['profile_image_url']);
			$json['comment']['sina_v'] = APP::F('filter', $result['user']['screen_name'], 'verify') == false ? 0 : 1;
			APP::ajaxRst($json, 0);
			exit;
		}
	}


	/**
	 * 关注某人
	 *
	 *
	 */
	function createFriendship()
	{
		$id = V('p:id');
		$user_id = V('p:user_id');
		$screen_name = V('p:name');

		if (empty($id) && empty($user_id) && empty($screen_name)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		$user_ids = explode(',', $user_id);

		if (count($user_ids) > 1) {
			$errNum = 0;
			$err = array();

			foreach($user_ids as $uid) {
				$uid = (string)$uid;

				$result = $wbApi->createFriendship(null, $uid, null, null, false);

				if ($result['error_code']) {
					$errNum++;
					array_push($err, array('uid' => $uid, 'err' => $result));
				}
			}

			if ($errNum > 0) {
				APP::ajaxRst(false, 20013, $err);
			}
			else {
				APP::ajaxRst(array(1), 0);
			}



		} else {
			$result = $wbApi->createFriendship($id, $user_id, $screen_name, null, false);

			//关注失败
			if ($result['error_code']) {
				APP::ajaxRst(false, 20013, $result);
				exit;
			}

			APP::ajaxRst(array(1), 0);
		}
		exit;
	}


	/**
	 * 取消关注
	 *
	 *
	 */
	function deleteFriendship()
	{
		$id = V('p:id');
		$user_id = V('p:user_id');
		$screen_name = V('p:name');

		if (empty($id) && empty($user_id) && empty($screen_name)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		$result = $wbApi->deleteFriendship($id, $user_id, $screen_name, false);
		//取消关注失败
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(array(1), 0);
		exit;
	}


	/**
	 * 发送一条私信
	 *
	 *
	 */
	function sendDirectMessage()
	{
		$id = V('p:id');
		$name = V('p:name');
		$text = V('p:text');

		if (empty($text) || (empty($id) && empty($name))) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		} elseif (strlen(iconv("utf-8", "gbk", $text)) > 600) {
			APP::ajaxRst(false, 20011, 'max_length');
			exit;
		} elseif (APP::F('filter', $text, 'content') !== true) {
			APP::ajaxRst(false, 20015, 'allowed');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		$result = $wbApi->sendDirectMessage($id, $text, $name, null, false);
		if ($result['error_code']) {
			if (strpos($result['error'], 'follower')) {
				APP::ajaxRst(false, 20016, $result);
				exit;
			}
			if (strpos($result['error'], 'repeated')) {
				APP::ajaxRst(false, 20014, $result);
				exit;
			}
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(1, 0);
		exit;
	}


	/**
	 * 删除一条私信
	 *
	 *
	 */
	function deleteDirectMessage()
	{
		$id = V('p:id');

		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		$result = $wbApi->deleteDirectMessage($id, false);
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(1, 0);
		exit;
	}


	/**
	 * 添加收藏
	 *
	 *
	 */
	function createFavorite()
	{
		//要收藏微博的id
		$id = V('p:id');

		//微博id为空
		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		//调用收藏微博api
		$result = $wbApi->createFavorite($id, false);
		//收藏失败
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(array(1), 0);
		exit;
	}


	/**
	 * 删除当前用户收藏的微博信息
	 *
	 *
	 */
	function deleteFavorite()
	{
		$id = V('p:id');
		//微博id为空
		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		//调用删除收藏微博api
		$result = $wbApi->deleteFavorite($id, false);
		//删除收藏失败
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		$json = array();
		APP::ajaxRst($json, 0);
		exit;
	}


	/**
	 * 更改头像
	 *
	 *
	 */
	function updateProfileImage()
	{
		$image = V('p:image');
		if (empty($image)) {
			die('{"retcode":"-1"}');
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		//调用发布微博api
		$result = $wbApi->updateProfileImage($image);
		//更改头像失败
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(array(1), 0);
		exit;
	}


	/**
	 * 更改资料
	 *
	 *
	 */
	function updateProfile()
	{
		$name = V('p:name');
		$gender = V('p:gender');
		$province = V('p:province');
		$city = V('p:city');
		$description = V('p:description');

		//必须有一个参数不能为空
		if (empty($name) && empty($gender) && empty($province) && empty($city) && empty($description)) {
		}

		if (!empty($name) && strlen(iconv("utf-8", "gbk", $name)) > 40) {
		}

		if (!empty($description) && strlen(iconv("utf-8", "gbk", $description)) > 320) {
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		//调用更改资料api
		$result = $wbApi->updateProfile(array('name' =>$name,
										'gender' => $gender,
										'province' => $province,
										'city' => $city,
										'description' => $description));
		//更改资料失败
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		APP::ajaxRst(array(1), 0);
		exit;
	}


	/**
	 * 获取未读微博 包括@我的, 新评论，新私信，新粉丝数
	 *
	 *
	 */
	function unread()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		$since_id = V('p:id');

		$list = array();
		$feeds = 0;
		if ($since_id) {
			//获取新的微博
			$list = $wbApi->getFriendsTimeline(200, null, $since_id, null, false);
			//新微博数
			$feeds = count($list);
			$limit =  V('-:userConfig/user_page_wb') ?  V('-:userConfig/user_page_wb') : (V('-:sysConfig/each_page_wb') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_wb'));
			if ($feeds > $limit) {
				$list = array_slice($list, 0, $limit);
			}
			if ($list && V('-:userConfig/user_newfeed') == 1) {
				$json = array();
				$ids = array();
				foreach ($list as $key => $var) {
					$ids[] = $var['id'];
					//如果存在转发微博
					if ($var['retweeted_status']) {
						$ids[] = $var['retweeted_status']['id'];
					}
				}
				//获取该微博的转发数和评论数
				$ids = implode(',', $ids);
				$batch_counts = $wbApi->getCounts($ids);
				foreach ($batch_counts as $key => $var) {
					$counts[$var['id']]['comments'] = $var['comments'];
					$counts[$var['id']]['rt'] = $var['rt'];
				}

				foreach ($list as $key => $item) {
					$json[$key]['id'] = (string)$item['id'];
					$json[$key]['cr'] = APP::F('format_time',$item['created_at']);
					$json[$key]['f'] = $item['favorited'] == false ? 0 : 1;
					$json[$key]['s'] = $item['source'];
					$json[$key]['tx'] = $item['text'];
                    $json[$key]['ftx'] = APP::F('format_text', $item['text']);
					$json[$key]['tp'] = $item['thumbnail_pic'];
					$json[$key]['mp'] = $item['bmiddle_pic'];
					$json[$key]['op'] = $item['original_pic'];
					$json[$key]['rts'] = $counts[$item['id']]['rt'];
					$json[$key]['comments'] = $counts[$item['id']]['comments'];
					$json[$key]['u'] = array();
					$json[$key]['u']['id'] = (string)$item['user']['id'];
					$json[$key]['u']['sn'] = $item['user']['screen_name'];
					$json[$key]['u']['p'] = $item['user']['profile_image_url'];
					$json[$key]['u']['v'] = $item['user']['verified'] == false ? 0 : 1;
					$json[$key]['u']['sina_v'] = APP::F('filter', $item['user']['screen_name'], 'verify') == false ? 0 : 1;
					//转发微博内容
					if ($item['retweeted_status']) {
						$json[$key]['rt'] = array();
						$json[$key]['rt']['id'] = (string)$item['retweeted_status']['id'];
						$json[$key]['rt']['cr'] = $item['retweeted_status']['created_at'];
						$json[$key]['rt']['f'] = $item['retweeted_status']['favorited'] == false ? 0 : 1;
						$json[$key]['rt']['s'] = $item['retweeted_status']['source'];
						$json[$key]['rt']['tx'] = $item['retweeted_status']['text'];
                        $json[$key]['rt']['ftx'] = APP::F('format_text',$item['retweeted_status']['text']);
						$json[$key]['rt']['tp'] = $item['retweeted_status']['thumbnail_pic'];
						$json[$key]['rt']['mp'] = $item['retweeted_status']['bmiddle_pic'];
						$json[$key]['rt']['op'] = $item['retweeted_status']['original_pic'];
						$json[$key]['rt']['rts'] = $counts[$item['retweeted_status']['id']]['rt'];
						$json[$key]['rt']['comments'] = $counts[$item['retweeted_status']['id']]['comments'];
						$json[$key]['rt']['u'] = array();
						$json[$key]['rt']['u']['id'] = (string)$item['retweeted_status']['user']['id'];
						$json[$key]['rt']['u']['sn'] = $item['retweeted_status']['user']['screen_name'];
						$json[$key]['rt']['u']['p'] = $item['retweeted_status']['user']['profile_image_url'];
						$json[$key]['rt']['u']['v'] = $item['retweeted_status']['user']['verified'] == false ? 0 : 1;
						$json[$key]['rt']['u']['sina_v'] = APP::F('filter', $item['retweeted_status']['user']['screen_name'], 'verify') == false ? 0 : 1;
					}
				}
			}
		}

		//调用评论微博api
		$result = $wbApi->getUnread();
		if (isset($list['error_code'])) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		////实例化计数器
		//$counter = APP::N('counter');
		//$result = $counter->updateUnread($storage->getInfo('sina_uid'));
		//if ($list['error_code'] || $result['error_code']) {
		//	APP::ajaxRst(false, 20013, $result);
		//	exit;
		//}
		//$result = $counter->getUnread($storage->getInfo('sina_uid'));

		//@我的微博数
		$mentions = $result['mentions'];
		//评论数
		$comments = $result['comments'];
		//新粉丝数
		$followers = $result['followers'];
		//私信
		$dm = $result['dm'];
		header('Content-type: application/json;');
		APP::ajaxRst(array('unread' => array($feeds, $mentions, $comments, $followers, $dm), 'data' => $json), 0);
		exit;
	}


	/**
	 * 获取指定微博的评论列表
	 *
	 *
	 */
	function getComments()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//评论的微博id
		$id = V('p:id');
		//显示评论数
		$count = V('p:count');
		if (empty($count)) {
			//设置每页显示微博数
			$limit = V('-:userConfig/user_page_comment') ? V('-:userConfig/user_page_comment') : (V('-:sysConfig/each_page_comment') == '' ? WB_API_LIMIT : V('-:sysConfig/each_page_comment'));
			$count = $limit;
		} else {
			$limit = $count;
		}

		//页码数
		$page = max(V('p:page'), 1);

		//列表类型, 默认是1，微博列表的某条微博评论列表，2单条微博的详细评论列表
		$type = V('p:type');
		$type = empty($type) ? 1 : $type;

		//实例化存储
		$storage = APP::N('clientUser');

		//微博id为空
		if (empty($id)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}
		$list = $wbApi->getComments($id, $count, $page, false);
		if ($list['error_code']) {
			APP::ajaxRst(false, 20013, $list);
			exit;
		}

		//过滤过敏评论列表
		$list = APP::F('weibo_filter', $list);
		$total_count = count($list);
		if ($total_count > $limit) {
			$list = array_slice($list, 0, $limit);
		}

		$json = array();
		if (!empty($list)) {
			if (2 == $type) {
				foreach ($list as $key => $var) {
					$json[$key]['id'] = (string)$var['id'];
					$json[$key]['create_at'] = APP::F('format_time', $var['created_at']);
					$json[$key]['text'] = APP::F('format_text', $var['text']);
					$json[$key]['nick'] = htmlspecialchars($var['user']['screen_name']);
					$json[$key]['uid'] = (string)$var['user']['id'];
					$json[$key]['profileImg'] = APP::F('profile_image_url', $var['user']['profile_image_url']);
					$json[$key]['sina_v'] = APP::F('filter', $var['user']['screen_name'], 'verify') == false ? 0 : 1;
				}
			} else {
				foreach ($list as $key => $var) {
					$json[$key]['id'] = (string)$var['id'];
					$json[$key]['create_at'] = APP::F('format_time', $var['created_at']);
					$json[$key]['text'] = APP::F('format_text', $var['text']);
					$json[$key]['nick'] = htmlspecialchars($var['user']['screen_name']);
					$json[$key]['uid'] = (string)$var['user']['id'];
					$json[$key]['profileImg'] = APP::F('profile_image_url', $var['user']['profile_image_url'], 'comment');
					$json[$key]['sina_v'] = APP::F('filter', $var['user']['screen_name'], 'verify') == false ? 0 : 1;
				}
			}
		}

		$comments = $wbApi->getCounts($id, false);
		$json['total'] = $comments[0]['comments'];
		$json['limit'] = $limit;
		APP::ajaxRst($json, 0);
		exit;
	}

	function sinaurl() {
		//获取要查询的ID，以逗号分隔
		$url_id = V('r:id');

		//var_dump($url_id);

		$http = APP::ADP('http');

		$http->setUrl(SINAURL_INFO);
		$http->setData('url=' . $url_id);
		$result = $http->request();

		if ($http->getState() == 200) {
			//APP::ajaxRst(json_decode($result));
			echo $result;
		}
		else {
			echo '{code: -1}';
		}
		exit;
	}

	/**
	 * 清除新评论数tip，新粉丝tip，@我tip，新私信tip
	 *
	 * @return string
	 */
	function clearTip()
	{
		//实例化微博api
		$wbApi = APP::N('weibo');

		//实例化存储
		$storage = APP::N('clientUser');

		//实例化计数器
		$counter = APP::N('counter');

		//调用获取@当前用户的微博列表api
		$list = array();
		$list = $wbApi->getMentions(1, 1, null, null, false);
		if ($list['error_code']) {
			APP::ajaxRst(false, 20013, $list);
			exit;
		}
		if (empty($list[0]['id'])) {
			$list[0]['id'] = -1;
		}
		//清零@metip
		$counter->zero($storage->getInfo('sina_uid'), 'mentions', $list[0]['id']);

		//调用我收到的评论api
		$list = array();
		$list = $wbApi->getCommentsToMe(null, 1, 1, null, null, false);
		if ($list['error_code']) {
			APP::ajaxRst(false, 20013, $list);
			exit;
		}
		if (empty($list[0]['id'])) {
			$list[0]['id'] = -1;
		}
		//清零评论tip
		$counter->zero($storage->getInfo('sina_uid'), 'comments', $list[0]['id']);

		//调用我的粉丝列表api
		$list = array();
		$list = $wbApi->getFollowers(null, null, null, -1, 1, false);
		if ($list['error_code']) {
			APP::ajaxRst(false, 20013, $list);
			exit;
		}
		if (empty($list['users'][0]['id'])) {
			$list[0]['id'] = -1;
		}
		//清零粉丝tip
		$counter->zero($storage->getInfo('sina_uid'), 'followers', $list['users'][0]['id']);

		//调用获取当前用户收到的最新私信列表 api
		$list = array();
		$list = $wbApi->getDirectMessages(1, 1, null, null, false);
		if (empty($list[0]['id'])) {
			$list[0]['id'] = -1;
		}
		//清零私信tip
		$counter->zero($storage->getInfo('sina_uid'), 'dm', $list[0]['id']);

		APP::ajaxRst(array(1), 0);
		exit;
	}

	/**
	 * 查看某人是否是当用户的粉丝
	 *
	 *
	 */
	function friendShip()
	{
		$t_id = V('p:t_id');
		$t_name = V('p:t_name');
		$s_id = V('p:s_id');
		$s_name = V('p:s_name');

		if (empty($t_id) && empty($t_name)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');

		$result = $wbApi->getFriendship($t_id, $t_name, $s_id, $s_name, false);
		if ($result['error_code']) {
			APP::ajaxRst(false, 20013, $result);
			exit;
		}

		if ($result['target']['following'] == true) {
			APP::ajaxRst(1, 0);
			exit;
		} else {
			APP::ajaxRst(false, 20016);
			exit;
		}
	}

	/**
	 * 个人显示设置
	 *
	 * @param unknown_type
	 * @return unknown
	 */
	function setting()
	{
		$type = V('p:type', 'autoshow');

		$json = array();
		$json['user_page_wb'] = V('-:userConfig/user_page_wb');
		$json['user_page_comment'] = V('-:userConfig/user_page_comment');
		$json['user_newfeed'] =  V('-:userConfig/user_newfeed');
		$json['user_newmsg'] =  V('-:userConfig/user_newmsg');
		if ('autoshow' == $type) {
			$json['user_newfeed'] = 0;
		} else {
			$json['user_newmsg'] = 0;
		}

		$values = json_encode($json);

		$userConfig = APP::N('userConfig');
		$ret = $userConfig->set($values);
		if ($ret === false) {
			APP::ajaxRst(false, 60003, 'failed to save config');
			exit;
		}
		APP::ajaxRst('0', 0);
		exit;
	}

	/**
	 * 批量获取评论数和转发数
	 *
	 * @param unknown_type
	 * @return unknown
	 */
	function getCounts()
	{
		$ids = V('p:ids');
		//微博id为空
		if (empty($ids)) {
			APP::ajaxRst(false, 20010, 'empty');
			exit;
		}

		//实例化微博api
		$wbApi = APP::N('weibo');
		//批量获取指定微博的转发数和评论数
		$batch_counts = $wbApi->getCounts($ids, false);
		if ($batch_counts['error_code']) {
			APP::ajaxRst(false, 20013, $batch_counts);
			exit;
		}

		if (!empty($batch_counts)) {
			$counts = array();
			foreach ($batch_counts as $key => $var) {
				$counts[(string)$var['id']] = array($var['comments'], $var['rt']);
			}
			APP::ajaxRst($counts, 0);
			exit;
		}
		APP::ajaxRst('0', 0);
		exit;
	}
}
