<?php
/**************************************************
*  Created:  2010-06-13
*
*  微博过滤
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author zhenquan <zhenquan@staff.sina.com.cn>
*
***************************************************/

require_once  APP::functionFile('get_filter_cache');
/**
 * 微博过滤
 * @param $data 数据
 * @param $alone 是否为单条记录
 * @return array
 */
function weibo_filter($data, $alone = false){
    if ($alone) {
		if (chk_weibo($data) && chk_content($data)) {
			$row = $data;
			if (isset($user_verify[$row['user']['screen_name']])) {
				$row['user']['sina_v'] = 1;
			}
			if ($row['retweeted_status'] && isset($user_verify[$row['retweeted_status']['user']['screen_name']])) {
				$row['retweeted_status']['user']['sina_v'] = 1;
			}
			if ($row['status'] && isset($user_verify[$row['status']['user']['screen_name']])) {
				$row['status']['user']['sina_v'] = 1;
			}
			return $row;
		} else {
			return array();
		}
	}
	$data_after_filter = array();
	$user_verify = get_filter_cache('user_verify');
	if (is_array($data)) {
		foreach ($data as $key => $row) {
			if (chk_weibo($row) && chk_content($row)) {
				if (isset($user_verify[$row['user']['screen_name']])) {
					$row['user']['sina_v'] = 1;
				}
				if ($row['retweeted_status'] && isset($user_verify[$row['retweeted_status']['user']['screen_name']])) {
					$row['retweeted_status']['user']['sina_v'] = 1;
				}
				if ($row['status'] && isset($user_verify[$row['status']['user']['screen_name']])) {
					$row['status']['user']['sina_v'] = 1;
				}
				$data_after_filter[] = $row;
			}
		}
		return $data_after_filter;
	}else{
		return array();
	}
	
}

function chk_weibo(&$data) {
	if (!field_exists($data)) return false;
	if ($data['retweeted_status']) {
		if (!field_exists($data['retweeted_status'])) return false;
	}
	if ($data['status']) {
		if (!field_exists($data['status'])) return false;
	}
	return true;
}

function field_exists($data) {
	if ( isset($data['id']) && isset($data['text']) ) {
		if (isset($data['user'])) {
				if (isset($data['user']['screen_name']) && isset($data['user']['description'])) {
					return true;
				}
				return false;
		}
		return true;
	}
	return false;
}
/**
 * 过滤微博或回复
 */
function chk_content($data) {
	$disabled_weibo = get_filter_cache('weibo');
	$disabled_comment = get_filter_cache('comment');
	//var_dump($disabled_comment);
	//var_dump(array($data['id'], $data['status']['id'], $data['retweeted_status']['id']));
	if (isset($data['status'])) {
		//echo __LINE__ . '<br />';
		if (isset($disabled_comment[(string)$data['id']])) return false;
	} else {
		//echo __LINE__ . '<br />';
		if (isset($disabled_weibo[(string)$data['id']])) return false;
	} 
	// 昵称和内容的关键字过滤
	$kw_content = get_filter_cache('content');
	$kw_nick = get_filter_cache('nick');
	$size_content = 1 + sizeof($kw_content);
	$size_nick = 1 + sizeof($kw_nick);
	// 用户名关键字过滤
	$screen_name = $data['status']['user']['screen_name'] .$data['status']['user']['description'] . $data['user']['screen_name'] . $data['user']['description'] . $data['retweeted_status']['user']['screen_name'] . $data['retweeted_status']['user']['description'] . $data['from_user'];
	do  {
		if (strpos($screen_name, key($kw_nick)) > -1) {
			return false;
		}
	} while(next($kw_nick));
	// 内容关键字过滤
	$text = $data['status']['text'] . $data['text'] . $data['retweeted_status']['text'];
	do {
		if (strpos($text, key($kw_content)) > -1) {
			return false;
		}
	} while(next($kw_content));
	// 回复的微博如果是被屏蔽的，也过滤掉
	if ($data['status'] && isset($disabled_weibo[$data['status']['id']])) {
		return false;
	}
	// 处理转发
	if ($data['retweeted_status'] && isset($disabled_weibo[$data['retweeted_status']['id']])) {
		return false;
	}
	return true;
}

?>

