<?php
/**************************************************
*  Created:  2010-06-08
*
*  批量获取指定微博的转发数和评论数
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/


/**
 * weibo counts
 *
 * @param array $ids
 * @param string $retype
 * @return array|string
 */
function weibo_counts($ids, $retype = 'array')
{
	//实例化微博api
	$wb = APP::N('weibo');
	if (!is_array($ids)) {
		return false;
	}
	//批量获取指定微博的转发数和评论数
	$ids = implode(',', $ids);
	$batch_counts = $wb->getCounts($ids);

	if (!in_array($batch_counts['error_code'], V('-:apierrno'))) {
		$counts = array();
		foreach ($batch_counts as $key => $var) {
			$counts[$var['id']]['comments'] = $var['comments'];
			$counts[$var['id']]['rt'] = $var['rt'];
		}
		return $counts;
	}
	return $batch_counts;
}
