<?php
/**************************************************
*  Created:  2010-06-13
*
*  用户过滤
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author zhenquan <zhenquan@staff.sina.com.cn>
*
***************************************************/
require_once  APP::functionFile('get_filter_cache');

/**
 * 用户过滤
 * @param $data Array 用户数据
 * @param $alone boolean 是否为单条数据
 * @param $chk_publish 是否检查最后发现的微博是否能通过
 * @return string
 */
function user_filter($data, $alone = false, $chk_publish = false){
	$user_verify = get_filter_cache('user_verify');
    if ($alone) {
		if (user_field_exists($data) && chk_user_content($data, $chk_publish)) {
			$row = $data;
			if (isset($user_verify[$row['screen_name']])) {
				$row['sina_v'] = 1;
			}
			return $row;
		}
		return array();
	}
	$data_after_filter = array();
    foreach ($data as $key => $row) {
		if (user_field_exists($row) && chk_user_content($row, $chk_publish)) {
			if (isset($user_verify[$row['screen_name']])) {
				$row['sina_v'] = 1;
			}
			$data_after_filter[] = $row;
		}
	}
	return $data_after_filter;
}

function user_field_exists($data) {
	if (isset($data['id']) && isset($data['screen_name']) && isset($data['description'])) {
			if (isset($data['status'])) {
				if (isset($data['status']['id']) && isset($data['status']['text']) ) {
					return true;
				}
				return false;
			}
		return true;
	}
	return false;
}

/**
 * 过滤用户
 */
function chk_user_content($data, $chk_publish) {
	$disabled_weibo = get_filter_cache('weibo');
	if ($chk_publish && isset($data['status']) && isset($disabled_weibo[$data['status']['id']])) return false;
	// 昵称和内容的关键字过滤
	$kw_content = get_filter_cache('content');
	$kw_nick = get_filter_cache('nick');
	// 用户名关键字过滤
	$screen_name = $data['screen_name'] .$data['description'] . $data['name'];
	do  {
		if (strpos($screen_name, key($kw_nick)) > -1) {
			return false;
		}
	} while(next($kw_nick));
	// 内容关键字过滤
	if (isset($data['status'])) {
	$text = $data['status']['text'];
		do {
			if (strpos($text, key($kw_content)) > -1) {
				return false;
			}
		} while(next($kw_content));
	}
	
	return true;
}


?>

