<?php
/**************************************************
*  Created:  2010-06-08
*
*  头像url
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/

/**
 * profile image url
 *
 * @param string $url
 * @param string $type
 * @return string
 */
function profile_image_url($url, $type = 'index')
{
	if (strpos($url, 'http') === false) {
		$id = $url % 4 + 1;
		if ($type == 'index') {
			$size = 50;
		} elseif ($type == 'comment') {
			$size = 30;
		} elseif ($type == 'profile') {
			$size = 180;
		}
		$url = 'http://tp'.$id.'.sinaimg.cn/'.$url.'/'.$size.'/'.time();
		return $url;
	} else {
		switch ($type) {
			case 'comment':
				$urls = explode('/', $url);
				if (count($urls) != 6) {
					$url_new = $url;
				} else {
					$url_new = $urls[0].'//'.$urls[2].'/'.$urls[3].'/30/'.$urls[5];
				}
				break;
			case 'profile':
				$urls = explode('/', $url);
				if (count($urls) != 6) {
					$url_new = $url;
				} else {
					$url_new = $urls[0].'//'.$urls[2].'/'.$urls[3].'/180/'.$urls[5];
				}
				break;
			default:
				$url_new = $url;
		}
		return $url_new;
	}
}
?>