<?php
/**************************************************
*  Created:  2010-06-08
*
*  得到过滤相关缓存
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author zhenquan <zhenquan@staff.sina.com.cn>
*
***************************************************/
function get_filter_cache($type) {
	static $data = array();
	$allow_type = array('weibo', 'comment', 'nick', 'content', 'user_verify');
	if (!in_array($type, $allow_type)) {
		return false;
	}

	if (isset($data[$type])) {
		return $data[$type];
	}

	switch ($type) {
		case 'weibo':
			$cache_key = CACHE_DISABLED_WEIBO;
			$table = T_DISABLED_WEIBO;
			$field_name = 'wid';
		break;
		case 'comment':
			$cache_key = CACHE_DISABLED_COMMENT;
			$table = T_DISABLED_COMMENT;
			$field_name = 'cid';
		break;
		case 'nick':
			$cache_key = CACHE_DISABLED_NICK_KEYWORD;
			$table = T_KEYWORD;
			$field_name = 'keyword';
			$s_type = '1';
		break;
		case 'content':
			$cache_key = CACHE_DISABLED_CONTENT_KEYWORD;
			$table = T_KEYWORD;
			$field_name = 'keyword';
			$s_type = '2';
		break;
		case 'user_verify':
			$cache_key = CACHE_USER_VERIFY;
			$table = T_USER_VERIFY;
			$field_name = 'nick';
		break;
	}
	$cache = CACHE :: get($cache_key);
	if (!is_array($cache)) {
		// 同步cache
		$db = APP :: ADP('db');
		if ($s_type) {
			$where = ' WHERE `type`="' . $s_type . '"';
		}
		$sql = 'SELECT ' . $field_name . ' FROM '. $db->getTable($table) . $where;
		$data = $db->query($sql);
		if ($err = $db->getError()) {
			//throw new Exception($sql. '<br />' . $err);
			trigger_error($sql. '<br />' . $err, E_USER_WARNING);
		}
		$cache = array();
		while ($k = array_pop($data)) {
			$cache[$k[$field_name]] = 1;
		}
		CACHE :: set($cache_key, $cache);
	}
	$data[$type] = $cache;
	return $data[$type];
}
