<?php
/**************************************************
*  Created:  2010-06-08
*
*  微博api操作类
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author xionghui <xionghui1@staff.sina.com.cn>
*
***************************************************/

include_once "oauth.class.php";

 class weibo
 {

	var $http;
	var $token;
	var $shal_method;
	var $consumer;
	var $storage;
	var $format = 'json';
	var $error;

	/**
	 * 构造函数
	 *
	 * @param @oauth_token
	 * @param @oauth_token_secret
	 * @return
	 */
	function weibo($oauth_token = NULL, $oauth_token_secret = NULL)
	{
        $this->sha1_method = new OAuthSignatureMethod_HMAC_SHA1();
        $this->consumer = new OAuthConsumer(WB_AKEY, WB_SKEY);
		$this->storage = APP::N('clientUser');
		$this->setConfig();

		$this->http = APP::ADP('http');
	}


	/**
	 * 设置
	 *
	 * @return
	 */
	function setConfig()
	{
		$key  = $this->storage->getOAuthKey(false);
		$key2 = $this->storage->getOAuthKey(true);

		if ( !empty($key2) ) {
			$key = $key2;
		}

        if (!empty($key['oauth_token']) && !empty($key['oauth_token_secret'])) {
            $this->token = new OAuthConsumer($key['oauth_token'], $key['oauth_token_secret']);
        } else {
            $this->token = NULL;
        }
	}

	/**
	 * 手动设置Token
	 *
	 * @param unknown_type
	 * @return unknown
	 */
	function setToken($oauth_token, $oauth_token_secret)
	{
        if (!empty($oauth_token) && !empty($oauth_token_secret)) {
			$this->token = new OAuthConsumer($oauth_token, $oauth_token_secret);
		} else {
			$this->token = NULL;
		}
		
	}

	/**
	 * 设置错误提示
	 *
	 * @param string $error
	 * @return unknown
	 */
	function setError($error)
	{
		if (strpos($error['error'], 'auth')) {
			$msg = '系统内部错误，请稍后重试';
		} elseif (strpos($error['error'], 'User does not exists')) {
			$msg = '用户不存在';
		} elseif (strpos($error['error'], 'target weibo does not exist')) {
			$msg = '微博已删除';
		} elseif (strpos($error['error'], 'weibo id is null')) {
			$msg = '获取微博ID失败';
		} elseif (strpos($error['error'], 'System Error')) {
			$msg = '系统内部错误，请稍后重试';
		} elseif (strpos($error['error'], 'App_key')) {
			$msg = '来源APP_KEY错误';
		} elseif (strpos($error['error'], 'IP request')) {
			$msg = '请求次数超过API限制，请稍后再试';
		} elseif (strpos($error['error'], 'Attention  Out')) {
			$msg = '关注次数超过API限制，请稍后再试';
		} elseif (strpos($error['error'], 'Comment status')) {
			$msg = '评论次数超过API限制，请稍后再试';
		} elseif (strpos($error['error'], 'Update status')) {
			$msg = '发布微博次数超过API限制，请稍后再试';
		} else {
			$msg = '系统内部错误，请稍后重试';
		}

		APP::tips(array('tpl' => 'error', 'msg' => $msg));
	}


	/**
	 * 获取错误提示
	 *
	 * @param $useType string
	 * @return unknown
	 */
	function getError($useType = 'array')
	{
		if ('array' == $useType) {
			return json_decode($this->error, true);
		}
		return $this->error;
	}


	//数据集(timeline)接口

	/**
	 * 获取最新更新的公共微博消息
	 *
	 * @param $useType string
	 * @return array|string
	 */
	 function getPublicTimeline($useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/public_timeline.'.$this->format;
		$params = array();
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户所关注用户的最新微博信息
	 *
	 * @param $count int
	 * @param page int
	 * @param since_id int
	 * @param max_id int
	 * @return array|string
	 */
	 function getHomeTimeline($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/home_timeline.'.$this->format;
		$params = array();
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户所关注用户的最新微博信息
	 *
	 * @param $count int
	 * @param $page int
	 * @param $since_id int
	 * @param $max_id int
	 * @param $useType string
	 * @return array|string
	 */
	 function getFriendsTimeline($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		return $this->getHomeTimeline($count, $page, $since_id, $max_id, $useType);
	 }


	/**
	 * 获取用户发布的微博信息列表
	 *
	 * @param $id int|string
	 * @param $user_id int
	 * @param $name string
	 * @param $since_id int
	 * @parmas $max_id int
	 * @param $count int
	 * @param $page int
	 * @param $useType string
	 * @return array|string
	 */
	 function getUserTimeline($id = null, $user_id = null, $name = null, $since_id = null, $max_id = null, $count = null, $page = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'statuses/user_timeline/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'statuses/user_timeline.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	 /**
	  * 获取@当前用户的微博列表
	  *
	  * @param $count int
	  * @param page int
	  * @param since_id int
	  * @param max_id int
	  * @param @useType string
	  * @return array|string
	  */
	 function getMentions($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/mentions.'.$this->format;

		$params = array();
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户发送及收到的评论列表
	 *
	 * @param $count int
	 * @param $page int
	 * @param $since_id int
	 * @param $max_id int
	 * @param $useType string
	 * @return array|string
	 */
	 function getCommentsTimeline($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/comments_timeline.'.$this->format;

		$params = array();
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户发出的评论
	 *
	 * @param $count int
	 * @param $page int
	 * @param $since_id int
	 * @param $max_id int
	 * @param $useType string
	 * @return array|string
	 */
	 function getCommentsByMe($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/comments_by_me.'.$this->format;

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户收到的评论列表
	 *
	 * @param $list
	 * @param $count
	 * @param $page
	 * @param $since_id
	 * @param $max_id
	 * @return array
	 */
	function getCommentsToMe($list = null, $count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	{
		if (empty($list)) {
			$url = WEIBO_API_URL.'statuses/comments_timeline.'.$this->format;

			$params = array();
			if ($since_id) {
				$params['since_id'] = $since_id;
			}
			if ($max_id) {
				$params['max_id'] = $max_id;
			}
			if ($count) {
				$params['count'] = $count;
			}
			if ($page) {
				$params['page'] = $page;
			}

			$response = $this->oAuthRequest($url, 'get', $params, $useType);
		} else {
			$response = $list;
		}

		if (is_array($response) && $response) {
			//实例化存储
			$storage = APP::N('clientUser');
			$result = array();
			$uid = $storage->getInfo('sina_uid');
			foreach ($response as $var) {
				if ($var['user']['id'] == $uid) {
					continue;
				}
				$result[] = $var;
			}
			return $result;
		}
		return $response;
	}


	/**
	 * 获取指定微博的评论列表
	 *
	 * @param $id int
	 * @param $count int
	 * @param $page int
	 * @param $useType string
	 * @return array|string
	 */
	 function getComments($id, $count = null, $page = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/comments.'.$this->format;

		$params = array();
		$params['id'] = $id;

		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 批量获取一组微博的评论数及转发数
	 *
	 * @param $ids string
	 * @param $useType string
	 * @return array|string
	 */
	 function getCounts($ids, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/counts.'.$this->format;

		$params = array();
		if (is_array($ids)) {
			$params['ids'] = implode(',', $ids);
		} else {
			$params['ids'] = $ids;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户未读消息数
	 *
	 * @param $useType string
	 * @return array|string
	 */
	 function getUnread($useType = true)
	 {
		$url = WEIBO_API_URL.'/statuses/unread.'.$this->format;

		$params = array();
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	 //访问接口

	/**
	 * 根据ID获取单条微博信息内容
	 *
	 * @param $id int
	 * @param $user_id int
	 * @param $name string
	 * @param $useType string
	 * @return array|string
	 */
	 function getStatuseShow($id, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/show/'.$id.'.'.$this->format;

		$params = array();

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 发布一条微博信息
	 *
	 * @param $status string
	 * @param $useType string
	 * @return array|string
	 */
	 function update($status, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/update.'.$this->format;

		$params = array();
		$params['status'] = urlencode($status);

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	 /**
	  * 上传图片并发布一条微博信息
	  *
	  * @param $status string
	  * @param $pid string
	  * @param $lat string
	  * @param $long string
	  * @param $useType string
	  * @return array|string
	  */
	 function upload($status, $pic, $lat = null, $long = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/upload.'.$this->format;

		$params = array();
		$params['status'] = urlencode($status);
		$params['pic'] = '@'.$pic;

		if ($lat) {
			$params['lat'] = $lat;
		}
		if ($long) {
			$params['long'] = $long;
		}
		$response = $this->oAuthRequest($url, 'post', $params, $useType, true);

		return $response;
	 }


	/**
	 * 删除微博
	 *
	 * @param $id int
	 * @param $useType string
	 * @return array|string
	 */
	 function destroy($id, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/destroy/'.$id.'.'.$this->format;

		$params = array();

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 转发一条微博信息（可加评论）
	 *
	 * @param $id int
	 * @param $status string
	 * @param $useType string
	 * @return array|string
	 */
	 function repost($id, $status = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/repost.'.$this->format;

		$params = array();
		$params['id'] = $id;
		if ($status) {
			$params['status'] = urlencode($status);
		}

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 对一条微博信息进行评论
	 *
	 * @param $id int
	 * @param $comment string
	 * @param $useType string
	 * @return array|string
	 */
	 function comment($id, $comment, $cid = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/comment.'.$this->format;

		$params = array();
		$params['id'] = $id;
		$params['comment'] = urlencode($comment);
		if ($cid) {
			$params['cid'] = $cid;
		}

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 删除当前用户的微博评论信息
	 *
	 * @param $id int
	 * @param $useType string
	 * @return array|string
	 */
	 function comment_destroy($id, $useType = true)
	 {
		$url = WEIBO_API_URL.'statuses/comment_destroy/'.$id.'.'.$this->format;

		$params = array();

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	 /**
	  * 回复微博评论信息
	  *
	  * @param $id int
	  * @param $cid int
	  * @param $comment string
	  * @param $useType string
	  * @return array|string
	  */
	function reply($id, $cid, $comment, $useType = true)
	{
		$url = WEIBO_API_URL.'statuses/reply.'.$this->format;

		$params = array();
		$params['id'] = $id;
		$params['comment'] = urlencode($comment);
		$params['cid'] = $cid;

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }



	 //用户接口

	/**
	 * 根据用户ID获取用户资料（授权用户）
	 *
	 * @param $id int|string
	 * @param $user_id int
	 * @param $name string
	 * @param $useType string
	 * @return array|string
	 */
	function getUserShow($id = null, $user_id = null, $name = null, $useType = true)
	{
		if ($id) {
			$url = WEIBO_API_URL.'users/show/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'users/show.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	}


	/**
	 * 获取当前用户关注对象列表及最新一条微博信息
	 *
	 * @param $id int|string
	 * @parmas $user_id int
	 * @param $name string
	 * @param $cursor
	 * @param $count
	 * @param $useType string
	 * @return array|string
	 */
	 function getFriends($id = null, $user_id = null, $name = null, $cursor = null, $count = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'statuses/friends/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'statuses/friends.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($cursor) {
			$params['cursor'] = $cursor;
		}
		if ($count) {
			$params['count'] = $count;
		}


		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户粉丝列表及最新一条微博信息
	 *
	 * @param $id int|string
	 * @param $user_id int
	 * @param $name string
	 * @param $cursor string
	 * @param $count int
	 * @param $useType string
	 * @return array|string
	 */
	 function getFollowers($id = null, $user_id = null, $name = null, $cursor = null, $count = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'statuses/followers/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'statuses/followers.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($cursor) {
			$params['cursor'] = $cursor;
		}
		if ($count) {
			$params['count'] = $count;
		}


		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }



	 //私信接口

	/**
	 * 获取当前用户最新私信列表
	 *
	 * @param $count int
	 * @param $page int
	 * @param $since_id int
	 * @param $max_id int
	 * @param $useType string
	 * @return array|string
	 */
	 function getDirectMessages($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'direct_messages.'.$this->format;

		$params = array();
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户发送的最新私信列表
	 *
	 * @param $count int
	 * @param $page int
	 * @param $since_id int
	 * @param $max_id int
	 * @param $useType string
	 * @return array|string
	 */
	 function getSentDirectMessages($count = null, $page = null, $since_id = null, $max_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'direct_messages/sent.'.$this->format;

		$params = array();
		if ($since_id) {
			$params['since_id'] = $since_id;
		}
		if ($max_id) {
			$params['max_id'] = $max_id;
		}
		if ($count) {
			$params['count'] = $count;
		}
		if ($page) {
			$params['page'] = $page;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 发送一条私信
	 *
	 * @param $id int|string
	 * @param $text string
	 * @param $name string
	 * @param $user_id int
	 * @param $useType string
	 * @return array|string
	 */
	 function sendDirectMessage($id, $text, $name = null, $user_id = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'direct_messages/new.'.$this->format;

		$params = array();
		$params['id'] = $id;
		$params['text'] = $text;
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($user_id) {
			$params['user_id'] = $user_id;
		}

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 删除一条私信
	 *
	 * @param $id int
	 * @param $useType string
	 * @return array|string
	 */
	 function deleteDirectMessage($id, $useType = true)
	 {
		$url = WEIBO_API_URL.'direct_messages/destroy/'.$id.'.'.$this->format;

		$params = array();

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }



	 //关注接口

	/**
	 * 关注某用户
	 *
	 * @param $id int|string
	 * @param $user_id int
	 * @param $name string
	 * @param $follow string
	 * @param $useType string
	 * @return array|string
	 */
	 function createFriendship($id = null, $user_id = null, $name = null, $follow = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'friendships/create/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'friendships/create.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($follow) {
			$params['follow'] = $follow;
		}

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 取消关注
	 *
	 * @param $id int|string
	 * @param $user_id int
	 * @param $name string
	 * @param $useType string
	 * @return array|string
	 */
	 function deleteFriendship($id = null, $user_id = null, $name = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'friendships/destroy/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'friendships/destroy.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 是否关注某用户
	 *
	 * @param $user_a int
	 * @param $user_b int
	 * @param $useType string
	 * @return array|string
	 */
	 function existsFriendship($user_a, $user_b, $useType = true)
	 {
		$url = WEIBO_API_URL.'friendships/exists.'.$this->format;

		$params = array();
		$params['user_a'] = $user_a;
		$params['user_b'] = $user_b;

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 获取两个用户关系的详细情况
	 *
	 * @param $target_id int
	 * @param $target_screen_name string
	 * @param $source_id int
	 * @param $source_screen_name string
	 * @param $useType string
	 * @return array|string
	 */
	 function getFriendship($target_id = null, $target_screen_name = null, $source_id = null, $source_screen_name = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'friendships/show.'.$this->format;

		$params = array();
		if ($target_id) {
			$params['target_id'] = $target_id;
		}
		if ($target_screen_name) {
			$params['target_screen_name'] = $target_screen_name;
		}
		if ($source_id) {
			$params['source_id'] = $source_id;
		}
		if ($source_screen_name) {
			$params['source_screen_name'] = $source_screen_name;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }



	 //Social Graph接口

	/**
	 * 获取用户关注对象uid列表
	 *
	 * @param $id int
	 * @param $user_id int
	 * @param $name string
	 * @param $cursor string
	 * @param $count int
	 * @param $useType string
	 * @return array|string
	 */
	 function getFriendIds($id = null, $user_id = null, $name = null, $cursor = null, $count = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'friends/ids/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'friends/ids.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($cursor) {
			$params['cursor'] = $cursor;
		}
		if ($count) {
			$params['count'] = $count;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取用户粉丝对象uid列表
	 *
	 * @param $id int
	 * @param $user_id int
	 * @param $name string
	 * @param $useType string
	 * @return array|string
	 */
	 function getFollowerIds($id = null, $user_id = null, $name = null, $cursor = null, $count = null, $useType = true)
	 {
		if ($id) {
			$url = WEIBO_API_URL.'followers/ids/'.$id.'.'.$this->format;
		} else {
			$url = WEIBO_API_URL.'followers/ids.'.$this->format;
		}

		$params = array();
		if ($user_id) {
			$params['user_id'] = $user_id;
		}
		if ($name) {
			$params['screen_name'] = $name;
		}
		if ($cursor) {
			$params['cursor'] = $cursor;
		}
		if ($count) {
			$params['count'] = $count;
		}

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }



	 //账号接口

	/**
	 * 验证当前用户身份是否合法
	 *
	 * @param $useType string
	 * @return array|string
	 */
	 function verifyCredentials($useType = true)
	 {
		$url = WEIBO_API_URL.'account/verify_credentials.'.$this->format;

		$params = array();
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 获取当前用户API访问频率限制
	 *
	 * @param $useType string
	 * @return array|string
	 */
	 function getRateLimitStatus($useType = true)
	 {
		$url = WEIBO_API_URL.'account/rate_limit_status.'.$this->format;

		$params = array();
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 当前用户退出登录
	 *
	 * @param $useType string
	 * @return array|string
	 */
	 function endSession($useType = true)
	 {
		$url = WEIBO_API_URL.'account/end_session.'.$this->format;

		$params = array();
		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 更改头像
	 *
	 * @param $image string
	 * @param $useType string
	 * @return array|string
	 */
	 function updateProfileImage($image, $useType = true)
	 {
		$url = WEIBO_API_URL.'account/update_profile_image.'.$this->format;

		$params = array();
		$params['image'] = '@'.$image;

		$response = $this->oAuthRequest($url, 'post', $params, $useType, true);

		return $response;
	 }


	/**
	 * 更改资料
	 *
	 * @param $name string
	 * @param $gender string
	 * @param $province int
	 * @param $city int
	 * @param $description string
	 * @param $params
	 * @param $useType string
	 * @return array|string
	 */
	 function updateProfile($params, $useType = true)
	 {
		$url = WEIBO_API_URL.'account/update_profile.'.$this->format;

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 注册新浪微博帐号
	 *
	 * @param $params array
	 * @return array|string
	 */
	 function register($params, $useType = true)
	 {
		$url = WEIBO_API_URL.'account/register.'.$this->format;

		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }



	 //收藏接口

	/**
	 * 获取当前用户的收藏列表
	 *
	 * @param $page int
	 * @param $useType string
	 * @return array|string
	 */
	 function getFavorites($page = null, $useType = true)
	 {
		$url = WEIBO_API_URL.'favorites.'.$this->format;

		$params = array();
		if ($page) {
			$params['page'] = $page;
		}
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	 }


	/**
	 * 添加收藏
	 *
	 * @param $id int
	 * @param $useType string
	 * @return array|string
	 */
	 function createFavorite($id, $useType = true)
	 {
		$url = WEIBO_API_URL.'favorites/create.'.$this->format;

		$params = array();
		$params['id'] = $id;
		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	/**
	 * 删除当前用户收藏的微博信息
	 *
	 * @param $id int
	 * @param $useType string
	 * @return array|string
	 */
	 function deleteFavorite($id, $useType = true)
	 {
		$url = WEIBO_API_URL.'favorites/destroy/'.$id.'.'.$this->format;

		$params = array();
		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	 }


	 //oauth

    /**
     * Set API URLS
     */
    /**
     * @ignore
     */
    function accessTokenURL()  { return WEIBO_API_URL.'oauth/access_token'; }
    /**
     * @ignore
     */
    function authenticateURL() { return WEIBO_API_URL.'oauth/authenticate'; }
    /**
     * @ignore
     */
    function authorizeURL()    { return WEIBO_API_URL.'oauth/authorize'; }
    /**
     * @ignore
     */
    function requestTokenURL() { return WEIBO_API_URL.'oauth/request_token'; }

    /**
     * Get a request_token from Weibo
     *
     * @return array a key/value array containing oauth_token and oauth_token_secret
     */
    function getRequestToken($oauth_callback = NULL, $useType = 'string')
	{
        $parameters = array();
        if (!empty($oauth_callback)) {
            $parameters['oauth_callback'] = $oauth_callback;
        }

        $request = $this->oAuthRequest($this->requestTokenURL(), 'GET', $parameters, $useType);
        $token = OAuthUtil::parse_parameters($request);
        $this->token = new OAuthConsumer($token['oauth_token'], $token['oauth_token_secret']);
        return $token;
    }

    /**
     * Get the authorize URL
     *
     * @return array
     */
    function getAuthorizeURL($token, $sign_in_with_Weibo = TRUE , $url)
	{
        if (is_array($token)) {
            $token = $token['oauth_token'];
        }
        if (empty($sign_in_with_Weibo)) {
            return $this->authorizeURL() . "?oauth_token={$token}&oauth_callback=" . urlencode($url);
        } else {
            return $this->authenticateURL() . "?oauth_token={$token}&oauth_callback=". urlencode($url);
        }
    }

	/**
	 * Get the authorize Token
	 *
	 * @param string $token
	 * @param string $user
	 * @param string $password
	 * @param string $useType
	 *
	 * @return array
	 */
	function getAuthorizeToken($token, $user, $password, $useType = 'json')
	{
        if (is_array($token)) {
            $token = $token['oauth_token'];
        }

		$url = $this->authorizeURL();
		$params = array();
		$params['oauth_token'] = $token;
		$params['oauth_callback'] = $useType;
		$params['display'] = 'web';
		$params['userId'] = $user;
		$params['passwd'] = $password;

		$this->http->setUrl($url);
		$this->http->setData($params);
		$response = $this->http->request();

		$code = $this->http->getState();
		if ($userType !== false || $userType !== true) {
			if (200 != $code) {
				$this->setError($result);
			}
		}
		$response = json_decode($response, true);
		return $response;
	}

    /**
     * Exchange the request token and secret for an access token and
     * secret, to sign API calls.
     *
     * @return array array("oauth_token" => the access token,
     *                "oauth_token_secret" => the access secret)
     */
    function getAccessToken($oauth_verifier = FALSE, $oauth_token = false, $useType = 'string')
	{
        $parameters = array();
        if (!empty($oauth_verifier)) {
            $parameters['oauth_verifier'] = $oauth_verifier;
        }


        $request = $this->oAuthRequest($this->accessTokenURL(), 'GET', $parameters, $useType);
        $token = OAuthUtil::parse_parameters($request);
        $this->token = new OAuthConsumer($token['oauth_token'], $token['oauth_token_secret']);
        return $token;
    }

    /**
     * Format and sign an OAuth / API request
     *
     * @return array
     */
    function oAuthRequest($url, $method, $parameters , $useType = true, $multi = false)
	{
        $request = OAuthRequest::from_consumer_and_token($this->consumer, $this->token, $method, $url, $parameters);
        $request->sign_request($this->sha1_method, $this->consumer, $this->token);
		$method = strtoupper($method);
        switch ($method) {
        case 'GET':
//            echo $request->to_url();
			$this->http->base_string = $request->base_string;
			$this->http->key_string = $request->key_string;
			$this->http->setUrl($request->to_url());
			$result = $this->http->request();
			if ($useType === false || $useType === true) {
				$ret = $result;
				$result = json_decode($result, true);
			}
			$code = $this->http->getState();
			if (200 != $code) {
				APP::LOG('url: '.$this->http->getUrl()." \r\ncode: ".$code." \r\nret: ".$ret . "\r\nerror: " . $this->http->getError()."\r\nbase_string:: ".$request->base_string."\r\nkey_string: ".$request->key_string);
				if (0 == $code) {
					$result = array("error_code" => "50000", "error" => "timeout");
				}
				if ($useType === true) {
					$this->setError($result);
				}
				return $result;
			}
			return $result;
        default:
			$this->http->base_string = $request->base_string;
			$this->http->key_string = $request->key_string;
			$this->http->setUrl($request->get_normalized_http_url());
			$this->http->setData($request->to_postdata($multi));
			if ($multi) {
				$header_array = array();
				$header_array2=array();
				$header_array2 = array("Content-Type: multipart/form-data; boundary=" . $GLOBALS['___xwbStData']['boundary'] , "Expect: ");
				foreach($header_array as $k => $v) {
					array_push($header_array2,$k.': '.$v);
				}
				$config = array(CURLOPT_HTTPHEADER => $header_array2);
				$this->http->setConfig($config);
			}

			$result = $this->http->request('post');
			if ($useType === false || $useType === true) {
				$ret = $result;
				$result = json_decode($result, true);
			}
			$code = $this->http->getState();
			if (200 != $code) {
				APP::LOG('url: '.$this->http->getUrl()." \r\ncode: ".$code." \r\nret: ".$ret . "\r\nerror: " . $this->http->getError()."\r\nbase_string:: ".$request->base_string."\r\nkey_string: ".$request->key_string);
				if (0 == $code) {
					$result = array("error_code" => "50000", "error" => "timeout");
				}
				if ($useType === true) {
					$this->setError($result);
				}
				return $result;
			}
			return $result;
        }
    }


	// search user

	/**
	 * 搜索微博用户
	 *
	 * @param $params array
	 * @param $useType bool
	 * @return array|string
	 */
	function searchUser($params, $useType = true)
	{
		$url = WEIBO_API_URL.'users/search.'.$this->format;
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	}


	/**
	 * 搜索微博文章
	 *
	 * @param $q string
	 * @param $page int
	 * @param $rpp string
	 * @param $callback string
	 * @param $geocode string
	 * @param $useType string
	 * @return array|string
	 */
	function search($q = null, $page = null, $rpp = null, $callback = null, $geocode = null, $useType = true)
	{
		$url = WEIBO_API_URL.'search.'.$this->format;
		$params = array();
		if ($q) {
			$params['q'] = $q;
		}
		if ($page) {
			$params['page'] = $page;
		}
		if ($rpp) {
			$params['rpp'] = $rpp;
		}
		if ($callback) {
			$params['callback'] = $callback;
		}
		if ($geocode) {
			$params['geocode'] = $geocode;
		}
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	}


	/**
	 * 搜索微博文章
	 *
	 * @param $q string
	 * @param $filter_ori stirng
	 * @param $filter_pic string
	 * @param $province int
	 * @param $city int
	 * @param $starttime string
	 * @param $endtime string
	 * @param $page int
	 * @param $count int
	 * @param $callback string
	 * @param $useType string
	 * @return array|string
	 */
	function searchStatuse($params, $useType = true)
	{
		$url = WEIBO_API_URL.'statuses/search.'.$this->format;
		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	}


	/**
	 * 获取省份及城市编码ID与文字对应
	 *
	 * @param $useType bool
	 * @return array|string
	 */
	function getProvinces($useType = true)
	{
		$url = WEIBO_API_URL.'provinces.'.$this->format;
		$params = array();

		$response = $this->oAuthRequest($url, 'get', $params, $useType);

		return $response;
	}

	/**
	 * 设置某个用户某个新消息的未读数为0
	 *
	 * @param string $type 1--评论数，2--@数，3--私信数，4--关注我的数
	 * @param string $useType
	 * @return unknown
	 */
	function reset_count($type = 1, $useType = true)
	{
		$url = WEIBO_API_URL.'statuses/reset_count.'.$this->format;
		$params = array();

		$params['type'] = $type;
		$response = $this->oAuthRequest($url, 'post', $params, $useType);

		return $response;
	}
}
