<?php
/**************************************************
*  Created:  2010-06-28
*
*  用户自定义配置项管理类
*
*  @Xweibo (C)1996-2099 SINA Inc.
*  @Author zhenquan <zhenquan@staff.sina.com.cn>
*
***************************************************/
class userConfig {

	/**
	 * 保存用户配置信息
	 *
	 * @param int $sina_uid
	 * @param string $values
	 * @return bool|null
	 */
	function set($values, $sina_uid = null)
	{
		$storage = APP::N('clientUser');
		$sina_uid = empty($sina_uid) ? $storage->getInfo('sina_uid') : $sina_uid;

		if (empty($sina_uid) || empty($values)) {
			return false;
		}

		$db = APP :: ADP('db');
		$row = $db->query('SELECT * FROM ' . $db->getTable(T_USER_CONFIG) . ' WHERE sina_uid = '.$sina_uid);
		$data = array();
		$data['values'] = $values;
		if (empty($row)) {
			$data['sina_uid'] = $sina_uid;
			$ret = $db->save($data, '', T_USER_CONFIG);
		} else {
			$ret = $db->save($data, $sina_uid, T_USER_CONFIG, 'sina_uid');
		}

		if ($ret === false) {
			return false;
		}

		CACHE::set($sina_uid.'_'.CACHE_USER_CONFIG, $values);
	}

	/**
	 * 获取用户自定义配置信息
	 *
	 * @param int $sina_uid
	 * @return bool|null
	 */
	function get($sina_uid = null)
	{
		$storage = APP::N('clientUser');
		$sina_uid = empty($sina_uid) ? $storage->getInfo('sina_uid') : $sina_uid;
		if (empty($sina_uid)) {
			return false;
		}

		$values = CACHE::get($sina_uid.'_'.CACHE_USER_CONFIG);
		if (empty($values)) {
			$db = APP :: ADP('db');
			$row = $db->query('SELECT * FROM ' . $db->getTable(T_USER_CONFIG) . ' WHERE sina_uid = '.$sina_uid);
			if (empty($row)) {
				//初始化空值
				$values = '{"user_newfeed":"","user_newmsg":"","user_page_wb":"","user_page_comment":""}';
			} else {
				$values = $row[0]['values'];
			}
			CACHE::set($sina_uid.'_'.CACHE_USER_CONFIG, $values);
		}

		$values = json_decode($values, true);
		$GLOBALS[V_CFG_GLOBAL_NAME]['userConfig'] = $values;
	}
}
?>