* SAVE_SRC.PRG
* Demo Coverage AddIn, Saves Source Table to Disk

LPARAMETERS toCoverageRef

ASSERT TYPE("toCoverageRef.lUsingRegistry") = "L"


********************************
* Demo AddIn Help Material:

#DEFINE COV_ADDIN_README .T.

#IF COV_ADDIN_README

   #DEFINE COV_ADDIN_HELP "ADD_READ.PRG"

   LOCAL cFile
  
   cFile = UPPER(SYS(16))

   IF LEFT(cFile,10) = "PROCEDURE "
      cFile = ;
        SUBSTR(cFile,AT(" ",cFile,2) + 1)
   ENDIF
  
   cFile = STRTRAN(cFile,;
                   SUBSTR(cFile,RAT("\",cFile)+1), ;
                   COV_ADDIN_HELP)

   IF NOT FILE(cFile)
  
      cFile = toCoverageRef.GetResourceLocation( ;
              cFile, ;
              "Please locate AddIn Help Program", ;
              "Programs" + " (*.prg)|*.prg", ;
              COV_ADDIN_HELP, ;
              "GETFILE")
   ENDIF              
          
  
   IF NOT EMPTY(cFile)
  
      DO (cFile) WITH SYS(16)
  
   ENDIF
  
#ENDIF  

*********************


LOCAL cDBFName, iSelect, cSource, iDataSession, lTalk

IF SET("TALK") = "ON"
  SET TALK OFF
  lTalk = .T.
ENDIF  

* get the alias of the current Source table
cSource = toCoverageRef.cSourceAlias

* get a default tablename for the save-to-disk
cDBFName = toCoverageRef.GetTableName("_SRC")

* now ask the user whether this name is okay:
cDBFName = ;
  toCoverageRef.GetResourceLocation( ;
       toCoverageRef.cSourceFile, ;
      "Please decide where to save the Source table", ;
      "Tables" + " (*.dbf)|*.dbf", ;
      cDBFName, ;
      "PUTFILE")

IF (NOT(EMPTY(cDBFName)))

   iDataSession = SET("DATASESSION")
   SET DATASESSION TO toCoverageRef.DataSessionID

   iSelect = SELECT()
   SELECT (cSource)
   COPY TO (cDBFName) 
   SELECT (iSelect)
   SET DATASESSION TO iDataSession   
   IF EMPTY(SYS(2000,cDBFName))
      WAIT WINDOW NOWAIT "Nothing happened!"
      toCoverageRef.lError = .T.
   ENDIF

ENDIF

IF lTalk
   SET TALK ON
ENDIF   

RETURN