* ADD_UI.PRG
* Demo Coverage AddIn, 
* Adds a Button to the Standard UI Main Dialog
* which, when clicked, adds a Button to the
* Main Dialog's tool container

* Both buttons are descended from a button class
* that shows you the Coverage standard error 
* handling, although this is not required for
* buttons you add to the Coverage app!

* Classes are DEFINEd within this PRG for
* convenience, but CLASSLIBs could be SET etc

LPARAMETERS toCoverageRef


********************************
* Demo AddIn Help Material:

#DEFINE COV_ADDIN_README .T.

#IF COV_ADDIN_README

   #DEFINE COV_ADDIN_HELP "ADD_READ.PRG"

   LOCAL cFile
  
   cFile = UPPER(SYS(16))

   IF LEFT(cFile,10) = "PROCEDURE "
      cFile = ;
        SUBSTR(cFile,AT(" ",cFile,2) + 1)
   ENDIF

  
   cFile = STRTRAN(cFile,;
                   SUBSTR(cFile,RAT("\",cFile)+1), ;
                   COV_ADDIN_HELP)

   IF NOT FILE(cFile)                   
  
      cFile = toCoverageRef.GetResourceLocation( ;
             cFile, ;
             "Please locate AddIn Help Program", ;
             "Programs" + " (*.prg)|*.prg", ;
             COV_ADDIN_HELP, ;
             "GETFILE")
   ENDIF             
  
   IF NOT EMPTY(cFile)
  
      DO (cFile) WITH SYS(16)
  
   ENDIF
  
#ENDIF  

*********************

LOCAL ARRAY aTemp[1]

LOCAL cExact, cName

cExact = SET("EXACT")
SET EXACT ON

DO CASE

CASE TYPE("toCoverageRef.BaseClass") # "C" OR ;
   ACLASS(aTemp,toCoverageRef) = 0 OR ;
   ASCAN(aTemp,"COV_STANDARD") = 0
   
   MESSAGEBOX("This Demo AddIn requires a Coverage Object "+CHR(13)+;
              "descended from the Standard UI class (COV_STANDARD).",;
              16)
              
   SET EXACT &cExact
   RETURN .F.
   
CASE toCoverageRef.lUnattended

   MESSAGEBOX("This Demo AddIn is not designed to be used "+ CHR(13)+;
              "when the Coverage Engine is running in "+CHR(13)+ ;
              "Unattended mode."+ ;
              CHR(13)+CHR(13)+;
              "For this AddIn, use .F. as your second parameter:"+;
              CHR(13)+CHR(13)+;
              "DO (_COVERAGE) WITH <logfile>,.F.,"+toCoverageRef.cAddIn,;
              16)
   SET EXACT &cExact
   RETURN .F.

OTHERWISE
   SET EXACT &cExact   
ENDCASE

* give the member a unique name: 
cName = "cmd"+SYS(2015)

toCoverageRef.frmMainDialog.AddObject(cName, ;
              "DemoFormButton")

STORE .T. TO ("toCoverageRef.frmMainDialog." + ;
              cName + ".Visible")

RETURN


DEFINE Class DemoFormButton AS DemoButton

  Caption = "New Tool"
  
  PROC Init
     LOCAL lReturn
     lReturn = DODEFAULT()
     IF lReturn
        * force the form to make room for it,
        * to make life more interesting <g>:
       WITH THISFORMSET.frmMainDialog.Controls(1)
          THIS.Top = .Top
          THIS.Height = .Height
          .Left = THIS.Width + 2
          .SynchSizes()
       ENDWITH 
     ENDIF
  RETURN lReturn AND (NOT THIS.lError)

  PROC Click
    THISFORMSET.frmMainDialog.AddTool("DemoContainerButton")
    THIS.Enabled = .F.
  ENDPROC
  
ENDDEFINE

DEFINE Class DemoContainerButton AS DemoButton

  Caption = "Find..."

  PROC Init
     LOCAL lReturn
     lReturn = DODEFAULT()
     IF lReturn
        THIS.Height = THIS.Parent.Height
     ENDIF
  RETURN lReturn AND (NOT THIS.lError)
  
  PROC Click
     LOCAL cFile
     
     cFile = UPPER(SYS(16))

     IF LEFT(cFile,10) = "PROCEDURE "
        cFile = ;
          SUBSTR(cFile,AT(" ",cFile,2) + 1)
     ENDIF
  
     cFile = STRTRAN(cFile,;
                   SUBSTR(cFile,RAT("\",cFile)+1), ;
                   "FIND_REC.SCX")
     IF NOT FILE(cFile)
  
        cFile = THISFORMSET.GetResourceLocation( ;
                cFile, ;
                "Please locate Find_Rec AddIn", ;
                "Forms" + " (*.scx)|*.scx", ;
                "FIND_REC.SCX", ;
                "GETFILE")
     ENDIF                
  
     THISFORMSET.RunAddIn(cFile)
     
  ENDPROC

ENDDEFINE


DEFINE CLASS DemoButton AS CommandButton
   * this class simply demonstrates
   * standard (not required!) 
   * Coverage member error handling

   lError = .F.
   AutoSize = .T.   

   PROC Init

     WITH THISFORMSET
        * just to demonstrate
        * the existance of these
        * properties:
        THIS.FontName = .cBaseFontName
        THIS.FontItalic = .lBaseFontItalic
        THIS.FontBold = .lBaseFontBold
        THIS.FontSize = .nBaseFontSize
     ENDWITH
     * now set off AutoSize so the
     * various containers have a chance
     * to have a go at sizing this button
     * according to their internal rules:
     THIS.AutoSize = .F.

   RETURN (NOT THIS.lError)
  
   PROC Error(nError, cMethod, nLine)
      THIS.lError = .T.
      IF TYPE("THISFORMSET.BaseClass") = "C"
         THISFORMSET.Error(nError,THIS.Name+":"+cMethod,nLine)
      ELSE
         ERROR nError
      ENDIF
   ENDPROC
   
ENDDEFINE

