* COV_TUNE.H
* Default/tunable option settings for Coverage app

* reference variable for the formset:
#DEFINE COV_PUBLIC_VARIABLE         _oCoverage

* class:
#DEFINE COV_CLASS_TO_INSTANCE       "cov_standard"
#DEFINE COV_CLASSLIB                "COVERAGE.VCX"
#DEFINE COV_APPNAME                 "COVERAGE.APP"

* default profile marking:
#DEFINE COV_PROFILE_EXECUTED_SPACING 12
#DEFINE COV_PROFILE_STATS_SPACING    12

* default coverage marking
#DEFINE COV_DEFAULT_MARKEXECUTED     ""
#DEFINE COV_DEFAULT_MARKNOTEXECUTED  "|"+SPACE(3)
#DEFINE COV_DEFAULT_MARKSPACING      5

* default fonts:
#DEFINE COV_DEFAULT_BASE_FONTNAME   "MS San Serif"
#DEFINE COV_DEFAULT_MONO_FONTNAME   "Courier New"
* these defaults will be overwritten by registry
* (trace window and standard Font properties) or
* if available resource file entries

* suffixs for default savenames for coverage result tables:
#DEFINE COV_SKIPFILEDBF_SUFFIX       "_SKIP"
#DEFINE COV_TARGETDBF_SUFFIX         "_COV"

#DEFINE COV_USE_OCXS                .T.
#DEFINE COV_TOPSPEED                .F.
* Make this one .T. if you want a fast, in-line call
* while Coverage parses your code.
* Using the method call, OTOH, gives you more
* scope for formatting the marks:
#IF COV_TOPSPEED
    #DEFINE COV_MARK_CODE_LINE      IIF(THIS.lInProfileMode, ;
                                        IIF(ISNULL(iExecuted), ;
                                            SPACE(30), ;
                                            STR(iExecuted,10,0)+ ;
                                            STR(nFirst,10,3)+STR(nAverage,10,3)), ;
                                        IIF(ISNULL(iExecuted), ;
                                            SPACE(LEN(THIS.cMarkExecuted)), ;
                                            IIF(iExecuted > 0, ;
                                                THIS.cMarkExecuted, ;
                                                THIS.cMarkNotExecuted)) ) + ;
                                     SPACE(4) + ;
                                     cRealLine
#ELSE
    #DEFINE COV_MARK_CODE_LINE      THIS.MarkCodeLine(cRealLine,iExecuted, nFirst, nAverage)
#ENDIF

#DEFINE COV_LINES_TO_VALIDATE       100
#DEFINE COV_POINT_SETTING           "."

* this mechanism provides output from the target
* file for a particular project. A REPORT FORM or any other
* mechanism can also be used.  The Target file
* is SELECTed() and filtered appropriately for the project.
* You can substitute a method call here, if you want a more
* elaborate mechanism than an in-line call:
#DEFINE COV_PROJECT_FRX             "COV_PJX.FRX"


* debugging:
#DEFINE COV_DEBUG                    .F.
#DEFINE COV_TIMEOUT_SECS             2
#IF COV_DEBUG

    #DEFINE COV_DEBUG_MESSAGE        WAIT WINDOW LEFT(MESSAGE()+C_CR+;
                                                      SYS(2018)+C_CR+;
                                                      cMethod+C_CR+;
                                                      MESSAGE(1),COV_MESSAGE_LIMIT) ;
                                          TIMEOUT COV_TIMEOUT_SECS
    #DEFINE COV_DEBUG_ACTION         ERROR nError
    #DEFINE COV_ENGINE_ERROR_DEFAULT NOTE

#ELSE

    #DEFINE COV_DEBUG_MESSAGE        MESSAGEBOX(COV_PROBLEM_LOC+":"+C_CR+;
                                                MESSAGE()+C_CR+;
                                                cMethod,COV_STOP_MESSAGEBOX)
    #DEFINE COV_DEBUG_ACTION         NOTE
    #DEFINE COV_ENGINE_ERROR_DEFAULT THIS.Release()

#ENDIF


