/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.animation;

import com.vicmatskiv.weaponlib.animation.MultipartPositioning;
import com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager;
import com.vicmatskiv.weaponlib.animation.MultipartTransition;
import com.vicmatskiv.weaponlib.animation.MultipartTransitionProvider;
import com.vicmatskiv.weaponlib.animation.Randomizer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class MultipartRenderStateManager<State, Part, Context> {
    private Randomizer randomizer;
    private State currentState;
    private MultipartTransitionProvider<State, Part, Context> transitionProvider;
    private Deque<MultipartPositioning<Part, Context>> positioningQueue;
    private Part mainPart;

    public MultipartRenderStateManager(State initialState, MultipartTransitionProvider<State, Part, Context> transitionProvider, Part mainPart) {
        this.transitionProvider = transitionProvider;
        this.mainPart = mainPart;
        this.positioningQueue = new LinkedList<MultipartPositioning<Part, Context>>();
        this.randomizer = new Randomizer();
        this.setState(initialState, false, true);
    }

    public void setState(State newState, boolean animated, boolean immediate) {
        if (newState == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        if (newState.equals(this.currentState)) {
            return;
        }
        if (immediate) {
            this.positioningQueue.clear();
        }
        if (animated) {
            this.positioningQueue.add(new TransitionedPositioning(this.currentState, newState));
        }
        this.positioningQueue.add(new StaticPositioning(newState));
        this.currentState = newState;
    }

    public MultipartPositioning<Part, Context> nextPositioning() {
        MultipartPositioning<Part, Context> result = null;
        while (!this.positioningQueue.isEmpty()) {
            MultipartPositioning<Part, Context> p = this.positioningQueue.poll();
            if (p.isExpired(this.positioningQueue)) continue;
            this.positioningQueue.addFirst(p);
            result = p;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Position cannot be null");
        }
        return result;
    }

    private class TransitionedPositioning
    implements MultipartPositioning<Part, Context> {
        private Map<Part, com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager$TransitionedPositioning.PartData> partDataMap = new HashMap();
        private int currentIndex;
        private long currentStartTime;
        private boolean expired;
        private int segmentCount;
        private List<MultipartTransition<Part, Context>> fromPositioning;
        private List<MultipartTransition<Part, Context>> toPositioning;
        private State fromState;
        private State toState;

        TransitionedPositioning(State fromState, State toState) {
            this.fromState = fromState;
            this.toState = toState;
            this.fromPositioning = MultipartRenderStateManager.this.transitionProvider.getPositioning(fromState);
            this.toPositioning = MultipartRenderStateManager.this.transitionProvider.getPositioning(toState);
            this.segmentCount = this.toPositioning.size();
        }

        @Override
        public boolean isExpired(Queue<MultipartPositioning<Part, Context>> positioningQueue) {
            return this.expired;
        }

        private com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager$TransitionedPositioning.PartData getPartData(Part part, Context context) {
            try {
                return this.partDataMap.computeIfAbsent(part, p -> {
                    PartData pd = new PartData();
                    pd.matrices.add(this.getMatrixForPositioning(this.fromPositioning.get(this.fromPositioning.size() - 1), p, context));
                    for (MultipartTransition t : this.toPositioning) {
                        pd.matrices.add(this.getMatrixForPositioning(t, p, context));
                    }
                    return pd;
                });
            }
            catch (Exception e) {
                System.err.println("Failed to get data for part " + part + " for transition from [" + this.fromState + "] to [" + this.toState + "]");
                throw e;
            }
        }

        @Override
        public MultipartPositioning.Positioner<Part, Context> getPositioner() {
            long currentTime = System.currentTimeMillis();
            long currentDuration = this.toPositioning.get(this.currentIndex).getDuration();
            long currentPause = this.toPositioning.get(this.currentIndex).getPause();
            if (this.currentStartTime == 0L) {
                this.currentStartTime = currentTime;
            } else if (currentTime > this.currentStartTime + currentDuration + currentPause) {
                ++this.currentIndex;
                this.currentStartTime = currentTime;
            }
            long currentOffset = currentTime - this.currentStartTime;
            if (this.currentIndex >= this.segmentCount) {
                this.expired = true;
                return new MultipartPositioning.Positioner<Part, Context>(){

                    @Override
                    public void position(Part part, Context context) {
                        PartData partData = TransitionedPositioning.this.getPartData(part, context);
                        TransitionedPositioning.this.applyOnce(part, context, partData.matrices.get(TransitionedPositioning.this.currentIndex - 1), partData.matrices.get(TransitionedPositioning.this.currentIndex), 1.0f);
                    }

                    @Override
                    public void randomize(float rate, float amplitude) {
                        MultipartRenderStateManager.this.randomizer.update(0.0f, 0.0f);
                    }
                };
            }
            float currentProgress = (float)currentOffset / (float)currentDuration;
            if (currentProgress > 1.0f) {
                currentProgress = 1.0f;
            }
            final float finalCurrentProgress = currentProgress;
            return new MultipartPositioning.Positioner<Part, Context>(){

                @Override
                public void position(Part part, Context context) {
                    PartData partData = TransitionedPositioning.this.getPartData(part, context);
                    TransitionedPositioning.this.applyOnce(part, context, partData.matrices.get(TransitionedPositioning.this.currentIndex), partData.matrices.get(TransitionedPositioning.this.currentIndex + 1), finalCurrentProgress);
                }

                @Override
                public void randomize(float rate, float amplitude) {
                    MultipartRenderStateManager.this.randomizer.update(0.0f, 0.0f);
                }
            };
        }

        private void applyOnce(Part part, Context context, Matrix4f beforeMatrix, Matrix4f afterMatrix, float progress) {
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2982, (FloatBuffer)buf);
            buf.rewind();
            Matrix4f currentMatrix = new Matrix4f();
            currentMatrix.load(buf);
            Matrix4f m1 = this.scale(beforeMatrix, 1.0f - progress);
            Matrix4f m2 = this.scale(afterMatrix, progress);
            Matrix4f deltaMatrix = Matrix4f.add((Matrix4f)m1, (Matrix4f)m2, null);
            Matrix4f composite = Matrix4f.mul((Matrix4f)currentMatrix, (Matrix4f)deltaMatrix, null);
            FloatBuffer buf2 = BufferUtils.createFloatBuffer((int)16);
            composite.store(buf2);
            buf2.rewind();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadMatrix((FloatBuffer)buf2);
        }

        private Matrix4f scale(Matrix4f m, float factor) {
            Matrix4f result = new Matrix4f();
            result.m00 = m.m00 * factor;
            result.m01 = m.m01 * factor;
            result.m02 = m.m02 * factor;
            result.m03 = m.m03 * factor;
            result.m10 = m.m10 * factor;
            result.m11 = m.m11 * factor;
            result.m12 = m.m12 * factor;
            result.m13 = m.m13 * factor;
            result.m20 = m.m20 * factor;
            result.m21 = m.m21 * factor;
            result.m22 = m.m22 * factor;
            result.m23 = m.m23 * factor;
            result.m30 = m.m30 * factor;
            result.m31 = m.m31 * factor;
            result.m32 = m.m32 * factor;
            result.m33 = m.m33 * factor;
            return result;
        }

        private Matrix4f getMatrixForPositioning(MultipartTransition<Part, Context> transition, Part part, Context context) {
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            transition.position(part, context);
            GL11.glGetFloat((int)2982, (FloatBuffer)buf);
            buf.rewind();
            Matrix4f matrix = new Matrix4f();
            matrix.load(buf);
            GL11.glPopMatrix();
            return matrix;
        }

        private class PartData {
            List<Matrix4f> matrices = new ArrayList<Matrix4f>();

            private PartData() {
            }
        }
    }

    private class StaticPositioning
    implements MultipartPositioning<Part, Context> {
        private State state;

        public StaticPositioning(State state) {
            this.state = state;
        }

        @Override
        public boolean isExpired(Queue<MultipartPositioning<Part, Context>> positioningQueue) {
            return !positioningQueue.isEmpty();
        }

        @Override
        public MultipartPositioning.Positioner<Part, Context> getPositioner() {
            final List transitions = MultipartRenderStateManager.this.transitionProvider.getPositioning(this.state);
            return new MultipartPositioning.Positioner<Part, Context>(){

                @Override
                public void position(Part part, Context context) {
                    try {
                        ((MultipartTransition)transitions.get(transitions.size() - 1)).position(part, context);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to find static position for " + part + " in " + StaticPositioning.this.state);
                        throw e;
                    }
                }

                @Override
                public void randomize(float rate, float amplitude) {
                    MultipartRenderStateManager.this.randomizer.update(rate, amplitude);
                }
            };
        }
    }
}

