/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SpawnEntityRenderer
extends Render<WeaponSpawnEntity> {
    protected SpawnEntityRenderer(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(WeaponSpawnEntity weaponSpawnEntity, double x, double y, double z, float yaw, float tick) {
        Weapon weapon = weaponSpawnEntity.getWeapon();
        if (weapon == null) {
            return;
        }
        ModelBase model = weapon.getAmmoModel();
        if (model != null) {
            ResourceLocation textureLocation;
            String ammoModelTextureName = weapon.getAmmoModelTextureName();
            ResourceLocation resourceLocation = textureLocation = ammoModelTextureName != null ? new ResourceLocation(ammoModelTextureName) : null;
            if (model != null) {
                GL11.glPushMatrix();
                if (textureLocation != null) {
                    this.func_110776_a(textureLocation);
                }
                GL11.glTranslated((double)x, (double)y, (double)z);
                model.func_78088_a((Entity)weaponSpawnEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
            }
        }
    }

    protected ResourceLocation getEntityTexture(WeaponSpawnEntity entity) {
        WeaponSpawnEntity weaponSpawnEntity = entity;
        return new ResourceLocation(weaponSpawnEntity.getWeapon().getAmmoModelTextureName());
    }
}

