/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.AttachmentManager;
import com.vicmatskiv.weaponlib.CustomArmor;
import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CustomGui
extends Gui {
    private Minecraft mc;
    private AttachmentManager attachmentManager;
    private static final int BUFF_ICON_SIZE = 256;

    public CustomGui(Minecraft mc, AttachmentManager attachmentManager) {
        this.mc = mc;
        this.attachmentManager = attachmentManager;
    }

    @SubscribeEvent
    public void onRenderHud(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            String hudTexture;
            ItemStack helmet;
            Iterator equipmentIterator = this.mc.field_71439_g.func_184209_aF().iterator();
            ItemStack itemStack = helmet = equipmentIterator.hasNext() ? (ItemStack)equipmentIterator.next() : null;
            if (helmet != null && this.mc.field_71474_y.field_74320_O == 0 && helmet.func_77973_b() instanceof CustomArmor && (hudTexture = ((CustomArmor)helmet.func_77973_b()).getHudTexture()) != null) {
                ScaledResolution scaledResolution = event.getResolution();
                int width = scaledResolution.func_78326_a();
                int height = scaledResolution.func_78328_b();
                GlStateManager.func_179123_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                this.mc.field_71446_o.func_110577_a(new ResourceLocation(hudTexture));
                CustomGui.drawTexturedQuadFit(0.0, 0.0, width, height, 0.0);
                GlStateManager.func_179099_b();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        ItemStack itemStack = this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77973_b() instanceof Weapon) {
            String crosshair;
            Weapon weaponItem = (Weapon)itemStack.func_77973_b();
            String string = crosshair = weaponItem != null ? weaponItem.getCrosshair(itemStack, (EntityPlayer)this.mc.field_71439_g) : null;
            if (crosshair != null) {
                ScaledResolution scaledResolution = event.getResolution();
                int width = scaledResolution.func_78326_a();
                int height = scaledResolution.func_78328_b();
                int xPos = width / 2 - 128;
                int yPos = height / 2 - 128;
                FontRenderer fontRender = this.mc.field_71466_p;
                this.mc.field_71460_t.func_78478_c();
                int color = 0xFFFFFF;
                this.mc.field_71446_o.func_110577_a(new ResourceLocation(crosshair));
                GlStateManager.func_179123_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                if (weaponItem.isCrosshairFullScreen(itemStack)) {
                    CustomGui.drawTexturedQuadFit(0.0, 0.0, width, height, 0.0);
                } else {
                    this.func_73729_b(xPos, yPos, 0, 0, 256, 256);
                }
                if (Weapon.isModifying(itemStack)) {
                    fontRender.func_175063_a("Attachment selection mode. Press [f] to exit.", 10.0f, 10.0f, color);
                    fontRender.func_175063_a("Press [up] to add optic", (float)(width / 2 - 40), 60.0f, color);
                    fontRender.func_175063_a("Press [left] to add barrel rig", 10.0f, (float)(height / 2 - 10), color);
                    fontRender.func_175063_a("Press [right] to change camo", (float)(width / 2 + 60), (float)(height / 2 - 20), color);
                    fontRender.func_175063_a("Press [down] to add under-barrel rig", 10.0f, (float)(height - 40), color);
                } else {
                    ItemMagazine magazine = (ItemMagazine)this.attachmentManager.getActiveAttachment(itemStack, AttachmentCategory.MAGAZINE);
                    int totalCapacity = magazine != null ? magazine.getAmmo() : weaponItem.getAmmoCapacity();
                    String text = weaponItem.getAmmoCapacity() == 0 && totalCapacity == 0 ? "No magazine" : "Ammo: " + weaponItem.getCurrentAmmo((EntityPlayer)this.mc.field_71439_g) + "/" + totalCapacity;
                    int x = width - 80;
                    int y = 10;
                    fontRender.func_175063_a(text, (float)x, (float)y, color);
                }
                GlStateManager.func_179099_b();
                event.setCanceled(true);
            }
        } else if (itemStack.func_77973_b() instanceof ItemMagazine) {
            ScaledResolution scaledResolution = event.getResolution();
            int width = scaledResolution.func_78326_a();
            FontRenderer fontRender = this.mc.field_71466_p;
            this.mc.field_71460_t.func_78478_c();
            int color = 0xFFFFFF;
            ItemMagazine magazine = (ItemMagazine)itemStack.func_77973_b();
            String text = "Ammo: " + Tags.getAmmo(itemStack) + "/" + magazine.getAmmo();
            int x = width - 80;
            int y = 10;
            fontRender.func_175063_a(text, (float)x, (float)y, color);
            event.setCanceled(true);
        }
    }

    private static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

