/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentManager;
import com.vicmatskiv.weaponlib.AttachmentModeMessage;
import com.vicmatskiv.weaponlib.AttachmentModeMessageHandler;
import com.vicmatskiv.weaponlib.ChangeAttachmentMessage;
import com.vicmatskiv.weaponlib.ChangeAttachmentMessageHandler;
import com.vicmatskiv.weaponlib.ChangeSettingMessageHandler;
import com.vicmatskiv.weaponlib.ChangeSettingsMessage;
import com.vicmatskiv.weaponlib.ChangeTextureMessage;
import com.vicmatskiv.weaponlib.ChangeTextureMessageHandler;
import com.vicmatskiv.weaponlib.FireManager;
import com.vicmatskiv.weaponlib.LaserSwitchMessage;
import com.vicmatskiv.weaponlib.LaserSwitchMessageHandler;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.ModelSourceRenderer;
import com.vicmatskiv.weaponlib.ReloadManager;
import com.vicmatskiv.weaponlib.ReloadMessage;
import com.vicmatskiv.weaponlib.ReloadMessageHandler;
import com.vicmatskiv.weaponlib.TryFireMessage;
import com.vicmatskiv.weaponlib.TryFireMessageHandler;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorageManager;
import com.vicmatskiv.weaponlib.WeaponKeyInputHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonModContext
implements ModContext {
    protected SimpleNetworkWrapper channel;
    protected AttachmentManager attachmentManager;
    protected FireManager fireManager;
    protected ReloadManager reloadManager;
    private String modId;
    private Map<ResourceLocation, SoundEvent> registeredSounds = new HashMap<ResourceLocation, SoundEvent>();

    @Override
    public void init(Object mod, String modId, SimpleNetworkWrapper channel) {
        this.channel = channel;
        this.modId = modId;
        this.attachmentManager = new AttachmentManager(this);
        this.fireManager = new FireManager(this);
        this.reloadManager = new ReloadManager(this);
        channel.registerMessage((IMessageHandler)new ReloadMessageHandler(this.reloadManager, ctx -> this.getServerPlayer((MessageContext)ctx)), ReloadMessage.class, 1, Side.SERVER);
        channel.registerMessage((IMessageHandler)new ReloadMessageHandler(this.reloadManager, ctx -> this.getPlayer((MessageContext)ctx)), ReloadMessage.class, 2, Side.CLIENT);
        channel.registerMessage((IMessageHandler)new AttachmentModeMessageHandler(this.attachmentManager), AttachmentModeMessage.class, 3, Side.SERVER);
        channel.registerMessage((IMessageHandler)new AttachmentModeMessageHandler(this.attachmentManager), AttachmentModeMessage.class, 4, Side.CLIENT);
        channel.registerMessage((IMessageHandler)new ChangeAttachmentMessageHandler(this.attachmentManager), ChangeAttachmentMessage.class, 5, Side.SERVER);
        channel.registerMessage((IMessageHandler)new ChangeAttachmentMessageHandler(this.attachmentManager), ChangeAttachmentMessage.class, 6, Side.CLIENT);
        channel.registerMessage((IMessageHandler)new ChangeTextureMessageHandler(this.attachmentManager), ChangeTextureMessage.class, 7, Side.SERVER);
        channel.registerMessage((IMessageHandler)new ChangeTextureMessageHandler(this.attachmentManager), ChangeTextureMessage.class, 8, Side.CLIENT);
        channel.registerMessage((IMessageHandler)new ChangeSettingMessageHandler(ctx -> this.getPlayer((MessageContext)ctx)), ChangeSettingsMessage.class, 9, Side.CLIENT);
        channel.registerMessage((IMessageHandler)new ChangeSettingMessageHandler(ctx -> this.getPlayer((MessageContext)ctx)), ChangeSettingsMessage.class, 10, Side.SERVER);
        channel.registerMessage((IMessageHandler)new TryFireMessageHandler(this.fireManager), TryFireMessage.class, 11, Side.SERVER);
        channel.registerMessage(LaserSwitchMessageHandler.class, LaserSwitchMessage.class, 12, Side.SERVER);
        channel.registerMessage(LaserSwitchMessageHandler.class, LaserSwitchMessage.class, 13, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this.attachmentManager);
        MinecraftForge.EVENT_BUS.register((Object)new WeaponKeyInputHandler(ctx -> this.getPlayer((MessageContext)ctx), this.attachmentManager, this.reloadManager, channel));
    }

    @Override
    public SoundEvent registerSound(String sound) {
        ResourceLocation soundResourceLocation = new ResourceLocation(this.modId, sound);
        SoundEvent result = this.registeredSounds.get(soundResourceLocation);
        if (result == null) {
            result = new SoundEvent(soundResourceLocation);
            this.registeredSounds.put(soundResourceLocation, result);
            GameRegistry.register((IForgeRegistryEntry)result, (ResourceLocation)soundResourceLocation);
        }
        return result;
    }

    @Override
    public void registerWeapon(String name, Weapon weapon) {
        GameRegistry.registerItem((Item)weapon, (String)name);
    }

    private EntityPlayer getServerPlayer(MessageContext ctx) {
        return ctx != null ? ctx.getServerHandler().field_147369_b : null;
    }

    protected EntityPlayer getPlayer(MessageContext ctx) {
        return this.getServerPlayer(ctx);
    }

    @Override
    public SimpleNetworkWrapper getChannel() {
        return this.channel;
    }

    @Override
    public void runSyncTick(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runInMainThread(Runnable runnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    @Override
    public WeaponClientStorageManager getWeaponClientStorageManager() {
        return null;
    }

    @Override
    public void registerRenderableItem(String name, Item item, ModelSourceRenderer renderer) {
        GameRegistry.registerItem((Item)item, (String)name);
    }
}

