/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.AttachmentContainer;
import com.vicmatskiv.weaponlib.AttachmentModeMessage;
import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorage;
import com.vicmatskiv.weaponlib.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class AttachmentManager {
    private static final String ACTIVE_ATTACHMENT_TAG = "ActiveAttachments";
    private static final String SELECTED_ATTACHMENT_INDEXES_TAG = "SelectedAttachments";
    private static final String PREVIOUSLY_SELECTED_ATTACHMENT_TAG = "PreviouslySelectedAttachments";
    private ModContext modContext;

    AttachmentManager(ModContext modContext) {
        this.modContext = modContext;
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent itemTossEvent) {
        ItemStack itemStack = itemTossEvent.getEntityItem().func_92059_d();
        Item item = itemStack.func_77973_b();
        if (!(item instanceof Weapon)) {
            return;
        }
        if (Weapon.isModifying(itemStack)) {
            this.exitAttachmentSelectionMode(itemStack, itemTossEvent.getPlayer());
        }
    }

    void toggleClientAttachmentSelectionMode(ItemStack itemStack, EntityPlayer player) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof Weapon) || player.func_184614_ca() != itemStack) {
            return;
        }
        Weapon weapon = (Weapon)item;
        WeaponClientStorage storage = weapon.getWeaponClientStorage(player);
        if (storage == null) {
            return;
        }
        if (storage.getState() == Weapon.State.EJECT_SPENT_ROUND) {
            return;
        }
        if (storage.getState() != Weapon.State.MODIFYING) {
            storage.setState(Weapon.State.MODIFYING);
        } else {
            storage.setState(Weapon.State.READY);
        }
        this.modContext.getChannel().sendToServer((IMessage)new AttachmentModeMessage());
    }

    void toggleServerAttachmentSelectionMode(ItemStack itemStack, EntityPlayer player) {
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        if (!Weapon.isModifying(itemStack)) {
            this.enterAttachmentSelectionMode(itemStack);
        } else {
            this.exitAttachmentSelectionMode(itemStack, player);
        }
    }

    void enterAttachmentSelectionMode(ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int[] selectedAttachmentIndexes = new int[AttachmentCategory.values.length];
        itemStack.func_77978_p().func_74783_a(SELECTED_ATTACHMENT_INDEXES_TAG, selectedAttachmentIndexes);
        itemStack.func_77978_p().func_74783_a(PREVIOUSLY_SELECTED_ATTACHMENT_TAG, Arrays.copyOf(activeAttachmentsIds, activeAttachmentsIds.length));
        Weapon.setModifying(itemStack, true);
    }

    void exitAttachmentSelectionMode(ItemStack itemStack, EntityPlayer player) {
        this.ensureItemStack(itemStack);
        int[] activeAttachmentsIds = itemStack.func_77978_p().func_74759_k(ACTIVE_ATTACHMENT_TAG);
        int[] previouslySelectedAttachmentIds = itemStack.func_77978_p().func_74759_k(PREVIOUSLY_SELECTED_ATTACHMENT_TAG);
        for (int i = 0; i < activeAttachmentsIds.length; ++i) {
            if (activeAttachmentsIds[i] == previouslySelectedAttachmentIds[i]) continue;
            Item newItem = Item.func_150899_d((int)activeAttachmentsIds[i]);
            Item oldItem = Item.func_150899_d((int)previouslySelectedAttachmentIds[i]);
            WorldHelper.consumeInventoryItem(player.field_71071_by, newItem);
            if (player.field_71071_by.func_70441_a(new ItemStack(oldItem))) continue;
            System.err.println("Cannot add item back to the inventory: " + oldItem);
        }
        Weapon.setModifying(itemStack, false);
    }

    List<CompatibleAttachment<? extends AttachmentContainer>> getActiveAttachments(ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        ArrayList<CompatibleAttachment<? extends AttachmentContainer>> activeAttachments = new ArrayList<CompatibleAttachment<? extends AttachmentContainer>>();
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        for (int activeIndex : activeAttachmentsIds) {
            CompatibleAttachment<Weapon> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = weapon.getCompatibleAttachments().get(item)) == null) continue;
            activeAttachments.add(compatibleAttachment);
        }
        return activeAttachments;
    }

    private int[] ensureActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds = itemStack.func_77978_p().func_74759_k(ACTIVE_ATTACHMENT_TAG);
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        if (activeAttachmentsIds == null || activeAttachmentsIds.length != AttachmentCategory.values.length) {
            activeAttachmentsIds = new int[AttachmentCategory.values.length];
            itemStack.func_77978_p().func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
            for (CompatibleAttachment<Weapon> attachment : weapon.getCompatibleAttachments().values()) {
                if (!attachment.isDefault()) continue;
                activeAttachmentsIds[attachment.getAttachment().getCategory().ordinal()] = Item.func_150891_b(attachment.getAttachment());
            }
        }
        return activeAttachmentsIds;
    }

    void changeAttachment(AttachmentCategory attachmentCategory, ItemStack itemStack, EntityPlayer player) {
        if (itemStack == null || !(itemStack.func_77973_b() instanceof Weapon) || !Weapon.isModifying(itemStack)) {
            return;
        }
        this.ensureItemStack(itemStack);
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachmentCategory.ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0) {
            currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory);
        }
        ItemAttachment<Weapon> nextAttachment = this.nextCompatibleAttachment(attachmentCategory, currentAttachment, player, itemStack);
        if (currentAttachment != null && currentAttachment.getRemove() != null) {
            currentAttachment.getRemove().apply(currentAttachment, weapon, player);
        }
        if (nextAttachment != null && nextAttachment.getApply() != null) {
            nextAttachment.getApply().apply(nextAttachment, weapon, player);
        }
        activeAttachmentsIds[attachmentCategory.ordinal()] = Item.func_150891_b(nextAttachment);
        itemStack.func_77978_p().func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
    }

    private ItemAttachment<Weapon> nextCompatibleAttachment(AttachmentCategory category, Item currentAttachment, EntityPlayer player, ItemStack itemStack) {
        int currentIndex;
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        int[] selectedAttachmentIndexes = itemStack.func_77978_p().func_74759_k(SELECTED_ATTACHMENT_INDEXES_TAG);
        if (selectedAttachmentIndexes == null || selectedAttachmentIndexes.length != AttachmentCategory.values.length) {
            return null;
        }
        int activeIndex = selectedAttachmentIndexes[category.ordinal()];
        ItemAttachment nextCompatibleAttachment = null;
        for (currentIndex = activeIndex + 1; currentIndex <= 36; ++currentIndex) {
            ItemAttachment attachmentItemFromInventory;
            if (currentIndex == 0) {
                int[] previouslySelectedAttachmentIds = itemStack.func_77978_p().func_74759_k(PREVIOUSLY_SELECTED_ATTACHMENT_TAG);
                nextCompatibleAttachment = (ItemAttachment)Item.func_150899_d((int)previouslySelectedAttachmentIds[category.ordinal()]);
                if (nextCompatibleAttachment == null) continue;
                break;
            }
            ItemStack slotItemStack = player.field_71071_by.func_70301_a(currentIndex - 1);
            if (slotItemStack == null || !(slotItemStack.func_77973_b() instanceof ItemAttachment) || (attachmentItemFromInventory = (ItemAttachment)slotItemStack.func_77973_b()).getCategory() != category || !weapon.getCompatibleAttachments().containsKey(attachmentItemFromInventory) || attachmentItemFromInventory == currentAttachment) continue;
            nextCompatibleAttachment = attachmentItemFromInventory;
            break;
        }
        if (nextCompatibleAttachment == null) {
            currentIndex = -1;
        }
        selectedAttachmentIndexes[category.ordinal()] = currentIndex;
        itemStack.func_77978_p().func_74783_a(SELECTED_ATTACHMENT_INDEXES_TAG, selectedAttachmentIndexes);
        return nextCompatibleAttachment;
    }

    void addAttachment(ItemAttachment<Weapon> attachment, ItemStack weaponStack, EntityPlayer player) {
        if (!(weaponStack.func_77973_b() instanceof Weapon)) {
            throw new IllegalStateException();
        }
        this.ensureItemStack(weaponStack);
        Weapon weapon = (Weapon)weaponStack.func_77973_b();
        int[] activeAttachmentsIds = this.ensureActiveAttachments(weaponStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachment.getCategory().ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0) {
            currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory);
        }
        if (currentAttachment == null) {
            if (attachment != null && attachment.getApply() != null) {
                attachment.getApply().apply(attachment, weapon, player);
            }
            activeAttachmentsIds[attachment.getCategory().ordinal()] = Item.func_150891_b(attachment);
        } else {
            System.err.println("Attachment of category " + (Object)((Object)attachment.getCategory()) + " installed, remove it first");
        }
    }

    ItemAttachment<Weapon> removeAttachment(AttachmentCategory attachmentCategory, ItemStack weaponStack, EntityPlayer player) {
        if (!(weaponStack.func_77973_b() instanceof Weapon)) {
            throw new IllegalStateException();
        }
        this.ensureItemStack(weaponStack);
        Weapon weapon = (Weapon)weaponStack.func_77973_b();
        int[] activeAttachmentsIds = this.ensureActiveAttachments(weaponStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachmentCategory.ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0) {
            currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory);
        }
        if (currentAttachment != null && currentAttachment.getRemove() != null) {
            currentAttachment.getRemove().apply(currentAttachment, weapon, player);
        }
        if (currentAttachment != null) {
            activeAttachmentsIds[attachmentCategory.ordinal()] = -1;
            weaponStack.func_77978_p().func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
        }
        return currentAttachment;
    }

    ItemAttachment<Weapon> getActiveAttachment(ItemStack itemStack, AttachmentCategory category) {
        int[] activeAttachmentsIds;
        this.ensureItemStack(itemStack);
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        ItemAttachment<Weapon> itemAttachment = null;
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment<Weapon> compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = weapon.getCompatibleAttachments().get(item)) == null || category != compatibleAttachment.getAttachment().getCategory()) continue;
            itemAttachment = compatibleAttachment.getAttachment();
            break;
        }
        return itemAttachment;
    }

    boolean isActiveAttachment(ItemStack itemStack, ItemAttachment<Weapon> attachment) {
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        return Arrays.stream(activeAttachmentsIds).anyMatch(attachmentId -> attachment == Item.func_150899_d((int)attachmentId));
    }

    boolean isSilencerOn(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return false;
        }
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[AttachmentCategory.SILENCER.ordinal()];
        return activeAttachmentIdForThisCategory > 0;
    }

    void changeTexture(ItemStack itemStack, EntityPlayer player) {
        if (!(itemStack.func_77973_b() instanceof Weapon)) {
            return;
        }
        if (!Weapon.isModifying(itemStack)) {
            return;
        }
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        this.ensureItemStack(itemStack);
        int currentIndex = Tags.getActiveTexture(itemStack);
        if (weapon.builder.textureNames.isEmpty()) {
            return;
        }
        currentIndex = currentIndex >= weapon.builder.textureNames.size() - 1 ? 0 : ++currentIndex;
        Tags.setActiveTexture(itemStack, currentIndex);
    }

    private void ensureItemStack(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }
}

