/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.Weapon;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class WeaponSpawnEntity
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    static final float DEFAULT_INACCURACY = 1.0f;
    private float explosionRadius = 0.1f;
    private float damage = 6.0f;
    private float speed;
    private float gravityVelocity;
    private float inaccuracy;
    private Weapon weapon;
    private int ticksInAir;

    public WeaponSpawnEntity(World world) {
        super(world);
    }

    public WeaponSpawnEntity(World par1World, EntityLivingBase arg1EntityLivingBase) {
        super(par1World, arg1EntityLivingBase);
    }

    public WeaponSpawnEntity(Weapon weapon, World par1World, EntityLivingBase throwerIn, float speed, float gravityVelocity, float inaccuracy, float damage, float explosionRadius, Material ... damageableBlockMaterials) {
        super(par1World, throwerIn);
        this.weapon = weapon;
        this.damage = damage;
        this.speed = speed;
        this.inaccuracy = inaccuracy;
        this.gravityVelocity = gravityVelocity;
        this.explosionRadius = explosionRadius;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(throwerIn.field_70165_t, throwerIn.field_70163_u + (double)throwerIn.func_70047_e(), throwerIn.field_70161_v, throwerIn.field_70177_z, throwerIn.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        float pitchOffset = 0.0f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + pitchOffset) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, inaccuracy);
    }

    protected float func_70185_h() {
        return this.gravityVelocity;
    }

    protected void func_70184_a(RayTraceResult position) {
        if (!this.field_70170_p.field_72995_K) {
            if (position.field_72308_g != null) {
                if (this.explosionRadius > 0.0f) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius, true);
                }
                position.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
                position.field_72308_g.field_70172_ad = 0;
                position.field_72308_g.field_70126_B = (float)((double)position.field_72308_g.field_70126_B - 0.3);
            } else if (this.explosionRadius > 0.0f) {
                this.field_70170_p.func_72876_a((Entity)this, (double)position.func_178782_a().func_177958_n(), (double)position.func_178782_a().func_177956_o(), (double)position.func_178782_a().func_177952_p(), this.explosionRadius, true);
            } else if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.weapon.onSpawnEntityBlockImpact(this.field_70170_p, null, this, position);
            }
            this.func_70106_y();
        }
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        motionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        motionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        motionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = motionX *= (double)velocity;
        this.field_70181_x = motionY *= (double)velocity;
        this.field_70179_y = motionZ *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Item.func_150891_b((Item)this.weapon));
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.gravityVelocity);
        buffer.writeFloat(this.inaccuracy);
        buffer.writeFloat(this.damage);
        buffer.writeFloat(this.explosionRadius);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.weapon = (Weapon)Item.func_150899_d((int)buffer.readInt());
        this.speed = buffer.readFloat();
        this.gravityVelocity = buffer.readFloat();
        this.inaccuracy = buffer.readFloat();
        this.damage = buffer.readFloat();
        this.explosionRadius = buffer.readFloat();
    }

    Weapon getWeapon() {
        return this.weapon;
    }

    boolean isDamageableEntity(Entity entity) {
        return false;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (!this.field_174854_a) {
            ++this.ticksInAir;
        }
        Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
        vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec31 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            EntityLivingBase entitylivingbase = this.func_85052_h();
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1 == entitylivingbase && this.ticksInAir < 5) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                if (movingobjectposition1 == null || !((d1 = vec3.func_72436_e(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(movingobjectposition.func_178782_a());
            } else {
                this.func_70184_a(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 0.99f;
        float f3 = this.func_70185_h();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f2 = 0.8f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70181_x -= (double)f3;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }
}

