/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.AttachmentContainer;
import com.vicmatskiv.weaponlib.ChangeSettingsMessage;
import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.ImpactHandler;
import com.vicmatskiv.weaponlib.ItemAmmo;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ItemBullet;
import com.vicmatskiv.weaponlib.ItemMagazine;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.WeaponClientStorage;
import com.vicmatskiv.weaponlib.WeaponRenderer;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Weapon
extends Item
implements AttachmentContainer {
    private static final UUID SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER_UUID = UUID.fromString("8efa8469-0256-4f8e-bdd9-3e7b23970663");
    private static final AttributeModifier SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER = new AttributeModifier(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER_UUID, "Slow Down While Zooming", -0.5, 2).func_111168_a(false);
    private static final long DEFAULT_RELOADING_TIMEOUT_TICKS = 10L;
    private static final long DEFAULT_UNLOADING_TIMEOUT_TICKS = 10L;
    static final long MAX_RELOAD_TIMEOUT_TICKS = 60L;
    private static final float DEFAULT_ZOOM = 0.75f;
    private static final float DEFAULT_FIRE_RATE = 0.5f;
    Builder builder;
    private ModContext modContext;
    private SoundEvent shootSound;
    private SoundEvent silencedShootSound;
    private SoundEvent reloadSound;
    private SoundEvent unloadSound;
    private SoundEvent ejectSpentRoundSound;

    Weapon(Builder builder, ModContext modContext) {
        this.builder = builder;
        this.modContext = modContext;
        this.func_77625_d(1);
    }

    public String getName() {
        return this.builder.name;
    }

    public SoundEvent getShootSound() {
        return this.shootSound;
    }

    public SoundEvent getSilencedShootSound() {
        return this.silencedShootSound;
    }

    public SoundEvent getReloadSound() {
        return this.reloadSound;
    }

    public SoundEvent getUnloadSound() {
        return this.unloadSound;
    }

    public SoundEvent getEjectSpentRoundSound() {
        return this.ejectSpentRoundSound;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack itemStack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            this.toggleAiming(itemStackIn, playerIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    void toggleAiming(ItemStack itemStack, EntityPlayer entityPlayer) {
        this.ensureItemStack(itemStack);
        if (Weapon.isModifying(itemStack)) {
            return;
        }
        float currentZoom = Tags.getZoom(itemStack);
        if (currentZoom != 1.0f || entityPlayer.func_70051_ag()) {
            Tags.setZoom(itemStack, 1.0f);
            Tags.setAimed(itemStack, false);
            Weapon.restoreNormalSpeed(entityPlayer);
        } else {
            float allowedZoom = Tags.getAllowedZoom(itemStack);
            if (allowedZoom > 0.0f) {
                Tags.setZoom(itemStack, allowedZoom);
            } else {
                allowedZoom = this.builder.zoom;
                Tags.setAllowedZoom(itemStack, allowedZoom);
                Tags.setZoom(itemStack, allowedZoom);
            }
            Weapon.slowDown(entityPlayer);
            Tags.setAimed(itemStack, true);
        }
    }

    private static void restoreNormalSpeed(EntityPlayer entityPlayer) {
        if (entityPlayer.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER.func_111167_a()) != null) {
            entityPlayer.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        } else {
            System.err.println("Attempted to remove modifier that was not applied: " + SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        }
    }

    private static void slowDown(EntityPlayer entityPlayer) {
        if (entityPlayer.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER.func_111167_a()) == null) {
            entityPlayer.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        } else {
            System.err.println("Attempted to add duplicate modifier: " + SLOW_DOWN_WHILE_ZOOMING_ATTRIBUTE_MODIFIER);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean active) {
        this.ensureItemStack(itemStack);
        float currentZoom = Tags.getZoom(itemStack);
        EntityPlayer player = (EntityPlayer)entity;
        if (currentZoom != 1.0f && (entity.func_70051_ag() || player.func_184614_ca() != itemStack)) {
            currentZoom = 1.0f;
            Tags.setZoom(itemStack, 1.0f);
            Tags.setAimed(itemStack, false);
            Weapon.restoreNormalSpeed(player);
        }
    }

    private void ensureItemStack(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
            Tags.setAmmo(itemStack, 0);
            Tags.setZoom(itemStack, 1.0f);
            Tags.setRecoil(itemStack, this.builder.recoil);
            Weapon.setModifying(itemStack, false);
        }
    }

    static void toggleLaser(ItemStack itemStack) {
        Tags.setLaser(itemStack, !Tags.isLaserOn(itemStack));
    }

    public static boolean isAimed(ItemStack itemStack) {
        return Tags.isAimed(itemStack);
    }

    public static boolean isZoomed(EntityPlayer player, ItemStack itemStack) {
        return Tags.getZoom(itemStack) != 1.0f;
    }

    static void setModifying(ItemStack itemStack, boolean modifying) {
        if (modifying) {
            Tags.setState(itemStack, State.MODIFYING);
        } else {
            Tags.setState(itemStack, State.READY);
        }
    }

    static boolean isModifying(ItemStack itemStack) {
        return Tags.getState(itemStack) == State.MODIFYING;
    }

    public void changeRecoil(EntityPlayer player, float factor) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        this.ensureItemStack(itemStack);
        float recoil = this.builder.recoil * factor;
        Tags.setRecoil(itemStack, recoil);
        this.modContext.getChannel().sendTo((IMessage)new ChangeSettingsMessage(this, recoil), (EntityPlayerMP)player);
    }

    void clientChangeRecoil(EntityPlayer player, float recoil) {
        WeaponClientStorage weaponInstanceStorage = this.getWeaponClientStorage(player);
        if (weaponInstanceStorage != null) {
            weaponInstanceStorage.setRecoil(recoil);
        }
    }

    public void changeZoom(EntityPlayer player, float factor) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack != null) {
            this.ensureItemStack(itemStack);
            float zoom = this.builder.zoom * factor;
            Tags.setAllowedZoom(itemStack, zoom);
        }
    }

    Map<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>> getCompatibleAttachments() {
        return this.builder.compatibleAttachments;
    }

    String getCrosshair(ItemStack itemStack, EntityPlayer thePlayer) {
        if (Weapon.isZoomed(thePlayer, itemStack)) {
            String crosshair = null;
            ItemAttachment<Weapon> scopeAttachment = this.modContext.getAttachmentManager().getActiveAttachment(itemStack, AttachmentCategory.SCOPE);
            if (scopeAttachment != null) {
                crosshair = scopeAttachment.getCrosshair();
            }
            if (crosshair == null) {
                crosshair = this.builder.crosshairZoomed;
            }
            return crosshair;
        }
        if (thePlayer.func_70051_ag()) {
            return this.builder.crosshairRunning;
        }
        return this.builder.crosshair;
    }

    boolean isCrosshairFullScreen(ItemStack itemStack) {
        if (Weapon.isZoomed(null, itemStack)) {
            return this.builder.crosshairZoomedFullScreen;
        }
        return this.builder.crosshairFullScreen;
    }

    String getActiveTextureName(ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        if (this.builder.textureNames.isEmpty()) {
            return null;
        }
        return this.builder.textureNames.get(Tags.getActiveTexture(itemStack));
    }

    public static boolean isActiveAttachment(ItemStack itemStack, ItemAttachment<Weapon> attachment) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        return weapon.modContext.getAttachmentManager().isActiveAttachment(itemStack, attachment);
    }

    static boolean isEjectedSpentRound(EntityPlayer player, ItemStack itemStack) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = weapon.getWeaponClientStorage(player);
        return storage != null && storage.getState() == State.EJECT_SPENT_ROUND;
    }

    static boolean isReloadingConfirmed(EntityPlayer player, ItemStack itemStack) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = weapon.getWeaponClientStorage(player);
        return storage != null && storage.getState() == State.RELOAD_CONFIRMED;
    }

    static boolean isUnloadingStarted(EntityPlayer player, ItemStack itemStack) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponClientStorage storage = weapon.getWeaponClientStorage(player);
        return storage != null && storage.getState() == State.UNLOAD_STARTED;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 0;
    }

    WeaponClientStorage getWeaponClientStorage(EntityPlayer player) {
        return this.modContext.getWeaponClientStorageManager().getWeaponClientStorage(player, this);
    }

    int getCurrentAmmo(EntityPlayer player) {
        WeaponClientStorage storage = this.getWeaponClientStorage(player);
        if (storage == null) {
            return 0;
        }
        return storage.getCurrentAmmo().get();
    }

    int getAmmoCapacity() {
        return this.builder.ammoCapacity;
    }

    int getMaxBulletsPerReload() {
        return this.builder.maxBulletsPerReload;
    }

    ModelBase getAmmoModel() {
        return this.builder.ammoModel;
    }

    String getAmmoModelTextureName() {
        return this.builder.ammoModelTextureName;
    }

    void onSpawnEntityBlockImpact(World world, EntityPlayer player, WeaponSpawnEntity entity, RayTraceResult position) {
        if (this.builder.blockImpactHandler != null) {
            this.builder.blockImpactHandler.onImpact(world, player, entity, position);
        }
    }

    @Override
    public List<CompatibleAttachment<? extends AttachmentContainer>> getActiveAttachments(ItemStack itemStack) {
        return this.modContext.getAttachmentManager().getActiveAttachments(itemStack);
    }

    long getUnloadTimeoutTicks() {
        return this.builder.unloadingTimeout;
    }

    boolean ejectSpentRoundRequired() {
        return this.builder.ejectSpentRoundRequired;
    }

    List<ItemMagazine> getCompatibleMagazines() {
        return this.builder.compatibleAttachments.keySet().stream().filter(a -> a instanceof ItemMagazine).map(a -> (ItemMagazine)a).collect(Collectors.toList());
    }

    public WeaponRenderer getRenderer() {
        return this.builder.renderer;
    }

    List<ItemAttachment<Weapon>> getCompatibleAttachments(Class<? extends ItemAttachment<Weapon>> target) {
        return this.builder.compatibleAttachments.entrySet().stream().filter(e -> target.isInstance(e.getKey())).map(e -> (ItemAttachment)e.getKey()).collect(Collectors.toList());
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean p_77624_4_) {
        if (list != null && this.builder.informationProvider != null) {
            list.addAll((Collection)this.builder.informationProvider.apply(itemStack));
        }
    }

    public static enum State {
        READY,
        SHOOTING,
        RELOAD_REQUESTED,
        RELOAD_CONFIRMED,
        UNLOAD_STARTED,
        UNLOAD_REQUESTED_FROM_SERVER,
        UNLOAD_CONFIRMED,
        PAUSED,
        MODIFYING,
        EJECT_SPENT_ROUND;

    }

    public static class Builder {
        private static final float DEFAULT_SPAWN_ENTITY_SPEED = 10.0f;
        String name;
        List<String> textureNames = new ArrayList<String>();
        int ammoCapacity = 0;
        float recoil = 1.0f;
        private String shootSound;
        private String silencedShootSound;
        private String reloadSound;
        private String unloadSound;
        private String ejectSpentRoundSound;
        private String exceededMaxShotsSound;
        ItemAmmo ammo;
        float fireRate = 0.5f;
        private CreativeTabs creativeTab;
        private WeaponRenderer renderer;
        float zoom = 0.75f;
        int maxShots = Integer.MAX_VALUE;
        String crosshair;
        String crosshairRunning;
        String crosshairZoomed;
        BiFunction<Weapon, EntityPlayer, ? extends WeaponSpawnEntity> spawnEntityWith;
        private float spawnEntityDamage;
        private float spawnEntityExplosionRadius;
        private float spawnEntityGravityVelocity;
        long reloadingTimeout = 10L;
        private String modId;
        boolean crosshairFullScreen = false;
        boolean crosshairZoomedFullScreen = false;
        Map<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>> compatibleAttachments = new HashMap<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>>();
        ModelBase ammoModel;
        String ammoModelTextureName;
        private float spawnEntitySpeed = 10.0f;
        private Class<? extends WeaponSpawnEntity> spawnEntityClass;
        ImpactHandler blockImpactHandler;
        long pumpTimeoutMilliseconds;
        private float inaccuracy = 1.0f;
        int pellets = 1;
        float flashIntensity = 0.7f;
        long unloadingTimeout = 10L;
        private boolean ejectSpentRoundRequired;
        public int maxBulletsPerReload;
        private Function<ItemStack, List<String>> informationProvider;

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withEjectRoundRequired() {
            this.ejectSpentRoundRequired = true;
            return this;
        }

        public Builder withInformationProvider(Function<ItemStack, List<String>> informationProvider) {
            this.informationProvider = informationProvider;
            return this;
        }

        public Builder withReloadingTime(long reloadingTime) {
            this.reloadingTimeout = reloadingTime;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withAmmoCapacity(int ammoCapacity) {
            this.ammoCapacity = ammoCapacity;
            return this;
        }

        public Builder withMaxBulletsPerReload(int maxBulletsPerReload) {
            this.maxBulletsPerReload = maxBulletsPerReload;
            return this;
        }

        public Builder withRecoil(float recoil) {
            this.recoil = recoil;
            return this;
        }

        public Builder withZoom(float zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder withAmmo(ItemAmmo ammo) {
            this.ammo = ammo;
            return this;
        }

        public Builder withMaxShots(int maxShots) {
            this.maxShots = maxShots;
            return this;
        }

        public Builder withFireRate(float fireRate) {
            if (fireRate >= 1.0f || fireRate <= 0.0f) {
                throw new IllegalArgumentException("Invalid fire rate " + fireRate);
            }
            this.fireRate = fireRate;
            return this;
        }

        public Builder withTextureNames(String ... textureNames) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            for (String textureName : textureNames) {
                this.textureNames.add(textureName + ".png");
            }
            return this;
        }

        public Builder withCrosshair(String crosshair) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshair = this.modId + ":" + "textures/crosshairs/" + crosshair + ".png";
            return this;
        }

        public Builder withCrosshair(String crosshair, boolean fullScreen) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshair = this.modId + ":" + "textures/crosshairs/" + crosshair + ".png";
            this.crosshairFullScreen = fullScreen;
            return this;
        }

        public Builder withCrosshairRunning(String crosshairRunning) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshairRunning = this.modId + ":" + "textures/crosshairs/" + crosshairRunning + ".png";
            return this;
        }

        public Builder withCrosshairZoomed(String crosshairZoomed) {
            return this.withCrosshairZoomed(crosshairZoomed, true);
        }

        public Builder withCrosshairZoomed(String crosshairZoomed, boolean fullScreen) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshairZoomed = this.modId + ":" + "textures/crosshairs/" + crosshairZoomed + ".png";
            this.crosshairZoomedFullScreen = fullScreen;
            return this;
        }

        public Builder withShootSound(String shootSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.shootSound = shootSound;
            return this;
        }

        public Builder withEjectSpentRoundSound(String ejectSpentRoundSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.ejectSpentRoundSound = ejectSpentRoundSound;
            return this;
        }

        public Builder withSilencedShootSound(String silencedShootSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.silencedShootSound = silencedShootSound;
            return this;
        }

        public Builder withReloadSound(String reloadSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.reloadSound = reloadSound;
            return this;
        }

        public Builder withUnloadSound(String unloadSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.unloadSound = unloadSound;
            return this;
        }

        public Builder withExceededMaxShotsSound(String shootSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.exceededMaxShotsSound = shootSound;
            return this;
        }

        public Builder withCreativeTab(CreativeTabs creativeTab) {
            this.creativeTab = creativeTab;
            return this;
        }

        public Builder withSpawnEntityDamage(float spawnEntityDamage) {
            this.spawnEntityDamage = spawnEntityDamage;
            return this;
        }

        public Builder withSpawnEntitySpeed(float spawnEntitySpeed) {
            this.spawnEntitySpeed = spawnEntitySpeed;
            return this;
        }

        public Builder withSpawnEntityExplosionRadius(float spawnEntityExplosionRadius) {
            this.spawnEntityExplosionRadius = spawnEntityExplosionRadius;
            return this;
        }

        public Builder withSpawnEntityGravityVelocity(float spawnEntityGravityVelocity) {
            this.spawnEntityGravityVelocity = spawnEntityGravityVelocity;
            return this;
        }

        public Builder withInaccuracy(float inaccuracy) {
            this.inaccuracy = inaccuracy;
            return this;
        }

        public Builder withRenderer(WeaponRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder withCompatibleBullet(ItemBullet bullet, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(bullet, new CompatibleAttachment<Weapon>(bullet, positioner));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioner));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, boolean isDefault, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioner, isDefault));
            return this;
        }

        public Builder withSpawnEntityModel(ModelBase ammoModel) {
            this.ammoModel = ammoModel;
            return this;
        }

        public Builder withSpawnEntityModelTexture(String ammoModelTextureName) {
            this.ammoModelTextureName = this.modId + ":" + "textures/models/" + ammoModelTextureName + ".png";
            return this;
        }

        public Builder withSpawnEntityBlockImpactHandler(ImpactHandler impactHandler) {
            this.blockImpactHandler = impactHandler;
            return this;
        }

        public Builder withPumpTimeout(long pumpTimeoutMilliseconds) {
            this.pumpTimeoutMilliseconds = pumpTimeoutMilliseconds;
            return this;
        }

        public Builder withPellets(int pellets) {
            if (pellets < 1) {
                throw new IllegalArgumentException("Pellet count must be >= 1");
            }
            this.pellets = pellets;
            return this;
        }

        public Builder withFlashIntensity(float flashIntensity) {
            if (flashIntensity < 0.0f || flashIntensity > 1.0f) {
                throw new IllegalArgumentException("Invalid flash intencity");
            }
            this.flashIntensity = flashIntensity;
            return this;
        }

        public Weapon build(ModContext modContext) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            if (this.name == null) {
                throw new IllegalStateException("Weapon name not provided");
            }
            if (this.shootSound == null) {
                this.shootSound = this.name;
            }
            if (this.silencedShootSound == null) {
                this.silencedShootSound = this.shootSound;
            }
            if (this.reloadSound == null) {
                this.reloadSound = "reload";
            }
            if (this.unloadSound == null) {
                this.unloadSound = "unload";
            }
            if (this.spawnEntityClass == null) {
                this.spawnEntityClass = WeaponSpawnEntity.class;
            }
            if (this.spawnEntityWith == null) {
                this.spawnEntityWith = (weapon, player) -> new WeaponSpawnEntity((Weapon)weapon, player.field_70170_p, (EntityLivingBase)player, this.spawnEntitySpeed, this.spawnEntityGravityVelocity, this.inaccuracy, this.spawnEntityDamage, this.spawnEntityExplosionRadius, new Material[0]);
            }
            if (this.crosshairRunning == null) {
                this.crosshairRunning = this.crosshair;
            }
            if (this.crosshairZoomed == null) {
                this.crosshairZoomed = this.crosshair;
            }
            if (this.blockImpactHandler == null) {
                this.blockImpactHandler = (world, player, entity, position) -> {
                    Block block = world.func_180495_p(position.func_178782_a()).func_177230_c();
                    if (block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co) {
                        world.func_175655_b(position.func_178782_a(), true);
                    }
                };
            }
            if (this.maxBulletsPerReload == 0) {
                this.maxBulletsPerReload = this.ammoCapacity;
            }
            Weapon weapon2 = new Weapon(this, modContext);
            weapon2.shootSound = modContext.registerSound(this.shootSound);
            weapon2.reloadSound = modContext.registerSound(this.reloadSound);
            weapon2.unloadSound = modContext.registerSound(this.unloadSound);
            weapon2.silencedShootSound = modContext.registerSound(this.silencedShootSound);
            if (this.ejectSpentRoundSound != null) {
                weapon2.ejectSpentRoundSound = modContext.registerSound(this.ejectSpentRoundSound);
            }
            weapon2.func_77637_a(this.creativeTab);
            weapon2.func_77655_b(this.name);
            if (this.ammo != null) {
                this.ammo.addCompatibleWeapon(weapon2);
            }
            for (ItemAttachment<Weapon> attachment : this.compatibleAttachments.keySet()) {
                attachment.addCompatibleWeapon(weapon2);
            }
            modContext.registerWeapon(this.name, weapon2);
            return weapon2;
        }
    }
}

