/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.Part;
import com.vicmatskiv.weaponlib.StaticModelSourceRenderer;
import com.vicmatskiv.weaponlib.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttachmentBuilder<T> {
    protected String name;
    protected String modId;
    protected ModelBase model;
    protected String textureName;
    protected Consumer<ItemStack> entityPositioning;
    protected Consumer<ItemStack> inventoryPositioning;
    protected BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning;
    protected BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning;
    protected BiConsumer<ModelBase, ItemStack> firstPersonModelPositioning;
    protected BiConsumer<ModelBase, ItemStack> thirdPersonModelPositioning;
    protected BiConsumer<ModelBase, ItemStack> inventoryModelPositioning;
    protected BiConsumer<ModelBase, ItemStack> entityModelPositioning;
    protected CreativeTabs tab;
    protected AttachmentCategory attachmentCategory;
    protected ItemAttachment.ApplyHandler<T> apply;
    protected ItemAttachment.ApplyHandler<T> remove;
    private String crosshair;
    private CustomRenderer postRenderer;
    private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();
    private boolean isRenderablePart;

    public AttachmentBuilder<T> withCategory(AttachmentCategory attachmentCategory) {
        this.attachmentCategory = attachmentCategory;
        return this;
    }

    public AttachmentBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public AttachmentBuilder<T> withCreativeTab(CreativeTabs tab) {
        this.tab = tab;
        return this;
    }

    public AttachmentBuilder<T> withModId(String modId) {
        this.modId = modId;
        return this;
    }

    public AttachmentBuilder<T> withModel(ModelBase model) {
        this.model = model;
        return this;
    }

    public AttachmentBuilder<T> withTextureName(String textureName) {
        this.textureName = textureName;
        return this;
    }

    public AttachmentBuilder<T> withEntityPositioning(Consumer<ItemStack> entityPositioning) {
        this.entityPositioning = entityPositioning;
        return this;
    }

    public AttachmentBuilder<T> withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
        this.inventoryPositioning = inventoryPositioning;
        return this;
    }

    public AttachmentBuilder<T> withThirdPersonPositioning(BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning) {
        this.thirdPersonPositioning = thirdPersonPositioning;
        return this;
    }

    public AttachmentBuilder<T> withFirstPersonPositioning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning) {
        this.firstPersonPositioning = firstPersonPositioning;
        return this;
    }

    public AttachmentBuilder<T> withFirstPersonModelPositioning(BiConsumer<ModelBase, ItemStack> firstPersonModelPositioning) {
        this.firstPersonModelPositioning = firstPersonModelPositioning;
        return this;
    }

    public AttachmentBuilder<T> withEntityModelPositioning(BiConsumer<ModelBase, ItemStack> entityModelPositioning) {
        this.entityModelPositioning = entityModelPositioning;
        return this;
    }

    public AttachmentBuilder<T> withInventoryModelPositioning(BiConsumer<ModelBase, ItemStack> inventoryModelPositioning) {
        this.inventoryModelPositioning = inventoryModelPositioning;
        return this;
    }

    public AttachmentBuilder<T> withThirdPersonModelPositioning(BiConsumer<ModelBase, ItemStack> thirdPersonModelPositioning) {
        this.thirdPersonModelPositioning = thirdPersonModelPositioning;
        return this;
    }

    public AttachmentBuilder<T> withCrosshair(String crosshair) {
        this.crosshair = crosshair;
        return this;
    }

    public AttachmentBuilder<T> withPostRender(CustomRenderer postRenderer) {
        this.postRenderer = postRenderer;
        return this;
    }

    public AttachmentBuilder<T> withModel(ModelBase model, String textureName) {
        this.texturedModels.add(new Tuple<ModelBase, String>(model, textureName));
        return this;
    }

    public AttachmentBuilder<T> withRenderablePart() {
        this.isRenderablePart = true;
        return this;
    }

    public AttachmentBuilder<T> withApply(ItemAttachment.ApplyHandler<T> apply) {
        this.apply = apply;
        return this;
    }

    public AttachmentBuilder<T> withRemove(ItemAttachment.ApplyHandler<T> remove) {
        this.remove = remove;
        return this;
    }

    protected ItemAttachment<T> createAttachment(ModContext modContext) {
        return new ItemAttachment<T>(this.modId, this.attachmentCategory, this.crosshair, this.apply, this.remove);
    }

    public ItemAttachment<T> build(ModContext modContext) {
        ItemAttachment attachment = this.createAttachment(modContext);
        attachment.func_77655_b(this.modId + "_" + this.name);
        attachment.func_77637_a(this.tab);
        attachment.setPostRenderer(this.postRenderer);
        attachment.setName(this.name);
        if (this.textureName != null) {
            attachment.setTextureName(this.modId + ":" + AttachmentBuilder.stripFileExtension(this.textureName, ".png"));
        }
        if (this.isRenderablePart) {
            attachment.setRenderablePart(new Part(){

                public String toString() {
                    return AttachmentBuilder.this.name != null ? "Part [" + AttachmentBuilder.this.name + "]" : super.toString();
                }
            });
        }
        if (this.model != null) {
            attachment.addModel(this.model, this.textureName);
        }
        this.texturedModels.forEach(tm -> attachment.addModel((ModelBase)tm.getU(), (String)tm.getV()));
        if (!(this.model == null && this.texturedModels.isEmpty() || FMLCommonHandler.instance().getSide() != Side.CLIENT)) {
            this.registerRenderer(modContext, attachment);
        }
        GameRegistry.registerItem(attachment, (String)this.name);
        return attachment;
    }

    @SideOnly(value=Side.CLIENT)
    private void registerRenderer(ModContext modContext, ItemAttachment<T> attachment) {
        StaticModelSourceRenderer renderer = new StaticModelSourceRenderer.Builder().withEntityPositioning(this.entityPositioning).withFirstPersonPositioning(this.firstPersonPositioning).withThirdPersonPositioning(this.thirdPersonPositioning).withInventoryPositioning(this.inventoryPositioning).withEntityModelPositioning(this.entityModelPositioning).withFirstPersonModelPositioning(this.firstPersonModelPositioning).withThirdPersonModelPositioning(this.thirdPersonModelPositioning).withInventoryModelPositioning(this.inventoryModelPositioning).withModId(this.modId).build();
        modContext.registerRenderableItem(this.name, attachment, renderer);
    }

    private static String stripFileExtension(String str, String extension) {
        return str.endsWith(extension) ? str.substring(0, str.length() - 4) : str;
    }

    public <V extends ItemAttachment<T>> V build(ModContext modContext, Class<V> target) {
        return (V)((ItemAttachment)target.cast(this.build(modContext)));
    }
}

