/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class WorldHelper {
    public static Block getBlockAtPosition(World world, MovingObjectPosition position) {
        return world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
    }

    public static void destroyBlock(World world, MovingObjectPosition position) {
        world.func_147480_a(position.field_72311_b, position.field_72312_c, position.field_72309_d, true);
    }

    public static boolean isGlassBlock(Block block) {
        return block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co;
    }

    static ItemStack itemStackForItem(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        ItemStack result = null;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != item || !condition.test(player.field_71071_by.field_70462_a[i])) continue;
            result = player.field_71071_by.field_70462_a[i];
            break;
        }
        return result;
    }

    private static int itemSlotIndex(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != item || !condition.test(player.field_71071_by.field_70462_a[i])) continue;
            return i;
        }
        return -1;
    }

    private static ItemStack consumeInventoryItem(Item item, Predicate<ItemStack> condition, EntityPlayer player, int maxSize) {
        if (maxSize <= 0) {
            return null;
        }
        int i = WorldHelper.itemSlotIndex(item, condition, player);
        if (i < 0) {
            return null;
        }
        ItemStack stackInSlot = player.field_71071_by.field_70462_a[i];
        int consumedStackSize = maxSize >= stackInSlot.field_77994_a ? stackInSlot.field_77994_a : maxSize;
        ItemStack result = stackInSlot.func_77979_a(consumedStackSize);
        if (stackInSlot.field_77994_a <= 0) {
            player.field_71071_by.field_70462_a[i] = null;
        }
        return result;
    }

    static ItemStack tryConsumingCompatibleItem(List<? extends Item> compatibleParts, int maxSize, EntityPlayer player) {
        return WorldHelper.tryConsumingCompatibleItem(compatibleParts, maxSize, player, i -> true);
    }

    @SafeVarargs
    static ItemStack tryConsumingCompatibleItem(List<? extends Item> compatibleParts, int maxSize, EntityPlayer player, Predicate<ItemStack> ... conditions) {
        ItemStack resultStack = null;
        for (Predicate<ItemStack> condition : conditions) {
            Item item;
            Iterator<? extends Item> iterator = compatibleParts.iterator();
            while (iterator.hasNext() && (resultStack = WorldHelper.consumeInventoryItem(item = iterator.next(), condition, player, maxSize)) == null) {
            }
            if (resultStack != null) break;
        }
        return resultStack;
    }
}

