/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentContainer;
import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.DefaultPart;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ModelWithAttachments;
import com.vicmatskiv.weaponlib.Part;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Tuple;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorage;
import com.vicmatskiv.weaponlib.animation.MultipartPositioning;
import com.vicmatskiv.weaponlib.animation.MultipartRenderStateManager;
import com.vicmatskiv.weaponlib.animation.MultipartTransition;
import com.vicmatskiv.weaponlib.animation.MultipartTransitionProvider;
import com.vicmatskiv.weaponlib.animation.Transition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WeaponRenderer
implements IItemRenderer {
    private static final float DEFAULT_RANDOMIZING_RATE = 0.33f;
    private static final float DEFAULT_RANDOMIZING_FIRING_RATE = 20.0f;
    private static final float DEFAULT_RANDOMIZING_ZOOM_RATE = 0.25f;
    private static final float DEFAULT_NORMAL_RANDOMIZING_AMPLITUDE = 0.06f;
    private static final float DEFAULT_ZOOM_RANDOMIZING_AMPLITUDE = 0.01f;
    private static final float DEFAULT_FIRING_RANDOMIZING_AMPLITUDE = 0.03f;
    private static final int DEFAULT_ANIMATION_DURATION = 250;
    private static final int DEFAULT_RECOIL_ANIMATION_DURATION = 100;
    private static final int DEFAULT_SHOOTING_ANIMATION_DURATION = 100;
    private Builder builder;
    private Map<EntityPlayer, MultipartRenderStateManager<RenderableState, Part, RenderContext>> firstPersonStateManagers;
    private MultipartTransitionProvider<RenderableState, Part, RenderContext> weaponTransitionProvider;

    private WeaponRenderer(Builder builder) {
        this.builder = builder;
        this.firstPersonStateManagers = new HashMap<EntityPlayer, MultipartRenderStateManager<RenderableState, Part, RenderContext>>();
        this.weaponTransitionProvider = new WeaponPositionProvider();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    private StateDescriptor getStateDescriptor(EntityPlayer player, ItemStack itemStack) {
        MultipartRenderStateManager<RenderableState, Part, RenderContext> stateManager;
        WeaponClientStorage storage;
        float amplitude = this.builder.normalRandomizingAmplitude;
        float rate = this.builder.normalRandomizingRate;
        RenderableState currentState = null;
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        if (Weapon.isModifying(itemStack)) {
            currentState = this.builder.firstPersonPositioningModifying != null ? RenderableState.MODIFYING : RenderableState.NORMAL;
        } else if (Weapon.isUnloadingStarted(player, itemStack)) {
            currentState = RenderableState.UNLOADING;
        } else if (Weapon.isReloadingConfirmed(player, itemStack)) {
            currentState = RenderableState.RELOADING;
        } else if (Weapon.isEjectedSpentRound(player, itemStack)) {
            currentState = RenderableState.EJECT_SPENT_ROUND;
        } else if (player.func_70051_ag() && this.builder.firstPersonPositioningRunning != null) {
            currentState = RenderableState.RUNNING;
        } else if (Weapon.isZoomed(itemStack)) {
            storage = weapon.getWeaponClientStorage(player);
            if (storage != null) {
                currentState = storage.getNextDisposableRenderableState();
                if (currentState == RenderableState.AUTO_SHOOTING) {
                    currentState = RenderableState.ZOOMING;
                    rate = this.builder.firingRandomizingRate;
                } else if (currentState == RenderableState.SHOOTING) {
                    currentState = RenderableState.ZOOMING_SHOOTING;
                    rate = this.builder.firingRandomizingRate;
                } else if (currentState == RenderableState.RECOILED) {
                    currentState = RenderableState.ZOOMING_RECOILED;
                    rate = this.builder.zoomRandomizingRate;
                } else {
                    currentState = RenderableState.ZOOMING;
                    rate = this.builder.zoomRandomizingRate;
                }
            }
            amplitude = this.builder.zoomRandomizingAmplitude;
        } else {
            storage = weapon.getWeaponClientStorage(player);
            if (storage != null && (currentState = storage.getNextDisposableRenderableState()) == RenderableState.AUTO_SHOOTING) {
                currentState = RenderableState.NORMAL;
                rate = this.builder.firingRandomizingRate;
                amplitude = this.builder.firingRandomizingAmplitude;
            }
        }
        if (currentState == null) {
            currentState = RenderableState.NORMAL;
        }
        if ((stateManager = this.firstPersonStateManagers.get(player)) == null) {
            stateManager = new MultipartRenderStateManager<RenderableState, Part, RenderContext>(currentState, this.weaponTransitionProvider, Part.WEAPON);
            this.firstPersonStateManagers.put(player, stateManager);
        } else {
            stateManager.setState(currentState, true, currentState == RenderableState.SHOOTING || currentState == RenderableState.ZOOMING_SHOOTING);
        }
        return new StateDescriptor(stateManager, rate, amplitude);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        RenderContext renderContext = new RenderContext((EntityPlayer)player, item);
        MultipartPositioning.Positioner<Part, RenderContext> positioner = null;
        switch (type) {
            case ENTITY: {
                this.builder.entityPositioning.accept(item);
                break;
            }
            case INVENTORY: {
                this.builder.inventoryPositioning.accept(item);
                break;
            }
            case EQUIPPED: {
                this.builder.thirdPersonPositioning.accept(player, item);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                StateDescriptor stateDescriptor = this.getStateDescriptor((EntityPlayer)player, item);
                MultipartPositioning<Part, RenderContext> multipartPositioning = stateDescriptor.stateManager.nextPositioning();
                positioner = multipartPositioning.getPositioner();
                positioner.randomize(stateDescriptor.rate, stateDescriptor.amplitude);
                positioner.position(Part.WEAPON, renderContext);
                this.renderLeftArm((EntityPlayer)player, renderContext, positioner);
                this.renderRightArm((EntityPlayer)player, renderContext, positioner);
                break;
            }
        }
        if (this.builder.textureName != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + this.builder.textureName));
        } else {
            Weapon weapon = (Weapon)item.func_77973_b();
            String textureName = weapon.getActiveTextureName(item);
            if (textureName != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + textureName));
            }
        }
        this.builder.model.func_78088_a(null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        if (this.builder.model instanceof ModelWithAttachments) {
            List<CompatibleAttachment<? extends AttachmentContainer>> attachments = ((Weapon)item.func_77973_b()).getActiveAttachments(item);
            this.renderAttachments(positioner, renderContext, item, type, attachments, null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        }
        GL11.glPopMatrix();
    }

    private void renderAttachments(MultipartPositioning.Positioner<Part, RenderContext> positioner, RenderContext renderContext, ItemStack itemStack, IItemRenderer.ItemRenderType type, List<CompatibleAttachment<? extends AttachmentContainer>> attachments, Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        for (CompatibleAttachment<? extends AttachmentContainer> compatibleAttachment : attachments) {
            if (compatibleAttachment == null) continue;
            GL11.glPushMatrix();
            ItemAttachment<? extends AttachmentContainer> itemAttachment = compatibleAttachment.getAttachment();
            if (positioner != null) {
                if (itemAttachment instanceof Part) {
                    positioner.position((Part)((Object)itemAttachment), renderContext);
                } else if (itemAttachment.getRenderablePart() != null) {
                    positioner.position(itemAttachment.getRenderablePart(), renderContext);
                }
            }
            for (Tuple<ModelBase, String> texturedModel : compatibleAttachment.getAttachment().getTexturedModels()) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + texturedModel.getV()));
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)8192);
                if (compatibleAttachment.getPositioning() != null) {
                    compatibleAttachment.getPositioning().accept(texturedModel.getU());
                }
                texturedModel.getU().func_78088_a(entity, f, f1, f2, f3, f4, f5);
                CustomRenderer postRenderer = compatibleAttachment.getAttachment().getPostRenderer();
                if (postRenderer != null) {
                    postRenderer.render(type, itemStack);
                }
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }

    private void renderRightArm(EntityPlayer player, RenderContext renderContext, MultipartPositioning.Positioner<Part, RenderContext> positioner) {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.2f);
        GL11.glRotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        positioner.position(Part.RIGHT_HAND, renderContext);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        render.field_77109_a.field_78095_p = 0.0f;
        render.field_77109_a.func_78087_a(0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        render.field_77109_a.field_78112_f.func_78785_a(0.0625f);
        GL11.glPopMatrix();
    }

    private void renderLeftArm(EntityPlayer player, RenderContext renderContext, MultipartPositioning.Positioner<Part, RenderContext> positioner) {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((AbstractClientPlayer)player).func_110306_p());
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        positioner.position(Part.LEFT_HAND, renderContext);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        render.field_77109_a.field_78095_p = 0.0f;
        render.field_77109_a.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        render.field_77109_a.field_78113_g.func_78785_a(0.0625f);
        GL11.glPopMatrix();
    }

    private BiConsumer<Part, RenderContext> createWeaponPartPositionFunction(BiConsumer<EntityPlayer, ItemStack> weaponPositionFunction) {
        return (part, context) -> weaponPositionFunction.accept(context.player, context.weapon);
    }

    private List<MultipartTransition<Part, RenderContext>> getComplexTransition(List<Transition> wt, List<Transition> lht, List<Transition> rht, LinkedHashMap<Part, List<Transition>> custom) {
        ArrayList<MultipartTransition<Part, RenderContext>> result = new ArrayList<MultipartTransition<Part, RenderContext>>();
        for (int i = 0; i < wt.size(); ++i) {
            Transition p = wt.get(i);
            Transition l = lht.get(i);
            Transition r = rht.get(i);
            MultipartTransition<Part, RenderContext> t = new MultipartTransition<Part, RenderContext>(p.getDuration(), p.getPause()).withPartPositionFunction(Part.WEAPON, this.createWeaponPartPositionFunction(p.getPositioning())).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(l.getPositioning())).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(r.getPositioning()));
            for (Map.Entry<Part, List<Transition>> e : custom.entrySet()) {
                Transition partTransition = e.getValue().get(i);
                t.withPartPositionFunction(e.getKey(), this.createWeaponPartPositionFunction(partTransition.getPositioning()));
            }
            result.add(t);
        }
        return result;
    }

    private List<MultipartTransition<Part, RenderContext>> getSimpleTransition(BiConsumer<EntityPlayer, ItemStack> w, BiConsumer<EntityPlayer, ItemStack> lh, BiConsumer<EntityPlayer, ItemStack> rh, LinkedHashMap<Part, BiConsumer<EntityPlayer, ItemStack>> custom, int duration) {
        MultipartTransition<Part, RenderContext> mt = new MultipartTransition<Part, RenderContext>(duration, 0L).withPartPositionFunction(Part.WEAPON, this.createWeaponPartPositionFunction(w)).withPartPositionFunction(Part.LEFT_HAND, this.createWeaponPartPositionFunction(lh)).withPartPositionFunction(Part.RIGHT_HAND, this.createWeaponPartPositionFunction(rh));
        custom.forEach((part, position) -> mt.withPartPositionFunction((Part)part, this.createWeaponPartPositionFunction((BiConsumer<EntityPlayer, ItemStack>)position)));
        return Collections.singletonList(mt);
    }

    private class WeaponPositionProvider
    implements MultipartTransitionProvider<RenderableState, Part, RenderContext> {
        private WeaponPositionProvider() {
        }

        @Override
        public List<MultipartTransition<Part, RenderContext>> getPositioning(RenderableState state) {
            switch (state) {
                case MODIFYING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningModifying, WeaponRenderer.this.builder.firstPersonLeftHandPositioningModifying, WeaponRenderer.this.builder.firstPersonRightHandPositioningModifying, WeaponRenderer.this.builder.firstPersonCustomPositioning, 250);
                }
                case RUNNING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningRunning, WeaponRenderer.this.builder.firstPersonLeftHandPositioningRunning, WeaponRenderer.this.builder.firstPersonRightHandPositioningRunning, WeaponRenderer.this.builder.firstPersonCustomPositioning, 250);
                }
                case UNLOADING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.builder.firstPersonPositioningUnloading, WeaponRenderer.this.builder.firstPersonLeftHandPositioningUnloading, WeaponRenderer.this.builder.firstPersonRightHandPositioningUnloading, WeaponRenderer.this.builder.firstPersonCustomPositioningUnloading);
                }
                case RELOADING: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.builder.firstPersonPositioningReloading, WeaponRenderer.this.builder.firstPersonLeftHandPositioningReloading, WeaponRenderer.this.builder.firstPersonRightHandPositioningReloading, WeaponRenderer.this.builder.firstPersonCustomPositioningReloading);
                }
                case RECOILED: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningRecoiled, WeaponRenderer.this.builder.firstPersonLeftHandPositioningRecoiled, WeaponRenderer.this.builder.firstPersonRightHandPositioningRecoiled, WeaponRenderer.this.builder.firstPersonCustomPositioningRecoiled, WeaponRenderer.this.builder.recoilAnimationDuration);
                }
                case SHOOTING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningShooting, WeaponRenderer.this.builder.firstPersonLeftHandPositioningShooting, WeaponRenderer.this.builder.firstPersonRightHandPositioningShooting, WeaponRenderer.this.builder.firstPersonCustomPositioning, WeaponRenderer.this.builder.shootingAnimationDuration);
                }
                case EJECT_SPENT_ROUND: {
                    return WeaponRenderer.this.getComplexTransition(WeaponRenderer.this.builder.firstPersonPositioningEjectSpentRound, WeaponRenderer.this.builder.firstPersonLeftHandPositioningEjectSpentRound, WeaponRenderer.this.builder.firstPersonRightHandPositioningEjectSpentRound, WeaponRenderer.this.builder.firstPersonCustomPositioningEjectSpentRound);
                }
                case NORMAL: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioning, WeaponRenderer.this.builder.firstPersonLeftHandPositioning, WeaponRenderer.this.builder.firstPersonRightHandPositioning, WeaponRenderer.this.builder.firstPersonCustomPositioning, 250);
                }
                case ZOOMING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningZooming, WeaponRenderer.this.builder.firstPersonLeftHandPositioningZooming, WeaponRenderer.this.builder.firstPersonRightHandPositioningZooming, WeaponRenderer.this.builder.firstPersonCustomPositioning, 250);
                }
                case ZOOMING_SHOOTING: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningZoomingShooting, WeaponRenderer.this.builder.firstPersonLeftHandPositioningZooming, WeaponRenderer.this.builder.firstPersonRightHandPositioningZooming, WeaponRenderer.this.builder.firstPersonCustomPositioningZoomingShooting, 60);
                }
                case ZOOMING_RECOILED: {
                    return WeaponRenderer.this.getSimpleTransition(WeaponRenderer.this.builder.firstPersonPositioningZoomingRecoiled, WeaponRenderer.this.builder.firstPersonLeftHandPositioningZooming, WeaponRenderer.this.builder.firstPersonRightHandPositioningZooming, WeaponRenderer.this.builder.firstPersonCustomPositioningZoomingRecoiled, 60);
                }
            }
            return null;
        }
    }

    private class RenderContext {
        EntityPlayer player;
        ItemStack weapon;

        public RenderContext(EntityPlayer player, ItemStack weapon) {
            this.player = player;
            this.weapon = weapon;
        }
    }

    private static class StateDescriptor {
        MultipartRenderStateManager<RenderableState, Part, RenderContext> stateManager;
        float rate;
        float amplitude = 0.04f;

        public StateDescriptor(MultipartRenderStateManager<RenderableState, Part, RenderContext> stateManager, float rate, float amplitude) {
            this.stateManager = stateManager;
            this.rate = rate;
            this.amplitude = amplitude;
        }
    }

    public static class Builder {
        private ModelBase model;
        private String textureName;
        private float weaponProximity;
        private float yOffsetZoom;
        private float xOffsetZoom = 0.69f;
        private Consumer<ItemStack> entityPositioning;
        private Consumer<ItemStack> inventoryPositioning;
        private BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZooming;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningRunning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningModifying;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningRecoiled;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningShooting;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZoomingRecoiled;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZoomingShooting;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonLeftHandPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonLeftHandPositioningZooming;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonLeftHandPositioningRunning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonLeftHandPositioningModifying;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonLeftHandPositioningRecoiled;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonLeftHandPositioningShooting;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonRightHandPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonRightHandPositioningZooming;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonRightHandPositioningRunning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonRightHandPositioningModifying;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonRightHandPositioningRecoiled;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonRightHandPositioningShooting;
        private List<Transition> firstPersonPositioningReloading;
        private List<Transition> firstPersonLeftHandPositioningReloading;
        private List<Transition> firstPersonRightHandPositioningReloading;
        private List<Transition> firstPersonPositioningUnloading;
        private List<Transition> firstPersonLeftHandPositioningUnloading;
        private List<Transition> firstPersonRightHandPositioningUnloading;
        private String modId;
        private int recoilAnimationDuration = 100;
        private int shootingAnimationDuration = 100;
        private float normalRandomizingRate = 0.33f;
        private float firingRandomizingRate = 20.0f;
        private float zoomRandomizingRate = 0.25f;
        private float normalRandomizingAmplitude = 0.06f;
        private float zoomRandomizingAmplitude = 0.01f;
        private float firingRandomizingAmplitude = 0.03f;
        private LinkedHashMap<Part, BiConsumer<EntityPlayer, ItemStack>> firstPersonCustomPositioning = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition>> firstPersonCustomPositioningUnloading = new LinkedHashMap();
        private LinkedHashMap<Part, List<Transition>> firstPersonCustomPositioningReloading = new LinkedHashMap();
        private LinkedHashMap<Part, BiConsumer<EntityPlayer, ItemStack>> firstPersonCustomPositioningRecoiled = new LinkedHashMap();
        private LinkedHashMap<Part, BiConsumer<EntityPlayer, ItemStack>> firstPersonCustomPositioningZoomingRecoiled = new LinkedHashMap();
        private LinkedHashMap<Part, BiConsumer<EntityPlayer, ItemStack>> firstPersonCustomPositioningZoomingShooting = new LinkedHashMap();
        private List<Transition> firstPersonPositioningEjectSpentRound;
        private List<Transition> firstPersonLeftHandPositioningEjectSpentRound;
        private List<Transition> firstPersonRightHandPositioningEjectSpentRound;
        private LinkedHashMap<Part, List<Transition>> firstPersonCustomPositioningEjectSpentRound = new LinkedHashMap();

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withModel(ModelBase model) {
            this.model = model;
            return this;
        }

        public Builder withShootingAnimationDuration(int shootingAnimationDuration) {
            this.shootingAnimationDuration = shootingAnimationDuration;
            return this;
        }

        public Builder withRecoilAnimationDuration(int recoilAnimationDuration) {
            this.recoilAnimationDuration = recoilAnimationDuration;
            return this;
        }

        public Builder withNormalRandomizingRate(float normalRandomizingRate) {
            this.normalRandomizingRate = normalRandomizingRate;
            return this;
        }

        public Builder withZoomRandomizingRate(float zoomRandomizingRate) {
            this.zoomRandomizingRate = zoomRandomizingRate;
            return this;
        }

        public Builder withFiringRandomizingRate(float firingRandomizingRate) {
            this.firingRandomizingRate = firingRandomizingRate;
            return this;
        }

        public Builder withFiringRandomizingAmplitude(float firingRandomizingAmplitude) {
            this.firingRandomizingAmplitude = firingRandomizingAmplitude;
            return this;
        }

        public Builder withNormalRandomizingAmplitude(float firingRandomizingRate) {
            this.firingRandomizingRate = firingRandomizingRate;
            return this;
        }

        public Builder withZoomRandomizingAmplitude(float zoomRandomizingAmplitude) {
            this.zoomRandomizingAmplitude = zoomRandomizingAmplitude;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName + ".png";
            return this;
        }

        public Builder withWeaponProximity(float weaponProximity) {
            this.weaponProximity = weaponProximity;
            return this;
        }

        public Builder withYOffsetZoom(float yOffsetZoom) {
            this.yOffsetZoom = yOffsetZoom;
            return this;
        }

        public Builder withXOffsetZoom(float xOffsetZoom) {
            this.xOffsetZoom = xOffsetZoom;
            return this;
        }

        public Builder withEntityPositioning(Consumer<ItemStack> entityPositioning) {
            this.entityPositioning = entityPositioning;
            return this;
        }

        public Builder withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
            this.inventoryPositioning = inventoryPositioning;
            return this;
        }

        public Builder withThirdPersonPositioning(BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning) {
            this.thirdPersonPositioning = thirdPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning) {
            this.firstPersonPositioning = firstPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioningRunning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningRunning) {
            this.firstPersonPositioningRunning = firstPersonPositioningRunning;
            return this;
        }

        public Builder withFirstPersonPositioningZooming(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZooming) {
            this.firstPersonPositioningZooming = firstPersonPositioningZooming;
            return this;
        }

        public Builder withFirstPersonPositioningRecoiled(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningRecoiled) {
            this.firstPersonPositioningRecoiled = firstPersonPositioningRecoiled;
            return this;
        }

        public Builder withFirstPersonPositioningShooting(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningShooting) {
            this.firstPersonPositioningShooting = firstPersonPositioningShooting;
            return this;
        }

        public Builder withFirstPersonPositioningZoomingRecoiled(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZoomingRecoiled) {
            this.firstPersonPositioningZoomingRecoiled = firstPersonPositioningZoomingRecoiled;
            return this;
        }

        public Builder withFirstPersonPositioningZoomingShooting(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZoomingShooting) {
            this.firstPersonPositioningZoomingShooting = firstPersonPositioningZoomingShooting;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningReloading(Transition ... transitions) {
            this.firstPersonPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningUnloading(Transition ... transitions) {
            this.firstPersonPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningEjectSpentRound(Transition ... transitions) {
            this.firstPersonPositioningEjectSpentRound = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonPositioningModifying(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningModifying) {
            this.firstPersonPositioningModifying = firstPersonPositioningModifying;
            return this;
        }

        public Builder withFirstPersonHandPositioning(BiConsumer<EntityPlayer, ItemStack> leftHand, BiConsumer<EntityPlayer, ItemStack> rightHand) {
            this.firstPersonLeftHandPositioning = leftHand;
            this.firstPersonRightHandPositioning = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningRunning(BiConsumer<EntityPlayer, ItemStack> leftHand, BiConsumer<EntityPlayer, ItemStack> rightHand) {
            this.firstPersonLeftHandPositioningRunning = leftHand;
            this.firstPersonRightHandPositioningRunning = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningZooming(BiConsumer<EntityPlayer, ItemStack> leftHand, BiConsumer<EntityPlayer, ItemStack> rightHand) {
            this.firstPersonLeftHandPositioningZooming = leftHand;
            this.firstPersonRightHandPositioningZooming = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningRecoiled(BiConsumer<EntityPlayer, ItemStack> leftHand, BiConsumer<EntityPlayer, ItemStack> rightHand) {
            this.firstPersonLeftHandPositioningRecoiled = leftHand;
            this.firstPersonRightHandPositioningRecoiled = rightHand;
            return this;
        }

        public Builder withFirstPersonHandPositioningShooting(BiConsumer<EntityPlayer, ItemStack> leftHand, BiConsumer<EntityPlayer, ItemStack> rightHand) {
            this.firstPersonLeftHandPositioningShooting = leftHand;
            this.firstPersonRightHandPositioningShooting = rightHand;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningReloading(Transition ... transitions) {
            this.firstPersonLeftHandPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningEjectSpentRound(Transition ... transitions) {
            this.firstPersonLeftHandPositioningEjectSpentRound = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonLeftHandPositioningUnloading(Transition ... transitions) {
            this.firstPersonLeftHandPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningReloading(Transition ... transitions) {
            this.firstPersonRightHandPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningUnloading(Transition ... transitions) {
            this.firstPersonRightHandPositioningUnloading = Arrays.asList(transitions);
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonRightHandPositioningEjectSpentRound(Transition ... transitions) {
            this.firstPersonRightHandPositioningEjectSpentRound = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonHandPositioningModifying(BiConsumer<EntityPlayer, ItemStack> leftHand, BiConsumer<EntityPlayer, ItemStack> rightHand) {
            this.firstPersonLeftHandPositioningModifying = leftHand;
            this.firstPersonRightHandPositioningModifying = rightHand;
            return this;
        }

        public Builder withFirstPersonCustomPositioning(Part part, BiConsumer<EntityPlayer, ItemStack> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioning.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        public Builder withFirstPersonPositioningCustomRecoiled(Part part, BiConsumer<EntityPlayer, ItemStack> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningRecoiled.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        public Builder withFirstPersonPositioningCustomZoomingShooting(Part part, BiConsumer<EntityPlayer, ItemStack> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningZoomingShooting.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        public Builder withFirstPersonPositioningCustomZoomingRecoiled(Part part, BiConsumer<EntityPlayer, ItemStack> positioning) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            if (this.firstPersonCustomPositioningZoomingRecoiled.put(part, positioning) != null) {
                throw new IllegalArgumentException("Part " + part + " already added");
            }
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningReloading(Part part, Transition ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningReloading.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningUnloading(Part part, Transition ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningUnloading.put(part, Arrays.asList(transitions));
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonCustomPositioningEjectSpentRound(Part part, Transition ... transitions) {
            if (part instanceof DefaultPart) {
                throw new IllegalArgumentException("Part " + part + " is not custom");
            }
            this.firstPersonCustomPositioningEjectSpentRound.put(part, Arrays.asList(transitions));
            return this;
        }

        public WeaponRenderer build() {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            if (this.inventoryPositioning == null) {
                this.inventoryPositioning = itemStack -> GL11.glTranslatef((float)0.0f, (float)0.12f, (float)0.0f);
            }
            if (this.entityPositioning == null) {
                this.entityPositioning = itemStack -> {};
            }
            if (this.firstPersonPositioning == null) {
                this.firstPersonPositioning = (player, itemStack) -> {
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (itemStack.field_77990_d != null && Tags.getZoom(itemStack) != 1.0f) {
                        GL11.glTranslatef((float)this.xOffsetZoom, (float)this.yOffsetZoom, (float)this.weaponProximity);
                    } else {
                        GL11.glTranslatef((float)0.0f, (float)-1.2f, (float)0.0f);
                    }
                };
            }
            if (this.firstPersonPositioningZooming == null) {
                this.firstPersonPositioningZooming = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningReloading == null) {
                this.firstPersonPositioningReloading = Collections.singletonList(new Transition(this.firstPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningUnloading == null) {
                this.firstPersonPositioningUnloading = Collections.singletonList(new Transition(this.firstPersonPositioning, 250L));
            }
            if (this.firstPersonPositioningRecoiled == null) {
                this.firstPersonPositioningRecoiled = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningRunning == null) {
                this.firstPersonPositioningRunning = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningModifying == null) {
                this.firstPersonPositioningModifying = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningShooting == null) {
                this.firstPersonPositioningShooting = this.firstPersonPositioning;
            }
            if (this.firstPersonPositioningZoomingRecoiled == null) {
                this.firstPersonPositioningZoomingRecoiled = this.firstPersonPositioningZooming;
            }
            if (this.firstPersonPositioningZoomingShooting == null) {
                this.firstPersonPositioningZoomingShooting = this.firstPersonPositioningZooming;
            }
            if (this.thirdPersonPositioning == null) {
                this.thirdPersonPositioning = (player, itemStack) -> {
                    GL11.glTranslatef((float)-0.4f, (float)0.2f, (float)0.4f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                };
            }
            if (this.firstPersonLeftHandPositioning == null) {
                this.firstPersonLeftHandPositioning = (player, itemStack) -> {};
            }
            if (this.firstPersonLeftHandPositioningReloading == null) {
                this.firstPersonLeftHandPositioningReloading = this.firstPersonPositioningReloading.stream().map(t -> new Transition((p, i) -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningUnloading == null) {
                this.firstPersonLeftHandPositioningUnloading = this.firstPersonPositioningUnloading.stream().map(t -> new Transition((p, i) -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonLeftHandPositioningRecoiled == null) {
                this.firstPersonLeftHandPositioningRecoiled = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningShooting == null) {
                this.firstPersonLeftHandPositioningShooting = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningZooming == null) {
                this.firstPersonLeftHandPositioningZooming = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningRunning == null) {
                this.firstPersonLeftHandPositioningRunning = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonLeftHandPositioningModifying == null) {
                this.firstPersonLeftHandPositioningModifying = this.firstPersonLeftHandPositioning;
            }
            if (this.firstPersonRightHandPositioning == null) {
                this.firstPersonRightHandPositioning = (player, itemStack) -> {};
            }
            if (this.firstPersonRightHandPositioningReloading == null) {
                this.firstPersonRightHandPositioningReloading = this.firstPersonPositioningReloading.stream().map(t -> new Transition((p, i) -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningUnloading == null) {
                this.firstPersonRightHandPositioningUnloading = this.firstPersonPositioningUnloading.stream().map(t -> new Transition((p, i) -> {}, 0L)).collect(Collectors.toList());
            }
            if (this.firstPersonRightHandPositioningRecoiled == null) {
                this.firstPersonRightHandPositioningRecoiled = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningShooting == null) {
                this.firstPersonRightHandPositioningShooting = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningZooming == null) {
                this.firstPersonRightHandPositioningZooming = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningRunning == null) {
                this.firstPersonRightHandPositioningRunning = this.firstPersonRightHandPositioning;
            }
            if (this.firstPersonRightHandPositioningModifying == null) {
                this.firstPersonRightHandPositioningModifying = this.firstPersonRightHandPositioning;
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningRecoiled.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningRecoiled.put((Part)part, (BiConsumer<EntityPlayer, ItemStack>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningZoomingRecoiled.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningZoomingRecoiled.put((Part)part, (BiConsumer<EntityPlayer, ItemStack>)pos));
            }
            if (!this.firstPersonCustomPositioning.isEmpty() && this.firstPersonCustomPositioningZoomingShooting.isEmpty()) {
                this.firstPersonCustomPositioning.forEach((part, pos) -> this.firstPersonCustomPositioningZoomingShooting.put((Part)part, (BiConsumer<EntityPlayer, ItemStack>)pos));
            }
            this.firstPersonCustomPositioningReloading.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningReloading.size()) {
                    throw new IllegalStateException("Custom reloading transition number mismatch. Expected " + this.firstPersonPositioningReloading.size() + ", actual: " + t.size());
                }
            });
            this.firstPersonCustomPositioningUnloading.forEach((p, t) -> {
                if (t.size() != this.firstPersonPositioningUnloading.size()) {
                    throw new IllegalStateException("Custom unloading transition number mismatch. Expected " + this.firstPersonPositioningUnloading.size() + ", actual: " + t.size());
                }
            });
            return new WeaponRenderer(this);
        }
    }
}

