/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.SafeGlobals;
import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;

public class WeaponEventHandler {
    private SafeGlobals safeGlobals;

    public WeaponEventHandler(SafeGlobals safeGlobals) {
        this.safeGlobals = safeGlobals;
    }

    @SubscribeEvent
    public void onGuiOpenEvent(GuiOpenEvent event) {
        this.safeGlobals.guiOpen.set(event.gui != null);
    }

    @SubscribeEvent
    public void zoom(FOVUpdateEvent event) {
        ItemStack stack = event.entity.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof Weapon && stack.field_77990_d != null) {
            event.newfov = Tags.getZoom(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouse(MouseEvent event) {
        ItemStack heldItem;
        if (event.button == 0) {
            ItemStack heldItem2 = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
            if (heldItem2 != null && heldItem2.func_77973_b() instanceof Weapon) {
                event.setCanceled(true);
            }
        } else if (event.button == 1 && (heldItem = Minecraft.func_71410_x().field_71439_g.func_70694_bm()) != null && heldItem.func_77973_b() instanceof Weapon && Weapon.isEjectedSpentRound((EntityPlayer)Minecraft.func_71410_x().field_71439_g, heldItem)) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleRenderLivingEvent(RenderLivingEvent.Pre event) {
        if (event.isCanceled() || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack itemStack = event.entity.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() instanceof Weapon) {
            RenderPlayer rp = (RenderPlayer)event.renderer;
            if (itemStack.field_77990_d != null) {
                rp.field_77109_a.field_78118_o = Weapon.isAimed(itemStack);
            }
        }
    }
}

