/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.Tags;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.WeaponClientStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

class WeaponClientStorageManager {
    private Map<Key, WeaponClientStorage> weaponClientStorage = new HashMap<Key, WeaponClientStorage>();

    WeaponClientStorageManager() {
    }

    WeaponClientStorage getWeaponClientStorage(EntityPlayer player, Weapon weapon) {
        if (player == null) {
            return null;
        }
        return this.weaponClientStorage.computeIfAbsent(new Key(player.getPersistentID(), weapon), w -> {
            ItemStack itemStack = player.func_70694_bm();
            return itemStack.field_77990_d != null ? new WeaponClientStorage(Tags.getState(itemStack), Tags.getAmmo(itemStack), weapon.builder.zoom, Tags.getRecoil(player.func_70694_bm()), weapon.builder.fireRate, weapon.builder.maxShots > 1) : null;
        });
    }

    private class Key {
        UUID playerUuid;
        Weapon weapon;

        Key(UUID playerUuid, Weapon weapon) {
            this.playerUuid = playerUuid;
            this.weapon = weapon;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.playerUuid == null ? 0 : this.playerUuid.hashCode());
            result = 31 * result + (this.weapon == null ? 0 : this.weapon.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.playerUuid == null ? other.playerUuid != null : !this.playerUuid.equals(other.playerUuid)) {
                return false;
            }
            return !(this.weapon == null ? other.weapon != null : this.weapon != other.weapon);
        }
    }
}

