/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.google.common.util.concurrent.AtomicDouble;
import com.vicmatskiv.weaponlib.ExpirableRenderableState;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class WeaponClientStorage {
    private AtomicInteger currentAmmo;
    private AtomicLong reloadingStopsAt;
    private long lastShotFiredAt;
    private long ejectSpentRoundStartedAt;
    private int shotsInternal;
    private float zoom;
    private AtomicDouble recoil;
    private float fireRate;
    private AtomicReference<Weapon.State> state;
    private boolean automatic;
    private Queue<ExpirableRenderableState> expirableRenderableStates = new ArrayBlockingQueue<ExpirableRenderableState>(100);

    public WeaponClientStorage(Weapon.State state, int currentAmmo, float zoom, float recoil, float fireRate, boolean automatic) {
        this.currentAmmo = new AtomicInteger(currentAmmo);
        this.reloadingStopsAt = new AtomicLong();
        this.recoil = new AtomicDouble((double)recoil);
        this.state = new AtomicReference<Weapon.State>(state);
        this.zoom = zoom;
        this.fireRate = fireRate;
        this.automatic = automatic;
    }

    void setLastShotFiredAt(long lastShotFiredAt) {
        this.lastShotFiredAt = lastShotFiredAt;
    }

    long getLastShotFiredAt() {
        return this.lastShotFiredAt;
    }

    long getEjectSpentRoundStartedAt() {
        return this.ejectSpentRoundStartedAt;
    }

    void setEjectSpentRoundStartedAt(long ejectSpentRoundStartedAt) {
        this.ejectSpentRoundStartedAt = ejectSpentRoundStartedAt;
    }

    public Weapon.State getState() {
        return this.state.get();
    }

    public void setState(Weapon.State state) {
        this.state.set(state);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public AtomicInteger getCurrentAmmo() {
        return this.currentAmmo;
    }

    public AtomicLong getReloadingStopsAt() {
        return this.reloadingStopsAt;
    }

    public float getRecoil() {
        return (float)this.recoil.get();
    }

    public void setRecoil(float recoil) {
        this.recoil.set((double)recoil);
    }

    public void addShot() {
        if (this.shotsInternal++ == 0) {
            // empty if block
        }
        if (this.automatic) {
            this.expirableRenderableStates.add(new ExpirableRenderableState(RenderableState.AUTO_SHOOTING, System.currentTimeMillis() + (long)(50.0f / this.fireRate), false));
        }
        if (!this.automatic) {
            this.expirableRenderableStates.add(new ExpirableRenderableState(RenderableState.RECOILED, System.currentTimeMillis() + 500L, true));
            this.expirableRenderableStates.add(new ExpirableRenderableState(RenderableState.SHOOTING, System.currentTimeMillis() + 500L, true));
        }
    }

    public RenderableState getNextDisposableRenderableState() {
        ExpirableRenderableState ers;
        while ((ers = this.expirableRenderableStates.peek()) != null) {
            if (System.currentTimeMillis() <= ers.expiresAt) {
                if (!ers.singleUse) break;
                this.expirableRenderableStates.poll();
                break;
            }
            this.expirableRenderableStates.poll();
        }
        return ers != null ? ers.state : RenderableState.NORMAL;
    }

    public int getShots() {
        return this.shotsInternal;
    }

    public void resetShots() {
        this.shotsInternal = 0;
    }
}

